C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE INISOL
C                       *****************
C
C     -------------------------------------------------------------
     *(NDIM,NDIELE,NBFACE,NFBIDA,
     * NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL,NPOINS,NELEMS,NDMATS,
     * NELESS,NDMASS,NELEUS,NELERC,NELEPR,NELERA,NBRESS,
     * NBRAYS,NBRAIS,NBPRIO,NBMOBS,NBCOPR,NBPHYS,NPPEL,NPOUE,NBICOR,
     * NBFFLU,NBFECH,NBFRAI,
     * NCOUPS,NFLUSS,NDIRS,NECHS,NFLUVS,NRESCS,NRAYTS,
     * NRAYIS,NPRIOS,NMOBIL,
     * VFLUSS,VDIRS,VECHS,VFLUVS,VRESCS,VRAYTS,VRAYIS,
     * NREFAC,NREFAL,NFCOUS,NFFLUS,NFECHS,NFRESC,NFRAYS,NFRAIS,
     * VFFLUS,VFECHS,VFRESC,VFRAYS,VFRAIS,
     * NREFS,NREFE,COORDS,NODES,NODESS,NODEUS,NODERC,NODEPR,NODERA,
     * NANGLE,PHYSOL,TMPSA,TMPS,TMPSC1,TMPSC2,TMPSC3,VOLUME,SURFUS,
     * NELRAY,NPOINR,NNSRAY,NNFRAY,NNERAY,NFCFRA,NFCSRA,NFTIRA,
     * NFFIRA,NFPERA,NFMST,NFMSTE,NGFFIR,NGFTIR,NGFPER,NGFPEF,
     * NGFMST,NGFMSE,VFMSTE,PHMSTP,PHMSTO,
     * EMISSI,PHFRAF,PHFRAE,TEMRAY,FIRAY,VFIRAY,ERAYEQ,TRAYEQ,
     * NODRAY,NRFRAY,ITYFAR,COORAY,FDFRAY,SUFRAY,NCSRAY,NCFRAY,NESRAY,
     * NCFIN,NCGROS,BARYGR,BARYFS,ITRAV,IDTRAV,TABRAY,RADIOS,
     * ITRAV1,ITRAV2,TRAV1,TRAV2,TRAV3,TOTRAI,TMPMAX,TMPMIN,ITRMED)
C     -------------------------------------------------------------
C
C     Attention, les tableaux  ITRAV2,TRAV1,TRAV2,TRAV3
C     n'existent qu'en presence de noeuds periodiques
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C     INITIALISATIONS POUR LA PRISE EN COMPTE DU COUPLAGE
C     THERMIQUE FLUIDE/SOLIDE 
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NBCOUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NBFLUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DE TYPE FLUX!
C !  NBDIRS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DIRICHLET   !
C !  NBECHS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC CL COEF ECH    !
C !  NBFLVS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC FLUX VOLUMIQUE !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NELESS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE SURF SOLIDE        !
C !  NDMASS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS SURF SOLIDES       !
C !  NELEUS   !  E ! D  ! NBRE D'ELTS DU MAILLAGE SURF SOLIDE AVEC FLUX!
C !  NELERA   !  E ! D  ! NBRE D'ELTS DU MAIL SURF SOLIDE AVEC RAYT    !
C !  NELEPR   !  E ! D  ! NBRE D'ELTS DU MAIL VOL SOLIDE PERIODIQUE    !
C !  NBRESS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC CL RESI CONTACT!
C !  NBRAYS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT    !
C !  NBPRIO   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES PERIODIQUES         !
C !  NBMOBS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES EN MOUVEMENT        !
C !  NBCOPR   !  E ! D  ! NBRE DE CORRESPONDANTS POUR LES NOEUDS PERIOD!
C !  NBPHYS   !  E ! D  ! NOMBRE DE VARIABLES PHYSIQUES SUR LE SOLIDE  !
C !  NBICOR   !  E ! D  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !  NBFFLU   !  E ! D  ! NOMBRE DE FACES AVEC FLUX                    !
C !  NBFECH   !  E ! D  ! NOMBRE DE FACES AVEC COEF ECH                !
C !  NCOUPS   ! TE ! R  ! NUMEROS GLOBAUX DES NOEUDS SOLIDES COUPLES   !
C !  NFLUSS   ! TE ! R  ! NUMEROS GLOBAUX DES NOEUDS AVEC CL FLUX      !
C !  NDIRS    ! TE ! R  ! NUMEROS GLOBAUX DES NOEUDS AVEC CL DIRICHLET !
C !  NECHS    ! TE ! R  ! NUMEROS GLOBAUX DES NOEUDS AVEC CL COEFF ECH !
C !  NFLUVS   ! TE ! R  ! NUMEROS GLOBAUX DES NOEUDS AVEC FLUX VOLUM   !
C !  NRESCS   ! TE ! R  ! NUMEROS GLOB DES NOEUDS AVEC RES DE CONTACT  !
C !  NRAYTS   ! TE ! R  ! NUMEROS GLOB DES NOEUDS AVEC RAYONNEMENT     !
C !  NPRIOS   ! TE ! R  ! NUMEROS GLOB DES NOEUDS PERIODIQUES          !
C !  NMOBIL   ! TE ! R  ! NUMEROS GLOB DES NOEUDS EN MOUVEMENT         !
C !  VFLUSS   ! TR ! R  ! VALEURS DE LA CL DE TYPE FLUX                !
C !  VFDIRS   ! TR ! R  ! VALEURS DE LA CL DE TYPE DIRICHLET           !
C !  VECHS    ! TR ! R  ! VALEURS DE LA CL DE TYPE COEFF D'ECHANGE     !
C !  VFLUVS   ! TR ! R  ! VALEURS DU FLUX VOLUMIQUE                    !
C !  VRESCS   ! TR ! R  ! VALEURS DE LA CL DE TYPE RESIST DE CONTACT   !
C !  VRAYTS   ! TR ! R  ! VALEURS DE LA CL DE TYPE RAYONNEMENT         !
C !  NREFAC   ! TE ! R  ! REFERENCES DES FACES (volumique)             !
C !  NREFAL   ! TE ! R  ! REFERENCES DES FACES (num loc dans NODEUS)   !
C !  NFCOUS   ! TE ! R  ! NUM DANS NODEUS DES FACES COUPLEES           !
C !  NFFLUS   ! TE ! R  ! NUM DANS NODEUS DES FACES AVEC FLUX          !
C !  NFECHS   ! TE ! R  ! NUM DANS NODEUS DES FACES AVEC COEFF D'ECH   !
C !  NFRESC   ! TE ! R  ! NUM DANS NODEUS DES FACES AVEC RES DE CONT   !
C !  NFRAYS   ! TE ! R  ! NUM DANS NODEUS DES FACES AVEC RAYONNEMENT   !
C !  VFFLUS   ! TR ! R  ! VAL DU FLUX AUX NOEUDS DE LA FACETTE         !
C !  VFECHS   ! TR ! R  ! VAL DE T ET COEF ECH AUX NOEUDS DE LA FACETTE!
C !  VFRESC   ! TR ! R  ! VAL DE T ET RES CONT AUX NOEUDS DE LA FACETTE!
C !  VFRAYS   ! TR ! R  ! VAL DU RAYONNEMENT AUX NOEUDS DE LA FACETTE  !
C !  NREFS    ! TR ! R  ! REFERENCES DES NOEUDS SOLIDES                !
C !  NREFE    ! TR ! R  ! REFERENCES DES ELEMENTS SOLIDES              !
C !  COORDS   ! TR ! R  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !  NODES    ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE SOLIDE      !
C !  NODESS   ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF SOLIDE !
C !  NODEUS   ! TE ! R  ! CONNECTIVITE NOEUDS AVEC CL TYPE FLUX (SOL)  !
C !  NODERC   ! TE ! R  ! CONNECTIVITE NOEUDS AVEC CL TYPE RES CONTACT !
C !  NODERA   ! TE ! R  ! CONNECTIVITE NOEUDS AVEC CL TYPE RAYT        !
C !  PHYSOL   ! TR ! R  ! PROPRIETES PHYSIQUES DU SOLIDE               !
C !  TMPSA    ! TR ! M  ! TEMPERATURE DANS LE SOLIDE ETAPE n           !
C !  TMPS     ! TR ! M  ! TEMPERATURE DANS LE SOLIDE ETAPE n+1         !
C !  TMPSC1   ! TR ! M  ! MODELE COQUE : TEMPERATURE COMPOSANTE 1      !
C !  TMPSC2   ! TR ! M  ! MODELE COQUE : TEMPERATURE COMPOSANTE 2      !
C !  TMPSC3   ! TR ! M  ! MODELE COQUE : TEMPERATURE COMPOSANTE 3      !
C !  VOLUME   ! TR ! R  ! SURFACE DU TRIANGLE EN 2D                    !
C !           !    !    ! VOLUME DU TETRAEDRE EN 3D                    !
C !  SURFUS   ! TR ! R  ! EN 3D SURFACE DU TRIANGLE DE BORD (flux)     !
C !           !    !    ! EN 2D LONGUEUR DU SEGMENT DE BORD (flux)     !
C !  NODRAY   ! TE ! R  ! MAILLAGE EXT RAYONNEMENT                     !
C !  COORAY   ! TR ! R  ! COORD MAILLAGE EXT RAYONNEMENT               !
C !  FDFRAY   ! TR ! R  ! FACTEURS DE FORME RAYONNEMENT                !
C !  TEMRAY   ! TR ! R  ! TEMPERATURE DE FACETTE                       !
C !  FIRAY    ! TR ! R  ! FLUX SUR LA FACETTE (impose ou calcule)      !
C !  NCFIN    ! TE ! R  ! NUMERO DE L'ELEMENT GROSSIER CORRESPONDANT   !
C !  NCGROS   ! TE ! R  ! NUMERO DE L'ELEMENT FIN CORRESPONDANT        !
C !  BARYGR   ! TR ! R  ! COORD BARY DES CORRESPONDANTS DES NOEUDS GROS!
C !  ITRAV    ! TE ! A  ! TABLEAUX DE TRAVAIL                          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /OPTCT/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :  
C
C     SOUS PROGRAMME(S) APPELE(S) :
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON 
C **********************************************************************
C
#include "divct.h"
#include "optct.h"
#include "mobil.h"
#include "nlofes.h"
#include "nlofct.h"
#include "fichct.h"
#include "syrth.h"
#include "rayonn.h"
#include "xrefer.h"
#include "f2c_syrthes.h"
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NDIELE,NBFACE,NFBIDA
      INTEGER NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL
      INTEGER NPOINS,NELEMS,NDMATS
      INTEGER NELESS,NELEUS,NDMASS,NELERC,NELERA,NELEPR,NBRESS,NBPRIO
      INTEGER NBRAYS,NBRAIS,NBMOBS,NBCOPR
      INTEGER NBPHYS,NPPEL,NPOUE,NBICOR,NBFFLU,NBFECH,NBFRAI
      INTEGER NCOUPS(NBCOUS),NFLUSS(NBFLUS),NDIRS(NBDIRS)
      INTEGER NECHS(NBECHS),NFLUVS(NBFLVS),NRESCS(NBRESS,2)
      INTEGER NRAYTS(NBRAYS),NPRIOS(NBPRIO,1+NBCOPR)
      INTEGER NRAYIS(NBRAIS),NMOBIL(NBMOBS,2)
      INTEGER NREFS(NPOINS),NREFE(NELEMS),NODES(NELEMS,NDMATS)
      INTEGER NANGLE(NELEMS)
      INTEGER NODESS(NELESS,NDMASS), NODEUS(NELEUS,NDMASS)
      INTEGER NODEPR(NELEPR,NDMATS+1),NODERC(NELERC,NDMASS)
      INTEGER NREFAC(NELEMS,NBFACE),NREFAL(NELEUS)
      INTEGER NFCOUS(NELESS),NFFLUS(NBFFLU),NFECHS(NBFECH)
      INTEGER NFRESC(NELERC),NFRAYS(NELERA),NFRAIS(NBFRAI)
      INTEGER NELRAY,NPOINR,NNSRAY,NNFRAY,NNERAY
      INTEGER NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE
      INTEGER NODRAY(NELRAY,NDIM)
      INTEGER NODERA(NELERA,NDMASS)
      INTEGER NCFIN(NBRAYS),NCGROS(NNSRAY,2),NRFRAY(NELRAY)
      INTEGER ITYFAR(NELRAY)
      INTEGER NCSRAY(NNSRAY),NCFRAY(NNFRAY),NESRAY(NNERAY)
C
      DOUBLE PRECISION VFLUSS(NBFLUS),VDIRS(NBDIRS)
      DOUBLE PRECISION VECHS(NBECHS,2),VFLUVS(NBFLVS,NPFEL)
      DOUBLE PRECISION VRESCS(NBRESS,2)
      DOUBLE PRECISION VRAYTS(NBRAYS,2),VRAYIS(NBRAIS,2)
      DOUBLE PRECISION VFFLUS(NBFFLU,NDMASS)
      DOUBLE PRECISION VFECHS(NBFECH,NDMASS,2),VFRESC(NELERC,NDMASS,2)
      DOUBLE PRECISION VFRAYS(NELERA,NDMASS,2),VFRAIS(NBFRAI,NDMASS,2)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)
      DOUBLE PRECISION BARYGR(NNSRAY,NDIM)
      DOUBLE PRECISION BARYFS(NBRAYS,NDIM)
      DOUBLE PRECISION COORAY(NPOINR,NDIM)
      DOUBLE PRECISION FDFRAY(NELRAY*(NELRAY+1)/2)
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)
      DOUBLE PRECISION TMPSC1(NPOINS),TMPSC2(NPOINS),TMPSC3(NPOINS)
      DOUBLE PRECISION TMPSA(NPOINS), TMPS(NPOINS)
      DOUBLE PRECISION TMPMAX(NPOINS),TMPMIN(NPOINS)
      DOUBLE PRECISION VOLUME(NELEMS),SURFUS(NELEUS)
      INTEGER IDTRAV,ITRAV(IDTRAV),ITRAV1(IDTRAV),ITRAV2(NPOINS)
      INTEGER ITRMED(NDMATS,NELEMS)
      DOUBLE PRECISION TRAV1(NPOINS),TRAV2(NPOINS),TRAV3(NPOINS)
      DOUBLE PRECISION SUFRAY(NELRAY),TABRAY(NELRAY,9)
      DOUBLE PRECISION TOTRAI
C
      INTEGER NGFFIR(NFFIRA),NGFTIR(NFTIRA)
      INTEGER NGFPER(NFPERA),NGFPEF(NFCFRA)
      INTEGER NGFMST(NFMST,2),NGFMSE(NFMSTE)
      DOUBLE PRECISION VFMSTE(NFMSTE,2),EMISSI(NELRAY,2,NBANDE)
      DOUBLE PRECISION PHFRAF(NFCFRA,4),PHFRAE(NFPERA,4)
      DOUBLE PRECISION PHMSTP(NFMST,4),PHMSTO(NFMST,5,NBANDE)
      DOUBLE PRECISION TEMRAY(NELRAY),FIRAY(NELRAY,NBANDE)
      DOUBLE PRECISION TRAYEQ(NELRAY),ERAYEQ(NELRAY)
      DOUBLE PRECISION VFIRAY(NFFIRA,NBANDE,2)
      DOUBLE PRECISION RADIOS(NELRAY,NBANDE)
C
C.. Variables internes
      INTEGER N,NB,NBSOM,NUMA,INDGLO,NUMBAN,NGFAC,NPERAY,I,NBSCAL
      LOGICAL LF,LDEVDI,LDEVFD
      PARAMETER(LDEVDI=.FALSE., LDEVFD=.FALSE.)
      INTEGER IREF(NRFMAX),NBRE,MODE
      DOUBLE PRECISION T1
C
      DOUBLE PRECISION TFAC1,TFAC2,TCORR1,TCORR2
C
C
C***********************************************************************
C
C     -----------------------
C     Lecture maillage solide
C     -----------------------
C
C     Si le maillage element fini a ete genere par SIMAIL
      IF (TYPEF .EQ. 'SIM') THEN
         IF (LCFACE) THEN
            DO  N=1,NELEMS*NBFACE
               NREFAC(N,1) = 0
            ENDDO
         ENDIF
         CALL LECSI3(NDIM,NDIELE,NPOINS,NELEMS,NDMATS,NBFACE,
     &               NODES,NREFS,NREFE,NREFAC,COORDS)
C     
C     Si le maillage element fini a ete genere par IDEAS
      ELSEIF (TYPEF .EQ. 'IDE')THEN
         IF (LCFACE) THEN
            DO  N=1,NELEMS*NBFACE
               NREFAC(N,1) = 0
            ENDDO
         ENDIF
         CALL LECID3(NDIM,NDIELE,NPOINS,NELEMS,NFBIDA,NDMATS,
     &               NODES,NREFS,NREFE,COORDS,NBFACE,NREFAC)
C     
C     Si le maillage element fini est au format SYRTHES
      ELSEIF (TYPEF .EQ. 'SYR')THEN
         IF (LCFACE) THEN
            DO  N=1,NELEMS*NBFACE
               NREFAC(N,1) = 0
            ENDDO
         ENDIF
         CALL LECSY3(NDIM,NDIELE,NPOINS,NELEMS,NDMATS,NBFACE,
     &               NODES,NREFS,NREFE,NREFAC,COORDS)
C     
      ELSE
         WRITE(NFECRA,2100)
         STOP
C     
      ENDIF
C
C     Ecriture du maillage solide sur fichier resu
C     --------------------------------------------
C
      LF = LCFACE
C
      IF (LGEOMS)
     &     CALL ECRG1
     &       ( NFGGCT,LF,NDIM,NDIELE,NPOINS,NELEMS,NDMATS,NBFACE,
     &         COORDS,NODES,NREFS,NREFE,NREFAC)
C
C      
C     Ecriture de l'entete du fichier resu
C     ------------------------------------
      NBSCAL=1
      IF (LTMAX)  NBSCAL = NBSCAL+2
      IF (LDEVDI .AND. LRAY) NBSCAL = NBSCAL+1
      IF (LDEVDI .AND. .NOT.LSYRTH) NBSCAL = NBSCAL+1
      CALL ECRG2E(NBSCAL,NFGRCT,NDIM,NDIELE,NELEMS,NPOINS) 
C
C
       IVECTO = 0
CHRIS#ifdef __uxpv__
c      IF (.NOT. LSDEPL) THEN
c         CALL NVECTO (NDMATS,NELEMS,NODES,NREFAC,NBFACE,NREFE)
c      ENDIF
CHRIS#endif
C
       IF (LCFACE .AND. (TYPEF.NE.'SIM')) THEN
            CALL INREFA (NDIM,NDIELE,NELEMS,NDMATS,NBFACE,
     *                   NODES,NREFAC,NPOINS,NREFS)
       ELSE
            WRITE(NFECRA,2200)
       ENDIF
C
       IF (LCFACE) CALL VERIFA (NDIELE,NELEMS,NBFACE,NREFAC)
C
       IF (LSDEPL) CALL MOBMX2 (NDIM,NDIELE,NPOINS,NELEMS,NDMATS,NBFACE,
     *                          NODES,NREFS,NREFAC,COORDS)
C
C
C
        IF (NCTHFS.EQ.3) THEN
          CALL XMAILL(NDIELE,NPOINS,
     *                NELEMS,NELESS,NELEUS,NELERC,NELERA,
     *                NDMATS,NDMASS,NBFACE,
     *                NODES,NODESS,NODEUS,NODERC,NODERA,
     *                NREFS,NREFAC,NREFAL)
c          IF (.NOT. LSDEPL) THEN
c              MODE=2
c              NB=1
c              CALL NVECTO (MODE,NDMASS,NELEUS,NODEUS,ITRAV1,NB,
c     *                     NREFAL,NPOINS,ITRAV)
c           ELSE
               LVECTB = .FALSE.
c           ENDIF
        ENDIF
C
C
C       
C     2.4- Numerotation locale des noeuds ou faces en fonction de leur 
C          condition a la limite, num des noeuds avec flux volumique 
C     -----------------------------------------------------------------
C
      IF (.NOT. LCFACE) THEN
         CALL LIMNUM (NCOUPS,NBCOUS,NFLUSS,NBFLUS,NDIRS,NBDIRS,
     *                NECHS,NBECHS,NRAYTS,NBRAYS,
     *                NRAYIS,NBRAIS,NRESCS,NBRESS,NPRIOS,NBPRIO,
     *                NMOBIL,NBMOBS,NBCOPR,NREFS,NPOINS)
C
         DO 250 N=1,NPOINS
           NREFS(N) = ABS(NREFS(N))
  250    CONTINUE
C
       ELSEIF (NCTHFS.EQ.3) THEN
         CALL LIMFNU 
     *      (NCOUPS,NBCOUS,NFCOUS,NELESS,NFFLUS,NBFFLU,NDIRS,NBDIRS,
     *       NFECHS,NBFECH,NRESCS,NBRESS,NFRESC,NELERC,
     *       NRAYTS,NBRAYS,NFRAYS,NELERA,NFRAIS,NBFRAI,
     *       NPRIOS,NBPRIO,NMOBIL,NBMOBS,NBCOPR,NREFS,
     *       NPOINS,NDIELE,NELEUS,NDMASS,NODEUS,
     *       NREFAL,ITRAV,ITRAV1)
C
       ELSE
         CALL LIMFCO 
     *      (NCOUPS,NBCOUS,NFCOUS,NFFLUS,NBFFLU,NDIRS,NBDIRS,
     *       NFECHS,NBFECH,NFRAYS,NELERA,
     *       NPRIOS,NBPRIO,
     *       NMOBIL,NBMOBS,NBCOPR,NREFS,NPOINS,NDIELE,
     *       NELEMS,NDMATS,NODES,
     *       NBFACE,NREFAC)
C
       ENDIF
C
       IF (NBFLVS.GT.0) 
     *     CALL FLVNUM (NFLUVS,NBFLVS,NREFS,NPOINS,NREFE,NELEMS)
C
C
C      2.5- Initialisation puis lecture des conditions aux limites 
C      ------------------------------------------------------------
C      ITRAV a la dimension : NPOINS
       CALL LECLIM 
     *    ( NDIM,NPOINS,NELEMS,NREFS,NREFE,
     *      TMPSA,TMPS,TMPSC1,TMPSC2,TMPSC3,
     *      COORDS,NBFLUS,NFLUSS,VFLUSS,NBDIRS,NDIRS,VDIRS,
     *      NBECHS,NECHS,VECHS,NBFLVS,NPFEL,NFLUVS,VFLUVS,
     *      NBRESS,NRESCS,VRESCS,
     *      NBPRIO,NBCOPR,NPRIOS,NBMOBS,NMOBIL,
     *      NPOUE,NPPEL,NBPHYS,PHYSOL,
     *      NDMASS,NREFAL,NELEUS,NFFLUS,VFFLUS,NBFFLU,
     *      NFECHS,VFECHS,NBFECH,NFRESC,VFRESC,NELERC,NELERA,
     *      NBRAIS,NRAYIS,VRAYIS,NBFRAI,NFRAIS,VFRAIS,
     *      ITRAV,ITRAV1,ITRAV2,TRAV1,TRAV2,TRAV3)
C
C
C
C      2.6- Solides en translation : deplacement des coordonnees 
C      ---------------------------------------------------------
       IF (LSDEPL) THEN
         IF (.NOT. LSUISO) THEN
C           maillage 1
            NUMA = 2
            CALL MOBTRA (NUMA,NDIM,NPOINS,COORDS,
     *                   -TRXMOB,-TRYMOB,-TRZMOB)
         ELSE
            CALL MOBLG1 (NDIM,NPOINS,COORDS)
         ENDIF
       ENDIF
C
C
C      2.7- Passage a la numerotation locale
C      -------------------------------------
C
        IF (NCTHFS.EQ.3) THEN
         CALL NDLOCS (NELESS,NDMASS,NBCOUS,NPOINS,NODESS,NCOUPS,ITRAV)
        ENDIF
C 
        IF (LRAY) THEN
         CALL NDLOCS (NELERA,NDMASS,NBRAYS,NPOINS,NODERA,NRAYTS,ITRAV)
        ENDIF
C
C      2.8- Extraction du maillage des elts periodiques
C      ------------------------------------------------
C
         IF (NELEPR.NE.0) 
     *   CALL XMPRIO (NPOINS,NELEMS,NELEPR,NDMATS,
     *                NODES,NODEPR,NPRIOS,NBPRIO,NBCOPR,NREFS,ITRAV)
C
C
C      2.9- Calcul du volume des elements
C      --------------------------------------------------
C
       CALL SVOLUM ( NDIM,NDIELE,NELEMS,NDMATS,NELEUS,NDMASS,NPOINS,
     *               VOLUME,SURFUS,NODES,NODEUS,COORDS,NANGLE)
C
C     2.10- Correspondants pour les resistances de contact
C     ----------------------------------------------------
      IF (NBRESS.GT.0) CALL CORESC (NDIM,NPOINS,NBRESS,NRESCS,COORDS)
C
C     2.11- Calcul distance min
C     -------------------------
      CALL MOBDIS (NBMOBS,NDIM,NODERC,NELERC,NDMASS,NPOINS,COORDS)
C
C     2.12- Rayonnement
C     -----------------
      IF (LRAY) THEN
C
        CALL CPUSYR(T1)
C
C
          IF (TYPRA.EQ.'SIM') THEN
            CALL LRASI3(NDIM,NPOINR,NELRAY,NODRAY,NRFRAY,COORAY)
          ELSEIF (TYPRA.EQ.'IDE') THEN
            CALL LRAID3(NDIM,NPOINR,NELRAY,NODRAY,NRFRAY,COORAY)
          ELSEIF (TYPRA.EQ.'SYR') THEN
            CALL LRASY3(NDIM,NPOINR,NELRAY,NODRAY,NRFRAY,COORAY)
          ENDIF
C
C         Ecriture de la geometrie resultat
C         ---------------------------------
          CALL ECRG1R
     &     ( NFGGRA,NDIM,NDIM-1,NPOINR,NELRAY,NDIM,
     &       COORAY,NODRAY,NRFRAY)

C         Ecriture de l'entete du fichier resultat
C         ----------------------------------------
          NBSCAL=1+NBANDE
          IF (LDEVDI) NBSCAL=NBSCAL+1
          CALL ECRG2E(NBSCAL,NFGRRA,NDIM,NDIM-1,NELRAY,NPOINR) 

C         Decompte
C         --------
          CALL LNRAY2 (NDIM,NELRAY,NODRAY,NRFRAY,NPOINR,
     *                 ITRAV,ITRAV1,
     *                 NNSRAY,NNFRAY,NNERAY,NCSRAY,NCFRAY,NESRAY)
C          
          CALL LFRAY2 (NELRAY,NRFRAY,
     *                 NFCFRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE,
     *                 NGFFIR,NGFTIR,NGFPER,NGFPEF,NGFMST,NGFMSE,ITYFAR)
C          
C
        CALL LECLIR (NDIM,NELRAY,
     *               NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE,
     *               NRFRAY,NGFFIR,NGFTIR,NGFPER,NGFPEF,NGFMST,NGFMSE,
     *               EMISSI,TEMRAY,PHFRAF,PHFRAE,FIRAY,VFIRAY,VFMSTE,
     *               PHMSTP,PHMSTO)
C
       
C
C       
        CALL CPUSYR(TFAC1)

        IF (LECFDF) THEN
           READ(NFFFRA,*) NBRE
           READ(NFFFRA,*) SUFRAY
           READ(NFFFRA,*) NBRE
           READ(NFFFRA,*) FDFRAY
        ELSE
C
          IF (LPERAY) THEN
             IF (NDIM.EQ.2) THEN
               NPERAY = INT(360./PERRAY(3)+0.1)
             ELSE
               NPERAY = INT(360./PERRAY(7)+0.1)
             ENDIF
          ELSE
             NPERAY = 0
          ENDIF
C
          IF (NDIM .EQ. 3) THEN
            CALL CFDF3D (NDIM,NELRAY,NPOINR,NODRAY,COORAY,
     *                   SUFRAY,FDFRAY,NPLASY,PLASYM,
     *                   NPERAY,PERRAY,NDECMX,NRFRAY,
     *                   PINTER,NUMGU,NGUMAX,NBLBLR)
          ELSEIF (IAXISY.EQ.0) THEN
            CALL CFDF2D (NDIM,NELRAY,NPOINR,NODRAY,COORAY,
     *                   SUFRAY,FDFRAY,NPLASY,PLASYM,
     *                   NPERAY,PERRAY,NDECMX,NRFRAY,
     *                   PINTER,NUMGU,NGUMAX,NBLBLR)
          ELSE
            CALL CFDF2A (NDIM,NELRAY,NPOINR,NODRAY,COORAY,
     *                   SUFRAY,FDFRAY,NPLASY,PLASYM,
     *                   IAXISY,NDECMX,NRFRAY,
     *	                 PINTER,NUMGU,NGUMAX,NBLBLR)
          ENDIF
C
          IF (LROUVR) CALL FDFFIN(NELRAY,SUFRAY,FDFRAY,TABRAY(1,9))
C
          IF(NBLBLR.GE.10) CALL CNTLFF(NELRAY,SUFRAY,FDFRAY,TABRAY(1,9))
C
          IF (.NOT.LROUVR .AND. .NOT.LDEVFD)
     *         CALL SMOOGC (FDFRAY,SUFRAY,NELRAY,
     *                  TABRAY(1,1),TABRAY(1,2),TABRAY(1,3),TABRAY(1,4),
     *                  TABRAY(1,5),TABRAY(1,6),TABRAY(1,7))
          IF(NBLBLR.GE.10) CALL CNTLFF(NELRAY,SUFRAY,FDFRAY,TABRAY(1,9))
C
        ENDIF
C
        IF (LSTOKF) THEN
           WRITE(NFFFRA,*) NELRAY
           WRITE(NFFFRA,*) SUFRAY
           WRITE(NFFFRA,*) NELRAY*(NELRAY+1)/2
           WRITE(NFFFRA,*) FDFRAY
        ENDIF
C
        CALL CPUSYR(TFAC2)
        TFAC2=TFAC2-TFAC1
        WRITE(NFECRA,5017) TFAC2
C
C
        CALL CPUSYR(TCORR1)
        IF (LLCORA) THEN
          IF (NBRAYS.GT.0) THEN
               READ (NFCORA,*) NBRE
               READ (NFCORA,*) NCFIN
               READ (NFCORA,*) NBRE
               READ (NFCORA,*) BARYFS
          ENDIF
          IF (NNSRAY.GT.0) THEN
               READ (NFCORA,*) NBRE
               READ (NFCORA,*) NCGROS
               READ (NFCORA,*) NBRE
               READ (NFCORA,*) BARYGR
          ENDIF

        ELSE
C
C         
          DO N=1,NRFMAX
           IREF(N) = IRERCS(N)
          ENDDO
          INDGLO = 1
          IF (NDIM.EQ.3) THEN
             CALL CRROCT (NDIM,NDMASS,NPOINS,COORDS,NELERA,NODERA,
     *                    NBRAYS,NRAYTS,NCFIN,BARYFS,
     *                    NDIM,  NPOINR,COORAY,NELRAY,NODRAY,NRFRAY,
     *                    NNSRAY,NCSRAY,NCGROS,BARYGR,
     *                    IREF,INDGLO,NBLBLR,TRAV1,TRAV2)
          ELSE
             CALL CORAY2 (NDIM,NDMASS,NPOINS,COORDS,NELERA,NODERA,
     *                    NBRAYS,NRAYTS,NCFIN,BARYFS,
     *                    NDIM,  NPOINR,COORAY,NELRAY,NODRAY,NRFRAY,
     *                    NNSRAY,NCSRAY,NCGROS,BARYGR,
     *                    IREF,NRFMAX,INDGLO)
          ENDIF
        ENDIF
C
        IF (LDEVDI) THEN
           CALL ECRG3E(NFGRCT)
           CALL ECRG2R(TRAV1,NPOINS,'DIST_AU_RAY ','3',NFGRCT)
           CALL ECRG3E(NFGRRA)
           CALL ECRG2R(TRAV2,NPOINR,'DIST_AU_SOL ','3',NFGRRA)
        ENDIF
C
        IF (LSTORA) THEN
          IF (NBRAYS.GT.0) THEN
             WRITE (NFCORA,*) NBRAYS
             WRITE (NFCORA,*) NCFIN
             WRITE (NFCORA,*) NBRAYS*NDIM
             WRITE (NFCORA,*) BARYFS
          ENDIF
          IF (NNSRAY.GT.0) THEN
             WRITE (NFCORA,*) NNSRAY*2
             WRITE (NFCORA,*) NCGROS
             WRITE (NFCORA,*) NNSRAY*NDIM
             WRITE (NFCORA,*) BARYGR
          ENDIF
        ENDIF
C
        CALL CPUSYR(TCORR2)
        TCORR2=TCORR2-TCORR1
        WRITE(NFECRA,5018) TCORR2
C
C
        IF (NFMST.GT.0) CALL COUMST (NDIM,NELRAY,NPOINR,NODRAY,
     *                               COORAY,NFMST,NGFMST,NBLBLR)
C
        CALL CPUSYR(TOTRAI)
        TOTRAI = TOTRAI - T1
C
      ENDIF
C
C
C     3- SOUS-PROGRAMMES UTILISATEUR
C     ==============================
C
C      3.1- Initialisation de la temperature dans le solide
C      ----------------------------------------------------
C      (Sous-programme utilisateur)
C
       CALL INITMP (NDIM,NPOINS,NELEMS,NDMATS,NODES,
     *              COORDS,NREFS,NREFE,TMPSA,TMPS)
C
C      3.3.2- Initialisation des conditions aux limites de type
C             rayonnement confine transparent
C      -------------------------------------- 
C      (Sous-programme utilisateur)
C
       IF (LRAY) THEN
C
         CALL LIMRAY (NDIM,NELRAY,NPOINR,
     *              NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,
     *              NODRAY,NRFRAY,NGFFIR,NGFTIR,NGFPER,NGFPEF,
     *              COORAY,EMISSI,TEMRAY,FIRAY,PHFRAF,PHFRAE,VFIRAY)
C
C     3.3.3- Remplissage des conditions de type flux impose par bande
C      -------------------------------------------------------------
         DO 333 NUMBAN=1,NBANDE
            DO 334 N=1,NFFIRA
                NGFAC = NGFFIR(N)
                VFIRAY(N,NUMBAN,2) = EMISSI(NGFAC,1,NUMBAN)
  334       CONTINUE
  333    CONTINUE     
C
       ENDIF     
C
C      3.4- Initialisation des flux volumiques
C      ----------------------------------------
C      (Sous-programme utilisateur)
C       Inutile, fait dans RESSOL
C
C     4- CAS DES SOLIDES EN TRANSLATION
C     =================================
C
      IF (LSDEPL) THEN
C
C
         IF (NCTHFS.EQ.3) 
     *     CALL MOBRES (NPOINS,NBRESS,NRESCS,VRESCS,NREFS,
     *                  NODERC,NFRESC,VFRESC,NELERC,NDMASS,
     *                  NREFAL,NELEUS,ITRAV)
C
         NUMA = 2
         CALL MOBTMP (NUMA,NDIM,NPOINS,TMPSA,TMPS)
C
       ENDIF
C
C
C     5- LECTURE DU FICHIER SUITE (si suite de calcul)
C     ================================================
C
      NTSYRD=0
      IF (LSUISO) THEN
        CALL LECSOL(NDIM,NDIELE,NPOINS,NELEMS,
     *              TMPSA,TMPS,TMPSC1,TMPSC2,TMPSC3,TMPMAX,TMPMIN)
	NTSYRD=NTSYR
      ENDIF
C
      IF (LRAY.AND.NFMST.GT.0) THEN
        DO I=1,NBANDE
         DO N=1,NFMST
          EMISSI(NGFMST(N,1),1,I)=PHMSTO(N,1,I)
         ENDDO
        ENDDO
        CALL INIMST(NELRAY,EMISSI,TEMRAY,FDFRAY,TABRAY(1,8),
     *               SUFRAY,RADIOS)
      ENDIF
C
C     6- ECRITURE DU FICHIER CHRONO
C     =============================
C
      IF (LSUISO .AND. (NCHROS.GE.1)) THEN
        NBSCAL=1
        CALL ECRG2E(NBSCAL,NFGCCT,NDIM,NDIELE,NELEMS,NPOINS) 
        CALL ECRG3E(NFGCCT) 
        CALL ECRG2R(TMPS,NPOINS,'TEMP_SOLIDE ','3',NFGCCT)
        CALL FLUSHF(NFGCCT)
      ENDIF
C
C     7- INITIALISATIONS 
C     ==================
C
C
C     7.1- Initialisation des coefficients du modele coque
C     ----------------------------------------------------
      IF (NCTHFS.EQ.2 .AND. .NOT. LSUISO) THEN
        DO 700 N=1,NPOINS
         TMPSC1(N) = (TMPSA(N) + TMPS(N) ) * 0.5D0
         TMPSC2(N) = 0.D0
         TMPSC3(N) = 0.D0
  700  CONTINUE
      ENDIF
C
C     7.2- Initialisations
C     --------------------
      IF (LRAY) THEN
        DO 720 N=1,NELRAY
          TRAYEQ(N) = TEMRAY(N)
          ERAYEQ(N) = 1.
  720   CONTINUE
C
      IF (LCFACE) THEN
        DO 721 N=1,NELERA*NDMASS*2
         VFRAYS(N,1,1) = 0.
  721   CONTINUE
      ELSE
        DO 722 N=1,NBRAYS*2
         VRAYTS(N,1) = 0.
  722   CONTINUE
      ENDIF

      ENDIF
C
C     8- INITIALISATION DU TEMPS 
C     ==========================
C
C       8.1- INITIALISATION DU TEMPS REEL
C       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
        IF (.NOT. LSUISO) THEN
cc          IF (LSYRTH) THEN
             TEMPSS = 0.
             NTSYR    = 0
cc           ELSE
cc             TEMPSS = RDTTS
cc             NTSYR    = 0
cc           ENDIF
        ENDIF
C
C
C       8.2- INITIALISATION DU PAS DE TEMPS SOLIDE
C       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
C
        PREMPA = .TRUE.
C
C
C      9- HISTORIQUES EN TEMPS
C      =======================
       IF (LHISOL) THEN
C
         IF (LSUISO) THEN
            THISSO = INT (TEMPSS / XFREQS) * XFREQS
         ELSE
            THISSO = 0.
         ENDIF
       ENDIF
C           
C--------
C FORMATS
C--------
C
 1000 FORMAT(/,'  --> ATTENTION : LE CALCUL SOLIDE EST FAIT',
     &         ' EN AXISYMETRIQUE')
C
 2100 FORMAT(/,'  %% ERREUR INISOL : TYPE DE MAILLAGE ELEMENTS',
     &         ' FINIS INCONNU')
 2200 FORMAT(/,'  $$ REMARQUE : DANS LE CAS D''UN MAILLAGE DE TYPE ',
     &         ' SIMAIL,',/,
     &         '                LES REFERENCES DES FACES SONT ',
     &         'IMPOSEES AU NIVEAU DU MAILLEUR',/,
     &         '                LE SOUS-PROGRAMME inrefa DE ',
     &         'MODIFICATION MANUELLE DES REFERENCES DES FACES',/,
     &         '                N''EST PAS PRIS EN COMPTE')
 3100 FORMAT (/,'LA DATE D''UTILISATION DE SYRTHES EST EXPIREE',/)
 3200 FORMAT (/,'VERSION SYRTHES NON ACTIVABLE --> Contacter C.P.',/)
 5017 FORMAT(' *** INITIALISATION : temps CPU necessaire au calcul',
     &             ' des facteurs de forme : ',E15.5,' s')
 5018 FORMAT(' *** INITIALISATION : temps CPU necessaire au calcul',
     &             ' des correspondants rayonnement : ',E15.5,' s')
 9000 FORMAT(/,'  %% ERREUR INISOL : Erreur sur le nombre de noeuds',
     &         ' avec historiques en temps',/,
     &         '     On en trouve : ',I6,/,
     &         '     Le tableau est dimensionne a : ',I6)
C----
C FIN
C----
C
      END


