C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                    ****************
                     SUBROUTINE DIFSOL
C                    *****************
C
C     ---------------------------------------------------
     *( TMPS,TMPSA,B,DMAT,XMAT,PHYSOL,
     *  COORDS,NODES,NODEUS,NFLUVS,VFLUVS,NDIRS,VDIRS,
     *  NCOUPS,VCOUPS,NFLUSS,VFLUSS,NECHS,VECHS,
     *  NODERC,NODEPR,NPRIOS,NRESCS,VRESCS,
     *  NRAYTS,VRAYTS,NBRAYS,
     *  NRAYIS,VRAYIS,NBRAIS,
     *  VOLUME,SURFUS,DIAG,
     *  NELEMS,NPOINS,NDIM,NDIELE,NDMATS,NDMASS,NCOEMA,
     *  NPOUE,NPPEL,NBPHYS,
     *  NELEUS,NELERC,NELEPR,
     *  NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL,NBRESS,
     *  NBPRIO,NBCOPR,
     *  NFFLUS,VFFLUS,NBFFLU,NFECHS,VFECHS,NBFECH, 
     *  NFRESC,VFRESC,
     *  NFRAYS,VFRAYS,NELERA,
     *  NFRAIS,VFRAIS,NBFRAI,
     *  NFCOUS,VFCOUS,NELESS,NANGLE,TRAVF,
     *  TRAV1,TRAV2,TRAV3,TRAV4,WCT)
C     -------------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     TRAITEMENT DE LA DIFFUSION SOLIDE                 *
C                    CAS BIDIMENSIONNEL, AXISYMETRIQUE, COQUE          *
C                    ET TRIDIMENSIONNEL, PAR LA METHODE                *
C                    DES ELEMENTS FINIS                                *
C                                                                      *
C      On notera que les conditions limites de type flux et echange    *
C      peuvent etre prise en compte de deux facons differentes         *
C                                                                      *
C      Soit par points --> ce qui induit une facilite de prise         *
C                          en compte pour l'utilisateur, mais tend     *
C                          a lisser les discontinuites                 *
C                          qui, il faut bien le reconnaitre ne sont pas*
C                          tres "physiques", sauf pour le cas d'une    *
C                          rupture brutale de geometrie (type coin)    *
C                                                                      *
C      Soit par faces  --> ce qui induit une complexite plus grande    *
C                          pour l'utilisateur (en particulier pour     *
C                          ideas ou les notions de faces n'existe pas) *
C                          mais permet de mieux apprehender            *
C                          les chargements discontinus                 *
C                          (singularite par exemple de type step !)    *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   TMPS    !  TR  ! R  ! TEMPERATURE EN CHAQUE POINT A T = N + 1  !
C   !   TMPSA   !  TR  ! D  ! TEMPERATURE EN CHAQUE POINS A T = N      !
C   !   DMAT    !  TR  ! M  ! DIAGONALE DE LA MATRICE M                !
C   !   XMAT    !  TR  ! M  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   PHYSOL  !  TR  ! D  ! CARACTERISTIQUE DU SOLIDE                !
C   !           !      !    !  physol(n,1) = rho (masse volumique)     !
C   !           !      !    !  physol(n,2) = Cp (chaleur massique)     !
C   !           !      !    !  physol(n,3) = k conductivite (ou k11)   !
C   !           !      !    !  a partir de 4 c'est optionnel si anisotr!
C   !           !      !    !  physol(n,4) = k conductivite (k22)      !
C   !           !      !    !  physol(n,5) = k conductivite k23 ou k33 !
C   !           !      !    !  physol(n,6) = k conductivite k12        !
C   !           !      !    !  physol(n,7) = k conductivite k13        !
C   !           !      !    !  physol(n,8) = k conductivite k23        !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   NODEUS  !  TE  ! D  !   // NOEUDS LOCAUX FLUX BORD --> GLOBAUX !
C   !   NFLUVS  !  TE  ! D  ! NUMERO DES POINTS DE FLUX VOLUMIQUE      !
C   !   VFLUVS  !  TR  ! D  ! VALEUR DU FLUX AU POINT DE FLUX VOLUMIQUE!
C   !   NCOUPS  !  TE  ! D  ! NUMERO DES POINTS DE COUPLAGE            !
C   !   VCOUPS  !  TR  ! D  ! VALEUR DU FLUX AU POINT DE COUPLAGE      !
C   !   NFLUSS  !  TE  ! D  ! NUMERO DES POINTS DE FLUX                !
C   !   VFLUSS  !  TR  ! D  ! VALEUR DU FLUX AU POINT DE FLUX          !
C   !   NDIRS   !  TE  ! D  ! NUMERO DES POINTS DE DIRICHLET           !
C   !   VDIRS   !  TR  ! D  ! VALEUR DE DIRICHLET                      !
C   !   NECHS   !  TE  ! D  ! NUMERO DES POINTS DE COEF D'ECHANGE      !
C   !   VECHS   !  TR  ! D  ! VALEUR POUR LES POINTS A COEF D'ECHANGE  !
C   !           !  TR  ! D  !     VECHS(n,1) = Temperature exterieure  !
C   !           !  TR  ! D  !     VECHS(n,2) = Coef d'echange          !
C   !   NFFLUS  !  TE  ! D  ! No de facette flux ---> face glob        !
C   !   VFFLUS  !  TR  ! D  ! Valeur des flux a chaque point de la face!
C   !   NBFFLU  !  E   ! D  ! Nombre de facette de type flux           ! 
C   !   NFECHS  !  TE  ! D  ! No de facette echange ---> face glob     !
C   !   VFECHS  !  TR  ! D  ! Valeur des echan aux points de la face   !
C   !   NBFECH  !  E   ! D  ! Nombre de facette de type echange        ! 
C   !   NFRESC  !  TE  ! D  ! No de facette resistance ---> face glob  !
C   !   VFRESC  !  TR  ! D  ! Valeur des resista aux points de la face !
C   !   NELERC  !  E   ! D  ! Nombre de facette de type resistance     ! 
C   !   NFRAYS  !  TE  ! D  ! No de facette rayont conf ---> face glob !
C   !   VFRAYS  !  TR  ! D  ! Valeur du rayo conf aux points de la face!
C   !   NELERA  !  E   ! D  ! Nombre de facette de type rayonnnt conf  ! 
C   !   NFRAIS  !  TE  ! D  ! No de facette rayont infi ---> face glob !
C   !   VFRAIS  !  TR  ! D  ! Valeur du rayo infi aux points de la face!
C   !   NBFRAI  !  E   ! D  ! Nombre de facette de type rayonnnt infi  ! 
C   !   NFCOUS  !  TE  ! D  ! No de facette couplee ---> face glob     !
C   !   VFCOUS  !  TR  ! D  ! Valeur du couplage aux points de la face !
C   !   NELESS  !  E   ! D  ! Nombre de facette de type couplee        ! 
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                !
C   !   SURFUS  !  TR  ! D  ! EN 3D SURFACE DU TRIANGLE DE BORD (flux) !
C   !           !      !    ! EN 2D LONGUEUR DU SEGMENT DE BORD (flux) !
C   !   DIAG    !  TR  ! M  ! DIAGONALE DE PRECONDITIONNEMENT          !
C   !   TRAV1   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPMXS)       !
C   !   TRAV2   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPMXS)       ! 
C   !   TRAV3   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPMXS)       ! 
C   !   TRAV4   !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPMXS)       !  
C   !   TRAVF   !  TR  ! M  ! TABLEAU DE TRAVAIL(Taille: NELEUS*NDMASS)!  
C   !   WCT     !  TR  ! M  ! TABLEAU  DE TRAVAIL ( NELEMS * NDMATS)   !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "divct.h"
C
C***********************************************************************
C.. Variables externes
      INTEGER NPOINS,NELEMS,NDMATS,NELEUS,NDMASS,NDIM,NCOEMA,NDIELE
      INTEGER NPOUE,NPPEL,NBPHYS
      INTEGER NBCOUS,NBFLUS,NBECHS,NBFLVS,NPFEL,NBDIRS,NBPRIO,NBCOPR
      INTEGER NBRAYS,NBRAIS
      INTEGER NELERA,NBFRAI
      INTEGER NBRESS
      INTEGER NELERC,NELEPR
      INTEGER NBFFLU,NBFECH,NELESS
      INTEGER NFFLUS(NBFFLU),NFECHS(NBFECH),NFRESC(NELERC)
      INTEGER NFCOUS(NELESS)
C
      INTEGER NODES(NELEMS,NDMATS)
      INTEGER NODEUS(NELEUS,NDMASS)
      INTEGER NODERC(NELERC,NDMASS),NODEPR(NELEPR,NDMATS+1)
      INTEGER NFLUVS(NBFLVS)
      INTEGER NDIRS(NBDIRS),NCOUPS(NBCOUS),NFLUSS(NBFLUS),NECHS(NBECHS)
      INTEGER NRESCS(NBRESS,2),NPRIOS(NBPRIO,1+NBCOPR)
      INTEGER NRAYTS(NBRAYS),NRAYIS(NBRAIS)
      INTEGER NFRAYS(NELERA),NFRAIS(NBFRAI)
      INTEGER NANGLE(NELEMS)
C
      DOUBLE PRECISION COORDS(NPOINS,NDIM),B(NPOINS)
      DOUBLE PRECISION XMAT(NELEMS,NCOEMA)
      DOUBLE PRECISION DMAT(NPOINS)
      DOUBLE PRECISION TMPS(NPOINS),TMPSA(NPOINS)
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)
      DOUBLE PRECISION VFLUVS(NBFLVS,NPFEL)
      DOUBLE PRECISION VDIRS(NBDIRS),VCOUPS(NBCOUS,2)
      DOUBLE PRECISION VFLUSS(NBFLUS),VECHS(NBECHS,2)
      DOUBLE PRECISION DIAG(NPOINS),VOLUME(NELEMS),SURFUS(NELEUS)
      DOUBLE PRECISION VRESCS(NBRESS,2)
      DOUBLE PRECISION VRAYTS(NBRAYS,2),VRAYIS(NBRAIS,2)
      DOUBLE PRECISION VFRAYS(NELERA,NDMASS,2),VFRAIS(NBFRAI,NDMASS,2)
C
      DOUBLE PRECISION VFFLUS(NBFFLU,NDMASS),VFECHS(NBFECH,NDMASS,2)
      DOUBLE PRECISION VFRESC(NELERC,NDMASS,2)
      DOUBLE PRECISION VFCOUS(NELESS,NDMASS,2)
C
C     tableaux de travail
      DOUBLE PRECISION TRAV1(NPOINS),TRAV2(NPOINS)
      DOUBLE PRECISION TRAV3(NPOINS),TRAV4(NPOINS)
      DOUBLE PRECISION TRAVF(NELEUS,NDMASS)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
C
C.. Variables internes
      DOUBLE PRECISION ZERO,RINDTS
      INTEGER I
      LOGICAL LVERIF
C***********************************************************************
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .TRUE.
      ZERO   = 0.D0
C
C
C     2- CALCUL DE LA MATRICE DE MASSE MASSLUMPEE
C     ===========================================
C
C     2.1 Prise en compte du terme d'evolution en temps
C     -------------------------------------------------
      IF (NDPROP .EQ. 1) THEN
        RINDTS = 1.D0 / RDTTS
        DO 20 I=1,NPOINS
          TRAV1(I) =  PHYSOL(I,1,1) * PHYSOL(I,1,2) * RINDTS
   20   CONTINUE
      ENDIF
C     
        CALL MATELE ('MASSE   ',TRAV2,XMAT,TRAV1,PHYSOL,NODES,COORDS, 
     &               VOLUME,
     &               NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &               NPOUE,NPPEL,NBPHYS,
     &               WCT ) 
C   
C
C     2.2 Prise en compte des termes du a l'implicitation suivant 
C         le mot cle LCLEXP
C 
      IF ( LCLEXP ) THEN
C
          CALL OV ('X=C     ',TRAV4,TRAV4,TRAV4,ZERO,NPOINS ) 
C
      ELSE
C
C
          IF ( LCFACE ) THEN
            CALL MAFCLI ( NFECHS,VFECHS,NBFECH, 
     &                    NFRESC,VFRESC,NELERC,
     &                    NFRAYS,VFRAYS,NELERA,
     &                    NFRAIS,VFRAIS,NBFRAI,
     &                    NFCOUS,VFCOUS,NELESS,
     &                    TMPSA,NODEUS,COORDS,SURFUS,
     &                    NPOINS,NELEMS,NDIM,NELEUS,NDMASS,
     &                    TRAVF,TRAV4,WCT)
C
          ELSE
            CALL MATCLI ( NCOUPS,VCOUPS,NECHS,VECHS,
     &                    NRESCS,VRESCS,
     &                    NRAYTS,VRAYTS,NBRAYS,
     &                    NRAYIS,VRAYIS,NBRAIS,
     &                    TMPSA,NODEUS,COORDS,SURFUS,
     &                    NPOINS,NELEMS,NDIM,NELEUS,NDMASS,
     &                    NBCOUS,NBECHS,NBRESS,
     &                    TRAV1,TRAV4,DIAG,WCT)
          ENDIF
C          ATTENTION :
C          ===========
C
      ENDIF
C
C     3- CALCUL DE LA MATRICE DE DIFFUSION
C     =====================================
C
C     3.1 Affectation de la conductivite k dans TRAV1
C     -----------------------------------------------
C
        CALL MATELE ('DIFFU   ',TRAV3,XMAT,TRAV1,PHYSOL,NODES,COORDS,
     &                VOLUME,
     &                NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     &                NPOUE,NPPEL,NBPHYS,
     &                WCT )
C
C
      IF ( LCFACE ) THEN
        DO 310 I=1,NPOINS
          DMAT(I) = TRAV2(I) + TRAV3(I) + TRAV4(I)  
  310   CONTINUE
      ELSE
        DO 311 I=1,NPOINS
          DMAT(I) = TRAV2(I) + TRAV3(I) + TRAV4(I) + DIAG(I)
  311   CONTINUE
      ENDIF
C
C
C     3.2 Prise en compte des conditions periodiques sur la diagonale
C     ---------------------------------------------------------------
C
        IF (NBPRIO .GT. 0) THEN
          CALL PERIOD(DMAT,TRAV1,NPOINS,NPRIOS,NBPRIO,NBCOPR)
        ENDIF
C
C
C     4- CALCUL DU SECOND MEMBRE
C     ==========================
C
C         4.1 Calcul du second membre explicite (Etape n)
C         -----------------------------------------------
             CALL SMEXPS ( TMPSA,B,TRAV2,NPOINS )
C          
C         4.2 Prise en compte d'un flux volumique
C         --------------------------------------- 
          IF ( NBFLVS .GT. 0 ) THEN   
            CALL SMFVOS ( NFLUVS,VFLUVS,B,NODES,VOLUME,COORDS,
     &                    NELEMS,NPOINS,NDMATS,NDIM,NBFLVS,NPFEL,
     &                    NDIELE,TRAV1,WCT)
          ENDIF
C          
C         4.3 Prise en compte des conditions periodiques
C         ------------------------------------------------
          IF (NBPRIO .GT. 0) THEN
            CALL PERIOD(B,TRAV1,NPOINS,NPRIOS,NBPRIO,NBCOPR)
          ENDIF
C
C          
C         4.4 Prise en compte des conditions de flux a la frontiere
C         ------------------------------------------------------           
C         cela comprend : 
C         --------------   la partie couplee au fluide
C                          la partie avec flux de bord utilisateur
C                          la partie avec coefficient d'echange.
C                          la partie avec resistance de contact
C                          la partie avec rayonnement
C
C
          IF ( LCFACE ) THEN
            CALL SMFFLU ( NFFLUS,VFFLUS,NBFFLU,NFECHS,VFECHS,NBFECH,  
     &                    NFRESC,VFRESC,NELERC,
     &                    NFRAYS,VFRAYS,NELERA,
     &                    NFRAIS,VFRAIS,NBFRAI,
     &                    NFCOUS,VFCOUS,NELESS,
     &                    TMPSA,B,NODEUS,COORDS,SURFUS,
     &                    NPOINS,NELEMS,NDIM,NELEUS,NDMASS,
     &                    TRAVF,TRAV4,WCT)
          ELSE
            CALL SMFLUS ( NCOUPS,VCOUPS,NFLUSS,VFLUSS,NECHS,VECHS,
     &                    NRESCS,VRESCS,
     &                    NRAYTS,VRAYTS,NBRAYS,
     &                    NRAYIS,VRAYIS,NBRAIS,
     &                    TMPSA,B,NODEUS,COORDS,SURFUS,
     &                    NPOINS,NELEMS,NDIM,NELEUS,NDMASS,
     &                    NBCOUS,NBFLUS,NBECHS,NBRESS,
     &                    TRAV1,TRAV4,DIAG,TRAV2,WCT)
          ENDIF 
C
C
C
C         4.5 Prise en compte des conditions de Dirichlet 
C         -----------------------------------------------
          IF ( NBDIRS .GT. 0 ) THEN
            CALL SMDIRS ( NDIRS,VDIRS,B,DMAT,XMAT,NODES,
     &                    TRAV1,TRAV2,TRAV3,
     &                    NPOINS,NELEMS,NDMATS,NBDIRS,NCOEMA,
     &                    NDIELE,NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR,
     &                    WCT ) 
          ENDIF
C
C
C         4.6 Correction de la matrice pour les angles ouverts
C         ---------------------------------------------------
ch          CALL ANGOUV(NDIM,NPOINS,NELEMS,NCOEMA,NDMATS,NODES,
ch     *                NANGLE,DMAT,XMAT)
C
C     5- ETAPE DE RESOLUTION DU SYSTEME LINEAIRE
C     ==========================================
C
C         5.1- Cas general (bidimensionnel, axisymetrique et
C         -------------------------------------------------
C         tridimensionnel.
C         ----------------
          CALL FLUSHF(NFECRA)
C
          CALL OV ('X=1/Y   ',DIAG,DMAT,DMAT,ZERO,NPOINS )
C
          CALL GRCONJ ( TMPS,DMAT,XMAT,B,DIAG,NODES,
     &                  TRAV1,TRAV2,TRAV3,TRAV4,WCT,
     &                  NPOINS,NELEMS,NDIELE,NDMATS,NCOEMA,
     &                  NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C      
cc          CALL GRCON3 ( TMPS,DMAT,XMAT,B,DIAG,NODES,
cc     &                  TRAV1,TRAV2,TRAV3,TRAV4,WCT,
cc     &                  NPOINS,NELEMS,NDIELE,NDMATS,NCOEMA,
cc     &                  NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C
      END
