/* File : example.i */
%module Example

%{
#include "example.h"
%}

%include "example_const.i"

// such features are generated by the following pragmas
#if 0
%feature("modula3:enumitem:enum","Days")    DAY_MONDAY;
%feature("modula3:enumitem:name","monday")  DAY_MONDAY;
%feature("modula3:enumitem:conv","int:int") DAY_MONDAY;

%feature("modula3:enumitem:enum","Month")     MTHB_JANUARY;
%feature("modula3:enumitem:name","january")   MTHB_JANUARY;
%feature("modula3:enumitem:conv","set:int")   MTHB_JANUARY;
//%feature("modula3:constset:type","MonthSet")      MTHB_JANUARY;  /*type in the constant definition*/
%feature("modula3:constset:set", "MonthSet")      MTHB_JANUARY;  /*remarks that the 'type' is a set type*/
%feature("modula3:constset:base","Month")         MTHB_JANUARY;
%feature("modula3:constset:name","monthsJanuary") MTHB_JANUARY;
%feature("modula3:constset:conv","set:set")       MTHB_JANUARY;  /*conversion of the bit pattern: no change*/

%feature("modula3:enumitem:enum","Color")     BLUE;
%feature("modula3:enumitem:name","blue")      BLUE;
%feature("modula3:enumitem:conv","int:int")   BLUE;

%feature("modula3:constint:type","INTEGER") Foo::IMPULSE;
%feature("modula3:constint:name","impulse") Foo::IMPULSE;
%feature("modula3:constint:conv","int:int") Foo::IMPULSE;
#endif

%rename(pi) PI;

%pragma(modula3) enumitem="prefix=DAY_;int;srcstyle=underscore;Day";

%pragma(modula3) enumitem="enum=color;int;srcstyle=underscore;Color";
%pragma(modula3) makesetofenum="Color";
%pragma(modula3) constset="prefix=CLB_;set;srcstyle=underscore,prefix=clb;ColorSet,Color";

%pragma(modula3) enumitem="prefix=MTHB_,enum=calendar;set;srcstyle=underscore;Month";
%pragma(modula3) makesetofenum="Month";
%pragma(modula3) constset="prefix=MTHB_,enum=calendar;set;srcstyle=underscore,prefix=monthset;MonthSet,Month";

%pragma(modula3) constint="prefix=Answer::Foo::,enum=Answer::Foo::speed;int;srcstyle=underscore,prefix=speed;INTEGER";

%pragma(modula3) constint="prefix=Answer::,enum=Answer::;int;srcstyle=underscore,prefix=answer;CARDINAL";

%rename(AnswerFoo) Answer::Foo;
%typemap("m3rawrettype")   Answer::Foo * %{AnswerFoo%}
%typemap("m3rawintype")    Answer::Foo * %{AnswerFoo%}
%typemap("m3rawinmode")    Answer::Foo * %{%}
%typemap("m3wraprettype")  Answer::Foo * %{AnswerFoo%}
%typemap("m3wrapintype")   Answer::Foo * %{AnswerFoo%}
%typemap("m3wrapinmode")   Answer::Foo * %{%}
%typemap("m3wrapargraw")   Answer::Foo * %{self.cxxObj%}

%typemap("m3wrapretvar")   Answer::Foo * %{cxxObj : ExampleRaw.AnswerFoo;%}
%typemap("m3wrapretraw")   Answer::Foo * %{cxxObj%}
%typemap("m3wrapretconv")  Answer::Foo * %{NEW(AnswerFoo,cxxObj:=cxxObj)%}


%typemap("m3rawintype")        Answer::Foo::speed %{C.int%};
%typemap("m3rawintype:import") Answer::Foo::speed %{Ctypes AS C%};
%typemap("m3wrapintype")       Answer::Foo::speed %{[-2..3]%};

%typemap("m3wrapintype")       color %{Color%};
%typemap("m3wrapargraw")       color %{ORD($1_name)%};

/* Let's just grab the original header file here */
%include "example.h"
