/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import java.util.Properties;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Install;

public class WrapperExecutor {
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String DISTRIBUTION_BASE_PROPERTY = "distributionBase";
    public static final String ZIP_STORE_BASE_PROPERTY = "zipStoreBase";
    public static final String DISTRIBUTION_PATH_PROPERTY = "distributionPath";
    public static final String ZIP_STORE_PATH_PROPERTY = "zipStorePath";
    private final Properties properties;
    private final URI distribution;
    private final File propertiesFile;
    private final Appendable warningOutput;

    public static WrapperExecutor forProjectDirectory(File projectDir, Appendable warningOutput) {
        return new WrapperExecutor(new File(projectDir, "gradle/wrapper/gradle-wrapper.properties"), new Properties(), warningOutput);
    }

    public static WrapperExecutor forWrapperPropertiesFile(File propertiesFile, Appendable warningOutput) {
        return new WrapperExecutor(propertiesFile, new Properties(), warningOutput);
    }

    WrapperExecutor(File propertiesFile, Properties properties, Appendable warningOutput) {
        this.properties = properties;
        this.propertiesFile = propertiesFile;
        this.warningOutput = warningOutput;
        if (propertiesFile.exists()) {
            try {
                WrapperExecutor.loadProperties(propertiesFile, properties);
                this.distribution = this.prepareDistributionUri();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not load wrapper properties from '%s'.", propertiesFile), e);
            }
        } else {
            this.distribution = null;
        }
    }

    private URI prepareDistributionUri() throws URISyntaxException {
        URI source = this.readDistroUrl();
        if (source.getScheme() == null) {
            return new File(this.propertiesFile.getParentFile(), source.getSchemeSpecificPart()).toURI();
        }
        return source;
    }

    private URI readDistroUrl() throws URISyntaxException {
        if (this.properties.getProperty(DISTRIBUTION_URL_PROPERTY) != null) {
            return new URI(this.getProperty(DISTRIBUTION_URL_PROPERTY));
        }
        return this.readDistroUrlDeprecatedWay();
    }

    private URI readDistroUrlDeprecatedWay() throws URISyntaxException {
        String distroUrl = null;
        try {
            distroUrl = this.getProperty("urlRoot") + "/" + this.getProperty("distributionName") + "-" + this.getProperty("distributionVersion") + "-" + this.getProperty("distributionClassifier") + ".zip";
            Formatter formatter = new Formatter();
            formatter.format("%s contains deprecated entries: 'urlRoot', 'distributionName', 'distributionVersion' and 'distributionClassifier' are deprecated and will be removed soon. Please use '%s' instead.%n", this.properties, DISTRIBUTION_URL_PROPERTY);
            this.warningOutput.append(formatter.toString());
        }
        catch (Exception e) {
            this.reportMissingProperty(DISTRIBUTION_URL_PROPERTY);
        }
        return new URI(distroUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(File propertiesFile, Properties properties) throws IOException {
        FileInputStream inStream = new FileInputStream(propertiesFile);
        try {
            properties.load(inStream);
        }
        finally {
            ((InputStream)inStream).close();
        }
    }

    public URI getDistribution() {
        return this.distribution;
    }

    public void execute(String[] args, Install install, BootstrapMainStarter bootstrapMainStarter) throws Exception {
        if (this.distribution == null) {
            throw new FileNotFoundException(String.format("Wrapper properties file '%s' does not exist.", this.propertiesFile));
        }
        File gradleHome = install.createDist(this.getDistribution(), this.getProperty(DISTRIBUTION_BASE_PROPERTY), this.getProperty(DISTRIBUTION_PATH_PROPERTY), this.getProperty(ZIP_STORE_BASE_PROPERTY), this.getProperty(ZIP_STORE_PATH_PROPERTY));
        bootstrapMainStarter.start(args, gradleHome);
    }

    private String getProperty(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (value == null) {
            return this.reportMissingProperty(propertyName);
        }
        return value;
    }

    private String reportMissingProperty(String propertyName) {
        throw new RuntimeException(String.format("No value with key '%s' specified in wrapper properties file '%s'.", propertyName, this.propertiesFile));
    }
}

