/*
 *  SPL - The SPL Programming Language
 *  Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  c-api-test1.c: Simple test for the plain bytecode interpreter.
 */

#ifndef USEWIN32API
#  include <sys/types.h>
#  include <netinet/in.h>
#else
#  define htonl(x) \
	((((unsigned int)(x) & 0xff000000) >> 24) | \
	 (((unsigned int)(x) & 0x00ff0000) >> 8)  | \
	 (((unsigned int)(x) & 0x0000ff00) << 8)  | \
	 (((unsigned int)(x) & 0x000000ff) << 24))
#endif

#include <stdio.h>

#include "spl.h"

unsigned char demoprog[] =
	SPL_SIGNATURE "\000"
	"\x24\xff\xff\xff\xff"	//  0 -  4: pushc "hello"
	"\x24\xff\xff\xff\xff"	//  5 -  9: pushc " "
	"\x24\xff\xff\xff\xff"	// 10 - 14: pushc "world"
	"\xa2\xa2\xf8"		// 15 - 17: cat, cat, debug
	"\x24\xff\xff\xff\xff"  // 18 - 22: pushc "42"
	"\xf2"			// 23 - 23: rlret
	"hello\x00"		// 24 - 29: "hello"
	" \x00"			// 30 - 31: " "
	"world\x00"		// 32 - 37: "world"
	"42";			// 38 - 40: "42"

int main()
{
	*((int32_t*)(demoprog+ 1+sizeof(SPL_SIGNATURE))) = htonl(24 -  5);
	*((int32_t*)(demoprog+ 6+sizeof(SPL_SIGNATURE))) = htonl(30 - 10);
	*((int32_t*)(demoprog+11+sizeof(SPL_SIGNATURE))) = htonl(32 - 15);
	*((int32_t*)(demoprog+19+sizeof(SPL_SIGNATURE))) = htonl(38 - 23);

	if ( sizeof(demoprog) != 41+sizeof(SPL_SIGNATURE) )
		printf("WARNING: demoprog[] is %d bytes long.\n", (int)sizeof(demoprog));

	struct spl_vm *vm = spl_vm_create();
	struct spl_task *task = spl_task_create(vm, 0);
	struct spl_code *code = spl_code_get(0);

	code->code_type = SPL_CODE_STATIC;
	code->code = demoprog;
	spl_task_setcode(task, code);

	while ( spl_exec(task) != 42 ) {}

	spl_vm_destroy(vm);
	return 0;
}

