// Copyright (c) 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_IMPORTER_IMPORTER_TEST_REGISTRY_OVERRIDER_WIN_H_
#define CHROME_COMMON_IMPORTER_IMPORTER_TEST_REGISTRY_OVERRIDER_WIN_H_

#include <string>

// A helper class to let tests generate a random registry key to be used in
// HKEY_CURRENT_USER in tests. After the key has been generated by constructing
// an ImporterTestRegistryOverrider, consumers in this process (or in any
// child processes created after the key has been generated) can obtain the key
// via GetTestRegistryOverride(). ImporterTestRegistryOverrider will delete
// the temporary key upon being deleted itself. Only one
// ImporterTestRegistryOverrider should live at once in a given process
// hiearchy.
class ImporterTestRegistryOverrider {
 public:
  ImporterTestRegistryOverrider();

  ImporterTestRegistryOverrider(const ImporterTestRegistryOverrider&) = delete;
  ImporterTestRegistryOverrider& operator=(
      const ImporterTestRegistryOverrider&) = delete;

  ~ImporterTestRegistryOverrider();

  // Returns a test key if one was chosen and set by a call to
  // SetTestRegistryOverride(); returns the empty string if none.
  static std::wstring GetTestRegistryOverride();

 private:
  std::wstring temporary_key_;
};

#endif  // CHROME_COMMON_IMPORTER_IMPORTER_TEST_REGISTRY_OVERRIDER_WIN_H_
