# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class Agent(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Agent resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Resource system metadata.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar description: A description for the Agent.
    :vartype description: str
    :ivar agent_version: The Agent version.
    :vartype agent_version: str
    :ivar arc_resource_id: The fully qualified resource ID of the Hybrid Compute resource for the
     Agent. Required.
    :vartype arc_resource_id: str
    :ivar arc_vm_uuid: The VM UUID of the Hybrid Compute resource for the Agent. Required.
    :vartype arc_vm_uuid: str
    :ivar agent_status: The Agent status. Known values are: "Registering", "Offline", "Online",
     "Executing", "RequiresAttention", and "Unregistering".
    :vartype agent_status: str or ~azure.mgmt.storagemover.models.AgentStatus
    :ivar last_status_update: The last updated time of the Agent status.
    :vartype last_status_update: ~datetime.datetime
    :ivar local_ip_address: Local IP address reported by the Agent.
    :vartype local_ip_address: str
    :ivar memory_in_mb: Available memory reported by the Agent, in MB.
    :vartype memory_in_mb: int
    :ivar number_of_cores: Available compute cores reported by the Agent.
    :vartype number_of_cores: int
    :ivar uptime_in_seconds: Uptime of the Agent in seconds.
    :vartype uptime_in_seconds: int
    :ivar error_details:
    :vartype error_details: ~azure.mgmt.storagemover.models.AgentPropertiesErrorDetails
    :ivar provisioning_state: The provisioning state of this resource. "Succeeded"
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "agent_version": {"readonly": True},
        "arc_resource_id": {"required": True},
        "arc_vm_uuid": {"required": True},
        "agent_status": {"readonly": True},
        "last_status_update": {"readonly": True},
        "local_ip_address": {"readonly": True},
        "memory_in_mb": {"readonly": True},
        "number_of_cores": {"readonly": True},
        "uptime_in_seconds": {"readonly": True},
        "error_details": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "agent_version": {"key": "properties.agentVersion", "type": "str"},
        "arc_resource_id": {"key": "properties.arcResourceId", "type": "str"},
        "arc_vm_uuid": {"key": "properties.arcVmUuid", "type": "str"},
        "agent_status": {"key": "properties.agentStatus", "type": "str"},
        "last_status_update": {"key": "properties.lastStatusUpdate", "type": "iso-8601"},
        "local_ip_address": {"key": "properties.localIPAddress", "type": "str"},
        "memory_in_mb": {"key": "properties.memoryInMB", "type": "int"},
        "number_of_cores": {"key": "properties.numberOfCores", "type": "int"},
        "uptime_in_seconds": {"key": "properties.uptimeInSeconds", "type": "int"},
        "error_details": {"key": "properties.errorDetails", "type": "AgentPropertiesErrorDetails"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, arc_resource_id: str, arc_vm_uuid: str, description: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: A description for the Agent.
        :paramtype description: str
        :keyword arc_resource_id: The fully qualified resource ID of the Hybrid Compute resource for
         the Agent. Required.
        :paramtype arc_resource_id: str
        :keyword arc_vm_uuid: The VM UUID of the Hybrid Compute resource for the Agent. Required.
        :paramtype arc_vm_uuid: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.agent_version = None
        self.arc_resource_id = arc_resource_id
        self.arc_vm_uuid = arc_vm_uuid
        self.agent_status = None
        self.last_status_update = None
        self.local_ip_address = None
        self.memory_in_mb = None
        self.number_of_cores = None
        self.uptime_in_seconds = None
        self.error_details = None
        self.provisioning_state = None


class AgentList(_serialization.Model):
    """List of Agents.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.storagemover.models.Agent]
    :ivar next_link: Request URL that can be used to query next page of containers. Returned when
     total number of requested containers exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Agent]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class AgentPropertiesErrorDetails(_serialization.Model):
    """AgentPropertiesErrorDetails.

    :ivar code: Error code reported by Agent.
    :vartype code: str
    :ivar message: Expanded description of reported error code.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code reported by Agent.
        :paramtype code: str
        :keyword message: Expanded description of reported error code.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class AgentUpdateParameters(_serialization.Model):
    """The Agent resource.

    :ivar description: A description for the Agent.
    :vartype description: str
    """

    _attribute_map = {
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: A description for the Agent.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.description = description


class EndpointBaseProperties(_serialization.Model):
    """The resource specific properties for the Storage Mover resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureStorageBlobContainerEndpointProperties, NfsMountEndpointProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The Endpoint resource type. Required. Known values are:
     "AzureStorageBlobContainer" and "NfsMount".
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.EndpointType
    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. "Succeeded"
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    _subtype_map = {
        "endpoint_type": {
            "AzureStorageBlobContainer": "AzureStorageBlobContainerEndpointProperties",
            "NfsMount": "NfsMountEndpointProperties",
        }
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: A description for the Endpoint.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.endpoint_type: Optional[str] = None
        self.description = description
        self.provisioning_state = None


class AzureStorageBlobContainerEndpointProperties(EndpointBaseProperties):
    """AzureStorageBlobContainerEndpointProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The Endpoint resource type. Required. Known values are:
     "AzureStorageBlobContainer" and "NfsMount".
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.EndpointType
    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. "Succeeded"
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    :ivar storage_account_resource_id: The Azure Resource ID of the storage account that is the
     target destination. Required.
    :vartype storage_account_resource_id: str
    :ivar blob_container_name: The name of the Storage blob container that is the target
     destination. Required.
    :vartype blob_container_name: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "storage_account_resource_id": {"required": True},
        "blob_container_name": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "storage_account_resource_id": {"key": "storageAccountResourceId", "type": "str"},
        "blob_container_name": {"key": "blobContainerName", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_account_resource_id: str,
        blob_container_name: str,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: A description for the Endpoint.
        :paramtype description: str
        :keyword storage_account_resource_id: The Azure Resource ID of the storage account that is the
         target destination. Required.
        :paramtype storage_account_resource_id: str
        :keyword blob_container_name: The name of the Storage blob container that is the target
         destination. Required.
        :paramtype blob_container_name: str
        """
        super().__init__(description=description, **kwargs)
        self.endpoint_type: str = "AzureStorageBlobContainer"
        self.storage_account_resource_id = storage_account_resource_id
        self.blob_container_name = blob_container_name


class EndpointBaseUpdateProperties(_serialization.Model):
    """The Endpoint resource, which contains information about file sources and targets.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: A description for the Endpoint.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.description = description


class AzureStorageBlobContainerEndpointUpdateProperties(EndpointBaseUpdateProperties):
    """AzureStorageBlobContainerEndpointUpdateProperties.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: A description for the Endpoint.
        :paramtype description: str
        """
        super().__init__(description=description, **kwargs)


class Endpoint(ProxyResource):
    """The Endpoint resource, which contains information about file sources and targets.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: The resource specific properties for the Storage Mover resource. Required.
    :vartype properties: ~azure.mgmt.storagemover.models.EndpointBaseProperties
    :ivar system_data: Resource system metadata.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "properties": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "EndpointBaseProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, properties: "_models.EndpointBaseProperties", **kwargs: Any) -> None:
        """
        :keyword properties: The resource specific properties for the Storage Mover resource. Required.
        :paramtype properties: ~azure.mgmt.storagemover.models.EndpointBaseProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.system_data = None


class EndpointBaseUpdateParameters(_serialization.Model):
    """The Endpoint resource.

    :ivar properties: The Endpoint resource, which contains information about file sources and
     targets.
    :vartype properties: ~azure.mgmt.storagemover.models.EndpointBaseUpdateProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "EndpointBaseUpdateProperties"},
    }

    def __init__(self, *, properties: Optional["_models.EndpointBaseUpdateProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The Endpoint resource, which contains information about file sources and
         targets.
        :paramtype properties: ~azure.mgmt.storagemover.models.EndpointBaseUpdateProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class EndpointList(_serialization.Model):
    """List of Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.storagemover.models.Endpoint]
    :ivar next_link: Request URL that can be used to query next page of containers. Returned when
     total number of requested containers exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Endpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.storagemover.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.storagemover.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.storagemover.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.storagemover.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class JobDefinition(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Job Definition resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Resource system metadata.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar description: A description for the Job Definition.
    :vartype description: str
    :ivar copy_mode: Strategy to use for copy. Required. Known values are: "Additive" and "Mirror".
    :vartype copy_mode: str or ~azure.mgmt.storagemover.models.CopyMode
    :ivar source_name: The name of the source Endpoint. Required.
    :vartype source_name: str
    :ivar source_resource_id: Fully qualified resource ID of the source Endpoint.
    :vartype source_resource_id: str
    :ivar source_subpath: The subpath to use when reading from the source Endpoint.
    :vartype source_subpath: str
    :ivar target_name: The name of the target Endpoint. Required.
    :vartype target_name: str
    :ivar target_resource_id: Fully qualified resource ID of the target Endpoint.
    :vartype target_resource_id: str
    :ivar target_subpath: The subpath to use when writing to the target Endpoint.
    :vartype target_subpath: str
    :ivar latest_job_run_name: The name of the Job Run in a non-terminal state, if exists.
    :vartype latest_job_run_name: str
    :ivar latest_job_run_resource_id: The fully qualified resource ID of the Job Run in a
     non-terminal state, if exists.
    :vartype latest_job_run_resource_id: str
    :ivar latest_job_run_status: The current status of the Job Run in a non-terminal state, if
     exists. Known values are: "Queued", "Started", "Running", "CancelRequested", "Canceling",
     "Canceled", "Failed", and "Succeeded".
    :vartype latest_job_run_status: str or ~azure.mgmt.storagemover.models.JobRunStatus
    :ivar agent_name: Name of the Agent to assign for new Job Runs of this Job Definition.
    :vartype agent_name: str
    :ivar agent_resource_id: Fully qualified resource id of the Agent to assign for new Job Runs of
     this Job Definition.
    :vartype agent_resource_id: str
    :ivar provisioning_state: The provisioning state of this resource. "Succeeded"
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "copy_mode": {"required": True},
        "source_name": {"required": True},
        "source_resource_id": {"readonly": True},
        "target_name": {"required": True},
        "target_resource_id": {"readonly": True},
        "latest_job_run_name": {"readonly": True},
        "latest_job_run_resource_id": {"readonly": True},
        "latest_job_run_status": {"readonly": True},
        "agent_resource_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "copy_mode": {"key": "properties.copyMode", "type": "str"},
        "source_name": {"key": "properties.sourceName", "type": "str"},
        "source_resource_id": {"key": "properties.sourceResourceId", "type": "str"},
        "source_subpath": {"key": "properties.sourceSubpath", "type": "str"},
        "target_name": {"key": "properties.targetName", "type": "str"},
        "target_resource_id": {"key": "properties.targetResourceId", "type": "str"},
        "target_subpath": {"key": "properties.targetSubpath", "type": "str"},
        "latest_job_run_name": {"key": "properties.latestJobRunName", "type": "str"},
        "latest_job_run_resource_id": {"key": "properties.latestJobRunResourceId", "type": "str"},
        "latest_job_run_status": {"key": "properties.latestJobRunStatus", "type": "str"},
        "agent_name": {"key": "properties.agentName", "type": "str"},
        "agent_resource_id": {"key": "properties.agentResourceId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        copy_mode: Union[str, "_models.CopyMode"],
        source_name: str,
        target_name: str,
        description: Optional[str] = None,
        source_subpath: Optional[str] = None,
        target_subpath: Optional[str] = None,
        agent_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: A description for the Job Definition.
        :paramtype description: str
        :keyword copy_mode: Strategy to use for copy. Required. Known values are: "Additive" and
         "Mirror".
        :paramtype copy_mode: str or ~azure.mgmt.storagemover.models.CopyMode
        :keyword source_name: The name of the source Endpoint. Required.
        :paramtype source_name: str
        :keyword source_subpath: The subpath to use when reading from the source Endpoint.
        :paramtype source_subpath: str
        :keyword target_name: The name of the target Endpoint. Required.
        :paramtype target_name: str
        :keyword target_subpath: The subpath to use when writing to the target Endpoint.
        :paramtype target_subpath: str
        :keyword agent_name: Name of the Agent to assign for new Job Runs of this Job Definition.
        :paramtype agent_name: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.copy_mode = copy_mode
        self.source_name = source_name
        self.source_resource_id = None
        self.source_subpath = source_subpath
        self.target_name = target_name
        self.target_resource_id = None
        self.target_subpath = target_subpath
        self.latest_job_run_name = None
        self.latest_job_run_resource_id = None
        self.latest_job_run_status = None
        self.agent_name = agent_name
        self.agent_resource_id = None
        self.provisioning_state = None


class JobDefinitionList(_serialization.Model):
    """List of Job Definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.storagemover.models.JobDefinition]
    :ivar next_link: Request URL that can be used to query next page of containers. Returned when
     total number of requested containers exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class JobDefinitionUpdateParameters(_serialization.Model):
    """The Job Definition resource.

    :ivar description: A description for the Job Definition.
    :vartype description: str
    :ivar copy_mode: Strategy to use for copy. Known values are: "Additive" and "Mirror".
    :vartype copy_mode: str or ~azure.mgmt.storagemover.models.CopyMode
    :ivar agent_name: Name of the Agent to assign for new Job Runs of this Job Definition.
    :vartype agent_name: str
    """

    _attribute_map = {
        "description": {"key": "properties.description", "type": "str"},
        "copy_mode": {"key": "properties.copyMode", "type": "str"},
        "agent_name": {"key": "properties.agentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        copy_mode: Optional[Union[str, "_models.CopyMode"]] = None,
        agent_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: A description for the Job Definition.
        :paramtype description: str
        :keyword copy_mode: Strategy to use for copy. Known values are: "Additive" and "Mirror".
        :paramtype copy_mode: str or ~azure.mgmt.storagemover.models.CopyMode
        :keyword agent_name: Name of the Agent to assign for new Job Runs of this Job Definition.
        :paramtype agent_name: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.copy_mode = copy_mode
        self.agent_name = agent_name


class JobRun(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Job Run resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Resource system metadata.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar status: The state of the job execution. Known values are: "Queued", "Started", "Running",
     "CancelRequested", "Canceling", "Canceled", "Failed", and "Succeeded".
    :vartype status: str or ~azure.mgmt.storagemover.models.JobRunStatus
    :ivar scan_status: The status of Agent's scanning of source. Known values are: "NotStarted",
     "Scanning", and "Completed".
    :vartype scan_status: str or ~azure.mgmt.storagemover.models.JobRunScanStatus
    :ivar agent_name: Name of the Agent assigned to this run.
    :vartype agent_name: str
    :ivar agent_resource_id: Fully qualified resource id of the Agent assigned to this run.
    :vartype agent_resource_id: str
    :ivar execution_start_time: Start time of the run. Null if no Agent reported that the job has
     started.
    :vartype execution_start_time: ~datetime.datetime
    :ivar execution_end_time: End time of the run. Null if Agent has not reported that the job has
     ended.
    :vartype execution_end_time: ~datetime.datetime
    :ivar last_status_update: The last updated time of the Job Run.
    :vartype last_status_update: ~datetime.datetime
    :ivar items_scanned: Number of items scanned so far in source.
    :vartype items_scanned: int
    :ivar items_excluded: Number of items that will not be transferred, as they are excluded by
     user configuration.
    :vartype items_excluded: int
    :ivar items_unsupported: Number of items that will not be transferred, as they are unsupported
     on target.
    :vartype items_unsupported: int
    :ivar items_no_transfer_needed: Number of items that will not be transferred, as they are
     already found on target (e.g. mirror mode).
    :vartype items_no_transfer_needed: int
    :ivar items_failed: Number of items that were attempted to transfer and failed.
    :vartype items_failed: int
    :ivar items_transferred: Number of items successfully transferred to target.
    :vartype items_transferred: int
    :ivar bytes_scanned: Bytes of data scanned so far in source.
    :vartype bytes_scanned: int
    :ivar bytes_excluded: Bytes of data that will not be transferred, as they are excluded by user
     configuration.
    :vartype bytes_excluded: int
    :ivar bytes_unsupported: Bytes of data that will not be transferred, as they are unsupported on
     target.
    :vartype bytes_unsupported: int
    :ivar bytes_no_transfer_needed: Bytes of data that will not be transferred, as they are already
     found on target (e.g. mirror mode).
    :vartype bytes_no_transfer_needed: int
    :ivar bytes_failed: Bytes of data that were attempted to transfer and failed.
    :vartype bytes_failed: int
    :ivar bytes_transferred: Bytes of data successfully transferred to target.
    :vartype bytes_transferred: int
    :ivar source_name: Name of source Endpoint resource. This resource may no longer exist.
    :vartype source_name: str
    :ivar source_resource_id: Fully qualified resource id of source Endpoint. This id may no longer
     exist.
    :vartype source_resource_id: str
    :ivar source_properties: Copy of source Endpoint resource's properties at time of Job Run
     creation.
    :vartype source_properties: JSON
    :ivar target_name: Name of target Endpoint resource. This resource may no longer exist.
    :vartype target_name: str
    :ivar target_resource_id: Fully qualified resource id of of Endpoint. This id may no longer
     exist.
    :vartype target_resource_id: str
    :ivar target_properties: Copy of Endpoint resource's properties at time of Job Run creation.
    :vartype target_properties: JSON
    :ivar job_definition_properties: Copy of parent Job Definition's properties at time of Job Run
     creation.
    :vartype job_definition_properties: JSON
    :ivar error: Error details.
    :vartype error: ~azure.mgmt.storagemover.models.JobRunError
    :ivar provisioning_state: The provisioning state of this resource. "Succeeded"
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "status": {"readonly": True},
        "scan_status": {"readonly": True},
        "agent_name": {"readonly": True},
        "agent_resource_id": {"readonly": True},
        "execution_start_time": {"readonly": True},
        "execution_end_time": {"readonly": True},
        "last_status_update": {"readonly": True},
        "items_scanned": {"readonly": True},
        "items_excluded": {"readonly": True},
        "items_unsupported": {"readonly": True},
        "items_no_transfer_needed": {"readonly": True},
        "items_failed": {"readonly": True},
        "items_transferred": {"readonly": True},
        "bytes_scanned": {"readonly": True},
        "bytes_excluded": {"readonly": True},
        "bytes_unsupported": {"readonly": True},
        "bytes_no_transfer_needed": {"readonly": True},
        "bytes_failed": {"readonly": True},
        "bytes_transferred": {"readonly": True},
        "source_name": {"readonly": True},
        "source_resource_id": {"readonly": True},
        "source_properties": {"readonly": True},
        "target_name": {"readonly": True},
        "target_resource_id": {"readonly": True},
        "target_properties": {"readonly": True},
        "job_definition_properties": {"readonly": True},
        "error": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "status": {"key": "properties.status", "type": "str"},
        "scan_status": {"key": "properties.scanStatus", "type": "str"},
        "agent_name": {"key": "properties.agentName", "type": "str"},
        "agent_resource_id": {"key": "properties.agentResourceId", "type": "str"},
        "execution_start_time": {"key": "properties.executionStartTime", "type": "iso-8601"},
        "execution_end_time": {"key": "properties.executionEndTime", "type": "iso-8601"},
        "last_status_update": {"key": "properties.lastStatusUpdate", "type": "iso-8601"},
        "items_scanned": {"key": "properties.itemsScanned", "type": "int"},
        "items_excluded": {"key": "properties.itemsExcluded", "type": "int"},
        "items_unsupported": {"key": "properties.itemsUnsupported", "type": "int"},
        "items_no_transfer_needed": {"key": "properties.itemsNoTransferNeeded", "type": "int"},
        "items_failed": {"key": "properties.itemsFailed", "type": "int"},
        "items_transferred": {"key": "properties.itemsTransferred", "type": "int"},
        "bytes_scanned": {"key": "properties.bytesScanned", "type": "int"},
        "bytes_excluded": {"key": "properties.bytesExcluded", "type": "int"},
        "bytes_unsupported": {"key": "properties.bytesUnsupported", "type": "int"},
        "bytes_no_transfer_needed": {"key": "properties.bytesNoTransferNeeded", "type": "int"},
        "bytes_failed": {"key": "properties.bytesFailed", "type": "int"},
        "bytes_transferred": {"key": "properties.bytesTransferred", "type": "int"},
        "source_name": {"key": "properties.sourceName", "type": "str"},
        "source_resource_id": {"key": "properties.sourceResourceId", "type": "str"},
        "source_properties": {"key": "properties.sourceProperties", "type": "object"},
        "target_name": {"key": "properties.targetName", "type": "str"},
        "target_resource_id": {"key": "properties.targetResourceId", "type": "str"},
        "target_properties": {"key": "properties.targetProperties", "type": "object"},
        "job_definition_properties": {"key": "properties.jobDefinitionProperties", "type": "object"},
        "error": {"key": "properties.error", "type": "JobRunError"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:  # pylint: disable=too-many-locals
        """ """
        super().__init__(**kwargs)
        self.system_data = None
        self.status = None
        self.scan_status = None
        self.agent_name = None
        self.agent_resource_id = None
        self.execution_start_time = None
        self.execution_end_time = None
        self.last_status_update = None
        self.items_scanned = None
        self.items_excluded = None
        self.items_unsupported = None
        self.items_no_transfer_needed = None
        self.items_failed = None
        self.items_transferred = None
        self.bytes_scanned = None
        self.bytes_excluded = None
        self.bytes_unsupported = None
        self.bytes_no_transfer_needed = None
        self.bytes_failed = None
        self.bytes_transferred = None
        self.source_name = None
        self.source_resource_id = None
        self.source_properties = None
        self.target_name = None
        self.target_resource_id = None
        self.target_properties = None
        self.job_definition_properties = None
        self.error = None
        self.provisioning_state = None


class JobRunError(_serialization.Model):
    """Error type.

    :ivar code: Error code of the given entry.
    :vartype code: str
    :ivar message: Error message of the given entry.
    :vartype message: str
    :ivar target: Target of the given error entry.
    :vartype target: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, message: Optional[str] = None, target: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: Error code of the given entry.
        :paramtype code: str
        :keyword message: Error message of the given entry.
        :paramtype message: str
        :keyword target: Target of the given error entry.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class JobRunList(_serialization.Model):
    """List of Job Runs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.storagemover.models.JobRun]
    :ivar next_link: Request URL that can be used to query next page of containers. Returned when
     total number of requested containers exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobRun]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class JobRunResourceId(_serialization.Model):
    """Response that identifies a Job Run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_run_resource_id: Fully qualified resource id of the Job Run.
    :vartype job_run_resource_id: str
    """

    _validation = {
        "job_run_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "job_run_resource_id": {"key": "jobRunResourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.job_run_resource_id = None


class NfsMountEndpointProperties(EndpointBaseProperties):
    """NfsMountEndpointProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The Endpoint resource type. Required. Known values are:
     "AzureStorageBlobContainer" and "NfsMount".
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.EndpointType
    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. "Succeeded"
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    :ivar host: The host name or IP address of the server exporting the file system. Required.
    :vartype host: str
    :ivar nfs_version: The NFS protocol version. Known values are: "NFSauto", "NFSv3", and "NFSv4".
    :vartype nfs_version: str or ~azure.mgmt.storagemover.models.NfsVersion
    :ivar export: The directory being exported from the server. Required.
    :vartype export: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "host": {"required": True},
        "export": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "host": {"key": "host", "type": "str"},
        "nfs_version": {"key": "nfsVersion", "type": "str"},
        "export": {"key": "export", "type": "str"},
    }

    def __init__(
        self,
        *,
        host: str,
        export: str,
        description: Optional[str] = None,
        nfs_version: Optional[Union[str, "_models.NfsVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: A description for the Endpoint.
        :paramtype description: str
        :keyword host: The host name or IP address of the server exporting the file system. Required.
        :paramtype host: str
        :keyword nfs_version: The NFS protocol version. Known values are: "NFSauto", "NFSv3", and
         "NFSv4".
        :paramtype nfs_version: str or ~azure.mgmt.storagemover.models.NfsVersion
        :keyword export: The directory being exported from the server. Required.
        :paramtype export: str
        """
        super().__init__(description=description, **kwargs)
        self.endpoint_type: str = "NfsMount"
        self.host = host
        self.nfs_version = nfs_version
        self.export = export


class NfsMountEndpointUpdateProperties(EndpointBaseUpdateProperties):
    """NfsMountEndpointUpdateProperties.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: A description for the Endpoint.
        :paramtype description: str
        """
        super().__init__(description=description, **kwargs)


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.storagemover.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.storagemover.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.storagemover.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.storagemover.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.storagemover.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Project(ProxyResource):
    """The Project resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Resource system metadata.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar description: A description for the Project.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. "Succeeded"
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: A description for the Project.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.provisioning_state = None


class ProjectList(_serialization.Model):
    """List of Project resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.storagemover.models.Project]
    :ivar next_link: Request URL that can be used to query next page of containers. Returned when
     total number of requested containers exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Project]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ProjectUpdateParameters(_serialization.Model):
    """The Project resource.

    :ivar description: A description for the Project.
    :vartype description: str
    """

    _attribute_map = {
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: A description for the Project.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.description = description


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class StorageMover(TrackedResource):
    """The Storage Mover resource, which is a container for a group of Agents, Projects, and
    Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar system_data: Resource system metadata.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar description: A description for the Storage Mover.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. "Succeeded"
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, location: str, tags: Optional[Dict[str, str]] = None, description: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword description: A description for the Storage Mover.
        :paramtype description: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.description = description
        self.provisioning_state = None


class StorageMoverList(_serialization.Model):
    """List of Storage Movers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.storagemover.models.StorageMover]
    :ivar next_link: Request URL that can be used to query next page of containers. Returned when
     total number of requested containers exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageMover]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageMoverUpdateParameters(_serialization.Model):
    """The Storage Mover resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: A description for the Storage Mover.
    :vartype description: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, description: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: A description for the Storage Mover.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.description = description


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.storagemover.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.storagemover.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.storagemover.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.storagemover.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
