# pylint: disable=too-many-lines
# pylint: disable=W0622
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...operations._operations import (
    build_assets_get_request,
    build_assets_list_request,
    build_assets_update_request,
    build_discovery_groups_delete_request,
    build_discovery_groups_get_request,
    build_discovery_groups_list_request,
    build_discovery_groups_list_runs_request,
    build_discovery_groups_put_request,
    build_discovery_groups_run_request,
    build_discovery_groups_validate_request,
    build_discovery_templates_get_request,
    build_discovery_templates_list_request,
    build_reports_billable_request,
    build_reports_snapshot_request,
    build_reports_summary_request,
    build_saved_filters_delete_request,
    build_saved_filters_get_request,
    build_saved_filters_list_request,
    build_saved_filters_put_request,
    build_tasks_cancel_request,
    build_tasks_get_request,
    build_tasks_list_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AssetsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.defender.easm.aio.EasmClient`'s
        :attr:`assets` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        filter: Optional[str] = None,
        orderby: Optional[str] = None,
        skip: int = 0,
        mark: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Retrieve a list of assets for the provided search parameters.

        Retrieve a list of assets for the provided search parameters.

        :keyword filter: An expression on the resource type that selects the resources to be returned.
         Default value is None.
        :paramtype filter: str
        :keyword orderby: A list of expressions that specify the order of the returned resources.
         Default value is None.
        :paramtype orderby: str
        :keyword skip: An offset into the collection of the first item to be returned. Default value is
         0.
        :paramtype skip: int
        :keyword mark: Specify this value instead of 'skip' to use cursor-based searching. Initial
         value is '*' and subsequent values are returned in the response. Default value is None.
        :paramtype mark: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "as":
                asset_response = {
                    "asset": {
                        "adminContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "asNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "asn": 0,  # Optional. Required.
                        "count": 0,  # Optional. Required.
                        "countries": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "detailedFromWhoisAt": "2020-02-20 00:00:00",  # Optional. Required.
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "orgIds": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "orgNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrarCreatedAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registrarNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrarUpdatedAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registries": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ],
                        "technicalContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "as",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # JSON input template for discriminator value "contact":
                asset_response = {
                    "asset": {
                        "count": 0,  # Optional. Required.
                        "email": "str",  # Optional. Required.
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "names": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "organizations": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "contact",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # JSON input template for discriminator value "domain":
                asset_response = {
                    "asset": {
                        "adminContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "alexaInfos": [
                            {
                                "alexaRank": 0,  # Optional. Required.
                                "category": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "count": 0,  # Optional. Required.
                        "detailedFromWhoisAt": "2020-02-20 00:00:00",  # Optional. Required.
                        "domain": "str",  # Optional. Required.
                        "domainStatuses": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "mailServers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "nameServers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "parkedDomain": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "registrantContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrarCreatedAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registrarExpiresAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registrarIanaIds": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registrarNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrarUpdatedAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "soaRecords": [
                            {
                                "count": 0,  # Optional. Required.
                                "email": "str",  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "nameServer": "str",  # Optional. Required.
                                "recent": bool,  # Optional. Required.
                                "serialNumber": 0  # Optional. Required.
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ],
                        "technicalContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "whoisId": 0,  # Optional. Required.
                        "whoisServers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "domain",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # JSON input template for discriminator value "host":
                asset_response = {
                    "asset": {
                        "asns": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "attributes": [
                            {
                                "attributeType": "str",  # Optional. Required.
                                "attributeValue": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "banners": [
                            {
                                "banner": "str",  # Optional. Required.
                                "bannerMetadata": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "recent": bool,  # Optional. Required.
                                "scanType": "str",  # Optional. Required.
                                "sha256": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "childHosts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "cnames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "cookies": [
                            {
                                "cookieDomain": "str",  # Optional. Required.
                                "cookieExpiryDate": "2020-02-20 00:00:00",  #
                                  Optional. Required.
                                "cookieName": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "count": 0,  # Optional. Required.
                        "domain": "str",  # Optional. Required.
                        "domainAsset": {
                            "adminContacts": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "adminNames": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "adminOrgs": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "adminPhones": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "alexaInfos": [
                                {
                                    "alexaRank": 0,  # Optional. Required.
                                    "category": "str",  # Optional. Required.
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool  # Optional. Required.
                                }
                            ],
                            "count": 0,  # Optional. Required.
                            "detailedFromWhoisAt": "2020-02-20 00:00:00",  # Optional.
                              Required.
                            "domain": "str",  # Optional. Required.
                            "domainStatuses": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                            "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                            "mailServers": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "nameServers": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "parkedDomain": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": bool  # Optional. Required.
                                }
                            ],
                            "registrantContacts": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrantNames": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrantOrgs": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrantPhones": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrarCreatedAt": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": 0  # Optional. Required.
                                }
                            ],
                            "registrarExpiresAt": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": 0  # Optional. Required.
                                }
                            ],
                            "registrarIanaIds": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": 0  # Optional. Required.
                                }
                            ],
                            "registrarNames": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrarUpdatedAt": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": 0  # Optional. Required.
                                }
                            ],
                            "soaRecords": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "email": "str",  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "nameServer": "str",  # Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "serialNumber": 0  # Optional. Required.
                                }
                            ],
                            "sources": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "reason": "str",  # Optional. Required.
                                    "source": "str"  # Optional. Required.
                                }
                            ],
                            "technicalContacts": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "technicalNames": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "technicalOrgs": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "technicalPhones": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "whoisId": 0,  # Optional. Required.
                            "whoisServers": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ]
                        },
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "headers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "headerName": "str",  # Optional. Required.
                                "headerValue": "str",  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "host": "str",  # Optional. Required.
                        "hostCore": {
                            "alexaRank": 0,  # Optional. Required.
                            "blacklistCauseCount": 0,  # Optional. Required.
                            "blacklistCauseFirstSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "blacklistCauseLastSeen": "2020-02-20 00:00:00",  # Optional.
                              Required.
                            "blacklistResourceCount": 0,  # Optional. Required.
                            "blacklistResourceFirstSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "blacklistResourceLastSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "blacklistSequenceCount": 0,  # Optional. Required.
                            "blacklistSequenceFirstSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "blacklistSequenceLastSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "count": 0,  # Optional. Required.
                            "domain": "str",  # Optional. Required.
                            "domainMalwareReputationScore": 0,  # Optional. Required.
                            "domainPhishReputationScore": 0,  # Optional. Required.
                            "domainReputationScore": 0,  # Optional. Required.
                            "domainScamReputationScore": 0,  # Optional. Required.
                            "domainSpamReputationScore": 0,  # Optional. Required.
                            "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                            "host": "str",  # Optional. Required.
                            "hostMalwareReputationScore": 0,  # Optional. Required.
                            "hostPhishReputationScore": 0,  # Optional. Required.
                            "hostReputationScore": 0,  # Optional. Required.
                            "hostScamReputationScore": 0,  # Optional. Required.
                            "hostSpamReputationScore": 0,  # Optional. Required.
                            "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                            "malwareCauseCount": 0,  # Optional. Required.
                            "malwareResourceCount": 0,  # Optional. Required.
                            "malwareSequenceCount": 0,  # Optional. Required.
                            "phishCauseCount": 0,  # Optional. Required.
                            "phishResourceCount": 0,  # Optional. Required.
                            "phishSequenceCount": 0,  # Optional. Required.
                            "scamCauseCount": 0,  # Optional. Required.
                            "scamResourceCount": 0,  # Optional. Required.
                            "scamSequenceCount": 0,  # Optional. Required.
                            "spamCauseCount": 0,  # Optional. Required.
                            "spamResourceCount": 0,  # Optional. Required.
                            "spamSequenceCount": 0,  # Optional. Required.
                            "uuid": "str"  # Optional. Required.
                        },
                        "ipAddresses": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "ipBlocks": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "ipBlock": "str",  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "ipv4": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "ipv6": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "isWildcard": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "location": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": {
                                    "areaCode": 0,  # Optional. Required.
                                    "city": "str",  # Optional. Required.
                                    "countryCode": "str",  # Optional. Required.
                                    "countryName": "str",  # Optional. Required.
                                    "dmaCode": 0,  # Optional. Required.
                                    "latitude": 0.0,  # Optional. Required.
                                    "longitude": 0.0,  # Optional. Required.
                                    "metroCodeId": 0,  # Optional. Required.
                                    "postalCode": "str",  # Optional. Required.
                                    "region": "str",  # Optional. Required.
                                    "regionName": "str"  # Optional. Required.
                                }
                            }
                        ],
                        "mxRecord": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "nsRecord": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "nxdomain": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "parentHosts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "resourceUrls": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "resources": [
                                    {
                                        "cached": bool,  # Optional.
                                          Required.
                                        "contentType": "str",  # Optional.
                                          Required.
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "firstSeenCrawlGuid": "str",  #
                                          Optional. Required.
                                        "firstSeenPageGuid": "str",  #
                                          Optional. Required.
                                        "firstSeenResourceGuid": "str",  #
                                          Optional. Required.
                                        "host": "str",  # Optional. Required.
                                        "lastObservedActualSriHash": "str",
                                          # Optional. Required.
                                        "lastObservedExpectedSriHash": "str",
                                          # Optional. Required.
                                        "lastObservedValidation": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "lastObservedViolation": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "lastSeenCrawlGuid": "str",  #
                                          Optional. Required.
                                        "lastSeenPageGuid": "str",  #
                                          Optional. Required.
                                        "lastSeenResourceGuid": "str",  #
                                          Optional. Required.
                                        "md5": "str",  # Optional. Required.
                                        "responseBodyMinhash": [
                                            0  # Optional. Required.
                                        ],
                                        "responseBodySize": 0,  # Optional.
                                          Required.
                                        "sha256": "str",  # Optional.
                                          Required.
                                        "sha384": "str",  # Optional.
                                          Required.
                                        "sha512": "str",  # Optional.
                                          Required.
                                        "sriChecks": [
                                            {
                                                "causePageUrl":
                                                  "str",  # Optional. Required.
                                                "count": 0,  #
                                                  Optional. Required.
                                                "crawlGuid": "str",
                                                  # Optional. Required.
                                                "expectedHash":
                                                  "str",  # Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "pageGuid": "str",  #
                                                  Optional. Required.
                                                "resourceGuid":
                                                  "str",  # Optional. Required.
                                                "violation": bool  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "url": "str"  # Optional. Required.
                                    }
                                ],
                                "url": "str"  # Optional. Required.
                            }
                        ],
                        "responseBodies": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "scanMetadata": [
                            {
                                "bannerMetadata": "str",  # Optional. Required.
                                "endScan": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "startScan": "2020-02-20 00:00:00"  # Optional.
                                  Required.
                            }
                        ],
                        "services": [
                            {
                                "count": 0,  # Optional. Required.
                                "exceptions": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "recent": bool,  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "value": "str"  # Optional. Required.
                                    }
                                ],
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "portStates": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "port": 0,  # Optional. Required.
                                        "recent": bool,  # Optional.
                                          Required.
                                        "value": "str"  # Optional. Known
                                          values are: "open", "closed", and "filtered".
                                    }
                                ],
                                "recent": bool,  # Optional. Required.
                                "scheme": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "sslCerts": [
                                    {
                                        "certificateAuthority": bool,  #
                                          Optional. Required.
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "invalidAfter": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "invalidBefore": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "issuerAlternativeNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerCommonNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerCountry": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerLocality": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerOrganizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerOrganizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerState": [
                                            "str"  # Optional. Required.
                                        ],
                                        "keyAlgorithm": "str",  # Optional.
                                          Required.
                                        "keySize": 0,  # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "organizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "organizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "recent": bool,  # Optional.
                                          Required.
                                        "selfSigned": bool,  # Optional.
                                          Required.
                                        "serialNumber": "str",  # Optional.
                                          Required.
                                        "sha1": "str",  # Optional. Required.
                                        "sigAlgName": "str",  # Optional.
                                          Required.
                                        "sigAlgOid": "str",  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "subjectAlternativeNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectCommonNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectCountry": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectLocality": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectOrganizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectOrganizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectState": [
                                            "str"  # Optional. Required.
                                        ],
                                        "validationType": "str",  # Optional.
                                          Known values are: "domainValidation",
                                          "organizationValidation", and "extendedValidation".
                                        "version": 0  # Optional. Required.
                                    }
                                ],
                                "webComponents": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "cve": [
                                            {
                                                "cvss3Summary": {
                "attackComplexity": "str",  # Optional. Required.
                "attackVector": "str",  # Optional. Required.
                "availabilityImpact": "str",  # Optional.
                                                      Required.
                                                    "baseScore":
                                                      0.0,  # Optional. Required.
                "baseSeverity": "str",  # Optional. Required.
                "confidentialityImpact": "str",  # Optional.
                                                      Required.
                "exploitCodeMaturity": "str",  # Optional.
                                                      Required.
                "exploitabilityScore": 0.0,  # Optional.
                                                      Required.
                "impactScore": 0.0,  # Optional. Required.
                "integrityImpact": "str",  # Optional. Required.
                "privilegesRequired": "str",  # Optional.
                                                      Required.
                "remediationLevel": "str",  # Optional. Required.
                "reportConfidence": "str",  # Optional. Required.
                                                    "scope":
                                                      "str",  # Optional. Required.
                "userInteraction": "str",  # Optional. Required.
                "vectorString": "str",  # Optional. Required.
                                                    "version":
                                                      "str"  # Optional. Required.
                                                },
                                                "cvssScore": 0.0,  #
                                                  Optional. Required.
                                                "cweId": "str",  #
                                                  Optional. Required.
                                                "name": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "endOfLife": 0,  # Optional.
                                          Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "name": "str",  # Optional. Required.
                                        "ports": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "port": 0  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "recent": bool,  # Optional.
                                          Required.
                                        "ruleId": [
                                            "str"  # Optional. Required.
                                        ],
                                        "service": "str",  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "type": "str",  # Optional. Required.
                                        "version": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ],
                        "sslCerts": [
                            {
                                "certificateAuthority": bool,  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "invalidAfter": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "invalidBefore": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "issuerAlternativeNames": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerCommonNames": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerCountry": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerLocality": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerOrganizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerOrganizations": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerState": [
                                    "str"  # Optional. Required.
                                ],
                                "keyAlgorithm": "str",  # Optional. Required.
                                "keySize": 0,  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "organizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "organizations": [
                                    "str"  # Optional. Required.
                                ],
                                "recent": bool,  # Optional. Required.
                                "selfSigned": bool,  # Optional. Required.
                                "serialNumber": "str",  # Optional. Required.
                                "sha1": "str",  # Optional. Required.
                                "sigAlgName": "str",  # Optional. Required.
                                "sigAlgOid": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "subjectAlternativeNames": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectCommonNames": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectCountry": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectLocality": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectOrganizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectOrganizations": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectState": [
                                    "str"  # Optional. Required.
                                ],
                                "validationType": "str",  # Optional. Known values
                                  are: "domainValidation", "organizationValidation", and
                                  "extendedValidation".
                                "version": 0  # Optional. Required.
                            }
                        ],
                        "sslServerConfig": [
                            {
                                "cipherSuites": [
                                    "str"  # Optional. Required.
                                ],
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "tlsVersions": [
                                    "str"  # Optional. Required.
                                ]
                            }
                        ],
                        "webComponents": [
                            {
                                "count": 0,  # Optional. Required.
                                "cve": [
                                    {
                                        "cvss3Summary": {
                                            "attackComplexity": "str",  #
                                              Optional. Required.
                                            "attackVector": "str",  #
                                              Optional. Required.
                                            "availabilityImpact": "str",
                                              # Optional. Required.
                                            "baseScore": 0.0,  #
                                              Optional. Required.
                                            "baseSeverity": "str",  #
                                              Optional. Required.
                                            "confidentialityImpact":
                                              "str",  # Optional. Required.
                                            "exploitCodeMaturity": "str",
                                              # Optional. Required.
                                            "exploitabilityScore": 0.0,
                                              # Optional. Required.
                                            "impactScore": 0.0,  #
                                              Optional. Required.
                                            "integrityImpact": "str",  #
                                              Optional. Required.
                                            "privilegesRequired": "str",
                                              # Optional. Required.
                                            "remediationLevel": "str",  #
                                              Optional. Required.
                                            "reportConfidence": "str",  #
                                              Optional. Required.
                                            "scope": "str",  # Optional.
                                              Required.
                                            "userInteraction": "str",  #
                                              Optional. Required.
                                            "vectorString": "str",  #
                                              Optional. Required.
                                            "version": "str"  # Optional.
                                              Required.
                                        },
                                        "cvssScore": 0.0,  # Optional.
                                          Required.
                                        "cweId": "str",  # Optional.
                                          Required.
                                        "name": "str"  # Optional. Required.
                                    }
                                ],
                                "endOfLife": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "name": "str",  # Optional. Required.
                                "ports": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "port": 0  # Optional. Required.
                                    }
                                ],
                                "recent": bool,  # Optional. Required.
                                "ruleId": [
                                    "str"  # Optional. Required.
                                ],
                                "service": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "type": "str",  # Optional. Required.
                                "version": "str"  # Optional. Required.
                            }
                        ],
                        "webserver": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "host",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # JSON input template for discriminator value "ipAddress":
                asset_response = {
                    "asset": {
                        "asns": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "attributes": [
                            {
                                "attributeType": "str",  # Optional. Required.
                                "attributeValue": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "banners": [
                            {
                                "banner": "str",  # Optional. Required.
                                "bannerMetadata": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "recent": bool,  # Optional. Required.
                                "scanType": "str",  # Optional. Required.
                                "sha256": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "cookies": [
                            {
                                "cookieDomain": "str",  # Optional. Required.
                                "cookieExpiryDate": "2020-02-20 00:00:00",  #
                                  Optional. Required.
                                "cookieName": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "count": 0,  # Optional. Required.
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "headers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "headerName": "str",  # Optional. Required.
                                "headerValue": "str",  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "hosts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "ipAddress": "str",  # Optional. Required.
                        "ipBlocks": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "ipBlock": "str",  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "ipv4": bool,  # Optional. Required.
                        "ipv6": bool,  # Optional. Required.
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "location": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": {
                                    "areaCode": 0,  # Optional. Required.
                                    "city": "str",  # Optional. Required.
                                    "countryCode": "str",  # Optional. Required.
                                    "countryName": "str",  # Optional. Required.
                                    "dmaCode": 0,  # Optional. Required.
                                    "latitude": 0.0,  # Optional. Required.
                                    "longitude": 0.0,  # Optional. Required.
                                    "metroCodeId": 0,  # Optional. Required.
                                    "postalCode": "str",  # Optional. Required.
                                    "region": "str",  # Optional. Required.
                                    "regionName": "str"  # Optional. Required.
                                }
                            }
                        ],
                        "mxRecord": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "netRanges": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "nsRecord": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "nxdomain": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "reputations": [
                            {
                                "cidr": "str",  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "listName": "str",  # Optional. Required.
                                "listUpdatedAt": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "threatType": "str",  # Optional. Required.
                                "trusted": bool  # Optional. Required.
                            }
                        ],
                        "scanMetadata": [
                            {
                                "bannerMetadata": "str",  # Optional. Required.
                                "endScan": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "startScan": "2020-02-20 00:00:00"  # Optional.
                                  Required.
                            }
                        ],
                        "services": [
                            {
                                "count": 0,  # Optional. Required.
                                "exceptions": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "recent": bool,  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "value": "str"  # Optional. Required.
                                    }
                                ],
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "portStates": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "port": 0,  # Optional. Required.
                                        "recent": bool,  # Optional.
                                          Required.
                                        "value": "str"  # Optional. Known
                                          values are: "open", "closed", and "filtered".
                                    }
                                ],
                                "recent": bool,  # Optional. Required.
                                "scheme": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "sslCerts": [
                                    {
                                        "certificateAuthority": bool,  #
                                          Optional. Required.
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "invalidAfter": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "invalidBefore": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "issuerAlternativeNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerCommonNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerCountry": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerLocality": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerOrganizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerOrganizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerState": [
                                            "str"  # Optional. Required.
                                        ],
                                        "keyAlgorithm": "str",  # Optional.
                                          Required.
                                        "keySize": 0,  # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "organizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "organizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "recent": bool,  # Optional.
                                          Required.
                                        "selfSigned": bool,  # Optional.
                                          Required.
                                        "serialNumber": "str",  # Optional.
                                          Required.
                                        "sha1": "str",  # Optional. Required.
                                        "sigAlgName": "str",  # Optional.
                                          Required.
                                        "sigAlgOid": "str",  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "subjectAlternativeNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectCommonNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectCountry": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectLocality": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectOrganizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectOrganizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectState": [
                                            "str"  # Optional. Required.
                                        ],
                                        "validationType": "str",  # Optional.
                                          Known values are: "domainValidation",
                                          "organizationValidation", and "extendedValidation".
                                        "version": 0  # Optional. Required.
                                    }
                                ],
                                "webComponents": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "cve": [
                                            {
                                                "cvss3Summary": {
                "attackComplexity": "str",  # Optional. Required.
                "attackVector": "str",  # Optional. Required.
                "availabilityImpact": "str",  # Optional.
                                                      Required.
                                                    "baseScore":
                                                      0.0,  # Optional. Required.
                "baseSeverity": "str",  # Optional. Required.
                "confidentialityImpact": "str",  # Optional.
                                                      Required.
                "exploitCodeMaturity": "str",  # Optional.
                                                      Required.
                "exploitabilityScore": 0.0,  # Optional.
                                                      Required.
                "impactScore": 0.0,  # Optional. Required.
                "integrityImpact": "str",  # Optional. Required.
                "privilegesRequired": "str",  # Optional.
                                                      Required.
                "remediationLevel": "str",  # Optional. Required.
                "reportConfidence": "str",  # Optional. Required.
                                                    "scope":
                                                      "str",  # Optional. Required.
                "userInteraction": "str",  # Optional. Required.
                "vectorString": "str",  # Optional. Required.
                                                    "version":
                                                      "str"  # Optional. Required.
                                                },
                                                "cvssScore": 0.0,  #
                                                  Optional. Required.
                                                "cweId": "str",  #
                                                  Optional. Required.
                                                "name": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "endOfLife": 0,  # Optional.
                                          Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "name": "str",  # Optional. Required.
                                        "ports": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "port": 0  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "recent": bool,  # Optional.
                                          Required.
                                        "ruleId": [
                                            "str"  # Optional. Required.
                                        ],
                                        "service": "str",  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "type": "str",  # Optional. Required.
                                        "version": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ],
                        "sslCerts": [
                            {
                                "certificateAuthority": bool,  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "invalidAfter": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "invalidBefore": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "issuerAlternativeNames": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerCommonNames": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerCountry": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerLocality": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerOrganizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerOrganizations": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerState": [
                                    "str"  # Optional. Required.
                                ],
                                "keyAlgorithm": "str",  # Optional. Required.
                                "keySize": 0,  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "organizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "organizations": [
                                    "str"  # Optional. Required.
                                ],
                                "recent": bool,  # Optional. Required.
                                "selfSigned": bool,  # Optional. Required.
                                "serialNumber": "str",  # Optional. Required.
                                "sha1": "str",  # Optional. Required.
                                "sigAlgName": "str",  # Optional. Required.
                                "sigAlgOid": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "subjectAlternativeNames": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectCommonNames": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectCountry": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectLocality": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectOrganizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectOrganizations": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectState": [
                                    "str"  # Optional. Required.
                                ],
                                "validationType": "str",  # Optional. Known values
                                  are: "domainValidation", "organizationValidation", and
                                  "extendedValidation".
                                "version": 0  # Optional. Required.
                            }
                        ],
                        "sslServerConfig": [
                            {
                                "cipherSuites": [
                                    "str"  # Optional. Required.
                                ],
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "tlsVersions": [
                                    "str"  # Optional. Required.
                                ]
                            }
                        ],
                        "webComponents": [
                            {
                                "count": 0,  # Optional. Required.
                                "cve": [
                                    {
                                        "cvss3Summary": {
                                            "attackComplexity": "str",  #
                                              Optional. Required.
                                            "attackVector": "str",  #
                                              Optional. Required.
                                            "availabilityImpact": "str",
                                              # Optional. Required.
                                            "baseScore": 0.0,  #
                                              Optional. Required.
                                            "baseSeverity": "str",  #
                                              Optional. Required.
                                            "confidentialityImpact":
                                              "str",  # Optional. Required.
                                            "exploitCodeMaturity": "str",
                                              # Optional. Required.
                                            "exploitabilityScore": 0.0,
                                              # Optional. Required.
                                            "impactScore": 0.0,  #
                                              Optional. Required.
                                            "integrityImpact": "str",  #
                                              Optional. Required.
                                            "privilegesRequired": "str",
                                              # Optional. Required.
                                            "remediationLevel": "str",  #
                                              Optional. Required.
                                            "reportConfidence": "str",  #
                                              Optional. Required.
                                            "scope": "str",  # Optional.
                                              Required.
                                            "userInteraction": "str",  #
                                              Optional. Required.
                                            "vectorString": "str",  #
                                              Optional. Required.
                                            "version": "str"  # Optional.
                                              Required.
                                        },
                                        "cvssScore": 0.0,  # Optional.
                                          Required.
                                        "cweId": "str",  # Optional.
                                          Required.
                                        "name": "str"  # Optional. Required.
                                    }
                                ],
                                "endOfLife": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "name": "str",  # Optional. Required.
                                "ports": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "port": 0  # Optional. Required.
                                    }
                                ],
                                "recent": bool,  # Optional. Required.
                                "ruleId": [
                                    "str"  # Optional. Required.
                                ],
                                "service": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "type": "str",  # Optional. Required.
                                "version": "str"  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "ipAddress",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # response body for status code(s): 200
                response == asset_response
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_assets_list_request(
                    subscription_id=self._config.subscription_id,
                    resource_group_name=self._config.resource_group_name,
                    workspace_name=self._config.workspace_name,
                    filter=filter,
                    orderby=orderby,
                    skip=skip,
                    mark=mark,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["content"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def update(
        self, body: JSON, *, filter: Optional[str] = None, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Update labels on assets matching the provided filter.

        Update labels on assets matching the provided filter.

        :param body: Required.
        :type body: JSON
        :keyword filter: An expression on the resource type that selects the resources to be returned.
         Default value is None.
        :paramtype filter: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "externalId": "str",  # Optional. A string which can be used to identify the
                      asset in external systems.
                    "labels": {
                        "str": bool  # Optional. Any Labels to update the asset with.
                    },
                    "state": "str",  # Optional. The state to update the asset to. Known values
                      are: "candidate", "confirmed", "dismissed", "candidateInvestigate",
                      "associatedPartner", and "associatedThirdparty".
                    "transfers": "str"  # Optional. A list of asset types to cascade the updates
                      to. Known values are: "as", "contact", "domain", "host", "ipAddress", "ipBlock",
                      "page", and "sslCert".
                }

                # response body for status code(s): 200
                response == {
                    "completedAt": "2020-02-20 00:00:00",  # Optional. The time the task
                      completed.
                    "id": "str",  # Optional. The unique identifier of the task.
                    "lastPolledAt": "2020-02-20 00:00:00",  # Optional. The last time the status
                      of the task was updated.
                    "metadata": {
                        "str": {}  # Optional. Attributes unique to the task.  This differs
                          by task type.
                    },
                    "phase": "str",  # Optional. The phase the task is in. Known values are:
                      "running", "polling", and "complete".
                    "reason": "str",  # Optional. The reason the task was moved into its current
                      state, if the task wasn't completed.
                    "startedAt": "2020-02-20 00:00:00",  # Optional. The time the task started.
                    "state": "str"  # Optional. The state the task is in. Known values are:
                      "pending", "running", "paused", "complete", "incomplete", "failed", and
                      "warning".
                }
        """

    @overload
    async def update(
        self, body: IO, *, filter: Optional[str] = None, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Update labels on assets matching the provided filter.

        Update labels on assets matching the provided filter.

        :param body: Required.
        :type body: IO
        :keyword filter: An expression on the resource type that selects the resources to be returned.
         Default value is None.
        :paramtype filter: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "completedAt": "2020-02-20 00:00:00",  # Optional. The time the task
                      completed.
                    "id": "str",  # Optional. The unique identifier of the task.
                    "lastPolledAt": "2020-02-20 00:00:00",  # Optional. The last time the status
                      of the task was updated.
                    "metadata": {
                        "str": {}  # Optional. Attributes unique to the task.  This differs
                          by task type.
                    },
                    "phase": "str",  # Optional. The phase the task is in. Known values are:
                      "running", "polling", and "complete".
                    "reason": "str",  # Optional. The reason the task was moved into its current
                      state, if the task wasn't completed.
                    "startedAt": "2020-02-20 00:00:00",  # Optional. The time the task started.
                    "state": "str"  # Optional. The state the task is in. Known values are:
                      "pending", "running", "paused", "complete", "incomplete", "failed", and
                      "warning".
                }
        """

    @distributed_trace_async
    async def update(self, body: Union[JSON, IO], *, filter: Optional[str] = None, **kwargs: Any) -> JSON:
        """Update labels on assets matching the provided filter.

        Update labels on assets matching the provided filter.

        :param body: Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword filter: An expression on the resource type that selects the resources to be returned.
         Default value is None.
        :paramtype filter: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "completedAt": "2020-02-20 00:00:00",  # Optional. The time the task
                      completed.
                    "id": "str",  # Optional. The unique identifier of the task.
                    "lastPolledAt": "2020-02-20 00:00:00",  # Optional. The last time the status
                      of the task was updated.
                    "metadata": {
                        "str": {}  # Optional. Attributes unique to the task.  This differs
                          by task type.
                    },
                    "phase": "str",  # Optional. The phase the task is in. Known values are:
                      "running", "polling", and "complete".
                    "reason": "str",  # Optional. The reason the task was moved into its current
                      state, if the task wasn't completed.
                    "startedAt": "2020-02-20 00:00:00",  # Optional. The time the task started.
                    "state": "str"  # Optional. The state the task is in. Known values are:
                      "pending", "running", "paused", "complete", "incomplete", "failed", and
                      "warning".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_assets_update_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            filter=filter,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get(self, asset_id: str, **kwargs: Any) -> JSON:
        """Retrieve an asset by assetId.

        Retrieve an asset by assetId.

        :param asset_id: The unique identifier for the asset. Ids are formatted as
         ':code:`<kind>`$$:code:`<name>`' and can optionally be Base64 encoded if they contain special
         characters. Required.
        :type asset_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "as":
                asset_response = {
                    "asset": {
                        "adminContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "asNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "asn": 0,  # Optional. Required.
                        "count": 0,  # Optional. Required.
                        "countries": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "detailedFromWhoisAt": "2020-02-20 00:00:00",  # Optional. Required.
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "orgIds": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "orgNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrarCreatedAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registrarNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrarUpdatedAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registries": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ],
                        "technicalContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "as",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # JSON input template for discriminator value "contact":
                asset_response = {
                    "asset": {
                        "count": 0,  # Optional. Required.
                        "email": "str",  # Optional. Required.
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "names": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "organizations": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "contact",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # JSON input template for discriminator value "domain":
                asset_response = {
                    "asset": {
                        "adminContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "adminPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "alexaInfos": [
                            {
                                "alexaRank": 0,  # Optional. Required.
                                "category": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "count": 0,  # Optional. Required.
                        "detailedFromWhoisAt": "2020-02-20 00:00:00",  # Optional. Required.
                        "domain": "str",  # Optional. Required.
                        "domainStatuses": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "mailServers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "nameServers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "parkedDomain": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "registrantContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrantPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrarCreatedAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registrarExpiresAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registrarIanaIds": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "registrarNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "registrarUpdatedAt": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "soaRecords": [
                            {
                                "count": 0,  # Optional. Required.
                                "email": "str",  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "nameServer": "str",  # Optional. Required.
                                "recent": bool,  # Optional. Required.
                                "serialNumber": 0  # Optional. Required.
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ],
                        "technicalContacts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalNames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalOrgs": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "technicalPhones": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "whoisId": 0,  # Optional. Required.
                        "whoisServers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "domain",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # JSON input template for discriminator value "host":
                asset_response = {
                    "asset": {
                        "asns": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "attributes": [
                            {
                                "attributeType": "str",  # Optional. Required.
                                "attributeValue": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "banners": [
                            {
                                "banner": "str",  # Optional. Required.
                                "bannerMetadata": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "recent": bool,  # Optional. Required.
                                "scanType": "str",  # Optional. Required.
                                "sha256": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "childHosts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "cnames": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "cookies": [
                            {
                                "cookieDomain": "str",  # Optional. Required.
                                "cookieExpiryDate": "2020-02-20 00:00:00",  #
                                  Optional. Required.
                                "cookieName": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "count": 0,  # Optional. Required.
                        "domain": "str",  # Optional. Required.
                        "domainAsset": {
                            "adminContacts": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "adminNames": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "adminOrgs": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "adminPhones": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "alexaInfos": [
                                {
                                    "alexaRank": 0,  # Optional. Required.
                                    "category": "str",  # Optional. Required.
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool  # Optional. Required.
                                }
                            ],
                            "count": 0,  # Optional. Required.
                            "detailedFromWhoisAt": "2020-02-20 00:00:00",  # Optional.
                              Required.
                            "domain": "str",  # Optional. Required.
                            "domainStatuses": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                            "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                            "mailServers": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "nameServers": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "parkedDomain": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": bool  # Optional. Required.
                                }
                            ],
                            "registrantContacts": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrantNames": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrantOrgs": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrantPhones": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrarCreatedAt": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": 0  # Optional. Required.
                                }
                            ],
                            "registrarExpiresAt": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": 0  # Optional. Required.
                                }
                            ],
                            "registrarIanaIds": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": 0  # Optional. Required.
                                }
                            ],
                            "registrarNames": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "registrarUpdatedAt": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": 0  # Optional. Required.
                                }
                            ],
                            "soaRecords": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "email": "str",  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "nameServer": "str",  # Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "serialNumber": 0  # Optional. Required.
                                }
                            ],
                            "sources": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "reason": "str",  # Optional. Required.
                                    "source": "str"  # Optional. Required.
                                }
                            ],
                            "technicalContacts": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "technicalNames": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "technicalOrgs": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "technicalPhones": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ],
                            "whoisId": 0,  # Optional. Required.
                            "whoisServers": [
                                {
                                    "count": 0,  # Optional. Required.
                                    "firstSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "lastSeen": "2020-02-20 00:00:00",  #
                                      Optional. Required.
                                    "recent": bool,  # Optional. Required.
                                    "sources": [
                                        {
                                            "count": 0,  # Optional.
                                              Required.
                                            "firstSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "lastSeen": "2020-02-20
                                              00:00:00",  # Optional. Required.
                                            "reason": "str",  # Optional.
                                              Required.
                                            "source": "str"  # Optional.
                                              Required.
                                        }
                                    ],
                                    "value": "str"  # Optional. Required.
                                }
                            ]
                        },
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "headers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "headerName": "str",  # Optional. Required.
                                "headerValue": "str",  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "host": "str",  # Optional. Required.
                        "hostCore": {
                            "alexaRank": 0,  # Optional. Required.
                            "blacklistCauseCount": 0,  # Optional. Required.
                            "blacklistCauseFirstSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "blacklistCauseLastSeen": "2020-02-20 00:00:00",  # Optional.
                              Required.
                            "blacklistResourceCount": 0,  # Optional. Required.
                            "blacklistResourceFirstSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "blacklistResourceLastSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "blacklistSequenceCount": 0,  # Optional. Required.
                            "blacklistSequenceFirstSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "blacklistSequenceLastSeen": "2020-02-20 00:00:00",  #
                              Optional. Required.
                            "count": 0,  # Optional. Required.
                            "domain": "str",  # Optional. Required.
                            "domainMalwareReputationScore": 0,  # Optional. Required.
                            "domainPhishReputationScore": 0,  # Optional. Required.
                            "domainReputationScore": 0,  # Optional. Required.
                            "domainScamReputationScore": 0,  # Optional. Required.
                            "domainSpamReputationScore": 0,  # Optional. Required.
                            "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                            "host": "str",  # Optional. Required.
                            "hostMalwareReputationScore": 0,  # Optional. Required.
                            "hostPhishReputationScore": 0,  # Optional. Required.
                            "hostReputationScore": 0,  # Optional. Required.
                            "hostScamReputationScore": 0,  # Optional. Required.
                            "hostSpamReputationScore": 0,  # Optional. Required.
                            "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                            "malwareCauseCount": 0,  # Optional. Required.
                            "malwareResourceCount": 0,  # Optional. Required.
                            "malwareSequenceCount": 0,  # Optional. Required.
                            "phishCauseCount": 0,  # Optional. Required.
                            "phishResourceCount": 0,  # Optional. Required.
                            "phishSequenceCount": 0,  # Optional. Required.
                            "scamCauseCount": 0,  # Optional. Required.
                            "scamResourceCount": 0,  # Optional. Required.
                            "scamSequenceCount": 0,  # Optional. Required.
                            "spamCauseCount": 0,  # Optional. Required.
                            "spamResourceCount": 0,  # Optional. Required.
                            "spamSequenceCount": 0,  # Optional. Required.
                            "uuid": "str"  # Optional. Required.
                        },
                        "ipAddresses": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "ipBlocks": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "ipBlock": "str",  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "ipv4": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "ipv6": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "isWildcard": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "location": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": {
                                    "areaCode": 0,  # Optional. Required.
                                    "city": "str",  # Optional. Required.
                                    "countryCode": "str",  # Optional. Required.
                                    "countryName": "str",  # Optional. Required.
                                    "dmaCode": 0,  # Optional. Required.
                                    "latitude": 0.0,  # Optional. Required.
                                    "longitude": 0.0,  # Optional. Required.
                                    "metroCodeId": 0,  # Optional. Required.
                                    "postalCode": "str",  # Optional. Required.
                                    "region": "str",  # Optional. Required.
                                    "regionName": "str"  # Optional. Required.
                                }
                            }
                        ],
                        "mxRecord": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "nsRecord": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "nxdomain": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "parentHosts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "resourceUrls": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "resources": [
                                    {
                                        "cached": bool,  # Optional.
                                          Required.
                                        "contentType": "str",  # Optional.
                                          Required.
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "firstSeenCrawlGuid": "str",  #
                                          Optional. Required.
                                        "firstSeenPageGuid": "str",  #
                                          Optional. Required.
                                        "firstSeenResourceGuid": "str",  #
                                          Optional. Required.
                                        "host": "str",  # Optional. Required.
                                        "lastObservedActualSriHash": "str",
                                          # Optional. Required.
                                        "lastObservedExpectedSriHash": "str",
                                          # Optional. Required.
                                        "lastObservedValidation": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "lastObservedViolation": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "lastSeenCrawlGuid": "str",  #
                                          Optional. Required.
                                        "lastSeenPageGuid": "str",  #
                                          Optional. Required.
                                        "lastSeenResourceGuid": "str",  #
                                          Optional. Required.
                                        "md5": "str",  # Optional. Required.
                                        "responseBodyMinhash": [
                                            0  # Optional. Required.
                                        ],
                                        "responseBodySize": 0,  # Optional.
                                          Required.
                                        "sha256": "str",  # Optional.
                                          Required.
                                        "sha384": "str",  # Optional.
                                          Required.
                                        "sha512": "str",  # Optional.
                                          Required.
                                        "sriChecks": [
                                            {
                                                "causePageUrl":
                                                  "str",  # Optional. Required.
                                                "count": 0,  #
                                                  Optional. Required.
                                                "crawlGuid": "str",
                                                  # Optional. Required.
                                                "expectedHash":
                                                  "str",  # Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "pageGuid": "str",  #
                                                  Optional. Required.
                                                "resourceGuid":
                                                  "str",  # Optional. Required.
                                                "violation": bool  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "url": "str"  # Optional. Required.
                                    }
                                ],
                                "url": "str"  # Optional. Required.
                            }
                        ],
                        "responseBodies": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "scanMetadata": [
                            {
                                "bannerMetadata": "str",  # Optional. Required.
                                "endScan": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "startScan": "2020-02-20 00:00:00"  # Optional.
                                  Required.
                            }
                        ],
                        "services": [
                            {
                                "count": 0,  # Optional. Required.
                                "exceptions": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "recent": bool,  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "value": "str"  # Optional. Required.
                                    }
                                ],
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "portStates": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "port": 0,  # Optional. Required.
                                        "recent": bool,  # Optional.
                                          Required.
                                        "value": "str"  # Optional. Known
                                          values are: "open", "closed", and "filtered".
                                    }
                                ],
                                "recent": bool,  # Optional. Required.
                                "scheme": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "sslCerts": [
                                    {
                                        "certificateAuthority": bool,  #
                                          Optional. Required.
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "invalidAfter": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "invalidBefore": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "issuerAlternativeNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerCommonNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerCountry": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerLocality": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerOrganizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerOrganizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerState": [
                                            "str"  # Optional. Required.
                                        ],
                                        "keyAlgorithm": "str",  # Optional.
                                          Required.
                                        "keySize": 0,  # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "organizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "organizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "recent": bool,  # Optional.
                                          Required.
                                        "selfSigned": bool,  # Optional.
                                          Required.
                                        "serialNumber": "str",  # Optional.
                                          Required.
                                        "sha1": "str",  # Optional. Required.
                                        "sigAlgName": "str",  # Optional.
                                          Required.
                                        "sigAlgOid": "str",  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "subjectAlternativeNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectCommonNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectCountry": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectLocality": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectOrganizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectOrganizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectState": [
                                            "str"  # Optional. Required.
                                        ],
                                        "validationType": "str",  # Optional.
                                          Known values are: "domainValidation",
                                          "organizationValidation", and "extendedValidation".
                                        "version": 0  # Optional. Required.
                                    }
                                ],
                                "webComponents": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "cve": [
                                            {
                                                "cvss3Summary": {
                "attackComplexity": "str",  # Optional. Required.
                "attackVector": "str",  # Optional. Required.
                "availabilityImpact": "str",  # Optional.
                                                      Required.
                                                    "baseScore":
                                                      0.0,  # Optional. Required.
                "baseSeverity": "str",  # Optional. Required.
                "confidentialityImpact": "str",  # Optional.
                                                      Required.
                "exploitCodeMaturity": "str",  # Optional.
                                                      Required.
                "exploitabilityScore": 0.0,  # Optional.
                                                      Required.
                "impactScore": 0.0,  # Optional. Required.
                "integrityImpact": "str",  # Optional. Required.
                "privilegesRequired": "str",  # Optional.
                                                      Required.
                "remediationLevel": "str",  # Optional. Required.
                "reportConfidence": "str",  # Optional. Required.
                                                    "scope":
                                                      "str",  # Optional. Required.
                "userInteraction": "str",  # Optional. Required.
                "vectorString": "str",  # Optional. Required.
                                                    "version":
                                                      "str"  # Optional. Required.
                                                },
                                                "cvssScore": 0.0,  #
                                                  Optional. Required.
                                                "cweId": "str",  #
                                                  Optional. Required.
                                                "name": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "endOfLife": 0,  # Optional.
                                          Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "name": "str",  # Optional. Required.
                                        "ports": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "port": 0  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "recent": bool,  # Optional.
                                          Required.
                                        "ruleId": [
                                            "str"  # Optional. Required.
                                        ],
                                        "service": "str",  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "type": "str",  # Optional. Required.
                                        "version": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ],
                        "sslCerts": [
                            {
                                "certificateAuthority": bool,  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "invalidAfter": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "invalidBefore": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "issuerAlternativeNames": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerCommonNames": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerCountry": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerLocality": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerOrganizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerOrganizations": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerState": [
                                    "str"  # Optional. Required.
                                ],
                                "keyAlgorithm": "str",  # Optional. Required.
                                "keySize": 0,  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "organizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "organizations": [
                                    "str"  # Optional. Required.
                                ],
                                "recent": bool,  # Optional. Required.
                                "selfSigned": bool,  # Optional. Required.
                                "serialNumber": "str",  # Optional. Required.
                                "sha1": "str",  # Optional. Required.
                                "sigAlgName": "str",  # Optional. Required.
                                "sigAlgOid": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "subjectAlternativeNames": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectCommonNames": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectCountry": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectLocality": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectOrganizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectOrganizations": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectState": [
                                    "str"  # Optional. Required.
                                ],
                                "validationType": "str",  # Optional. Known values
                                  are: "domainValidation", "organizationValidation", and
                                  "extendedValidation".
                                "version": 0  # Optional. Required.
                            }
                        ],
                        "sslServerConfig": [
                            {
                                "cipherSuites": [
                                    "str"  # Optional. Required.
                                ],
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "tlsVersions": [
                                    "str"  # Optional. Required.
                                ]
                            }
                        ],
                        "webComponents": [
                            {
                                "count": 0,  # Optional. Required.
                                "cve": [
                                    {
                                        "cvss3Summary": {
                                            "attackComplexity": "str",  #
                                              Optional. Required.
                                            "attackVector": "str",  #
                                              Optional. Required.
                                            "availabilityImpact": "str",
                                              # Optional. Required.
                                            "baseScore": 0.0,  #
                                              Optional. Required.
                                            "baseSeverity": "str",  #
                                              Optional. Required.
                                            "confidentialityImpact":
                                              "str",  # Optional. Required.
                                            "exploitCodeMaturity": "str",
                                              # Optional. Required.
                                            "exploitabilityScore": 0.0,
                                              # Optional. Required.
                                            "impactScore": 0.0,  #
                                              Optional. Required.
                                            "integrityImpact": "str",  #
                                              Optional. Required.
                                            "privilegesRequired": "str",
                                              # Optional. Required.
                                            "remediationLevel": "str",  #
                                              Optional. Required.
                                            "reportConfidence": "str",  #
                                              Optional. Required.
                                            "scope": "str",  # Optional.
                                              Required.
                                            "userInteraction": "str",  #
                                              Optional. Required.
                                            "vectorString": "str",  #
                                              Optional. Required.
                                            "version": "str"  # Optional.
                                              Required.
                                        },
                                        "cvssScore": 0.0,  # Optional.
                                          Required.
                                        "cweId": "str",  # Optional.
                                          Required.
                                        "name": "str"  # Optional. Required.
                                    }
                                ],
                                "endOfLife": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "name": "str",  # Optional. Required.
                                "ports": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "port": 0  # Optional. Required.
                                    }
                                ],
                                "recent": bool,  # Optional. Required.
                                "ruleId": [
                                    "str"  # Optional. Required.
                                ],
                                "service": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "type": "str",  # Optional. Required.
                                "version": "str"  # Optional. Required.
                            }
                        ],
                        "webserver": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "host",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # JSON input template for discriminator value "ipAddress":
                asset_response = {
                    "asset": {
                        "asns": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": 0  # Optional. Required.
                            }
                        ],
                        "attributes": [
                            {
                                "attributeType": "str",  # Optional. Required.
                                "attributeValue": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "banners": [
                            {
                                "banner": "str",  # Optional. Required.
                                "bannerMetadata": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "recent": bool,  # Optional. Required.
                                "scanType": "str",  # Optional. Required.
                                "sha256": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "cookies": [
                            {
                                "cookieDomain": "str",  # Optional. Required.
                                "cookieExpiryDate": "2020-02-20 00:00:00",  #
                                  Optional. Required.
                                "cookieName": "str",  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "count": 0,  # Optional. Required.
                        "firstSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "headers": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "headerName": "str",  # Optional. Required.
                                "headerValue": "str",  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool  # Optional. Required.
                            }
                        ],
                        "hosts": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "ipAddress": "str",  # Optional. Required.
                        "ipBlocks": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "ipBlock": "str",  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "ipv4": bool,  # Optional. Required.
                        "ipv6": bool,  # Optional. Required.
                        "lastSeen": "2020-02-20 00:00:00",  # Optional. Required.
                        "location": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": {
                                    "areaCode": 0,  # Optional. Required.
                                    "city": "str",  # Optional. Required.
                                    "countryCode": "str",  # Optional. Required.
                                    "countryName": "str",  # Optional. Required.
                                    "dmaCode": 0,  # Optional. Required.
                                    "latitude": 0.0,  # Optional. Required.
                                    "longitude": 0.0,  # Optional. Required.
                                    "metroCodeId": 0,  # Optional. Required.
                                    "postalCode": "str",  # Optional. Required.
                                    "region": "str",  # Optional. Required.
                                    "regionName": "str"  # Optional. Required.
                                }
                            }
                        ],
                        "mxRecord": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "netRanges": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": "str"  # Optional. Required.
                            }
                        ],
                        "nsRecord": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "nxdomain": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "value": bool  # Optional. Required.
                            }
                        ],
                        "reputations": [
                            {
                                "cidr": "str",  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "listName": "str",  # Optional. Required.
                                "listUpdatedAt": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "recent": bool,  # Optional. Required.
                                "threatType": "str",  # Optional. Required.
                                "trusted": bool  # Optional. Required.
                            }
                        ],
                        "scanMetadata": [
                            {
                                "bannerMetadata": "str",  # Optional. Required.
                                "endScan": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "startScan": "2020-02-20 00:00:00"  # Optional.
                                  Required.
                            }
                        ],
                        "services": [
                            {
                                "count": 0,  # Optional. Required.
                                "exceptions": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "recent": bool,  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "value": "str"  # Optional. Required.
                                    }
                                ],
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "port": 0,  # Optional. Required.
                                "portStates": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "port": 0,  # Optional. Required.
                                        "recent": bool,  # Optional.
                                          Required.
                                        "value": "str"  # Optional. Known
                                          values are: "open", "closed", and "filtered".
                                    }
                                ],
                                "recent": bool,  # Optional. Required.
                                "scheme": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "sslCerts": [
                                    {
                                        "certificateAuthority": bool,  #
                                          Optional. Required.
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "invalidAfter": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "invalidBefore": "2020-02-20
                                          00:00:00",  # Optional. Required.
                                        "issuerAlternativeNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerCommonNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerCountry": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerLocality": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerOrganizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerOrganizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "issuerState": [
                                            "str"  # Optional. Required.
                                        ],
                                        "keyAlgorithm": "str",  # Optional.
                                          Required.
                                        "keySize": 0,  # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "organizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "organizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "recent": bool,  # Optional.
                                          Required.
                                        "selfSigned": bool,  # Optional.
                                          Required.
                                        "serialNumber": "str",  # Optional.
                                          Required.
                                        "sha1": "str",  # Optional. Required.
                                        "sigAlgName": "str",  # Optional.
                                          Required.
                                        "sigAlgOid": "str",  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "subjectAlternativeNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectCommonNames": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectCountry": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectLocality": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectOrganizationalUnits": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectOrganizations": [
                                            "str"  # Optional. Required.
                                        ],
                                        "subjectState": [
                                            "str"  # Optional. Required.
                                        ],
                                        "validationType": "str",  # Optional.
                                          Known values are: "domainValidation",
                                          "organizationValidation", and "extendedValidation".
                                        "version": 0  # Optional. Required.
                                    }
                                ],
                                "webComponents": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "cve": [
                                            {
                                                "cvss3Summary": {
                "attackComplexity": "str",  # Optional. Required.
                "attackVector": "str",  # Optional. Required.
                "availabilityImpact": "str",  # Optional.
                                                      Required.
                                                    "baseScore":
                                                      0.0,  # Optional. Required.
                "baseSeverity": "str",  # Optional. Required.
                "confidentialityImpact": "str",  # Optional.
                                                      Required.
                "exploitCodeMaturity": "str",  # Optional.
                                                      Required.
                "exploitabilityScore": 0.0,  # Optional.
                                                      Required.
                "impactScore": 0.0,  # Optional. Required.
                "integrityImpact": "str",  # Optional. Required.
                "privilegesRequired": "str",  # Optional.
                                                      Required.
                "remediationLevel": "str",  # Optional. Required.
                "reportConfidence": "str",  # Optional. Required.
                                                    "scope":
                                                      "str",  # Optional. Required.
                "userInteraction": "str",  # Optional. Required.
                "vectorString": "str",  # Optional. Required.
                                                    "version":
                                                      "str"  # Optional. Required.
                                                },
                                                "cvssScore": 0.0,  #
                                                  Optional. Required.
                                                "cweId": "str",  #
                                                  Optional. Required.
                                                "name": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "endOfLife": 0,  # Optional.
                                          Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "name": "str",  # Optional. Required.
                                        "ports": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "port": 0  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "recent": bool,  # Optional.
                                          Required.
                                        "ruleId": [
                                            "str"  # Optional. Required.
                                        ],
                                        "service": "str",  # Optional.
                                          Required.
                                        "sources": [
                                            {
                                                "count": 0,  #
                                                  Optional. Required.
                                                "firstSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "lastSeen":
                                                  "2020-02-20 00:00:00",  # Optional. Required.
                                                "reason": "str",  #
                                                  Optional. Required.
                                                "source": "str"  #
                                                  Optional. Required.
                                            }
                                        ],
                                        "type": "str",  # Optional. Required.
                                        "version": "str"  # Optional.
                                          Required.
                                    }
                                ]
                            }
                        ],
                        "sources": [
                            {
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "reason": "str",  # Optional. Required.
                                "source": "str"  # Optional. Required.
                            }
                        ],
                        "sslCerts": [
                            {
                                "certificateAuthority": bool,  # Optional. Required.
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "invalidAfter": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "invalidBefore": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "issuerAlternativeNames": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerCommonNames": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerCountry": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerLocality": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerOrganizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerOrganizations": [
                                    "str"  # Optional. Required.
                                ],
                                "issuerState": [
                                    "str"  # Optional. Required.
                                ],
                                "keyAlgorithm": "str",  # Optional. Required.
                                "keySize": 0,  # Optional. Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "organizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "organizations": [
                                    "str"  # Optional. Required.
                                ],
                                "recent": bool,  # Optional. Required.
                                "selfSigned": bool,  # Optional. Required.
                                "serialNumber": "str",  # Optional. Required.
                                "sha1": "str",  # Optional. Required.
                                "sigAlgName": "str",  # Optional. Required.
                                "sigAlgOid": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "subjectAlternativeNames": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectCommonNames": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectCountry": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectLocality": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectOrganizationalUnits": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectOrganizations": [
                                    "str"  # Optional. Required.
                                ],
                                "subjectState": [
                                    "str"  # Optional. Required.
                                ],
                                "validationType": "str",  # Optional. Known values
                                  are: "domainValidation", "organizationValidation", and
                                  "extendedValidation".
                                "version": 0  # Optional. Required.
                            }
                        ],
                        "sslServerConfig": [
                            {
                                "cipherSuites": [
                                    "str"  # Optional. Required.
                                ],
                                "count": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "tlsVersions": [
                                    "str"  # Optional. Required.
                                ]
                            }
                        ],
                        "webComponents": [
                            {
                                "count": 0,  # Optional. Required.
                                "cve": [
                                    {
                                        "cvss3Summary": {
                                            "attackComplexity": "str",  #
                                              Optional. Required.
                                            "attackVector": "str",  #
                                              Optional. Required.
                                            "availabilityImpact": "str",
                                              # Optional. Required.
                                            "baseScore": 0.0,  #
                                              Optional. Required.
                                            "baseSeverity": "str",  #
                                              Optional. Required.
                                            "confidentialityImpact":
                                              "str",  # Optional. Required.
                                            "exploitCodeMaturity": "str",
                                              # Optional. Required.
                                            "exploitabilityScore": 0.0,
                                              # Optional. Required.
                                            "impactScore": 0.0,  #
                                              Optional. Required.
                                            "integrityImpact": "str",  #
                                              Optional. Required.
                                            "privilegesRequired": "str",
                                              # Optional. Required.
                                            "remediationLevel": "str",  #
                                              Optional. Required.
                                            "reportConfidence": "str",  #
                                              Optional. Required.
                                            "scope": "str",  # Optional.
                                              Required.
                                            "userInteraction": "str",  #
                                              Optional. Required.
                                            "vectorString": "str",  #
                                              Optional. Required.
                                            "version": "str"  # Optional.
                                              Required.
                                        },
                                        "cvssScore": 0.0,  # Optional.
                                          Required.
                                        "cweId": "str",  # Optional.
                                          Required.
                                        "name": "str"  # Optional. Required.
                                    }
                                ],
                                "endOfLife": 0,  # Optional. Required.
                                "firstSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "lastSeen": "2020-02-20 00:00:00",  # Optional.
                                  Required.
                                "name": "str",  # Optional. Required.
                                "ports": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "port": 0  # Optional. Required.
                                    }
                                ],
                                "recent": bool,  # Optional. Required.
                                "ruleId": [
                                    "str"  # Optional. Required.
                                ],
                                "service": "str",  # Optional. Required.
                                "sources": [
                                    {
                                        "count": 0,  # Optional. Required.
                                        "firstSeen": "2020-02-20 00:00:00",
                                          # Optional. Required.
                                        "lastSeen": "2020-02-20 00:00:00",  #
                                          Optional. Required.
                                        "reason": "str",  # Optional.
                                          Required.
                                        "source": "str"  # Optional.
                                          Required.
                                    }
                                ],
                                "type": "str",  # Optional. Required.
                                "version": "str"  # Optional. Required.
                            }
                        ]
                    },
                    "kind": "ipAddress",
                    "auditTrail": [
                        {
                            "displayName": "str",  # Optional. The name that can be used
                              for display purposes.
                            "id": "str",  # Optional. The system generated unique id for
                              the resource.
                            "kind": "str",  # Optional. The kind of asset. Known values
                              are: "as", "contact", "domain", "host", "ipAddress", "ipBlock", "page",
                              and "sslCert".
                            "name": "str",  # Optional. The caller provided unique name
                              for the resource.
                            "reason": "str"  # Optional. An explanation of why this audit
                              trail node was discovered from the previous node.
                        }
                    ],
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      first added to this workspace.
                    "discoGroupName": "str",  # Optional. The name of the DiscoveryGroup that
                      brought added this asset to the workspace.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "externalId": "str",  # Optional. An optional customer provided identifier
                      for this asset.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "labels": [
                        "str"  # Optional. Customer labels assigned to this asset.
                    ],
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "reason": "str",  # Optional.
                    "state": "str",  # Optional. Known values are: "candidate", "confirmed",
                      "dismissed", "candidateInvestigate", "associatedPartner", "associatedThirdparty",
                      and "archived".
                    "updatedDate": "2020-02-20 00:00:00",  # Optional. The date this asset was
                      last updated for this workspace.
                    "uuid": "str",  # Optional. Global UUID for the asset.
                    "wildcard": bool  # Optional. An indicator of whether this asset represents a
                      wildcard rollup of assets on this domain.
                }

                # response body for status code(s): 200
                response == asset_response
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_assets_get_request(
            asset_id=asset_id,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class DiscoveryGroupsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.defender.easm.aio.EasmClient`'s
        :attr:`discovery_groups` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, *, filter: Optional[str] = None, skip: int = 0, **kwargs: Any) -> AsyncIterable[JSON]:
        """Retrieve a list of discovery group for the provided search parameters.

        Retrieve a list of discovery group for the provided search parameters.

        :keyword filter: An expression on the resource type that selects the resources to be returned.
         Default value is None.
        :paramtype filter: str
        :keyword skip: An offset into the collection of the first item to be returned. Default value is
         0.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date for the disco
                      group was created.
                    "description": "str",  # Optional. The description for a disco group.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "excludes": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "frequencyMilliseconds": 0,  # Optional. The frequency at which the disco
                      group is supposed to be rerun in milliseconds.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "latestRun": {
                        "completedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was completed by the system.
                        "excludes": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "names": [
                            "str"  # Optional. The list of names used for the disco run.
                        ],
                        "seeds": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "startedDate": "2020-02-20 00:00:00",  # Optional. The date for when
                          the disco run was actually started by the system.
                        "state": "str",  # Optional. The State of the disco run. Known values
                          are: "pending", "running", "completed", and "failed".
                        "submittedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was created in the system.
                        "tier": "str",  # Optional. The tier which will affect the algorithm
                          used for the disco run.
                        "totalAssetsFoundCount": 0  # Optional. The total count of assets
                          that were found this disco run.
                    },
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "names": [
                        "str"  # Optional. The list of names used for the disco group runs.
                    ],
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "templateId": "str",  # Optional. The unique identifier for the disco
                      template used for the disco group creation.
                    "tier": "str"  # Optional. The tier for the disco group which will affect the
                      algorithm used for the disco runs in this group.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_discovery_groups_list_request(
                    subscription_id=self._config.subscription_id,
                    resource_group_name=self._config.resource_group_name,
                    workspace_name=self._config.workspace_name,
                    filter=filter,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["content"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def delete(self, group_name: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Delete a discovery group with a given groupName.

        Delete a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_discovery_groups_delete_request(
            group_name=group_name,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def get(self, group_name: str, **kwargs: Any) -> JSON:
        """Retrieve a discovery group with a given groupName.

        Retrieve a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date for the disco
                      group was created.
                    "description": "str",  # Optional. The description for a disco group.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "excludes": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "frequencyMilliseconds": 0,  # Optional. The frequency at which the disco
                      group is supposed to be rerun in milliseconds.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "latestRun": {
                        "completedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was completed by the system.
                        "excludes": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "names": [
                            "str"  # Optional. The list of names used for the disco run.
                        ],
                        "seeds": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "startedDate": "2020-02-20 00:00:00",  # Optional. The date for when
                          the disco run was actually started by the system.
                        "state": "str",  # Optional. The State of the disco run. Known values
                          are: "pending", "running", "completed", and "failed".
                        "submittedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was created in the system.
                        "tier": "str",  # Optional. The tier which will affect the algorithm
                          used for the disco run.
                        "totalAssetsFoundCount": 0  # Optional. The total count of assets
                          that were found this disco run.
                    },
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "names": [
                        "str"  # Optional. The list of names used for the disco group runs.
                    ],
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "templateId": "str",  # Optional. The unique identifier for the disco
                      template used for the disco group creation.
                    "tier": "str"  # Optional. The tier for the disco group which will affect the
                      algorithm used for the disco runs in this group.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_discovery_groups_get_request(
            group_name=group_name,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def put(self, group_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Create a discovery group with a given groupName.

        Create a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "description": "str",  # Optional. The description for a disco group.
                    "excludes": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "frequencyMilliseconds": 0,  # Optional. The frequency at which the disco
                      group is supposed to be rerun in milliseconds.
                    "names": [
                        "str"  # Optional. The list of names used for the disco group runs.
                    ],
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "templateId": "str",  # Optional. The unique identifier for the disco
                      template used for the disco group creation.
                    "tier": "str"  # Optional. The tier for the disco group which will affect the
                      algorithm used for the disco runs in this group.
                }

                # response body for status code(s): 200
                response == {
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date for the disco
                      group was created.
                    "description": "str",  # Optional. The description for a disco group.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "excludes": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "frequencyMilliseconds": 0,  # Optional. The frequency at which the disco
                      group is supposed to be rerun in milliseconds.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "latestRun": {
                        "completedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was completed by the system.
                        "excludes": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "names": [
                            "str"  # Optional. The list of names used for the disco run.
                        ],
                        "seeds": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "startedDate": "2020-02-20 00:00:00",  # Optional. The date for when
                          the disco run was actually started by the system.
                        "state": "str",  # Optional. The State of the disco run. Known values
                          are: "pending", "running", "completed", and "failed".
                        "submittedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was created in the system.
                        "tier": "str",  # Optional. The tier which will affect the algorithm
                          used for the disco run.
                        "totalAssetsFoundCount": 0  # Optional. The total count of assets
                          that were found this disco run.
                    },
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "names": [
                        "str"  # Optional. The list of names used for the disco group runs.
                    ],
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "templateId": "str",  # Optional. The unique identifier for the disco
                      template used for the disco group creation.
                    "tier": "str"  # Optional. The tier for the disco group which will affect the
                      algorithm used for the disco runs in this group.
                }
        """

    @overload
    async def put(self, group_name: str, body: IO, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Create a discovery group with a given groupName.

        Create a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date for the disco
                      group was created.
                    "description": "str",  # Optional. The description for a disco group.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "excludes": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "frequencyMilliseconds": 0,  # Optional. The frequency at which the disco
                      group is supposed to be rerun in milliseconds.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "latestRun": {
                        "completedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was completed by the system.
                        "excludes": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "names": [
                            "str"  # Optional. The list of names used for the disco run.
                        ],
                        "seeds": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "startedDate": "2020-02-20 00:00:00",  # Optional. The date for when
                          the disco run was actually started by the system.
                        "state": "str",  # Optional. The State of the disco run. Known values
                          are: "pending", "running", "completed", and "failed".
                        "submittedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was created in the system.
                        "tier": "str",  # Optional. The tier which will affect the algorithm
                          used for the disco run.
                        "totalAssetsFoundCount": 0  # Optional. The total count of assets
                          that were found this disco run.
                    },
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "names": [
                        "str"  # Optional. The list of names used for the disco group runs.
                    ],
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "templateId": "str",  # Optional. The unique identifier for the disco
                      template used for the disco group creation.
                    "tier": "str"  # Optional. The tier for the disco group which will affect the
                      algorithm used for the disco runs in this group.
                }
        """

    @distributed_trace_async
    async def put(self, group_name: str, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Create a discovery group with a given groupName.

        Create a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :param body: Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDate": "2020-02-20 00:00:00",  # Optional. The date for the disco
                      group was created.
                    "description": "str",  # Optional. The description for a disco group.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "excludes": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "frequencyMilliseconds": 0,  # Optional. The frequency at which the disco
                      group is supposed to be rerun in milliseconds.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "latestRun": {
                        "completedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was completed by the system.
                        "excludes": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "names": [
                            "str"  # Optional. The list of names used for the disco run.
                        ],
                        "seeds": [
                            {
                                "kind": "str",  # Optional. The kind of disco source.
                                  Known values are: "as", "attribute", "contact", "domain", "host", and
                                  "ipBlock".
                                "name": "str"  # Optional. The name for the disco
                                  source.
                            }
                        ],
                        "startedDate": "2020-02-20 00:00:00",  # Optional. The date for when
                          the disco run was actually started by the system.
                        "state": "str",  # Optional. The State of the disco run. Known values
                          are: "pending", "running", "completed", and "failed".
                        "submittedDate": "2020-02-20 00:00:00",  # Optional. The date for
                          when the disco run was created in the system.
                        "tier": "str",  # Optional. The tier which will affect the algorithm
                          used for the disco run.
                        "totalAssetsFoundCount": 0  # Optional. The total count of assets
                          that were found this disco run.
                    },
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "names": [
                        "str"  # Optional. The list of names used for the disco group runs.
                    ],
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "templateId": "str",  # Optional. The unique identifier for the disco
                      template used for the disco group creation.
                    "tier": "str"  # Optional. The tier for the disco group which will affect the
                      algorithm used for the disco runs in this group.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_discovery_groups_put_request(
            group_name=group_name,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_runs(
        self, group_name: str, *, filter: Optional[str] = None, skip: int = 0, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Retrieve a collection of discovery run results for a discovery group with a given groupName.

        Retrieve a collection of discovery run results for a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :keyword filter: An expression on the resource type that selects the resources to be returned.
         Default value is None.
        :paramtype filter: str
        :keyword skip: An offset into the collection of the first item to be returned. Default value is
         0.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "completedDate": "2020-02-20 00:00:00",  # Optional. The date for when the
                      disco run was completed by the system.
                    "excludes": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "names": [
                        "str"  # Optional. The list of names used for the disco run.
                    ],
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "startedDate": "2020-02-20 00:00:00",  # Optional. The date for when the
                      disco run was actually started by the system.
                    "state": "str",  # Optional. The State of the disco run. Known values are:
                      "pending", "running", "completed", and "failed".
                    "submittedDate": "2020-02-20 00:00:00",  # Optional. The date for when the
                      disco run was created in the system.
                    "tier": "str",  # Optional. The tier which will affect the algorithm used for
                      the disco run.
                    "totalAssetsFoundCount": 0  # Optional. The total count of assets that were
                      found this disco run.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_discovery_groups_list_runs_request(
                    group_name=group_name,
                    subscription_id=self._config.subscription_id,
                    resource_group_name=self._config.resource_group_name,
                    workspace_name=self._config.workspace_name,
                    filter=filter,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["content"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def run(self, group_name: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Run a discovery group with a given groupName.

        Run a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_discovery_groups_run_request(
            group_name=group_name,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    async def validate(
        self, group_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Validate a discovery group with a given groupName.

        Validate a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "description": "str",  # Optional. The description for a disco group.
                    "excludes": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "frequencyMilliseconds": 0,  # Optional. The frequency at which the disco
                      group is supposed to be rerun in milliseconds.
                    "names": [
                        "str"  # Optional. The list of names used for the disco group runs.
                    ],
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "templateId": "str",  # Optional. The unique identifier for the disco
                      template used for the disco group creation.
                    "tier": "str"  # Optional. The tier for the disco group which will affect the
                      algorithm used for the disco runs in this group.
                }

                # response body for status code(s): 200
                response == {
                    "error": {
                        "code": "str",  # This is one of a server-defined set of error codes.
                          Required.
                        "message": "str",  # This is a human-readable representation of the
                          error. Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. This is a more specific error
                              code than was provided by the containing error.
                            "value": {}  # Optional. This is an additional field
                              representing the value that caused the error to help with debugging.
                        },
                        "target": "str"  # Optional. This is the error target.
                    }
                }
        """

    @overload
    async def validate(
        self, group_name: str, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Validate a discovery group with a given groupName.

        Validate a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "error": {
                        "code": "str",  # This is one of a server-defined set of error codes.
                          Required.
                        "message": "str",  # This is a human-readable representation of the
                          error. Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. This is a more specific error
                              code than was provided by the containing error.
                            "value": {}  # Optional. This is an additional field
                              representing the value that caused the error to help with debugging.
                        },
                        "target": "str"  # Optional. This is the error target.
                    }
                }
        """

    @distributed_trace_async
    async def validate(self, group_name: str, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Validate a discovery group with a given groupName.

        Validate a discovery group with a given groupName.

        :param group_name: The unique identifier for the discovery group. Required.
        :type group_name: str
        :param body: Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "error": {
                        "code": "str",  # This is one of a server-defined set of error codes.
                          Required.
                        "message": "str",  # This is a human-readable representation of the
                          error. Required.
                        "details": [
                            ...
                        ],
                        "innererror": {
                            "code": "str",  # Optional. This is a more specific error
                              code than was provided by the containing error.
                            "value": {}  # Optional. This is an additional field
                              representing the value that caused the error to help with debugging.
                        },
                        "target": "str"  # Optional. This is the error target.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_discovery_groups_validate_request(
            group_name=group_name,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class DiscoveryTemplatesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.defender.easm.aio.EasmClient`'s
        :attr:`discovery_templates` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, *, filter: Optional[str] = None, skip: int = 0, **kwargs: Any) -> AsyncIterable[JSON]:
        """Retrieve a list of disco templates for the provided search parameters.

        Retrieve a list of disco templates for the provided search parameters.

        :keyword filter: An expression on the resource type that selects the resources to be returned.
         Default value is None.
        :paramtype filter: str
        :keyword skip: An offset into the collection of the first item to be returned. Default value is
         0.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "city": "str",  # Optional. The name of the city.
                    "countryCode": "str",  # Optional. The country code.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "industry": "str",  # Optional. The name of the industry.
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "names": [
                        "str"  # Optional. The list of disco template names.
                    ],
                    "region": "str",  # Optional. The name of the region.
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "stateCode": "str"  # Optional. The state code.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_discovery_templates_list_request(
                    subscription_id=self._config.subscription_id,
                    resource_group_name=self._config.resource_group_name,
                    workspace_name=self._config.workspace_name,
                    filter=filter,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["content"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, template_id: str, **kwargs: Any) -> JSON:
        """Retrieve a disco template with a given templateId.

        Retrieve a disco template with a given templateId.

        :param template_id: The unique identifier for the disco template. Required.
        :type template_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "city": "str",  # Optional. The name of the city.
                    "countryCode": "str",  # Optional. The country code.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "industry": "str",  # Optional. The name of the industry.
                    "name": "str",  # Optional. The caller provided unique name for the resource.
                    "names": [
                        "str"  # Optional. The list of disco template names.
                    ],
                    "region": "str",  # Optional. The name of the region.
                    "seeds": [
                        {
                            "kind": "str",  # Optional. The kind of disco source. Known
                              values are: "as", "attribute", "contact", "domain", "host", and
                              "ipBlock".
                            "name": "str"  # Optional. The name for the disco source.
                        }
                    ],
                    "stateCode": "str"  # Optional. The state code.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_discovery_templates_get_request(
            template_id=template_id,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class ReportsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.defender.easm.aio.EasmClient`'s
        :attr:`reports` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def billable(self, **kwargs: Any) -> JSON:
        """Get billable assets summary for the workspace.

        Get billable assets summary for the workspace.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assetSummaries": [
                        {
                            "assetBreakdown": [
                                {
                                    "count": 0,  # Optional. The number of assets
                                      of this type.
                                    "kind": "str"  # Optional. The kind of
                                      billable asset. Known values are: "domain", "host", and
                                      "ipAddress".
                                }
                            ],
                            "date": "2020-02-20",  # Optional. The date these assets were
                              billed on.
                            "total": 0  # Optional. The total number of billable assets
                              for this date.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_reports_billable_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def snapshot(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Get the most recent snapshot of asset summary values for the snapshot request.

        Get the most recent snapshot of asset summary values for the snapshot request.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labelName": "str",  # Optional. The name of the label to retrieve a snapshot
                      for.
                    "metric": "str",  # Optional. The metric to retrieve a snapshot for.
                    "page": 0,  # Optional. The page to retrieve.
                    "size": 0  # Optional. The number of assets per page.
                }

                # response body for status code(s): 200
                response == {
                    "assets": {
                        "content": [
                            asset_response
                        ],
                        "first": bool,  # Optional. Whether or not this is the first page of
                          results.
                        "last": bool,  # Optional. Whether or not this is the last page of
                          results.
                        "mark": "str",  # Optional. The cursor mark to be used on the next
                          request.  Not set if using paging.
                        "nextLink": "str",  # Optional. The link to access the next page of
                          results.  Not set if at the end of the result set.
                        "number": 0,  # Optional. The page number requested.  Set to -1 if
                          using a cursor.
                        "numberOfElements": 0,  # Optional. The number of items in the
                          current page of results.
                        "size": 0,  # Optional. The page size requested.
                        "totalElements": 0,  # Optional. The total number of items available
                          in the full result set.
                        "totalPages": 0  # Optional. The total number of pages available in
                          the full result set.
                    },
                    "description": "str",  # Optional. A description of what the metric
                      represents.
                    "displayName": "str",  # Optional. The name of the metric.
                    "labelName": "str",  # Optional. The customer label that was filtered on, if
                      one was provided.
                    "metric": "str",  # Optional. The unique metric name.
                    "updatedAt": "2020-02-20 00:00:00"  # Optional. The last time this asset data
                      was updated on this metric.
                }
        """

    @overload
    async def snapshot(self, body: IO, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Get the most recent snapshot of asset summary values for the snapshot request.

        Get the most recent snapshot of asset summary values for the snapshot request.

        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assets": {
                        "content": [
                            asset_response
                        ],
                        "first": bool,  # Optional. Whether or not this is the first page of
                          results.
                        "last": bool,  # Optional. Whether or not this is the last page of
                          results.
                        "mark": "str",  # Optional. The cursor mark to be used on the next
                          request.  Not set if using paging.
                        "nextLink": "str",  # Optional. The link to access the next page of
                          results.  Not set if at the end of the result set.
                        "number": 0,  # Optional. The page number requested.  Set to -1 if
                          using a cursor.
                        "numberOfElements": 0,  # Optional. The number of items in the
                          current page of results.
                        "size": 0,  # Optional. The page size requested.
                        "totalElements": 0,  # Optional. The total number of items available
                          in the full result set.
                        "totalPages": 0  # Optional. The total number of pages available in
                          the full result set.
                    },
                    "description": "str",  # Optional. A description of what the metric
                      represents.
                    "displayName": "str",  # Optional. The name of the metric.
                    "labelName": "str",  # Optional. The customer label that was filtered on, if
                      one was provided.
                    "metric": "str",  # Optional. The unique metric name.
                    "updatedAt": "2020-02-20 00:00:00"  # Optional. The last time this asset data
                      was updated on this metric.
                }
        """

    @distributed_trace_async
    async def snapshot(self, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Get the most recent snapshot of asset summary values for the snapshot request.

        Get the most recent snapshot of asset summary values for the snapshot request.

        :param body: Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assets": {
                        "content": [
                            asset_response
                        ],
                        "first": bool,  # Optional. Whether or not this is the first page of
                          results.
                        "last": bool,  # Optional. Whether or not this is the last page of
                          results.
                        "mark": "str",  # Optional. The cursor mark to be used on the next
                          request.  Not set if using paging.
                        "nextLink": "str",  # Optional. The link to access the next page of
                          results.  Not set if at the end of the result set.
                        "number": 0,  # Optional. The page number requested.  Set to -1 if
                          using a cursor.
                        "numberOfElements": 0,  # Optional. The number of items in the
                          current page of results.
                        "size": 0,  # Optional. The page size requested.
                        "totalElements": 0,  # Optional. The total number of items available
                          in the full result set.
                        "totalPages": 0  # Optional. The total number of pages available in
                          the full result set.
                    },
                    "description": "str",  # Optional. A description of what the metric
                      represents.
                    "displayName": "str",  # Optional. The name of the metric.
                    "labelName": "str",  # Optional. The customer label that was filtered on, if
                      one was provided.
                    "metric": "str",  # Optional. The unique metric name.
                    "updatedAt": "2020-02-20 00:00:00"  # Optional. The last time this asset data
                      was updated on this metric.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_reports_snapshot_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def summary(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Get asset summary details for the summary request.

        Get asset summary details for the summary request.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "filters": [
                        "str"  # Optional. Query filters to apply to the asset summary.
                    ],
                    "groupBy": "str",  # Optional. A parameter to group the assets by (first
                      level facet field), only used when the chosen summary identifier is filters.
                    "labelName": "str",  # Optional. Currently unused.
                    "metricCategories": [
                        "str"  # Optional. Categories to retrieve risk reporting data for.
                    ],
                    "metrics": [
                        "str"  # Optional. Metrics to retrieve risk reporting data for.
                    ],
                    "segmentBy": "str"  # Optional. A parameter to segment the assets by (second
                      level facet field), only used when the chosen summary identifier is filters.
                }

                # response body for status code(s): 200
                response == {
                    "assetSummaries": [
                        {
                            "children": [
                                ...
                            ],
                            "count": 0,  # Optional. The count of assets matching the
                              request parameters.
                            "description": "str",  # Optional. The description of the
                              summary response.  Filters don't have a description.
                            "displayName": "str",  # Optional. The name of the summary
                              response.  Depending on the request time this will either be the asset
                              filter, risk category, or risk metric.
                            "filter": "str",  # Optional. If the request is for an asset
                              filter, this will contain the corresponding filter.
                            "labelName": "str",  # Optional. An optional label used to
                              filter requests results.
                            "link": "str",  # Optional. The link to the corresponding
                              asset details.
                            "metric": "str",  # Optional. If the request is for a metric,
                              this will contain the requested unique metric name.
                            "metricCategory": "str",  # Optional. If the request is for a
                              metric category, this will contain the requested unique category name.
                            "updatedAt": "2020-02-20 00:00:00"  # Optional. The last time
                              risk categories or risk metrics were captured. Set to the current time
                              for asset filter requests, which always pull the live asset data.
                        }
                    ]
                }
        """

    @overload
    async def summary(self, body: IO, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Get asset summary details for the summary request.

        Get asset summary details for the summary request.

        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assetSummaries": [
                        {
                            "children": [
                                ...
                            ],
                            "count": 0,  # Optional. The count of assets matching the
                              request parameters.
                            "description": "str",  # Optional. The description of the
                              summary response.  Filters don't have a description.
                            "displayName": "str",  # Optional. The name of the summary
                              response.  Depending on the request time this will either be the asset
                              filter, risk category, or risk metric.
                            "filter": "str",  # Optional. If the request is for an asset
                              filter, this will contain the corresponding filter.
                            "labelName": "str",  # Optional. An optional label used to
                              filter requests results.
                            "link": "str",  # Optional. The link to the corresponding
                              asset details.
                            "metric": "str",  # Optional. If the request is for a metric,
                              this will contain the requested unique metric name.
                            "metricCategory": "str",  # Optional. If the request is for a
                              metric category, this will contain the requested unique category name.
                            "updatedAt": "2020-02-20 00:00:00"  # Optional. The last time
                              risk categories or risk metrics were captured. Set to the current time
                              for asset filter requests, which always pull the live asset data.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def summary(self, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Get asset summary details for the summary request.

        Get asset summary details for the summary request.

        :param body: Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assetSummaries": [
                        {
                            "children": [
                                ...
                            ],
                            "count": 0,  # Optional. The count of assets matching the
                              request parameters.
                            "description": "str",  # Optional. The description of the
                              summary response.  Filters don't have a description.
                            "displayName": "str",  # Optional. The name of the summary
                              response.  Depending on the request time this will either be the asset
                              filter, risk category, or risk metric.
                            "filter": "str",  # Optional. If the request is for an asset
                              filter, this will contain the corresponding filter.
                            "labelName": "str",  # Optional. An optional label used to
                              filter requests results.
                            "link": "str",  # Optional. The link to the corresponding
                              asset details.
                            "metric": "str",  # Optional. If the request is for a metric,
                              this will contain the requested unique metric name.
                            "metricCategory": "str",  # Optional. If the request is for a
                              metric category, this will contain the requested unique category name.
                            "updatedAt": "2020-02-20 00:00:00"  # Optional. The last time
                              risk categories or risk metrics were captured. Set to the current time
                              for asset filter requests, which always pull the live asset data.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_reports_summary_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class SavedFiltersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.defender.easm.aio.EasmClient`'s
        :attr:`saved_filters` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, *, filter: Optional[str] = None, skip: int = 0, **kwargs: Any) -> AsyncIterable[JSON]:
        """Retrieve a list of saved filters for the provided search parameters.

        Retrieve a list of saved filters for the provided search parameters.

        :keyword filter: An expression on the resource type that selects the resources to be returned.
         Default value is None.
        :paramtype filter: str
        :keyword skip: An offset into the collection of the first item to be returned. Default value is
         0.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "description": "str",  # Optional.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "filter": "str",  # Optional.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "name": "str"  # Optional. The caller provided unique name for the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_saved_filters_list_request(
                    subscription_id=self._config.subscription_id,
                    resource_group_name=self._config.resource_group_name,
                    workspace_name=self._config.workspace_name,
                    filter=filter,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["content"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def delete(self, filter_name: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Delete a saved filter with a given filterName.

        Delete a saved filter with a given filterName.

        :param filter_name: The unique identifier for the saved filter. Required.
        :type filter_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_saved_filters_delete_request(
            filter_name=filter_name,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def get(self, filter_name: str, **kwargs: Any) -> JSON:
        """Retrieve a saved filter by filterName.

        Retrieve a saved filter by filterName.

        :param filter_name: The unique identifier for the saved filter. Required.
        :type filter_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "description": "str",  # Optional.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "filter": "str",  # Optional.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "name": "str"  # Optional. The caller provided unique name for the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_saved_filters_get_request(
            filter_name=filter_name,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def put(self, filter_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Create or update a saved filter with a given filterName.

        Create or update a saved filter with a given filterName.

        :param filter_name: The unique identifier for the saved filter. Required.
        :type filter_name: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "description": "str",  # A human readable description of the saved filter.
                      Required.
                    "filter": "str"  # An expression on the resource type that selects the
                      resources to be returned. Required.
                }

                # response body for status code(s): 200
                response == {
                    "description": "str",  # Optional.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "filter": "str",  # Optional.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "name": "str"  # Optional. The caller provided unique name for the resource.
                }
        """

    @overload
    async def put(self, filter_name: str, body: IO, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Create or update a saved filter with a given filterName.

        Create or update a saved filter with a given filterName.

        :param filter_name: The unique identifier for the saved filter. Required.
        :type filter_name: str
        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "description": "str",  # Optional.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "filter": "str",  # Optional.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "name": "str"  # Optional. The caller provided unique name for the resource.
                }
        """

    @distributed_trace_async
    async def put(self, filter_name: str, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Create or update a saved filter with a given filterName.

        Create or update a saved filter with a given filterName.

        :param filter_name: The unique identifier for the saved filter. Required.
        :type filter_name: str
        :param body: Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "description": "str",  # Optional.
                    "displayName": "str",  # Optional. The name that can be used for display
                      purposes.
                    "filter": "str",  # Optional.
                    "id": "str",  # Optional. The system generated unique id for the resource.
                    "name": "str"  # Optional. The caller provided unique name for the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_saved_filters_put_request(
            filter_name=filter_name,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class TasksOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.defender.easm.aio.EasmClient`'s
        :attr:`tasks` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, *, filter: Optional[str] = None, skip: int = 0, **kwargs: Any) -> AsyncIterable[JSON]:
        """Retrieve a list of tasks for the provided search parameters.

        Retrieve a list of tasks for the provided search parameters.

        :keyword filter: An expression on the resource type that selects the resources to be returned.
         Default value is None.
        :paramtype filter: str
        :keyword skip: An offset into the collection of the first item to be returned. Default value is
         0.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "completedAt": "2020-02-20 00:00:00",  # Optional. The time the task
                      completed.
                    "id": "str",  # Optional. The unique identifier of the task.
                    "lastPolledAt": "2020-02-20 00:00:00",  # Optional. The last time the status
                      of the task was updated.
                    "metadata": {
                        "str": {}  # Optional. Attributes unique to the task.  This differs
                          by task type.
                    },
                    "phase": "str",  # Optional. The phase the task is in. Known values are:
                      "running", "polling", and "complete".
                    "reason": "str",  # Optional. The reason the task was moved into its current
                      state, if the task wasn't completed.
                    "startedAt": "2020-02-20 00:00:00",  # Optional. The time the task started.
                    "state": "str"  # Optional. The state the task is in. Known values are:
                      "pending", "running", "paused", "complete", "incomplete", "failed", and
                      "warning".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_tasks_list_request(
                    subscription_id=self._config.subscription_id,
                    resource_group_name=self._config.resource_group_name,
                    workspace_name=self._config.workspace_name,
                    filter=filter,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["content"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, task_id: str, **kwargs: Any) -> JSON:
        """Retrieve a task by taskId.

        Retrieve a task by taskId.

        :param task_id: The unique identifier for the task. Required.
        :type task_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "completedAt": "2020-02-20 00:00:00",  # Optional. The time the task
                      completed.
                    "id": "str",  # Optional. The unique identifier of the task.
                    "lastPolledAt": "2020-02-20 00:00:00",  # Optional. The last time the status
                      of the task was updated.
                    "metadata": {
                        "str": {}  # Optional. Attributes unique to the task.  This differs
                          by task type.
                    },
                    "phase": "str",  # Optional. The phase the task is in. Known values are:
                      "running", "polling", and "complete".
                    "reason": "str",  # Optional. The reason the task was moved into its current
                      state, if the task wasn't completed.
                    "startedAt": "2020-02-20 00:00:00",  # Optional. The time the task started.
                    "state": "str"  # Optional. The state the task is in. Known values are:
                      "pending", "running", "paused", "complete", "incomplete", "failed", and
                      "warning".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_tasks_get_request(
            task_id=task_id,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def cancel(self, task_id: str, **kwargs: Any) -> JSON:
        """Cancel a task by taskId.

        Cancel a task by taskId.

        :param task_id: The unique identifier for the task. Required.
        :type task_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "completedAt": "2020-02-20 00:00:00",  # Optional. The time the task
                      completed.
                    "id": "str",  # Optional. The unique identifier of the task.
                    "lastPolledAt": "2020-02-20 00:00:00",  # Optional. The last time the status
                      of the task was updated.
                    "metadata": {
                        "str": {}  # Optional. Attributes unique to the task.  This differs
                          by task type.
                    },
                    "phase": "str",  # Optional. The phase the task is in. Known values are:
                      "running", "polling", and "complete".
                    "reason": "str",  # Optional. The reason the task was moved into its current
                      state, if the task wasn't completed.
                    "startedAt": "2020-02-20 00:00:00",  # Optional. The time the task started.
                    "state": "str"  # Optional. The state the task is in. Known values are:
                      "pending", "running", "paused", "complete", "incomplete", "failed", and
                      "warning".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_tasks_cancel_request(
            task_id=task_id,
            subscription_id=self._config.subscription_id,
            resource_group_name=self._config.resource_group_name,
            workspace_name=self._config.workspace_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)
