# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ApplicableSchedule(Resource):
    """Schedules applicable to a virtual machine. The schedules may have been
    defined on a VM or on lab level.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param lab_vms_shutdown: The auto-shutdown schedule, if one has been set
     at the lab or lab resource level.
    :type lab_vms_shutdown: ~azure.mgmt.devtestlabs.models.Schedule
    :param lab_vms_startup: The auto-startup schedule, if one has been set at
     the lab or lab resource level.
    :type lab_vms_startup: ~azure.mgmt.devtestlabs.models.Schedule
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'lab_vms_shutdown': {'key': 'properties.labVmsShutdown', 'type': 'Schedule'},
        'lab_vms_startup': {'key': 'properties.labVmsStartup', 'type': 'Schedule'},
    }

    def __init__(self, **kwargs):
        super(ApplicableSchedule, self).__init__(**kwargs)
        self.lab_vms_shutdown = kwargs.get('lab_vms_shutdown', None)
        self.lab_vms_startup = kwargs.get('lab_vms_startup', None)


class UpdateResource(Model):
    """Represents an update resource.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(UpdateResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class ApplicableScheduleFragment(UpdateResource):
    """Schedules applicable to a virtual machine. The schedules may have been
    defined on a VM or on lab level.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param lab_vms_shutdown: The auto-shutdown schedule, if one has been set
     at the lab or lab resource level.
    :type lab_vms_shutdown: ~azure.mgmt.devtestlabs.models.ScheduleFragment
    :param lab_vms_startup: The auto-startup schedule, if one has been set at
     the lab or lab resource level.
    :type lab_vms_startup: ~azure.mgmt.devtestlabs.models.ScheduleFragment
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'lab_vms_shutdown': {'key': 'properties.labVmsShutdown', 'type': 'ScheduleFragment'},
        'lab_vms_startup': {'key': 'properties.labVmsStartup', 'type': 'ScheduleFragment'},
    }

    def __init__(self, **kwargs):
        super(ApplicableScheduleFragment, self).__init__(**kwargs)
        self.lab_vms_shutdown = kwargs.get('lab_vms_shutdown', None)
        self.lab_vms_startup = kwargs.get('lab_vms_startup', None)


class ApplyArtifactsRequest(Model):
    """Request body for applying artifacts to a virtual machine.

    :param artifacts: The list of artifacts to apply.
    :type artifacts:
     list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
    """

    _attribute_map = {
        'artifacts': {'key': 'artifacts', 'type': '[ArtifactInstallProperties]'},
    }

    def __init__(self, **kwargs):
        super(ApplyArtifactsRequest, self).__init__(**kwargs)
        self.artifacts = kwargs.get('artifacts', None)


class ArmTemplate(Resource):
    """An Azure Resource Manager template.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :ivar display_name: The display name of the ARM template.
    :vartype display_name: str
    :ivar description: The description of the ARM template.
    :vartype description: str
    :ivar publisher: The publisher of the ARM template.
    :vartype publisher: str
    :ivar icon: The URI to the icon of the ARM template.
    :vartype icon: str
    :ivar contents: The contents of the ARM template.
    :vartype contents: object
    :ivar created_date: The creation date of the armTemplate.
    :vartype created_date: datetime
    :ivar parameters_value_files_info: File name and parameter values
     information from all azuredeploy.*.parameters.json for the ARM template.
    :vartype parameters_value_files_info:
     list[~azure.mgmt.devtestlabs.models.ParametersValueFileInfo]
    :ivar enabled: Whether or not ARM template is enabled for use by lab user.
    :vartype enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'publisher': {'readonly': True},
        'icon': {'readonly': True},
        'contents': {'readonly': True},
        'created_date': {'readonly': True},
        'parameters_value_files_info': {'readonly': True},
        'enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'contents': {'key': 'properties.contents', 'type': 'object'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'parameters_value_files_info': {'key': 'properties.parametersValueFilesInfo', 'type': '[ParametersValueFileInfo]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ArmTemplate, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.publisher = None
        self.icon = None
        self.contents = None
        self.created_date = None
        self.parameters_value_files_info = None
        self.enabled = None


class ArmTemplateInfo(Model):
    """Information about a generated ARM template.

    :param template: The template's contents.
    :type template: object
    :param parameters: The parameters of the ARM template.
    :type parameters: object
    """

    _attribute_map = {
        'template': {'key': 'template', 'type': 'object'},
        'parameters': {'key': 'parameters', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(ArmTemplateInfo, self).__init__(**kwargs)
        self.template = kwargs.get('template', None)
        self.parameters = kwargs.get('parameters', None)


class ArmTemplateParameterProperties(Model):
    """Properties of an Azure Resource Manager template parameter.

    :param name: The name of the template parameter.
    :type name: str
    :param value: The value of the template parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ArmTemplateParameterProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class ArmTemplateParameterPropertiesFragment(Model):
    """Properties of an Azure Resource Manager template parameter.

    :param name: The name of the template parameter.
    :type name: str
    :param value: The value of the template parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ArmTemplateParameterPropertiesFragment, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class Artifact(Resource):
    """An artifact.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :ivar title: The artifact's title.
    :vartype title: str
    :ivar description: The artifact's description.
    :vartype description: str
    :ivar publisher: The artifact's publisher.
    :vartype publisher: str
    :ivar file_path: The file path to the artifact.
    :vartype file_path: str
    :ivar icon: The URI to the artifact icon.
    :vartype icon: str
    :ivar target_os_type: The artifact's target OS.
    :vartype target_os_type: str
    :ivar parameters: The artifact's parameters.
    :vartype parameters: object
    :ivar created_date: The artifact's creation date.
    :vartype created_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'title': {'readonly': True},
        'description': {'readonly': True},
        'publisher': {'readonly': True},
        'file_path': {'readonly': True},
        'icon': {'readonly': True},
        'target_os_type': {'readonly': True},
        'parameters': {'readonly': True},
        'created_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'target_os_type': {'key': 'properties.targetOsType', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': 'object'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(Artifact, self).__init__(**kwargs)
        self.title = None
        self.description = None
        self.publisher = None
        self.file_path = None
        self.icon = None
        self.target_os_type = None
        self.parameters = None
        self.created_date = None


class ArtifactDeploymentStatusProperties(Model):
    """Properties of an artifact deployment.

    :param deployment_status: The deployment status of the artifact.
    :type deployment_status: str
    :param artifacts_applied: The total count of the artifacts that were
     successfully applied.
    :type artifacts_applied: int
    :param total_artifacts: The total count of the artifacts that were
     tentatively applied.
    :type total_artifacts: int
    """

    _attribute_map = {
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'artifacts_applied': {'key': 'artifactsApplied', 'type': 'int'},
        'total_artifacts': {'key': 'totalArtifacts', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ArtifactDeploymentStatusProperties, self).__init__(**kwargs)
        self.deployment_status = kwargs.get('deployment_status', None)
        self.artifacts_applied = kwargs.get('artifacts_applied', None)
        self.total_artifacts = kwargs.get('total_artifacts', None)


class ArtifactDeploymentStatusPropertiesFragment(Model):
    """Properties of an artifact deployment.

    :param deployment_status: The deployment status of the artifact.
    :type deployment_status: str
    :param artifacts_applied: The total count of the artifacts that were
     successfully applied.
    :type artifacts_applied: int
    :param total_artifacts: The total count of the artifacts that were
     tentatively applied.
    :type total_artifacts: int
    """

    _attribute_map = {
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'artifacts_applied': {'key': 'artifactsApplied', 'type': 'int'},
        'total_artifacts': {'key': 'totalArtifacts', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ArtifactDeploymentStatusPropertiesFragment, self).__init__(**kwargs)
        self.deployment_status = kwargs.get('deployment_status', None)
        self.artifacts_applied = kwargs.get('artifacts_applied', None)
        self.total_artifacts = kwargs.get('total_artifacts', None)


class ArtifactInstallProperties(Model):
    """Properties of an artifact.

    :param artifact_id: The artifact's identifier.
    :type artifact_id: str
    :param artifact_title: The artifact's title.
    :type artifact_title: str
    :param parameters: The parameters of the artifact.
    :type parameters:
     list[~azure.mgmt.devtestlabs.models.ArtifactParameterProperties]
    :param status: The status of the artifact.
    :type status: str
    :param deployment_status_message: The status message from the deployment.
    :type deployment_status_message: str
    :param vm_extension_status_message: The status message from the virtual
     machine extension.
    :type vm_extension_status_message: str
    :param install_time: The time that the artifact starts to install on the
     virtual machine.
    :type install_time: datetime
    """

    _attribute_map = {
        'artifact_id': {'key': 'artifactId', 'type': 'str'},
        'artifact_title': {'key': 'artifactTitle', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ArtifactParameterProperties]'},
        'status': {'key': 'status', 'type': 'str'},
        'deployment_status_message': {'key': 'deploymentStatusMessage', 'type': 'str'},
        'vm_extension_status_message': {'key': 'vmExtensionStatusMessage', 'type': 'str'},
        'install_time': {'key': 'installTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ArtifactInstallProperties, self).__init__(**kwargs)
        self.artifact_id = kwargs.get('artifact_id', None)
        self.artifact_title = kwargs.get('artifact_title', None)
        self.parameters = kwargs.get('parameters', None)
        self.status = kwargs.get('status', None)
        self.deployment_status_message = kwargs.get('deployment_status_message', None)
        self.vm_extension_status_message = kwargs.get('vm_extension_status_message', None)
        self.install_time = kwargs.get('install_time', None)


class ArtifactInstallPropertiesFragment(Model):
    """Properties of an artifact.

    :param artifact_id: The artifact's identifier.
    :type artifact_id: str
    :param artifact_title: The artifact's title.
    :type artifact_title: str
    :param parameters: The parameters of the artifact.
    :type parameters:
     list[~azure.mgmt.devtestlabs.models.ArtifactParameterPropertiesFragment]
    :param status: The status of the artifact.
    :type status: str
    :param deployment_status_message: The status message from the deployment.
    :type deployment_status_message: str
    :param vm_extension_status_message: The status message from the virtual
     machine extension.
    :type vm_extension_status_message: str
    :param install_time: The time that the artifact starts to install on the
     virtual machine.
    :type install_time: datetime
    """

    _attribute_map = {
        'artifact_id': {'key': 'artifactId', 'type': 'str'},
        'artifact_title': {'key': 'artifactTitle', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ArtifactParameterPropertiesFragment]'},
        'status': {'key': 'status', 'type': 'str'},
        'deployment_status_message': {'key': 'deploymentStatusMessage', 'type': 'str'},
        'vm_extension_status_message': {'key': 'vmExtensionStatusMessage', 'type': 'str'},
        'install_time': {'key': 'installTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ArtifactInstallPropertiesFragment, self).__init__(**kwargs)
        self.artifact_id = kwargs.get('artifact_id', None)
        self.artifact_title = kwargs.get('artifact_title', None)
        self.parameters = kwargs.get('parameters', None)
        self.status = kwargs.get('status', None)
        self.deployment_status_message = kwargs.get('deployment_status_message', None)
        self.vm_extension_status_message = kwargs.get('vm_extension_status_message', None)
        self.install_time = kwargs.get('install_time', None)


class ArtifactParameterProperties(Model):
    """Properties of an artifact parameter.

    :param name: The name of the artifact parameter.
    :type name: str
    :param value: The value of the artifact parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ArtifactParameterProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class ArtifactParameterPropertiesFragment(Model):
    """Properties of an artifact parameter.

    :param name: The name of the artifact parameter.
    :type name: str
    :param value: The value of the artifact parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ArtifactParameterPropertiesFragment, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class ArtifactSource(Resource):
    """Properties of an artifact source.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param display_name: The artifact source's display name.
    :type display_name: str
    :param uri: The artifact source's URI.
    :type uri: str
    :param source_type: The artifact source's type. Possible values include:
     'VsoGit', 'GitHub'
    :type source_type: str or ~azure.mgmt.devtestlabs.models.SourceControlType
    :param folder_path: The folder containing artifacts.
    :type folder_path: str
    :param arm_template_folder_path: The folder containing Azure Resource
     Manager templates.
    :type arm_template_folder_path: str
    :param branch_ref: The artifact source's branch reference.
    :type branch_ref: str
    :param security_token: The security token to authenticate to the artifact
     source.
    :type security_token: str
    :param status: Indicates if the artifact source is enabled (values:
     Enabled, Disabled). Possible values include: 'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :ivar created_date: The artifact source's creation date.
    :vartype created_date: datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'arm_template_folder_path': {'key': 'properties.armTemplateFolderPath', 'type': 'str'},
        'branch_ref': {'key': 'properties.branchRef', 'type': 'str'},
        'security_token': {'key': 'properties.securityToken', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ArtifactSource, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.uri = kwargs.get('uri', None)
        self.source_type = kwargs.get('source_type', None)
        self.folder_path = kwargs.get('folder_path', None)
        self.arm_template_folder_path = kwargs.get('arm_template_folder_path', None)
        self.branch_ref = kwargs.get('branch_ref', None)
        self.security_token = kwargs.get('security_token', None)
        self.status = kwargs.get('status', None)
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class ArtifactSourceFragment(UpdateResource):
    """Properties of an artifact source.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param display_name: The artifact source's display name.
    :type display_name: str
    :param uri: The artifact source's URI.
    :type uri: str
    :param source_type: The artifact source's type. Possible values include:
     'VsoGit', 'GitHub'
    :type source_type: str or ~azure.mgmt.devtestlabs.models.SourceControlType
    :param folder_path: The folder containing artifacts.
    :type folder_path: str
    :param arm_template_folder_path: The folder containing Azure Resource
     Manager templates.
    :type arm_template_folder_path: str
    :param branch_ref: The artifact source's branch reference.
    :type branch_ref: str
    :param security_token: The security token to authenticate to the artifact
     source.
    :type security_token: str
    :param status: Indicates if the artifact source is enabled (values:
     Enabled, Disabled). Possible values include: 'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'arm_template_folder_path': {'key': 'properties.armTemplateFolderPath', 'type': 'str'},
        'branch_ref': {'key': 'properties.branchRef', 'type': 'str'},
        'security_token': {'key': 'properties.securityToken', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ArtifactSourceFragment, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.uri = kwargs.get('uri', None)
        self.source_type = kwargs.get('source_type', None)
        self.folder_path = kwargs.get('folder_path', None)
        self.arm_template_folder_path = kwargs.get('arm_template_folder_path', None)
        self.branch_ref = kwargs.get('branch_ref', None)
        self.security_token = kwargs.get('security_token', None)
        self.status = kwargs.get('status', None)


class AttachDiskProperties(Model):
    """Properties of the disk to attach.

    :param leased_by_lab_vm_id: The resource ID of the Lab virtual machine to
     which the disk is attached.
    :type leased_by_lab_vm_id: str
    """

    _attribute_map = {
        'leased_by_lab_vm_id': {'key': 'leasedByLabVmId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AttachDiskProperties, self).__init__(**kwargs)
        self.leased_by_lab_vm_id = kwargs.get('leased_by_lab_vm_id', None)


class AttachNewDataDiskOptions(Model):
    """Properties to attach new disk to the Virtual Machine.

    :param disk_size_gi_b: Size of the disk to be attached in GibiBytes.
    :type disk_size_gi_b: int
    :param disk_name: The name of the disk to be attached.
    :type disk_name: str
    :param disk_type: The storage type for the disk (i.e. Standard, Premium).
     Possible values include: 'Standard', 'Premium', 'StandardSSD'
    :type disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        'disk_size_gi_b': {'key': 'diskSizeGiB', 'type': 'int'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AttachNewDataDiskOptions, self).__init__(**kwargs)
        self.disk_size_gi_b = kwargs.get('disk_size_gi_b', None)
        self.disk_name = kwargs.get('disk_name', None)
        self.disk_type = kwargs.get('disk_type', None)


class AttachNewDataDiskOptionsFragment(Model):
    """Properties to attach new disk to the Virtual Machine.

    :param disk_size_gi_b: Size of the disk to be attached in GibiBytes.
    :type disk_size_gi_b: int
    :param disk_name: The name of the disk to be attached.
    :type disk_name: str
    :param disk_type: The storage type for the disk (i.e. Standard, Premium).
     Possible values include: 'Standard', 'Premium', 'StandardSSD'
    :type disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        'disk_size_gi_b': {'key': 'diskSizeGiB', 'type': 'int'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AttachNewDataDiskOptionsFragment, self).__init__(**kwargs)
        self.disk_size_gi_b = kwargs.get('disk_size_gi_b', None)
        self.disk_name = kwargs.get('disk_name', None)
        self.disk_type = kwargs.get('disk_type', None)


class BulkCreationParameters(Model):
    """Parameters for creating multiple virtual machines as a single action.

    :param instance_count: The number of virtual machine instances to create.
    :type instance_count: int
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BulkCreationParameters, self).__init__(**kwargs)
        self.instance_count = kwargs.get('instance_count', None)


class BulkCreationParametersFragment(Model):
    """Parameters for creating multiple virtual machines as a single action.

    :param instance_count: The number of virtual machine instances to create.
    :type instance_count: int
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BulkCreationParametersFragment, self).__init__(**kwargs)
        self.instance_count = kwargs.get('instance_count', None)


class CloudError(Model):
    """Error from a REST request.

    :param error: The cloud error that occurred
    :type error: ~azure.mgmt.devtestlabs.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, **kwargs):
        super(CloudError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """Body of an error from a REST request.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    :param target: The error target.
    :type target: str
    :param details: Inner errors.
    :type details: list[~azure.mgmt.devtestlabs.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, **kwargs):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class ComputeDataDisk(Model):
    """A data disks attached to a virtual machine.

    :param name: Gets data disk name.
    :type name: str
    :param disk_uri: When backed by a blob, the URI of underlying blob.
    :type disk_uri: str
    :param managed_disk_id: When backed by managed disk, this is the ID of the
     compute disk resource.
    :type managed_disk_id: str
    :param disk_size_gi_b: Gets data disk size in GiB.
    :type disk_size_gi_b: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'disk_uri': {'key': 'diskUri', 'type': 'str'},
        'managed_disk_id': {'key': 'managedDiskId', 'type': 'str'},
        'disk_size_gi_b': {'key': 'diskSizeGiB', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ComputeDataDisk, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.disk_uri = kwargs.get('disk_uri', None)
        self.managed_disk_id = kwargs.get('managed_disk_id', None)
        self.disk_size_gi_b = kwargs.get('disk_size_gi_b', None)


class ComputeDataDiskFragment(Model):
    """A data disks attached to a virtual machine.

    :param name: Gets data disk name.
    :type name: str
    :param disk_uri: When backed by a blob, the URI of underlying blob.
    :type disk_uri: str
    :param managed_disk_id: When backed by managed disk, this is the ID of the
     compute disk resource.
    :type managed_disk_id: str
    :param disk_size_gi_b: Gets data disk size in GiB.
    :type disk_size_gi_b: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'disk_uri': {'key': 'diskUri', 'type': 'str'},
        'managed_disk_id': {'key': 'managedDiskId', 'type': 'str'},
        'disk_size_gi_b': {'key': 'diskSizeGiB', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ComputeDataDiskFragment, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.disk_uri = kwargs.get('disk_uri', None)
        self.managed_disk_id = kwargs.get('managed_disk_id', None)
        self.disk_size_gi_b = kwargs.get('disk_size_gi_b', None)


class ComputeVmInstanceViewStatus(Model):
    """Status information about a virtual machine.

    :param code: Gets the status Code.
    :type code: str
    :param display_status: Gets the short localizable label for the status.
    :type display_status: str
    :param message: Gets the message associated with the status.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ComputeVmInstanceViewStatus, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.display_status = kwargs.get('display_status', None)
        self.message = kwargs.get('message', None)


class ComputeVmInstanceViewStatusFragment(Model):
    """Status information about a virtual machine.

    :param code: Gets the status Code.
    :type code: str
    :param display_status: Gets the short localizable label for the status.
    :type display_status: str
    :param message: Gets the message associated with the status.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ComputeVmInstanceViewStatusFragment, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.display_status = kwargs.get('display_status', None)
        self.message = kwargs.get('message', None)


class ComputeVmProperties(Model):
    """Properties of a virtual machine returned by the Microsoft.Compute API.

    :param statuses: Gets the statuses of the virtual machine.
    :type statuses:
     list[~azure.mgmt.devtestlabs.models.ComputeVmInstanceViewStatus]
    :param os_type: Gets the OS type of the virtual machine.
    :type os_type: str
    :param vm_size: Gets the size of the virtual machine.
    :type vm_size: str
    :param network_interface_id: Gets the network interface ID of the virtual
     machine.
    :type network_interface_id: str
    :param os_disk_id: Gets OS disk blob uri for the virtual machine.
    :type os_disk_id: str
    :param data_disk_ids: Gets data disks blob uri for the virtual machine.
    :type data_disk_ids: list[str]
    :param data_disks: Gets all data disks attached to the virtual machine.
    :type data_disks: list[~azure.mgmt.devtestlabs.models.ComputeDataDisk]
    """

    _attribute_map = {
        'statuses': {'key': 'statuses', 'type': '[ComputeVmInstanceViewStatus]'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'network_interface_id': {'key': 'networkInterfaceId', 'type': 'str'},
        'os_disk_id': {'key': 'osDiskId', 'type': 'str'},
        'data_disk_ids': {'key': 'dataDiskIds', 'type': '[str]'},
        'data_disks': {'key': 'dataDisks', 'type': '[ComputeDataDisk]'},
    }

    def __init__(self, **kwargs):
        super(ComputeVmProperties, self).__init__(**kwargs)
        self.statuses = kwargs.get('statuses', None)
        self.os_type = kwargs.get('os_type', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.network_interface_id = kwargs.get('network_interface_id', None)
        self.os_disk_id = kwargs.get('os_disk_id', None)
        self.data_disk_ids = kwargs.get('data_disk_ids', None)
        self.data_disks = kwargs.get('data_disks', None)


class ComputeVmPropertiesFragment(Model):
    """Properties of a virtual machine returned by the Microsoft.Compute API.

    :param statuses: Gets the statuses of the virtual machine.
    :type statuses:
     list[~azure.mgmt.devtestlabs.models.ComputeVmInstanceViewStatusFragment]
    :param os_type: Gets the OS type of the virtual machine.
    :type os_type: str
    :param vm_size: Gets the size of the virtual machine.
    :type vm_size: str
    :param network_interface_id: Gets the network interface ID of the virtual
     machine.
    :type network_interface_id: str
    :param os_disk_id: Gets OS disk blob uri for the virtual machine.
    :type os_disk_id: str
    :param data_disk_ids: Gets data disks blob uri for the virtual machine.
    :type data_disk_ids: list[str]
    :param data_disks: Gets all data disks attached to the virtual machine.
    :type data_disks:
     list[~azure.mgmt.devtestlabs.models.ComputeDataDiskFragment]
    """

    _attribute_map = {
        'statuses': {'key': 'statuses', 'type': '[ComputeVmInstanceViewStatusFragment]'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'network_interface_id': {'key': 'networkInterfaceId', 'type': 'str'},
        'os_disk_id': {'key': 'osDiskId', 'type': 'str'},
        'data_disk_ids': {'key': 'dataDiskIds', 'type': '[str]'},
        'data_disks': {'key': 'dataDisks', 'type': '[ComputeDataDiskFragment]'},
    }

    def __init__(self, **kwargs):
        super(ComputeVmPropertiesFragment, self).__init__(**kwargs)
        self.statuses = kwargs.get('statuses', None)
        self.os_type = kwargs.get('os_type', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.network_interface_id = kwargs.get('network_interface_id', None)
        self.os_disk_id = kwargs.get('os_disk_id', None)
        self.data_disk_ids = kwargs.get('data_disk_ids', None)
        self.data_disks = kwargs.get('data_disks', None)


class CostThresholdProperties(Model):
    """Properties of a cost threshold item.

    :param threshold_id: The ID of the cost threshold item.
    :type threshold_id: str
    :param percentage_threshold: The value of the percentage cost threshold.
    :type percentage_threshold:
     ~azure.mgmt.devtestlabs.models.PercentageCostThresholdProperties
    :param display_on_chart: Indicates whether this threshold will be
     displayed on cost charts. Possible values include: 'Enabled', 'Disabled'
    :type display_on_chart: str or
     ~azure.mgmt.devtestlabs.models.CostThresholdStatus
    :param send_notification_when_exceeded: Indicates whether notifications
     will be sent when this threshold is exceeded. Possible values include:
     'Enabled', 'Disabled'
    :type send_notification_when_exceeded: str or
     ~azure.mgmt.devtestlabs.models.CostThresholdStatus
    :param notification_sent: Indicates the datetime when notifications were
     last sent for this threshold.
    :type notification_sent: str
    """

    _attribute_map = {
        'threshold_id': {'key': 'thresholdId', 'type': 'str'},
        'percentage_threshold': {'key': 'percentageThreshold', 'type': 'PercentageCostThresholdProperties'},
        'display_on_chart': {'key': 'displayOnChart', 'type': 'str'},
        'send_notification_when_exceeded': {'key': 'sendNotificationWhenExceeded', 'type': 'str'},
        'notification_sent': {'key': 'notificationSent', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CostThresholdProperties, self).__init__(**kwargs)
        self.threshold_id = kwargs.get('threshold_id', None)
        self.percentage_threshold = kwargs.get('percentage_threshold', None)
        self.display_on_chart = kwargs.get('display_on_chart', None)
        self.send_notification_when_exceeded = kwargs.get('send_notification_when_exceeded', None)
        self.notification_sent = kwargs.get('notification_sent', None)


class CustomImage(Resource):
    """A custom image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param vm: The virtual machine from which the image is to be created.
    :type vm: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromVm
    :param vhd: The VHD from which the image is to be created.
    :type vhd: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesCustom
    :param description: The description of the custom image.
    :type description: str
    :param author: The author of the custom image.
    :type author: str
    :ivar creation_date: The creation date of the custom image.
    :vartype creation_date: datetime
    :param managed_image_id: The Managed Image Id backing the custom image.
    :type managed_image_id: str
    :param managed_snapshot_id: The Managed Snapshot Id backing the custom
     image.
    :type managed_snapshot_id: str
    :param data_disk_storage_info: Storage information about the data disks
     present in the custom image
    :type data_disk_storage_info:
     list[~azure.mgmt.devtestlabs.models.DataDiskStorageTypeInfo]
    :param custom_image_plan: Storage information about the plan related to
     this custom image
    :type custom_image_plan:
     ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromPlan
    :param is_plan_authorized: Whether or not the custom images underlying
     offer/plan has been enabled for programmatic deployment
    :type is_plan_authorized: bool
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'vm': {'key': 'properties.vm', 'type': 'CustomImagePropertiesFromVm'},
        'vhd': {'key': 'properties.vhd', 'type': 'CustomImagePropertiesCustom'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'managed_image_id': {'key': 'properties.managedImageId', 'type': 'str'},
        'managed_snapshot_id': {'key': 'properties.managedSnapshotId', 'type': 'str'},
        'data_disk_storage_info': {'key': 'properties.dataDiskStorageInfo', 'type': '[DataDiskStorageTypeInfo]'},
        'custom_image_plan': {'key': 'properties.customImagePlan', 'type': 'CustomImagePropertiesFromPlan'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CustomImage, self).__init__(**kwargs)
        self.vm = kwargs.get('vm', None)
        self.vhd = kwargs.get('vhd', None)
        self.description = kwargs.get('description', None)
        self.author = kwargs.get('author', None)
        self.creation_date = None
        self.managed_image_id = kwargs.get('managed_image_id', None)
        self.managed_snapshot_id = kwargs.get('managed_snapshot_id', None)
        self.data_disk_storage_info = kwargs.get('data_disk_storage_info', None)
        self.custom_image_plan = kwargs.get('custom_image_plan', None)
        self.is_plan_authorized = kwargs.get('is_plan_authorized', None)
        self.provisioning_state = None
        self.unique_identifier = None


class CustomImageFragment(UpdateResource):
    """A custom image.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param vm: The virtual machine from which the image is to be created.
    :type vm:
     ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromVmFragment
    :param vhd: The VHD from which the image is to be created.
    :type vhd:
     ~azure.mgmt.devtestlabs.models.CustomImagePropertiesCustomFragment
    :param description: The description of the custom image.
    :type description: str
    :param author: The author of the custom image.
    :type author: str
    :param managed_image_id: The Managed Image Id backing the custom image.
    :type managed_image_id: str
    :param managed_snapshot_id: The Managed Snapshot Id backing the custom
     image.
    :type managed_snapshot_id: str
    :param data_disk_storage_info: Storage information about the data disks
     present in the custom image
    :type data_disk_storage_info:
     list[~azure.mgmt.devtestlabs.models.DataDiskStorageTypeInfoFragment]
    :param custom_image_plan: Storage information about the plan related to
     this custom image
    :type custom_image_plan:
     ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromPlanFragment
    :param is_plan_authorized: Whether or not the custom images underlying
     offer/plan has been enabled for programmatic deployment
    :type is_plan_authorized: bool
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'vm': {'key': 'properties.vm', 'type': 'CustomImagePropertiesFromVmFragment'},
        'vhd': {'key': 'properties.vhd', 'type': 'CustomImagePropertiesCustomFragment'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'managed_image_id': {'key': 'properties.managedImageId', 'type': 'str'},
        'managed_snapshot_id': {'key': 'properties.managedSnapshotId', 'type': 'str'},
        'data_disk_storage_info': {'key': 'properties.dataDiskStorageInfo', 'type': '[DataDiskStorageTypeInfoFragment]'},
        'custom_image_plan': {'key': 'properties.customImagePlan', 'type': 'CustomImagePropertiesFromPlanFragment'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(CustomImageFragment, self).__init__(**kwargs)
        self.vm = kwargs.get('vm', None)
        self.vhd = kwargs.get('vhd', None)
        self.description = kwargs.get('description', None)
        self.author = kwargs.get('author', None)
        self.managed_image_id = kwargs.get('managed_image_id', None)
        self.managed_snapshot_id = kwargs.get('managed_snapshot_id', None)
        self.data_disk_storage_info = kwargs.get('data_disk_storage_info', None)
        self.custom_image_plan = kwargs.get('custom_image_plan', None)
        self.is_plan_authorized = kwargs.get('is_plan_authorized', None)


class CustomImagePropertiesCustom(Model):
    """Properties for creating a custom image from a VHD.

    All required parameters must be populated in order to send to Azure.

    :param image_name: The image name.
    :type image_name: str
    :param sys_prep: Indicates whether sysprep has been run on the VHD.
    :type sys_prep: bool
    :param os_type: Required. The OS type of the custom image (i.e. Windows,
     Linux). Possible values include: 'Windows', 'Linux', 'None'
    :type os_type: str or ~azure.mgmt.devtestlabs.models.CustomImageOsType
    """

    _validation = {
        'os_type': {'required': True},
    }

    _attribute_map = {
        'image_name': {'key': 'imageName', 'type': 'str'},
        'sys_prep': {'key': 'sysPrep', 'type': 'bool'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CustomImagePropertiesCustom, self).__init__(**kwargs)
        self.image_name = kwargs.get('image_name', None)
        self.sys_prep = kwargs.get('sys_prep', None)
        self.os_type = kwargs.get('os_type', None)


class CustomImagePropertiesCustomFragment(Model):
    """Properties for creating a custom image from a VHD.

    :param image_name: The image name.
    :type image_name: str
    :param sys_prep: Indicates whether sysprep has been run on the VHD.
    :type sys_prep: bool
    :param os_type: The OS type of the custom image (i.e. Windows, Linux).
     Possible values include: 'Windows', 'Linux', 'None'
    :type os_type: str or ~azure.mgmt.devtestlabs.models.CustomImageOsType
    """

    _attribute_map = {
        'image_name': {'key': 'imageName', 'type': 'str'},
        'sys_prep': {'key': 'sysPrep', 'type': 'bool'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CustomImagePropertiesCustomFragment, self).__init__(**kwargs)
        self.image_name = kwargs.get('image_name', None)
        self.sys_prep = kwargs.get('sys_prep', None)
        self.os_type = kwargs.get('os_type', None)


class CustomImagePropertiesFromPlan(Model):
    """Properties for plan on a custom image.

    :param id: The id of the plan, equivalent to name of the plan
    :type id: str
    :param publisher: The publisher for the plan from the marketplace image
     the custom image is derived from
    :type publisher: str
    :param offer: The offer for the plan from the marketplace image the custom
     image is derived from
    :type offer: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CustomImagePropertiesFromPlan, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.publisher = kwargs.get('publisher', None)
        self.offer = kwargs.get('offer', None)


class CustomImagePropertiesFromPlanFragment(Model):
    """Properties for plan on a custom image.

    :param id: The id of the plan, equivalent to name of the plan
    :type id: str
    :param publisher: The publisher for the plan from the marketplace image
     the custom image is derived from
    :type publisher: str
    :param offer: The offer for the plan from the marketplace image the custom
     image is derived from
    :type offer: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CustomImagePropertiesFromPlanFragment, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.publisher = kwargs.get('publisher', None)
        self.offer = kwargs.get('offer', None)


class CustomImagePropertiesFromVm(Model):
    """Properties for creating a custom image from a virtual machine.

    :param source_vm_id: The source vm identifier.
    :type source_vm_id: str
    :param windows_os_info: The Windows OS information of the VM.
    :type windows_os_info: ~azure.mgmt.devtestlabs.models.WindowsOsInfo
    :param linux_os_info: The Linux OS information of the VM.
    :type linux_os_info: ~azure.mgmt.devtestlabs.models.LinuxOsInfo
    """

    _attribute_map = {
        'source_vm_id': {'key': 'sourceVmId', 'type': 'str'},
        'windows_os_info': {'key': 'windowsOsInfo', 'type': 'WindowsOsInfo'},
        'linux_os_info': {'key': 'linuxOsInfo', 'type': 'LinuxOsInfo'},
    }

    def __init__(self, **kwargs):
        super(CustomImagePropertiesFromVm, self).__init__(**kwargs)
        self.source_vm_id = kwargs.get('source_vm_id', None)
        self.windows_os_info = kwargs.get('windows_os_info', None)
        self.linux_os_info = kwargs.get('linux_os_info', None)


class CustomImagePropertiesFromVmFragment(Model):
    """Properties for creating a custom image from a virtual machine.

    :param source_vm_id: The source vm identifier.
    :type source_vm_id: str
    :param windows_os_info: The Windows OS information of the VM.
    :type windows_os_info:
     ~azure.mgmt.devtestlabs.models.WindowsOsInfoFragment
    :param linux_os_info: The Linux OS information of the VM.
    :type linux_os_info: ~azure.mgmt.devtestlabs.models.LinuxOsInfoFragment
    """

    _attribute_map = {
        'source_vm_id': {'key': 'sourceVmId', 'type': 'str'},
        'windows_os_info': {'key': 'windowsOsInfo', 'type': 'WindowsOsInfoFragment'},
        'linux_os_info': {'key': 'linuxOsInfo', 'type': 'LinuxOsInfoFragment'},
    }

    def __init__(self, **kwargs):
        super(CustomImagePropertiesFromVmFragment, self).__init__(**kwargs)
        self.source_vm_id = kwargs.get('source_vm_id', None)
        self.windows_os_info = kwargs.get('windows_os_info', None)
        self.linux_os_info = kwargs.get('linux_os_info', None)


class DataDiskProperties(Model):
    """Request body for adding a new or existing data disk to a virtual machine.

    :param attach_new_data_disk_options: Specifies options to attach a new
     disk to the virtual machine.
    :type attach_new_data_disk_options:
     ~azure.mgmt.devtestlabs.models.AttachNewDataDiskOptions
    :param existing_lab_disk_id: Specifies the existing lab disk id to attach
     to virtual machine.
    :type existing_lab_disk_id: str
    :param host_caching: Caching option for a data disk (i.e. None, ReadOnly,
     ReadWrite). Possible values include: 'None', 'ReadOnly', 'ReadWrite'
    :type host_caching: str or
     ~azure.mgmt.devtestlabs.models.HostCachingOptions
    """

    _attribute_map = {
        'attach_new_data_disk_options': {'key': 'attachNewDataDiskOptions', 'type': 'AttachNewDataDiskOptions'},
        'existing_lab_disk_id': {'key': 'existingLabDiskId', 'type': 'str'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataDiskProperties, self).__init__(**kwargs)
        self.attach_new_data_disk_options = kwargs.get('attach_new_data_disk_options', None)
        self.existing_lab_disk_id = kwargs.get('existing_lab_disk_id', None)
        self.host_caching = kwargs.get('host_caching', None)


class DataDiskPropertiesFragment(Model):
    """Request body for adding a new or existing data disk to a virtual machine.

    :param attach_new_data_disk_options: Specifies options to attach a new
     disk to the virtual machine.
    :type attach_new_data_disk_options:
     ~azure.mgmt.devtestlabs.models.AttachNewDataDiskOptionsFragment
    :param existing_lab_disk_id: Specifies the existing lab disk id to attach
     to virtual machine.
    :type existing_lab_disk_id: str
    :param host_caching: Caching option for a data disk (i.e. None, ReadOnly,
     ReadWrite). Possible values include: 'None', 'ReadOnly', 'ReadWrite'
    :type host_caching: str or
     ~azure.mgmt.devtestlabs.models.HostCachingOptions
    """

    _attribute_map = {
        'attach_new_data_disk_options': {'key': 'attachNewDataDiskOptions', 'type': 'AttachNewDataDiskOptionsFragment'},
        'existing_lab_disk_id': {'key': 'existingLabDiskId', 'type': 'str'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataDiskPropertiesFragment, self).__init__(**kwargs)
        self.attach_new_data_disk_options = kwargs.get('attach_new_data_disk_options', None)
        self.existing_lab_disk_id = kwargs.get('existing_lab_disk_id', None)
        self.host_caching = kwargs.get('host_caching', None)


class DataDiskStorageTypeInfo(Model):
    """Storage information about the data disks present in the custom image.

    :param lun: Disk Lun
    :type lun: str
    :param storage_type: Disk Storage Type. Possible values include:
     'Standard', 'Premium', 'StandardSSD'
    :type storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'str'},
        'storage_type': {'key': 'storageType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataDiskStorageTypeInfo, self).__init__(**kwargs)
        self.lun = kwargs.get('lun', None)
        self.storage_type = kwargs.get('storage_type', None)


class DataDiskStorageTypeInfoFragment(Model):
    """Storage information about the data disks present in the custom image.

    :param lun: Disk Lun
    :type lun: str
    :param storage_type: Disk Storage Type. Possible values include:
     'Standard', 'Premium', 'StandardSSD'
    :type storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'str'},
        'storage_type': {'key': 'storageType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataDiskStorageTypeInfoFragment, self).__init__(**kwargs)
        self.lun = kwargs.get('lun', None)
        self.storage_type = kwargs.get('storage_type', None)


class DayDetails(Model):
    """Properties of a daily schedule.

    :param time: The time of day the schedule will occur.
    :type time: str
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DayDetails, self).__init__(**kwargs)
        self.time = kwargs.get('time', None)


class DayDetailsFragment(Model):
    """Properties of a daily schedule.

    :param time: The time of day the schedule will occur.
    :type time: str
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DayDetailsFragment, self).__init__(**kwargs)
        self.time = kwargs.get('time', None)


class DetachDataDiskProperties(Model):
    """Request body for detaching data disk from a virtual machine.

    :param existing_lab_disk_id: Specifies the disk resource ID to detach from
     virtual machine.
    :type existing_lab_disk_id: str
    """

    _attribute_map = {
        'existing_lab_disk_id': {'key': 'existingLabDiskId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DetachDataDiskProperties, self).__init__(**kwargs)
        self.existing_lab_disk_id = kwargs.get('existing_lab_disk_id', None)


class DetachDiskProperties(Model):
    """Properties of the disk to detach.

    :param leased_by_lab_vm_id: The resource ID of the Lab VM to which the
     disk is attached.
    :type leased_by_lab_vm_id: str
    """

    _attribute_map = {
        'leased_by_lab_vm_id': {'key': 'leasedByLabVmId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DetachDiskProperties, self).__init__(**kwargs)
        self.leased_by_lab_vm_id = kwargs.get('leased_by_lab_vm_id', None)


class Disk(Resource):
    """A Disk.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param disk_type: The storage type for the disk (i.e. Standard, Premium).
     Possible values include: 'Standard', 'Premium', 'StandardSSD'
    :type disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :param disk_size_gi_b: The size of the disk in GibiBytes.
    :type disk_size_gi_b: int
    :param leased_by_lab_vm_id: The resource ID of the VM to which this disk
     is leased.
    :type leased_by_lab_vm_id: str
    :param disk_blob_name: When backed by a blob, the name of the VHD blob
     without extension.
    :type disk_blob_name: str
    :param disk_uri: When backed by a blob, the URI of underlying blob.
    :type disk_uri: str
    :ivar created_date: The creation date of the disk.
    :vartype created_date: datetime
    :param host_caching: The host caching policy of the disk (i.e. None,
     ReadOnly, ReadWrite).
    :type host_caching: str
    :param managed_disk_id: When backed by managed disk, this is the ID of the
     compute disk resource.
    :type managed_disk_id: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'disk_type': {'key': 'properties.diskType', 'type': 'str'},
        'disk_size_gi_b': {'key': 'properties.diskSizeGiB', 'type': 'int'},
        'leased_by_lab_vm_id': {'key': 'properties.leasedByLabVmId', 'type': 'str'},
        'disk_blob_name': {'key': 'properties.diskBlobName', 'type': 'str'},
        'disk_uri': {'key': 'properties.diskUri', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'host_caching': {'key': 'properties.hostCaching', 'type': 'str'},
        'managed_disk_id': {'key': 'properties.managedDiskId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Disk, self).__init__(**kwargs)
        self.disk_type = kwargs.get('disk_type', None)
        self.disk_size_gi_b = kwargs.get('disk_size_gi_b', None)
        self.leased_by_lab_vm_id = kwargs.get('leased_by_lab_vm_id', None)
        self.disk_blob_name = kwargs.get('disk_blob_name', None)
        self.disk_uri = kwargs.get('disk_uri', None)
        self.created_date = None
        self.host_caching = kwargs.get('host_caching', None)
        self.managed_disk_id = kwargs.get('managed_disk_id', None)
        self.provisioning_state = None
        self.unique_identifier = None


class DiskFragment(UpdateResource):
    """A Disk.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param disk_type: The storage type for the disk (i.e. Standard, Premium).
     Possible values include: 'Standard', 'Premium', 'StandardSSD'
    :type disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :param disk_size_gi_b: The size of the disk in GibiBytes.
    :type disk_size_gi_b: int
    :param leased_by_lab_vm_id: The resource ID of the VM to which this disk
     is leased.
    :type leased_by_lab_vm_id: str
    :param disk_blob_name: When backed by a blob, the name of the VHD blob
     without extension.
    :type disk_blob_name: str
    :param disk_uri: When backed by a blob, the URI of underlying blob.
    :type disk_uri: str
    :param host_caching: The host caching policy of the disk (i.e. None,
     ReadOnly, ReadWrite).
    :type host_caching: str
    :param managed_disk_id: When backed by managed disk, this is the ID of the
     compute disk resource.
    :type managed_disk_id: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'disk_type': {'key': 'properties.diskType', 'type': 'str'},
        'disk_size_gi_b': {'key': 'properties.diskSizeGiB', 'type': 'int'},
        'leased_by_lab_vm_id': {'key': 'properties.leasedByLabVmId', 'type': 'str'},
        'disk_blob_name': {'key': 'properties.diskBlobName', 'type': 'str'},
        'disk_uri': {'key': 'properties.diskUri', 'type': 'str'},
        'host_caching': {'key': 'properties.hostCaching', 'type': 'str'},
        'managed_disk_id': {'key': 'properties.managedDiskId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DiskFragment, self).__init__(**kwargs)
        self.disk_type = kwargs.get('disk_type', None)
        self.disk_size_gi_b = kwargs.get('disk_size_gi_b', None)
        self.leased_by_lab_vm_id = kwargs.get('leased_by_lab_vm_id', None)
        self.disk_blob_name = kwargs.get('disk_blob_name', None)
        self.disk_uri = kwargs.get('disk_uri', None)
        self.host_caching = kwargs.get('host_caching', None)
        self.managed_disk_id = kwargs.get('managed_disk_id', None)


class DtlEnvironment(Resource):
    """An environment, which is essentially an ARM template deployment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param deployment_properties: The deployment properties of the
     environment.
    :type deployment_properties:
     ~azure.mgmt.devtestlabs.models.EnvironmentDeploymentProperties
    :param arm_template_display_name: The display name of the Azure Resource
     Manager template that produced the environment.
    :type arm_template_display_name: str
    :ivar resource_group_id: The identifier of the resource group containing
     the environment's resources.
    :vartype resource_group_id: str
    :ivar created_by_user: The creator of the environment.
    :vartype created_by_user: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_group_id': {'readonly': True},
        'created_by_user': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'deployment_properties': {'key': 'properties.deploymentProperties', 'type': 'EnvironmentDeploymentProperties'},
        'arm_template_display_name': {'key': 'properties.armTemplateDisplayName', 'type': 'str'},
        'resource_group_id': {'key': 'properties.resourceGroupId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DtlEnvironment, self).__init__(**kwargs)
        self.deployment_properties = kwargs.get('deployment_properties', None)
        self.arm_template_display_name = kwargs.get('arm_template_display_name', None)
        self.resource_group_id = None
        self.created_by_user = None
        self.provisioning_state = None
        self.unique_identifier = None


class DtlEnvironmentFragment(UpdateResource):
    """An environment, which is essentially an ARM template deployment.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param deployment_properties: The deployment properties of the
     environment.
    :type deployment_properties:
     ~azure.mgmt.devtestlabs.models.EnvironmentDeploymentPropertiesFragment
    :param arm_template_display_name: The display name of the Azure Resource
     Manager template that produced the environment.
    :type arm_template_display_name: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'deployment_properties': {'key': 'properties.deploymentProperties', 'type': 'EnvironmentDeploymentPropertiesFragment'},
        'arm_template_display_name': {'key': 'properties.armTemplateDisplayName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DtlEnvironmentFragment, self).__init__(**kwargs)
        self.deployment_properties = kwargs.get('deployment_properties', None)
        self.arm_template_display_name = kwargs.get('arm_template_display_name', None)


class EnvironmentDeploymentProperties(Model):
    """Properties of an environment deployment.

    :param arm_template_id: The Azure Resource Manager template's identifier.
    :type arm_template_id: str
    :param parameters: The parameters of the Azure Resource Manager template.
    :type parameters:
     list[~azure.mgmt.devtestlabs.models.ArmTemplateParameterProperties]
    """

    _attribute_map = {
        'arm_template_id': {'key': 'armTemplateId', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ArmTemplateParameterProperties]'},
    }

    def __init__(self, **kwargs):
        super(EnvironmentDeploymentProperties, self).__init__(**kwargs)
        self.arm_template_id = kwargs.get('arm_template_id', None)
        self.parameters = kwargs.get('parameters', None)


class EnvironmentDeploymentPropertiesFragment(Model):
    """Properties of an environment deployment.

    :param arm_template_id: The Azure Resource Manager template's identifier.
    :type arm_template_id: str
    :param parameters: The parameters of the Azure Resource Manager template.
    :type parameters:
     list[~azure.mgmt.devtestlabs.models.ArmTemplateParameterPropertiesFragment]
    """

    _attribute_map = {
        'arm_template_id': {'key': 'armTemplateId', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ArmTemplateParameterPropertiesFragment]'},
    }

    def __init__(self, **kwargs):
        super(EnvironmentDeploymentPropertiesFragment, self).__init__(**kwargs)
        self.arm_template_id = kwargs.get('arm_template_id', None)
        self.parameters = kwargs.get('parameters', None)


class EvaluatePoliciesProperties(Model):
    """Properties for evaluating a policy set.

    :param fact_name: The fact name.
    :type fact_name: str
    :param fact_data: The fact data.
    :type fact_data: str
    :param value_offset: The value offset.
    :type value_offset: str
    :param user_object_id: The user for which policies will be evaluated
    :type user_object_id: str
    """

    _attribute_map = {
        'fact_name': {'key': 'factName', 'type': 'str'},
        'fact_data': {'key': 'factData', 'type': 'str'},
        'value_offset': {'key': 'valueOffset', 'type': 'str'},
        'user_object_id': {'key': 'userObjectId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EvaluatePoliciesProperties, self).__init__(**kwargs)
        self.fact_name = kwargs.get('fact_name', None)
        self.fact_data = kwargs.get('fact_data', None)
        self.value_offset = kwargs.get('value_offset', None)
        self.user_object_id = kwargs.get('user_object_id', None)


class EvaluatePoliciesRequest(Model):
    """Request body for evaluating a policy set.

    :param policies: Policies to evaluate.
    :type policies:
     list[~azure.mgmt.devtestlabs.models.EvaluatePoliciesProperties]
    """

    _attribute_map = {
        'policies': {'key': 'policies', 'type': '[EvaluatePoliciesProperties]'},
    }

    def __init__(self, **kwargs):
        super(EvaluatePoliciesRequest, self).__init__(**kwargs)
        self.policies = kwargs.get('policies', None)


class EvaluatePoliciesResponse(Model):
    """Response body for evaluating a policy set.

    :param results: Results of evaluating a policy set.
    :type results: list[~azure.mgmt.devtestlabs.models.PolicySetResult]
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': '[PolicySetResult]'},
    }

    def __init__(self, **kwargs):
        super(EvaluatePoliciesResponse, self).__init__(**kwargs)
        self.results = kwargs.get('results', None)


class Event(Model):
    """An event to be notified for.

    :param event_name: The event type for which this notification is enabled
     (i.e. AutoShutdown, Cost). Possible values include: 'AutoShutdown', 'Cost'
    :type event_name: str or
     ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
    """

    _attribute_map = {
        'event_name': {'key': 'eventName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Event, self).__init__(**kwargs)
        self.event_name = kwargs.get('event_name', None)


class EventFragment(Model):
    """An event to be notified for.

    :param event_name: The event type for which this notification is enabled
     (i.e. AutoShutdown, Cost). Possible values include: 'AutoShutdown', 'Cost'
    :type event_name: str or
     ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
    """

    _attribute_map = {
        'event_name': {'key': 'eventName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EventFragment, self).__init__(**kwargs)
        self.event_name = kwargs.get('event_name', None)


class ExportResourceUsageParameters(Model):
    """The parameters of the export operation.

    :param blob_storage_absolute_sas_uri: The blob storage absolute sas uri
     with write permission to the container which the usage data needs to be
     uploaded to.
    :type blob_storage_absolute_sas_uri: str
    :param usage_start_date: The start time of the usage. If not provided,
     usage will be reported since the beginning of data collection.
    :type usage_start_date: datetime
    """

    _attribute_map = {
        'blob_storage_absolute_sas_uri': {'key': 'blobStorageAbsoluteSasUri', 'type': 'str'},
        'usage_start_date': {'key': 'usageStartDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ExportResourceUsageParameters, self).__init__(**kwargs)
        self.blob_storage_absolute_sas_uri = kwargs.get('blob_storage_absolute_sas_uri', None)
        self.usage_start_date = kwargs.get('usage_start_date', None)


class ExternalSubnet(Model):
    """Subnet information as returned by the Microsoft.Network API.

    :param id: Gets or sets the identifier.
    :type id: str
    :param name: Gets or sets the name.
    :type name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExternalSubnet, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)


class ExternalSubnetFragment(Model):
    """Subnet information as returned by the Microsoft.Network API.

    :param id: Gets or sets the identifier.
    :type id: str
    :param name: Gets or sets the name.
    :type name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExternalSubnetFragment, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)


class Formula(Resource):
    """A formula for creating a VM, specifying an image base and other parameters.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param description: The description of the formula.
    :type description: str
    :param author: The author of the formula.
    :type author: str
    :param os_type: The OS type of the formula.
    :type os_type: str
    :ivar creation_date: The creation date of the formula.
    :vartype creation_date: datetime
    :param formula_content: The content of the formula.
    :type formula_content:
     ~azure.mgmt.devtestlabs.models.LabVirtualMachineCreationParameter
    :param vm: Information about a VM from which a formula is to be created.
    :type vm: ~azure.mgmt.devtestlabs.models.FormulaPropertiesFromVm
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'formula_content': {'key': 'properties.formulaContent', 'type': 'LabVirtualMachineCreationParameter'},
        'vm': {'key': 'properties.vm', 'type': 'FormulaPropertiesFromVm'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Formula, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.author = kwargs.get('author', None)
        self.os_type = kwargs.get('os_type', None)
        self.creation_date = None
        self.formula_content = kwargs.get('formula_content', None)
        self.vm = kwargs.get('vm', None)
        self.provisioning_state = None
        self.unique_identifier = None


class FormulaFragment(UpdateResource):
    """A formula for creating a VM, specifying an image base and other parameters.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param description: The description of the formula.
    :type description: str
    :param author: The author of the formula.
    :type author: str
    :param os_type: The OS type of the formula.
    :type os_type: str
    :param formula_content: The content of the formula.
    :type formula_content:
     ~azure.mgmt.devtestlabs.models.LabVirtualMachineCreationParameterFragment
    :param vm: Information about a VM from which a formula is to be created.
    :type vm: ~azure.mgmt.devtestlabs.models.FormulaPropertiesFromVmFragment
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'formula_content': {'key': 'properties.formulaContent', 'type': 'LabVirtualMachineCreationParameterFragment'},
        'vm': {'key': 'properties.vm', 'type': 'FormulaPropertiesFromVmFragment'},
    }

    def __init__(self, **kwargs):
        super(FormulaFragment, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.author = kwargs.get('author', None)
        self.os_type = kwargs.get('os_type', None)
        self.formula_content = kwargs.get('formula_content', None)
        self.vm = kwargs.get('vm', None)


class FormulaPropertiesFromVm(Model):
    """Information about a VM from which a formula is to be created.

    :param lab_vm_id: The identifier of the VM from which a formula is to be
     created.
    :type lab_vm_id: str
    """

    _attribute_map = {
        'lab_vm_id': {'key': 'labVmId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FormulaPropertiesFromVm, self).__init__(**kwargs)
        self.lab_vm_id = kwargs.get('lab_vm_id', None)


class FormulaPropertiesFromVmFragment(Model):
    """Information about a VM from which a formula is to be created.

    :param lab_vm_id: The identifier of the VM from which a formula is to be
     created.
    :type lab_vm_id: str
    """

    _attribute_map = {
        'lab_vm_id': {'key': 'labVmId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FormulaPropertiesFromVmFragment, self).__init__(**kwargs)
        self.lab_vm_id = kwargs.get('lab_vm_id', None)


class GalleryImage(Resource):
    """A gallery image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param author: The author of the gallery image.
    :type author: str
    :ivar created_date: The creation date of the gallery image.
    :vartype created_date: datetime
    :param description: The description of the gallery image.
    :type description: str
    :param image_reference: The image reference of the gallery image.
    :type image_reference:
     ~azure.mgmt.devtestlabs.models.GalleryImageReference
    :param icon: The icon of the gallery image.
    :type icon: str
    :param enabled: Indicates whether this gallery image is enabled.
    :type enabled: bool
    :param plan_id: The third party plan that applies to this image
    :type plan_id: str
    :param is_plan_authorized: Indicates if the plan has been authorized for
     programmatic deployment.
    :type is_plan_authorized: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'image_reference': {'key': 'properties.imageReference', 'type': 'GalleryImageReference'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(GalleryImage, self).__init__(**kwargs)
        self.author = kwargs.get('author', None)
        self.created_date = None
        self.description = kwargs.get('description', None)
        self.image_reference = kwargs.get('image_reference', None)
        self.icon = kwargs.get('icon', None)
        self.enabled = kwargs.get('enabled', None)
        self.plan_id = kwargs.get('plan_id', None)
        self.is_plan_authorized = kwargs.get('is_plan_authorized', None)


class GalleryImageReference(Model):
    """The reference information for an Azure Marketplace image.

    :param offer: The offer of the gallery image.
    :type offer: str
    :param publisher: The publisher of the gallery image.
    :type publisher: str
    :param sku: The SKU of the gallery image.
    :type sku: str
    :param os_type: The OS type of the gallery image.
    :type os_type: str
    :param version: The version of the gallery image.
    :type version: str
    """

    _attribute_map = {
        'offer': {'key': 'offer', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GalleryImageReference, self).__init__(**kwargs)
        self.offer = kwargs.get('offer', None)
        self.publisher = kwargs.get('publisher', None)
        self.sku = kwargs.get('sku', None)
        self.os_type = kwargs.get('os_type', None)
        self.version = kwargs.get('version', None)


class GalleryImageReferenceFragment(Model):
    """The reference information for an Azure Marketplace image.

    :param offer: The offer of the gallery image.
    :type offer: str
    :param publisher: The publisher of the gallery image.
    :type publisher: str
    :param sku: The SKU of the gallery image.
    :type sku: str
    :param os_type: The OS type of the gallery image.
    :type os_type: str
    :param version: The version of the gallery image.
    :type version: str
    """

    _attribute_map = {
        'offer': {'key': 'offer', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GalleryImageReferenceFragment, self).__init__(**kwargs)
        self.offer = kwargs.get('offer', None)
        self.publisher = kwargs.get('publisher', None)
        self.sku = kwargs.get('sku', None)
        self.os_type = kwargs.get('os_type', None)
        self.version = kwargs.get('version', None)


class GenerateArmTemplateRequest(Model):
    """Parameters for generating an ARM template for deploying artifacts.

    :param virtual_machine_name: The resource name of the virtual machine.
    :type virtual_machine_name: str
    :param parameters: The parameters of the ARM template.
    :type parameters: list[~azure.mgmt.devtestlabs.models.ParameterInfo]
    :param location: The location of the virtual machine.
    :type location: str
    :param file_upload_options: Options for uploading the files for the
     artifact. UploadFilesAndGenerateSasTokens is the default value. Possible
     values include: 'UploadFilesAndGenerateSasTokens', 'None'
    :type file_upload_options: str or
     ~azure.mgmt.devtestlabs.models.FileUploadOptions
    """

    _attribute_map = {
        'virtual_machine_name': {'key': 'virtualMachineName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ParameterInfo]'},
        'location': {'key': 'location', 'type': 'str'},
        'file_upload_options': {'key': 'fileUploadOptions', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GenerateArmTemplateRequest, self).__init__(**kwargs)
        self.virtual_machine_name = kwargs.get('virtual_machine_name', None)
        self.parameters = kwargs.get('parameters', None)
        self.location = kwargs.get('location', None)
        self.file_upload_options = kwargs.get('file_upload_options', None)


class GenerateUploadUriParameter(Model):
    """Properties for generating an upload URI.

    :param blob_name: The blob name of the upload URI.
    :type blob_name: str
    """

    _attribute_map = {
        'blob_name': {'key': 'blobName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GenerateUploadUriParameter, self).__init__(**kwargs)
        self.blob_name = kwargs.get('blob_name', None)


class GenerateUploadUriResponse(Model):
    """Response body for generating an upload URI.

    :param upload_uri: The upload URI for the VHD.
    :type upload_uri: str
    """

    _attribute_map = {
        'upload_uri': {'key': 'uploadUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GenerateUploadUriResponse, self).__init__(**kwargs)
        self.upload_uri = kwargs.get('upload_uri', None)


class HourDetails(Model):
    """Properties of an hourly schedule.

    :param minute: Minutes of the hour the schedule will run.
    :type minute: int
    """

    _attribute_map = {
        'minute': {'key': 'minute', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(HourDetails, self).__init__(**kwargs)
        self.minute = kwargs.get('minute', None)


class HourDetailsFragment(Model):
    """Properties of an hourly schedule.

    :param minute: Minutes of the hour the schedule will run.
    :type minute: int
    """

    _attribute_map = {
        'minute': {'key': 'minute', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(HourDetailsFragment, self).__init__(**kwargs)
        self.minute = kwargs.get('minute', None)


class IdentityProperties(Model):
    """Properties of a managed identity.

    :param type: Managed identity.
    :type type: str
    :param principal_id: The principal id of resource identity.
    :type principal_id: str
    :param tenant_id: The tenant identifier of resource.
    :type tenant_id: str
    :param client_secret_url: The client secret URL of the identity.
    :type client_secret_url: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'client_secret_url': {'key': 'clientSecretUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IdentityProperties, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.client_secret_url = kwargs.get('client_secret_url', None)


class ImportLabVirtualMachineRequest(Model):
    """This represents the payload required to import a virtual machine from a
    different lab into the current one.

    :param source_virtual_machine_resource_id: The full resource ID of the
     virtual machine to be imported.
    :type source_virtual_machine_resource_id: str
    :param destination_virtual_machine_name: The name of the virtual machine
     in the destination lab
    :type destination_virtual_machine_name: str
    """

    _attribute_map = {
        'source_virtual_machine_resource_id': {'key': 'sourceVirtualMachineResourceId', 'type': 'str'},
        'destination_virtual_machine_name': {'key': 'destinationVirtualMachineName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImportLabVirtualMachineRequest, self).__init__(**kwargs)
        self.source_virtual_machine_resource_id = kwargs.get('source_virtual_machine_resource_id', None)
        self.destination_virtual_machine_name = kwargs.get('destination_virtual_machine_name', None)


class InboundNatRule(Model):
    """A rule for NAT - exposing a VM's port (backendPort) on the public IP
    address using a load balancer.

    :param transport_protocol: The transport protocol for the endpoint.
     Possible values include: 'Tcp', 'Udp'
    :type transport_protocol: str or
     ~azure.mgmt.devtestlabs.models.TransportProtocol
    :param frontend_port: The external endpoint port of the inbound
     connection. Possible values range between 1 and 65535, inclusive. If
     unspecified, a value will be allocated automatically.
    :type frontend_port: int
    :param backend_port: The port to which the external traffic will be
     redirected.
    :type backend_port: int
    """

    _attribute_map = {
        'transport_protocol': {'key': 'transportProtocol', 'type': 'str'},
        'frontend_port': {'key': 'frontendPort', 'type': 'int'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(InboundNatRule, self).__init__(**kwargs)
        self.transport_protocol = kwargs.get('transport_protocol', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.backend_port = kwargs.get('backend_port', None)


class InboundNatRuleFragment(Model):
    """A rule for NAT - exposing a VM's port (backendPort) on the public IP
    address using a load balancer.

    :param transport_protocol: The transport protocol for the endpoint.
     Possible values include: 'Tcp', 'Udp'
    :type transport_protocol: str or
     ~azure.mgmt.devtestlabs.models.TransportProtocol
    :param frontend_port: The external endpoint port of the inbound
     connection. Possible values range between 1 and 65535, inclusive. If
     unspecified, a value will be allocated automatically.
    :type frontend_port: int
    :param backend_port: The port to which the external traffic will be
     redirected.
    :type backend_port: int
    """

    _attribute_map = {
        'transport_protocol': {'key': 'transportProtocol', 'type': 'str'},
        'frontend_port': {'key': 'frontendPort', 'type': 'int'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(InboundNatRuleFragment, self).__init__(**kwargs)
        self.transport_protocol = kwargs.get('transport_protocol', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.backend_port = kwargs.get('backend_port', None)


class Lab(Resource):
    """A lab.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :ivar default_storage_account: The lab's default storage account.
    :vartype default_storage_account: str
    :ivar default_premium_storage_account: The lab's default premium storage
     account.
    :vartype default_premium_storage_account: str
    :ivar artifacts_storage_account: The lab's artifact storage account.
    :vartype artifacts_storage_account: str
    :ivar premium_data_disk_storage_account: The lab's premium data disk
     storage account.
    :vartype premium_data_disk_storage_account: str
    :ivar vault_name: The lab's Key vault.
    :vartype vault_name: str
    :param lab_storage_type: Type of storage used by the lab. It can be either
     Premium or Standard. Default is Premium. Possible values include:
     'Standard', 'Premium', 'StandardSSD'
    :type lab_storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :param mandatory_artifacts_resource_ids_linux: The ordered list of
     artifact resource IDs that should be applied on all Linux VM creations by
     default, prior to the artifacts specified by the user.
    :type mandatory_artifacts_resource_ids_linux: list[str]
    :param mandatory_artifacts_resource_ids_windows: The ordered list of
     artifact resource IDs that should be applied on all Windows VM creations
     by default, prior to the artifacts specified by the user.
    :type mandatory_artifacts_resource_ids_windows: list[str]
    :ivar created_date: The creation date of the lab.
    :vartype created_date: datetime
    :param premium_data_disks: The setting to enable usage of premium data
     disks.
     When its value is 'Enabled', creation of standard or premium data disks is
     allowed.
     When its value is 'Disabled', only creation of standard data disks is
     allowed. Possible values include: 'Disabled', 'Enabled'
    :type premium_data_disks: str or
     ~azure.mgmt.devtestlabs.models.PremiumDataDisk
    :param environment_permission: The access rights to be granted to the user
     when provisioning an environment. Possible values include: 'Reader',
     'Contributor'
    :type environment_permission: str or
     ~azure.mgmt.devtestlabs.models.EnvironmentPermission
    :param announcement: The properties of any lab announcement associated
     with this lab
    :type announcement:
     ~azure.mgmt.devtestlabs.models.LabAnnouncementProperties
    :param support: The properties of any lab support message associated with
     this lab
    :type support: ~azure.mgmt.devtestlabs.models.LabSupportProperties
    :ivar vm_creation_resource_group: The resource group in which all new lab
     virtual machines will be created. To let DevTest Labs manage resource
     group creation, set this value to null.
    :vartype vm_creation_resource_group: str
    :ivar public_ip_id: The public IP address for the lab's load balancer.
    :vartype public_ip_id: str
    :ivar load_balancer_id: The load balancer used to for lab VMs that use
     shared IP address.
    :vartype load_balancer_id: str
    :ivar network_security_group_id: The Network Security Group attached to
     the lab VMs Network interfaces to restrict open ports.
    :vartype network_security_group_id: str
    :param extended_properties: Extended properties of the lab used for
     experimental features
    :type extended_properties: dict[str, str]
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'default_storage_account': {'readonly': True},
        'default_premium_storage_account': {'readonly': True},
        'artifacts_storage_account': {'readonly': True},
        'premium_data_disk_storage_account': {'readonly': True},
        'vault_name': {'readonly': True},
        'created_date': {'readonly': True},
        'vm_creation_resource_group': {'readonly': True},
        'public_ip_id': {'readonly': True},
        'load_balancer_id': {'readonly': True},
        'network_security_group_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'default_storage_account': {'key': 'properties.defaultStorageAccount', 'type': 'str'},
        'default_premium_storage_account': {'key': 'properties.defaultPremiumStorageAccount', 'type': 'str'},
        'artifacts_storage_account': {'key': 'properties.artifactsStorageAccount', 'type': 'str'},
        'premium_data_disk_storage_account': {'key': 'properties.premiumDataDiskStorageAccount', 'type': 'str'},
        'vault_name': {'key': 'properties.vaultName', 'type': 'str'},
        'lab_storage_type': {'key': 'properties.labStorageType', 'type': 'str'},
        'mandatory_artifacts_resource_ids_linux': {'key': 'properties.mandatoryArtifactsResourceIdsLinux', 'type': '[str]'},
        'mandatory_artifacts_resource_ids_windows': {'key': 'properties.mandatoryArtifactsResourceIdsWindows', 'type': '[str]'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'premium_data_disks': {'key': 'properties.premiumDataDisks', 'type': 'str'},
        'environment_permission': {'key': 'properties.environmentPermission', 'type': 'str'},
        'announcement': {'key': 'properties.announcement', 'type': 'LabAnnouncementProperties'},
        'support': {'key': 'properties.support', 'type': 'LabSupportProperties'},
        'vm_creation_resource_group': {'key': 'properties.vmCreationResourceGroup', 'type': 'str'},
        'public_ip_id': {'key': 'properties.publicIpId', 'type': 'str'},
        'load_balancer_id': {'key': 'properties.loadBalancerId', 'type': 'str'},
        'network_security_group_id': {'key': 'properties.networkSecurityGroupId', 'type': 'str'},
        'extended_properties': {'key': 'properties.extendedProperties', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Lab, self).__init__(**kwargs)
        self.default_storage_account = None
        self.default_premium_storage_account = None
        self.artifacts_storage_account = None
        self.premium_data_disk_storage_account = None
        self.vault_name = None
        self.lab_storage_type = kwargs.get('lab_storage_type', None)
        self.mandatory_artifacts_resource_ids_linux = kwargs.get('mandatory_artifacts_resource_ids_linux', None)
        self.mandatory_artifacts_resource_ids_windows = kwargs.get('mandatory_artifacts_resource_ids_windows', None)
        self.created_date = None
        self.premium_data_disks = kwargs.get('premium_data_disks', None)
        self.environment_permission = kwargs.get('environment_permission', None)
        self.announcement = kwargs.get('announcement', None)
        self.support = kwargs.get('support', None)
        self.vm_creation_resource_group = None
        self.public_ip_id = None
        self.load_balancer_id = None
        self.network_security_group_id = None
        self.extended_properties = kwargs.get('extended_properties', None)
        self.provisioning_state = None
        self.unique_identifier = None


class LabAnnouncementProperties(Model):
    """Properties of a lab's announcement banner.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param title: The plain text title for the lab announcement
    :type title: str
    :param markdown: The markdown text (if any) that this lab displays in the
     UI. If left empty/null, nothing will be shown.
    :type markdown: str
    :param enabled: Is the lab announcement active/enabled at this time?.
     Possible values include: 'Enabled', 'Disabled'
    :type enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param expiration_date: The time at which the announcement expires (null
     for never)
    :type expiration_date: datetime
    :param expired: Has this announcement expired?
    :type expired: bool
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'markdown': {'key': 'markdown', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'expired': {'key': 'expired', 'type': 'bool'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabAnnouncementProperties, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.markdown = kwargs.get('markdown', None)
        self.enabled = kwargs.get('enabled', None)
        self.expiration_date = kwargs.get('expiration_date', None)
        self.expired = kwargs.get('expired', None)
        self.provisioning_state = None
        self.unique_identifier = None


class LabAnnouncementPropertiesFragment(Model):
    """Properties of a lab's announcement banner.

    :param title: The plain text title for the lab announcement
    :type title: str
    :param markdown: The markdown text (if any) that this lab displays in the
     UI. If left empty/null, nothing will be shown.
    :type markdown: str
    :param enabled: Is the lab announcement active/enabled at this time?.
     Possible values include: 'Enabled', 'Disabled'
    :type enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param expiration_date: The time at which the announcement expires (null
     for never)
    :type expiration_date: datetime
    :param expired: Has this announcement expired?
    :type expired: bool
    """

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'markdown': {'key': 'markdown', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'expired': {'key': 'expired', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(LabAnnouncementPropertiesFragment, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.markdown = kwargs.get('markdown', None)
        self.enabled = kwargs.get('enabled', None)
        self.expiration_date = kwargs.get('expiration_date', None)
        self.expired = kwargs.get('expired', None)


class LabCost(Resource):
    """A cost item.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param target_cost: The target cost properties
    :type target_cost: ~azure.mgmt.devtestlabs.models.TargetCostProperties
    :ivar lab_cost_summary: The lab cost summary component of the cost data.
    :vartype lab_cost_summary:
     ~azure.mgmt.devtestlabs.models.LabCostSummaryProperties
    :ivar lab_cost_details: The lab cost details component of the cost data.
    :vartype lab_cost_details:
     list[~azure.mgmt.devtestlabs.models.LabCostDetailsProperties]
    :ivar resource_costs: The resource cost component of the cost data.
    :vartype resource_costs:
     list[~azure.mgmt.devtestlabs.models.LabResourceCostProperties]
    :param currency_code: The currency code of the cost.
    :type currency_code: str
    :param start_date_time: The start time of the cost data.
    :type start_date_time: datetime
    :param end_date_time: The end time of the cost data.
    :type end_date_time: datetime
    :param created_date: The creation date of the cost.
    :type created_date: datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'lab_cost_summary': {'readonly': True},
        'lab_cost_details': {'readonly': True},
        'resource_costs': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'target_cost': {'key': 'properties.targetCost', 'type': 'TargetCostProperties'},
        'lab_cost_summary': {'key': 'properties.labCostSummary', 'type': 'LabCostSummaryProperties'},
        'lab_cost_details': {'key': 'properties.labCostDetails', 'type': '[LabCostDetailsProperties]'},
        'resource_costs': {'key': 'properties.resourceCosts', 'type': '[LabResourceCostProperties]'},
        'currency_code': {'key': 'properties.currencyCode', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabCost, self).__init__(**kwargs)
        self.target_cost = kwargs.get('target_cost', None)
        self.lab_cost_summary = None
        self.lab_cost_details = None
        self.resource_costs = None
        self.currency_code = kwargs.get('currency_code', None)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.created_date = kwargs.get('created_date', None)
        self.provisioning_state = None
        self.unique_identifier = None


class LabCostDetailsProperties(Model):
    """The properties of a lab cost item.

    :param date_property: The date of the cost item.
    :type date_property: datetime
    :param cost: The cost component of the cost item.
    :type cost: float
    :param cost_type: The type of the cost. Possible values include:
     'Unavailable', 'Reported', 'Projected'
    :type cost_type: str or ~azure.mgmt.devtestlabs.models.CostType
    """

    _attribute_map = {
        'date_property': {'key': 'date', 'type': 'iso-8601'},
        'cost': {'key': 'cost', 'type': 'float'},
        'cost_type': {'key': 'costType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabCostDetailsProperties, self).__init__(**kwargs)
        self.date_property = kwargs.get('date_property', None)
        self.cost = kwargs.get('cost', None)
        self.cost_type = kwargs.get('cost_type', None)


class LabCostSummaryProperties(Model):
    """The properties of the cost summary.

    :param estimated_lab_cost: The cost component of the cost item.
    :type estimated_lab_cost: float
    """

    _attribute_map = {
        'estimated_lab_cost': {'key': 'estimatedLabCost', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(LabCostSummaryProperties, self).__init__(**kwargs)
        self.estimated_lab_cost = kwargs.get('estimated_lab_cost', None)


class LabFragment(UpdateResource):
    """A lab.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param lab_storage_type: Type of storage used by the lab. It can be either
     Premium or Standard. Default is Premium. Possible values include:
     'Standard', 'Premium', 'StandardSSD'
    :type lab_storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :param mandatory_artifacts_resource_ids_linux: The ordered list of
     artifact resource IDs that should be applied on all Linux VM creations by
     default, prior to the artifacts specified by the user.
    :type mandatory_artifacts_resource_ids_linux: list[str]
    :param mandatory_artifacts_resource_ids_windows: The ordered list of
     artifact resource IDs that should be applied on all Windows VM creations
     by default, prior to the artifacts specified by the user.
    :type mandatory_artifacts_resource_ids_windows: list[str]
    :param premium_data_disks: The setting to enable usage of premium data
     disks.
     When its value is 'Enabled', creation of standard or premium data disks is
     allowed.
     When its value is 'Disabled', only creation of standard data disks is
     allowed. Possible values include: 'Disabled', 'Enabled'
    :type premium_data_disks: str or
     ~azure.mgmt.devtestlabs.models.PremiumDataDisk
    :param environment_permission: The access rights to be granted to the user
     when provisioning an environment. Possible values include: 'Reader',
     'Contributor'
    :type environment_permission: str or
     ~azure.mgmt.devtestlabs.models.EnvironmentPermission
    :param announcement: The properties of any lab announcement associated
     with this lab
    :type announcement:
     ~azure.mgmt.devtestlabs.models.LabAnnouncementPropertiesFragment
    :param support: The properties of any lab support message associated with
     this lab
    :type support: ~azure.mgmt.devtestlabs.models.LabSupportPropertiesFragment
    :param extended_properties: Extended properties of the lab used for
     experimental features
    :type extended_properties: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'lab_storage_type': {'key': 'properties.labStorageType', 'type': 'str'},
        'mandatory_artifacts_resource_ids_linux': {'key': 'properties.mandatoryArtifactsResourceIdsLinux', 'type': '[str]'},
        'mandatory_artifacts_resource_ids_windows': {'key': 'properties.mandatoryArtifactsResourceIdsWindows', 'type': '[str]'},
        'premium_data_disks': {'key': 'properties.premiumDataDisks', 'type': 'str'},
        'environment_permission': {'key': 'properties.environmentPermission', 'type': 'str'},
        'announcement': {'key': 'properties.announcement', 'type': 'LabAnnouncementPropertiesFragment'},
        'support': {'key': 'properties.support', 'type': 'LabSupportPropertiesFragment'},
        'extended_properties': {'key': 'properties.extendedProperties', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(LabFragment, self).__init__(**kwargs)
        self.lab_storage_type = kwargs.get('lab_storage_type', None)
        self.mandatory_artifacts_resource_ids_linux = kwargs.get('mandatory_artifacts_resource_ids_linux', None)
        self.mandatory_artifacts_resource_ids_windows = kwargs.get('mandatory_artifacts_resource_ids_windows', None)
        self.premium_data_disks = kwargs.get('premium_data_disks', None)
        self.environment_permission = kwargs.get('environment_permission', None)
        self.announcement = kwargs.get('announcement', None)
        self.support = kwargs.get('support', None)
        self.extended_properties = kwargs.get('extended_properties', None)


class LabResourceCostProperties(Model):
    """The properties of a resource cost item.

    :param resourcename: The name of the resource.
    :type resourcename: str
    :param resource_uid: The unique identifier of the resource.
    :type resource_uid: str
    :param resource_cost: The cost component of the resource cost item.
    :type resource_cost: float
    :param resource_type: The logical resource type (ex. virtualmachine,
     storageaccount)
    :type resource_type: str
    :param resource_owner: The owner of the resource (ex.
     janedoe@microsoft.com)
    :type resource_owner: str
    :param resource_pricing_tier: The category of the resource (ex.
     Premium_LRS, Standard_DS1)
    :type resource_pricing_tier: str
    :param resource_status: The status of the resource (ex. Active)
    :type resource_status: str
    :param resource_id: The ID of the resource
    :type resource_id: str
    :param external_resource_id: The ID of the external resource
    :type external_resource_id: str
    """

    _attribute_map = {
        'resourcename': {'key': 'resourcename', 'type': 'str'},
        'resource_uid': {'key': 'resourceUId', 'type': 'str'},
        'resource_cost': {'key': 'resourceCost', 'type': 'float'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_owner': {'key': 'resourceOwner', 'type': 'str'},
        'resource_pricing_tier': {'key': 'resourcePricingTier', 'type': 'str'},
        'resource_status': {'key': 'resourceStatus', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'external_resource_id': {'key': 'externalResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabResourceCostProperties, self).__init__(**kwargs)
        self.resourcename = kwargs.get('resourcename', None)
        self.resource_uid = kwargs.get('resource_uid', None)
        self.resource_cost = kwargs.get('resource_cost', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_owner = kwargs.get('resource_owner', None)
        self.resource_pricing_tier = kwargs.get('resource_pricing_tier', None)
        self.resource_status = kwargs.get('resource_status', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.external_resource_id = kwargs.get('external_resource_id', None)


class LabSupportProperties(Model):
    """Properties of a lab's support banner.

    :param enabled: Is the lab support banner active/enabled at this time?.
     Possible values include: 'Enabled', 'Disabled'
    :type enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param markdown: The markdown text (if any) that this lab displays in the
     UI. If left empty/null, nothing will be shown.
    :type markdown: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'str'},
        'markdown': {'key': 'markdown', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabSupportProperties, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.markdown = kwargs.get('markdown', None)


class LabSupportPropertiesFragment(Model):
    """Properties of a lab's support banner.

    :param enabled: Is the lab support banner active/enabled at this time?.
     Possible values include: 'Enabled', 'Disabled'
    :type enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param markdown: The markdown text (if any) that this lab displays in the
     UI. If left empty/null, nothing will be shown.
    :type markdown: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'str'},
        'markdown': {'key': 'markdown', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabSupportPropertiesFragment, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.markdown = kwargs.get('markdown', None)


class LabVhd(Model):
    """Properties of a VHD in the lab.

    :param id: The URI to the VHD.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabVhd, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class LabVirtualMachine(Resource):
    """A virtual machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param notes: The notes of the virtual machine.
    :type notes: str
    :param owner_object_id: The object identifier of the owner of the virtual
     machine.
    :type owner_object_id: str
    :param owner_user_principal_name: The user principal name of the virtual
     machine owner.
    :type owner_user_principal_name: str
    :param created_by_user_id: The object identifier of the creator of the
     virtual machine.
    :type created_by_user_id: str
    :param created_by_user: The email address of creator of the virtual
     machine.
    :type created_by_user: str
    :param created_date: The creation date of the virtual machine.
    :type created_date: datetime
    :param compute_id: The resource identifier (Microsoft.Compute) of the
     virtual machine.
    :type compute_id: str
    :param custom_image_id: The custom image identifier of the virtual
     machine.
    :type custom_image_id: str
    :param os_type: The OS type of the virtual machine.
    :type os_type: str
    :param size: The size of the virtual machine.
    :type size: str
    :param user_name: The user name of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine administrator.
    :type password: str
    :param ssh_key: The SSH key of the virtual machine administrator.
    :type ssh_key: str
    :param is_authentication_with_ssh_key: Indicates whether this virtual
     machine uses an SSH key for authentication.
    :type is_authentication_with_ssh_key: bool
    :param fqdn: The fully-qualified domain name of the virtual machine.
    :type fqdn: str
    :param lab_subnet_name: The lab subnet name of the virtual machine.
    :type lab_subnet_name: str
    :param lab_virtual_network_id: The lab virtual network identifier of the
     virtual machine.
    :type lab_virtual_network_id: str
    :param disallow_public_ip_address: Indicates whether the virtual machine
     is to be created without a public IP address.
    :type disallow_public_ip_address: bool
    :param artifacts: The artifacts to be installed on the virtual machine.
    :type artifacts:
     list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
    :param artifact_deployment_status: The artifact deployment status for the
     virtual machine.
    :type artifact_deployment_status:
     ~azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusProperties
    :param gallery_image_reference: The Microsoft Azure Marketplace image
     reference of the virtual machine.
    :type gallery_image_reference:
     ~azure.mgmt.devtestlabs.models.GalleryImageReference
    :param plan_id: The id of the plan associated with the virtual machine
     image
    :type plan_id: str
    :ivar compute_vm: The compute virtual machine properties.
    :vartype compute_vm: ~azure.mgmt.devtestlabs.models.ComputeVmProperties
    :param network_interface: The network interface properties.
    :type network_interface:
     ~azure.mgmt.devtestlabs.models.NetworkInterfaceProperties
    :ivar applicable_schedule: The applicable schedule for the virtual
     machine.
    :vartype applicable_schedule:
     ~azure.mgmt.devtestlabs.models.ApplicableSchedule
    :param expiration_date: The expiration date for VM.
    :type expiration_date: datetime
    :param allow_claim: Indicates whether another user can take ownership of
     the virtual machine
    :type allow_claim: bool
    :param storage_type: Storage type to use for virtual machine (i.e.
     Standard, Premium).
    :type storage_type: str
    :param virtual_machine_creation_source: Tells source of creation of lab
     virtual machine. Output property only. Possible values include:
     'FromCustomImage', 'FromGalleryImage', 'FromSharedGalleryImage'
    :type virtual_machine_creation_source: str or
     ~azure.mgmt.devtestlabs.models.VirtualMachineCreationSource
    :param environment_id: The resource ID of the environment that contains
     this virtual machine, if any.
    :type environment_id: str
    :param data_disk_parameters: New or existing data disks to attach to the
     virtual machine after creation
    :type data_disk_parameters:
     list[~azure.mgmt.devtestlabs.models.DataDiskProperties]
    :param schedule_parameters: Virtual Machine schedules to be created
    :type schedule_parameters:
     list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameter]
    :param last_known_power_state: Last known compute power state captured in
     DTL
    :type last_known_power_state: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'compute_vm': {'readonly': True},
        'applicable_schedule': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'owner_object_id': {'key': 'properties.ownerObjectId', 'type': 'str'},
        'owner_user_principal_name': {'key': 'properties.ownerUserPrincipalName', 'type': 'str'},
        'created_by_user_id': {'key': 'properties.createdByUserId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'compute_id': {'key': 'properties.computeId', 'type': 'str'},
        'custom_image_id': {'key': 'properties.customImageId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'ssh_key': {'key': 'properties.sshKey', 'type': 'str'},
        'is_authentication_with_ssh_key': {'key': 'properties.isAuthenticationWithSshKey', 'type': 'bool'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'lab_subnet_name': {'key': 'properties.labSubnetName', 'type': 'str'},
        'lab_virtual_network_id': {'key': 'properties.labVirtualNetworkId', 'type': 'str'},
        'disallow_public_ip_address': {'key': 'properties.disallowPublicIpAddress', 'type': 'bool'},
        'artifacts': {'key': 'properties.artifacts', 'type': '[ArtifactInstallProperties]'},
        'artifact_deployment_status': {'key': 'properties.artifactDeploymentStatus', 'type': 'ArtifactDeploymentStatusProperties'},
        'gallery_image_reference': {'key': 'properties.galleryImageReference', 'type': 'GalleryImageReference'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'compute_vm': {'key': 'properties.computeVm', 'type': 'ComputeVmProperties'},
        'network_interface': {'key': 'properties.networkInterface', 'type': 'NetworkInterfaceProperties'},
        'applicable_schedule': {'key': 'properties.applicableSchedule', 'type': 'ApplicableSchedule'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'allow_claim': {'key': 'properties.allowClaim', 'type': 'bool'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'virtual_machine_creation_source': {'key': 'properties.virtualMachineCreationSource', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'data_disk_parameters': {'key': 'properties.dataDiskParameters', 'type': '[DataDiskProperties]'},
        'schedule_parameters': {'key': 'properties.scheduleParameters', 'type': '[ScheduleCreationParameter]'},
        'last_known_power_state': {'key': 'properties.lastKnownPowerState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabVirtualMachine, self).__init__(**kwargs)
        self.notes = kwargs.get('notes', None)
        self.owner_object_id = kwargs.get('owner_object_id', None)
        self.owner_user_principal_name = kwargs.get('owner_user_principal_name', None)
        self.created_by_user_id = kwargs.get('created_by_user_id', None)
        self.created_by_user = kwargs.get('created_by_user', None)
        self.created_date = kwargs.get('created_date', None)
        self.compute_id = kwargs.get('compute_id', None)
        self.custom_image_id = kwargs.get('custom_image_id', None)
        self.os_type = kwargs.get('os_type', None)
        self.size = kwargs.get('size', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.ssh_key = kwargs.get('ssh_key', None)
        self.is_authentication_with_ssh_key = kwargs.get('is_authentication_with_ssh_key', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.lab_subnet_name = kwargs.get('lab_subnet_name', None)
        self.lab_virtual_network_id = kwargs.get('lab_virtual_network_id', None)
        self.disallow_public_ip_address = kwargs.get('disallow_public_ip_address', None)
        self.artifacts = kwargs.get('artifacts', None)
        self.artifact_deployment_status = kwargs.get('artifact_deployment_status', None)
        self.gallery_image_reference = kwargs.get('gallery_image_reference', None)
        self.plan_id = kwargs.get('plan_id', None)
        self.compute_vm = None
        self.network_interface = kwargs.get('network_interface', None)
        self.applicable_schedule = None
        self.expiration_date = kwargs.get('expiration_date', None)
        self.allow_claim = kwargs.get('allow_claim', None)
        self.storage_type = kwargs.get('storage_type', None)
        self.virtual_machine_creation_source = kwargs.get('virtual_machine_creation_source', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.data_disk_parameters = kwargs.get('data_disk_parameters', None)
        self.schedule_parameters = kwargs.get('schedule_parameters', None)
        self.last_known_power_state = kwargs.get('last_known_power_state', None)
        self.provisioning_state = None
        self.unique_identifier = None


class LabVirtualMachineCreationParameter(Model):
    """Properties for creating a virtual machine.

    :param bulk_creation_parameters: The number of virtual machine instances
     to create.
    :type bulk_creation_parameters:
     ~azure.mgmt.devtestlabs.models.BulkCreationParameters
    :param notes: The notes of the virtual machine.
    :type notes: str
    :param owner_object_id: The object identifier of the owner of the virtual
     machine.
    :type owner_object_id: str
    :param owner_user_principal_name: The user principal name of the virtual
     machine owner.
    :type owner_user_principal_name: str
    :param created_by_user_id: The object identifier of the creator of the
     virtual machine.
    :type created_by_user_id: str
    :param created_by_user: The email address of creator of the virtual
     machine.
    :type created_by_user: str
    :param created_date: The creation date of the virtual machine.
    :type created_date: datetime
    :param compute_id: The resource identifier (Microsoft.Compute) of the
     virtual machine.
    :type compute_id: str
    :param custom_image_id: The custom image identifier of the virtual
     machine.
    :type custom_image_id: str
    :param os_type: The OS type of the virtual machine.
    :type os_type: str
    :param size: The size of the virtual machine.
    :type size: str
    :param user_name: The user name of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine administrator.
    :type password: str
    :param ssh_key: The SSH key of the virtual machine administrator.
    :type ssh_key: str
    :param is_authentication_with_ssh_key: Indicates whether this virtual
     machine uses an SSH key for authentication.
    :type is_authentication_with_ssh_key: bool
    :param fqdn: The fully-qualified domain name of the virtual machine.
    :type fqdn: str
    :param lab_subnet_name: The lab subnet name of the virtual machine.
    :type lab_subnet_name: str
    :param lab_virtual_network_id: The lab virtual network identifier of the
     virtual machine.
    :type lab_virtual_network_id: str
    :param disallow_public_ip_address: Indicates whether the virtual machine
     is to be created without a public IP address.
    :type disallow_public_ip_address: bool
    :param artifacts: The artifacts to be installed on the virtual machine.
    :type artifacts:
     list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
    :param artifact_deployment_status: The artifact deployment status for the
     virtual machine.
    :type artifact_deployment_status:
     ~azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusProperties
    :param gallery_image_reference: The Microsoft Azure Marketplace image
     reference of the virtual machine.
    :type gallery_image_reference:
     ~azure.mgmt.devtestlabs.models.GalleryImageReference
    :param plan_id: The id of the plan associated with the virtual machine
     image
    :type plan_id: str
    :param network_interface: The network interface properties.
    :type network_interface:
     ~azure.mgmt.devtestlabs.models.NetworkInterfaceProperties
    :param expiration_date: The expiration date for VM.
    :type expiration_date: datetime
    :param allow_claim: Indicates whether another user can take ownership of
     the virtual machine
    :type allow_claim: bool
    :param storage_type: Storage type to use for virtual machine (i.e.
     Standard, Premium).
    :type storage_type: str
    :param virtual_machine_creation_source: Tells source of creation of lab
     virtual machine. Output property only. Possible values include:
     'FromCustomImage', 'FromGalleryImage', 'FromSharedGalleryImage'
    :type virtual_machine_creation_source: str or
     ~azure.mgmt.devtestlabs.models.VirtualMachineCreationSource
    :param environment_id: The resource ID of the environment that contains
     this virtual machine, if any.
    :type environment_id: str
    :param data_disk_parameters: New or existing data disks to attach to the
     virtual machine after creation
    :type data_disk_parameters:
     list[~azure.mgmt.devtestlabs.models.DataDiskProperties]
    :param schedule_parameters: Virtual Machine schedules to be created
    :type schedule_parameters:
     list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameter]
    :param last_known_power_state: Last known compute power state captured in
     DTL
    :type last_known_power_state: str
    :param name: The name of the virtual machine or environment
    :type name: str
    :param location: The location of the new virtual machine or environment
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'bulk_creation_parameters': {'key': 'properties.bulkCreationParameters', 'type': 'BulkCreationParameters'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'owner_object_id': {'key': 'properties.ownerObjectId', 'type': 'str'},
        'owner_user_principal_name': {'key': 'properties.ownerUserPrincipalName', 'type': 'str'},
        'created_by_user_id': {'key': 'properties.createdByUserId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'compute_id': {'key': 'properties.computeId', 'type': 'str'},
        'custom_image_id': {'key': 'properties.customImageId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'ssh_key': {'key': 'properties.sshKey', 'type': 'str'},
        'is_authentication_with_ssh_key': {'key': 'properties.isAuthenticationWithSshKey', 'type': 'bool'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'lab_subnet_name': {'key': 'properties.labSubnetName', 'type': 'str'},
        'lab_virtual_network_id': {'key': 'properties.labVirtualNetworkId', 'type': 'str'},
        'disallow_public_ip_address': {'key': 'properties.disallowPublicIpAddress', 'type': 'bool'},
        'artifacts': {'key': 'properties.artifacts', 'type': '[ArtifactInstallProperties]'},
        'artifact_deployment_status': {'key': 'properties.artifactDeploymentStatus', 'type': 'ArtifactDeploymentStatusProperties'},
        'gallery_image_reference': {'key': 'properties.galleryImageReference', 'type': 'GalleryImageReference'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'network_interface': {'key': 'properties.networkInterface', 'type': 'NetworkInterfaceProperties'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'allow_claim': {'key': 'properties.allowClaim', 'type': 'bool'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'virtual_machine_creation_source': {'key': 'properties.virtualMachineCreationSource', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'data_disk_parameters': {'key': 'properties.dataDiskParameters', 'type': '[DataDiskProperties]'},
        'schedule_parameters': {'key': 'properties.scheduleParameters', 'type': '[ScheduleCreationParameter]'},
        'last_known_power_state': {'key': 'properties.lastKnownPowerState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(LabVirtualMachineCreationParameter, self).__init__(**kwargs)
        self.bulk_creation_parameters = kwargs.get('bulk_creation_parameters', None)
        self.notes = kwargs.get('notes', None)
        self.owner_object_id = kwargs.get('owner_object_id', None)
        self.owner_user_principal_name = kwargs.get('owner_user_principal_name', None)
        self.created_by_user_id = kwargs.get('created_by_user_id', None)
        self.created_by_user = kwargs.get('created_by_user', None)
        self.created_date = kwargs.get('created_date', None)
        self.compute_id = kwargs.get('compute_id', None)
        self.custom_image_id = kwargs.get('custom_image_id', None)
        self.os_type = kwargs.get('os_type', None)
        self.size = kwargs.get('size', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.ssh_key = kwargs.get('ssh_key', None)
        self.is_authentication_with_ssh_key = kwargs.get('is_authentication_with_ssh_key', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.lab_subnet_name = kwargs.get('lab_subnet_name', None)
        self.lab_virtual_network_id = kwargs.get('lab_virtual_network_id', None)
        self.disallow_public_ip_address = kwargs.get('disallow_public_ip_address', None)
        self.artifacts = kwargs.get('artifacts', None)
        self.artifact_deployment_status = kwargs.get('artifact_deployment_status', None)
        self.gallery_image_reference = kwargs.get('gallery_image_reference', None)
        self.plan_id = kwargs.get('plan_id', None)
        self.network_interface = kwargs.get('network_interface', None)
        self.expiration_date = kwargs.get('expiration_date', None)
        self.allow_claim = kwargs.get('allow_claim', None)
        self.storage_type = kwargs.get('storage_type', None)
        self.virtual_machine_creation_source = kwargs.get('virtual_machine_creation_source', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.data_disk_parameters = kwargs.get('data_disk_parameters', None)
        self.schedule_parameters = kwargs.get('schedule_parameters', None)
        self.last_known_power_state = kwargs.get('last_known_power_state', None)
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class LabVirtualMachineCreationParameterFragment(Model):
    """Properties for creating a virtual machine.

    :param bulk_creation_parameters: The number of virtual machine instances
     to create.
    :type bulk_creation_parameters:
     ~azure.mgmt.devtestlabs.models.BulkCreationParametersFragment
    :param notes: The notes of the virtual machine.
    :type notes: str
    :param owner_object_id: The object identifier of the owner of the virtual
     machine.
    :type owner_object_id: str
    :param owner_user_principal_name: The user principal name of the virtual
     machine owner.
    :type owner_user_principal_name: str
    :param created_by_user_id: The object identifier of the creator of the
     virtual machine.
    :type created_by_user_id: str
    :param created_by_user: The email address of creator of the virtual
     machine.
    :type created_by_user: str
    :param created_date: The creation date of the virtual machine.
    :type created_date: datetime
    :param compute_id: The resource identifier (Microsoft.Compute) of the
     virtual machine.
    :type compute_id: str
    :param custom_image_id: The custom image identifier of the virtual
     machine.
    :type custom_image_id: str
    :param os_type: The OS type of the virtual machine.
    :type os_type: str
    :param size: The size of the virtual machine.
    :type size: str
    :param user_name: The user name of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine administrator.
    :type password: str
    :param ssh_key: The SSH key of the virtual machine administrator.
    :type ssh_key: str
    :param is_authentication_with_ssh_key: Indicates whether this virtual
     machine uses an SSH key for authentication.
    :type is_authentication_with_ssh_key: bool
    :param fqdn: The fully-qualified domain name of the virtual machine.
    :type fqdn: str
    :param lab_subnet_name: The lab subnet name of the virtual machine.
    :type lab_subnet_name: str
    :param lab_virtual_network_id: The lab virtual network identifier of the
     virtual machine.
    :type lab_virtual_network_id: str
    :param disallow_public_ip_address: Indicates whether the virtual machine
     is to be created without a public IP address.
    :type disallow_public_ip_address: bool
    :param artifacts: The artifacts to be installed on the virtual machine.
    :type artifacts:
     list[~azure.mgmt.devtestlabs.models.ArtifactInstallPropertiesFragment]
    :param artifact_deployment_status: The artifact deployment status for the
     virtual machine.
    :type artifact_deployment_status:
     ~azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusPropertiesFragment
    :param gallery_image_reference: The Microsoft Azure Marketplace image
     reference of the virtual machine.
    :type gallery_image_reference:
     ~azure.mgmt.devtestlabs.models.GalleryImageReferenceFragment
    :param plan_id: The id of the plan associated with the virtual machine
     image
    :type plan_id: str
    :param network_interface: The network interface properties.
    :type network_interface:
     ~azure.mgmt.devtestlabs.models.NetworkInterfacePropertiesFragment
    :param expiration_date: The expiration date for VM.
    :type expiration_date: datetime
    :param allow_claim: Indicates whether another user can take ownership of
     the virtual machine
    :type allow_claim: bool
    :param storage_type: Storage type to use for virtual machine (i.e.
     Standard, Premium).
    :type storage_type: str
    :param virtual_machine_creation_source: Tells source of creation of lab
     virtual machine. Output property only. Possible values include:
     'FromCustomImage', 'FromGalleryImage', 'FromSharedGalleryImage'
    :type virtual_machine_creation_source: str or
     ~azure.mgmt.devtestlabs.models.VirtualMachineCreationSource
    :param environment_id: The resource ID of the environment that contains
     this virtual machine, if any.
    :type environment_id: str
    :param data_disk_parameters: New or existing data disks to attach to the
     virtual machine after creation
    :type data_disk_parameters:
     list[~azure.mgmt.devtestlabs.models.DataDiskPropertiesFragment]
    :param schedule_parameters: Virtual Machine schedules to be created
    :type schedule_parameters:
     list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameterFragment]
    :param last_known_power_state: Last known compute power state captured in
     DTL
    :type last_known_power_state: str
    :param name: The name of the virtual machine or environment
    :type name: str
    :param location: The location of the new virtual machine or environment
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'bulk_creation_parameters': {'key': 'properties.bulkCreationParameters', 'type': 'BulkCreationParametersFragment'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'owner_object_id': {'key': 'properties.ownerObjectId', 'type': 'str'},
        'owner_user_principal_name': {'key': 'properties.ownerUserPrincipalName', 'type': 'str'},
        'created_by_user_id': {'key': 'properties.createdByUserId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'compute_id': {'key': 'properties.computeId', 'type': 'str'},
        'custom_image_id': {'key': 'properties.customImageId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'ssh_key': {'key': 'properties.sshKey', 'type': 'str'},
        'is_authentication_with_ssh_key': {'key': 'properties.isAuthenticationWithSshKey', 'type': 'bool'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'lab_subnet_name': {'key': 'properties.labSubnetName', 'type': 'str'},
        'lab_virtual_network_id': {'key': 'properties.labVirtualNetworkId', 'type': 'str'},
        'disallow_public_ip_address': {'key': 'properties.disallowPublicIpAddress', 'type': 'bool'},
        'artifacts': {'key': 'properties.artifacts', 'type': '[ArtifactInstallPropertiesFragment]'},
        'artifact_deployment_status': {'key': 'properties.artifactDeploymentStatus', 'type': 'ArtifactDeploymentStatusPropertiesFragment'},
        'gallery_image_reference': {'key': 'properties.galleryImageReference', 'type': 'GalleryImageReferenceFragment'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'network_interface': {'key': 'properties.networkInterface', 'type': 'NetworkInterfacePropertiesFragment'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'allow_claim': {'key': 'properties.allowClaim', 'type': 'bool'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'virtual_machine_creation_source': {'key': 'properties.virtualMachineCreationSource', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'data_disk_parameters': {'key': 'properties.dataDiskParameters', 'type': '[DataDiskPropertiesFragment]'},
        'schedule_parameters': {'key': 'properties.scheduleParameters', 'type': '[ScheduleCreationParameterFragment]'},
        'last_known_power_state': {'key': 'properties.lastKnownPowerState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(LabVirtualMachineCreationParameterFragment, self).__init__(**kwargs)
        self.bulk_creation_parameters = kwargs.get('bulk_creation_parameters', None)
        self.notes = kwargs.get('notes', None)
        self.owner_object_id = kwargs.get('owner_object_id', None)
        self.owner_user_principal_name = kwargs.get('owner_user_principal_name', None)
        self.created_by_user_id = kwargs.get('created_by_user_id', None)
        self.created_by_user = kwargs.get('created_by_user', None)
        self.created_date = kwargs.get('created_date', None)
        self.compute_id = kwargs.get('compute_id', None)
        self.custom_image_id = kwargs.get('custom_image_id', None)
        self.os_type = kwargs.get('os_type', None)
        self.size = kwargs.get('size', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.ssh_key = kwargs.get('ssh_key', None)
        self.is_authentication_with_ssh_key = kwargs.get('is_authentication_with_ssh_key', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.lab_subnet_name = kwargs.get('lab_subnet_name', None)
        self.lab_virtual_network_id = kwargs.get('lab_virtual_network_id', None)
        self.disallow_public_ip_address = kwargs.get('disallow_public_ip_address', None)
        self.artifacts = kwargs.get('artifacts', None)
        self.artifact_deployment_status = kwargs.get('artifact_deployment_status', None)
        self.gallery_image_reference = kwargs.get('gallery_image_reference', None)
        self.plan_id = kwargs.get('plan_id', None)
        self.network_interface = kwargs.get('network_interface', None)
        self.expiration_date = kwargs.get('expiration_date', None)
        self.allow_claim = kwargs.get('allow_claim', None)
        self.storage_type = kwargs.get('storage_type', None)
        self.virtual_machine_creation_source = kwargs.get('virtual_machine_creation_source', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.data_disk_parameters = kwargs.get('data_disk_parameters', None)
        self.schedule_parameters = kwargs.get('schedule_parameters', None)
        self.last_known_power_state = kwargs.get('last_known_power_state', None)
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class LabVirtualMachineFragment(UpdateResource):
    """A virtual machine.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param notes: The notes of the virtual machine.
    :type notes: str
    :param owner_object_id: The object identifier of the owner of the virtual
     machine.
    :type owner_object_id: str
    :param owner_user_principal_name: The user principal name of the virtual
     machine owner.
    :type owner_user_principal_name: str
    :param created_by_user_id: The object identifier of the creator of the
     virtual machine.
    :type created_by_user_id: str
    :param created_by_user: The email address of creator of the virtual
     machine.
    :type created_by_user: str
    :param created_date: The creation date of the virtual machine.
    :type created_date: datetime
    :param compute_id: The resource identifier (Microsoft.Compute) of the
     virtual machine.
    :type compute_id: str
    :param custom_image_id: The custom image identifier of the virtual
     machine.
    :type custom_image_id: str
    :param os_type: The OS type of the virtual machine.
    :type os_type: str
    :param size: The size of the virtual machine.
    :type size: str
    :param user_name: The user name of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine administrator.
    :type password: str
    :param ssh_key: The SSH key of the virtual machine administrator.
    :type ssh_key: str
    :param is_authentication_with_ssh_key: Indicates whether this virtual
     machine uses an SSH key for authentication.
    :type is_authentication_with_ssh_key: bool
    :param fqdn: The fully-qualified domain name of the virtual machine.
    :type fqdn: str
    :param lab_subnet_name: The lab subnet name of the virtual machine.
    :type lab_subnet_name: str
    :param lab_virtual_network_id: The lab virtual network identifier of the
     virtual machine.
    :type lab_virtual_network_id: str
    :param disallow_public_ip_address: Indicates whether the virtual machine
     is to be created without a public IP address.
    :type disallow_public_ip_address: bool
    :param artifacts: The artifacts to be installed on the virtual machine.
    :type artifacts:
     list[~azure.mgmt.devtestlabs.models.ArtifactInstallPropertiesFragment]
    :param artifact_deployment_status: The artifact deployment status for the
     virtual machine.
    :type artifact_deployment_status:
     ~azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusPropertiesFragment
    :param gallery_image_reference: The Microsoft Azure Marketplace image
     reference of the virtual machine.
    :type gallery_image_reference:
     ~azure.mgmt.devtestlabs.models.GalleryImageReferenceFragment
    :param plan_id: The id of the plan associated with the virtual machine
     image
    :type plan_id: str
    :param network_interface: The network interface properties.
    :type network_interface:
     ~azure.mgmt.devtestlabs.models.NetworkInterfacePropertiesFragment
    :param expiration_date: The expiration date for VM.
    :type expiration_date: datetime
    :param allow_claim: Indicates whether another user can take ownership of
     the virtual machine
    :type allow_claim: bool
    :param storage_type: Storage type to use for virtual machine (i.e.
     Standard, Premium).
    :type storage_type: str
    :param virtual_machine_creation_source: Tells source of creation of lab
     virtual machine. Output property only. Possible values include:
     'FromCustomImage', 'FromGalleryImage', 'FromSharedGalleryImage'
    :type virtual_machine_creation_source: str or
     ~azure.mgmt.devtestlabs.models.VirtualMachineCreationSource
    :param environment_id: The resource ID of the environment that contains
     this virtual machine, if any.
    :type environment_id: str
    :param data_disk_parameters: New or existing data disks to attach to the
     virtual machine after creation
    :type data_disk_parameters:
     list[~azure.mgmt.devtestlabs.models.DataDiskPropertiesFragment]
    :param schedule_parameters: Virtual Machine schedules to be created
    :type schedule_parameters:
     list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameterFragment]
    :param last_known_power_state: Last known compute power state captured in
     DTL
    :type last_known_power_state: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'owner_object_id': {'key': 'properties.ownerObjectId', 'type': 'str'},
        'owner_user_principal_name': {'key': 'properties.ownerUserPrincipalName', 'type': 'str'},
        'created_by_user_id': {'key': 'properties.createdByUserId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'compute_id': {'key': 'properties.computeId', 'type': 'str'},
        'custom_image_id': {'key': 'properties.customImageId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'ssh_key': {'key': 'properties.sshKey', 'type': 'str'},
        'is_authentication_with_ssh_key': {'key': 'properties.isAuthenticationWithSshKey', 'type': 'bool'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'lab_subnet_name': {'key': 'properties.labSubnetName', 'type': 'str'},
        'lab_virtual_network_id': {'key': 'properties.labVirtualNetworkId', 'type': 'str'},
        'disallow_public_ip_address': {'key': 'properties.disallowPublicIpAddress', 'type': 'bool'},
        'artifacts': {'key': 'properties.artifacts', 'type': '[ArtifactInstallPropertiesFragment]'},
        'artifact_deployment_status': {'key': 'properties.artifactDeploymentStatus', 'type': 'ArtifactDeploymentStatusPropertiesFragment'},
        'gallery_image_reference': {'key': 'properties.galleryImageReference', 'type': 'GalleryImageReferenceFragment'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'network_interface': {'key': 'properties.networkInterface', 'type': 'NetworkInterfacePropertiesFragment'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'allow_claim': {'key': 'properties.allowClaim', 'type': 'bool'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'virtual_machine_creation_source': {'key': 'properties.virtualMachineCreationSource', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'data_disk_parameters': {'key': 'properties.dataDiskParameters', 'type': '[DataDiskPropertiesFragment]'},
        'schedule_parameters': {'key': 'properties.scheduleParameters', 'type': '[ScheduleCreationParameterFragment]'},
        'last_known_power_state': {'key': 'properties.lastKnownPowerState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabVirtualMachineFragment, self).__init__(**kwargs)
        self.notes = kwargs.get('notes', None)
        self.owner_object_id = kwargs.get('owner_object_id', None)
        self.owner_user_principal_name = kwargs.get('owner_user_principal_name', None)
        self.created_by_user_id = kwargs.get('created_by_user_id', None)
        self.created_by_user = kwargs.get('created_by_user', None)
        self.created_date = kwargs.get('created_date', None)
        self.compute_id = kwargs.get('compute_id', None)
        self.custom_image_id = kwargs.get('custom_image_id', None)
        self.os_type = kwargs.get('os_type', None)
        self.size = kwargs.get('size', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.ssh_key = kwargs.get('ssh_key', None)
        self.is_authentication_with_ssh_key = kwargs.get('is_authentication_with_ssh_key', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.lab_subnet_name = kwargs.get('lab_subnet_name', None)
        self.lab_virtual_network_id = kwargs.get('lab_virtual_network_id', None)
        self.disallow_public_ip_address = kwargs.get('disallow_public_ip_address', None)
        self.artifacts = kwargs.get('artifacts', None)
        self.artifact_deployment_status = kwargs.get('artifact_deployment_status', None)
        self.gallery_image_reference = kwargs.get('gallery_image_reference', None)
        self.plan_id = kwargs.get('plan_id', None)
        self.network_interface = kwargs.get('network_interface', None)
        self.expiration_date = kwargs.get('expiration_date', None)
        self.allow_claim = kwargs.get('allow_claim', None)
        self.storage_type = kwargs.get('storage_type', None)
        self.virtual_machine_creation_source = kwargs.get('virtual_machine_creation_source', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.data_disk_parameters = kwargs.get('data_disk_parameters', None)
        self.schedule_parameters = kwargs.get('schedule_parameters', None)
        self.last_known_power_state = kwargs.get('last_known_power_state', None)


class LinuxOsInfo(Model):
    """Information about a Linux OS.

    :param linux_os_state: The state of the Linux OS (i.e. NonDeprovisioned,
     DeprovisionRequested, DeprovisionApplied). Possible values include:
     'NonDeprovisioned', 'DeprovisionRequested', 'DeprovisionApplied'
    :type linux_os_state: str or ~azure.mgmt.devtestlabs.models.LinuxOsState
    """

    _attribute_map = {
        'linux_os_state': {'key': 'linuxOsState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LinuxOsInfo, self).__init__(**kwargs)
        self.linux_os_state = kwargs.get('linux_os_state', None)


class LinuxOsInfoFragment(Model):
    """Information about a Linux OS.

    :param linux_os_state: The state of the Linux OS (i.e. NonDeprovisioned,
     DeprovisionRequested, DeprovisionApplied). Possible values include:
     'NonDeprovisioned', 'DeprovisionRequested', 'DeprovisionApplied'
    :type linux_os_state: str or ~azure.mgmt.devtestlabs.models.LinuxOsState
    """

    _attribute_map = {
        'linux_os_state': {'key': 'linuxOsState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LinuxOsInfoFragment, self).__init__(**kwargs)
        self.linux_os_state = kwargs.get('linux_os_state', None)


class NetworkInterfaceProperties(Model):
    """Properties of a network interface.

    :param virtual_network_id: The resource ID of the virtual network.
    :type virtual_network_id: str
    :param subnet_id: The resource ID of the sub net.
    :type subnet_id: str
    :param public_ip_address_id: The resource ID of the public IP address.
    :type public_ip_address_id: str
    :param public_ip_address: The public IP address.
    :type public_ip_address: str
    :param private_ip_address: The private IP address.
    :type private_ip_address: str
    :param dns_name: The DNS name.
    :type dns_name: str
    :param rdp_authority: The RdpAuthority property is a server DNS host name
     or IP address followed by the service port number for RDP (Remote Desktop
     Protocol).
    :type rdp_authority: str
    :param ssh_authority: The SshAuthority property is a server DNS host name
     or IP address followed by the service port number for SSH.
    :type ssh_authority: str
    :param shared_public_ip_address_configuration: The configuration for
     sharing a public IP address across multiple virtual machines.
    :type shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SharedPublicIpAddressConfiguration
    """

    _attribute_map = {
        'virtual_network_id': {'key': 'virtualNetworkId', 'type': 'str'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'public_ip_address_id': {'key': 'publicIpAddressId', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'dns_name': {'key': 'dnsName', 'type': 'str'},
        'rdp_authority': {'key': 'rdpAuthority', 'type': 'str'},
        'ssh_authority': {'key': 'sshAuthority', 'type': 'str'},
        'shared_public_ip_address_configuration': {'key': 'sharedPublicIpAddressConfiguration', 'type': 'SharedPublicIpAddressConfiguration'},
    }

    def __init__(self, **kwargs):
        super(NetworkInterfaceProperties, self).__init__(**kwargs)
        self.virtual_network_id = kwargs.get('virtual_network_id', None)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.public_ip_address_id = kwargs.get('public_ip_address_id', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.dns_name = kwargs.get('dns_name', None)
        self.rdp_authority = kwargs.get('rdp_authority', None)
        self.ssh_authority = kwargs.get('ssh_authority', None)
        self.shared_public_ip_address_configuration = kwargs.get('shared_public_ip_address_configuration', None)


class NetworkInterfacePropertiesFragment(Model):
    """Properties of a network interface.

    :param virtual_network_id: The resource ID of the virtual network.
    :type virtual_network_id: str
    :param subnet_id: The resource ID of the sub net.
    :type subnet_id: str
    :param public_ip_address_id: The resource ID of the public IP address.
    :type public_ip_address_id: str
    :param public_ip_address: The public IP address.
    :type public_ip_address: str
    :param private_ip_address: The private IP address.
    :type private_ip_address: str
    :param dns_name: The DNS name.
    :type dns_name: str
    :param rdp_authority: The RdpAuthority property is a server DNS host name
     or IP address followed by the service port number for RDP (Remote Desktop
     Protocol).
    :type rdp_authority: str
    :param ssh_authority: The SshAuthority property is a server DNS host name
     or IP address followed by the service port number for SSH.
    :type ssh_authority: str
    :param shared_public_ip_address_configuration: The configuration for
     sharing a public IP address across multiple virtual machines.
    :type shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SharedPublicIpAddressConfigurationFragment
    """

    _attribute_map = {
        'virtual_network_id': {'key': 'virtualNetworkId', 'type': 'str'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'public_ip_address_id': {'key': 'publicIpAddressId', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'dns_name': {'key': 'dnsName', 'type': 'str'},
        'rdp_authority': {'key': 'rdpAuthority', 'type': 'str'},
        'ssh_authority': {'key': 'sshAuthority', 'type': 'str'},
        'shared_public_ip_address_configuration': {'key': 'sharedPublicIpAddressConfiguration', 'type': 'SharedPublicIpAddressConfigurationFragment'},
    }

    def __init__(self, **kwargs):
        super(NetworkInterfacePropertiesFragment, self).__init__(**kwargs)
        self.virtual_network_id = kwargs.get('virtual_network_id', None)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.public_ip_address_id = kwargs.get('public_ip_address_id', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.dns_name = kwargs.get('dns_name', None)
        self.rdp_authority = kwargs.get('rdp_authority', None)
        self.ssh_authority = kwargs.get('ssh_authority', None)
        self.shared_public_ip_address_configuration = kwargs.get('shared_public_ip_address_configuration', None)


class NotificationChannel(Resource):
    """A notification.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param web_hook_url: The webhook URL to send notifications to.
    :type web_hook_url: str
    :param email_recipient: The email recipient to send notifications to (can
     be a list of semi-colon separated email addresses).
    :type email_recipient: str
    :param notification_locale: The locale to use when sending a notification
     (fallback for unsupported languages is EN).
    :type notification_locale: str
    :param description: Description of notification.
    :type description: str
    :param events: The list of event for which this notification is enabled.
    :type events: list[~azure.mgmt.devtestlabs.models.Event]
    :ivar created_date: The creation date of the notification channel.
    :vartype created_date: datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'web_hook_url': {'key': 'properties.webHookUrl', 'type': 'str'},
        'email_recipient': {'key': 'properties.emailRecipient', 'type': 'str'},
        'notification_locale': {'key': 'properties.notificationLocale', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'events': {'key': 'properties.events', 'type': '[Event]'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NotificationChannel, self).__init__(**kwargs)
        self.web_hook_url = kwargs.get('web_hook_url', None)
        self.email_recipient = kwargs.get('email_recipient', None)
        self.notification_locale = kwargs.get('notification_locale', None)
        self.description = kwargs.get('description', None)
        self.events = kwargs.get('events', None)
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class NotificationChannelFragment(UpdateResource):
    """A notification.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param web_hook_url: The webhook URL to send notifications to.
    :type web_hook_url: str
    :param email_recipient: The email recipient to send notifications to (can
     be a list of semi-colon separated email addresses).
    :type email_recipient: str
    :param notification_locale: The locale to use when sending a notification
     (fallback for unsupported languages is EN).
    :type notification_locale: str
    :param description: Description of notification.
    :type description: str
    :param events: The list of event for which this notification is enabled.
    :type events: list[~azure.mgmt.devtestlabs.models.EventFragment]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'web_hook_url': {'key': 'properties.webHookUrl', 'type': 'str'},
        'email_recipient': {'key': 'properties.emailRecipient', 'type': 'str'},
        'notification_locale': {'key': 'properties.notificationLocale', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'events': {'key': 'properties.events', 'type': '[EventFragment]'},
    }

    def __init__(self, **kwargs):
        super(NotificationChannelFragment, self).__init__(**kwargs)
        self.web_hook_url = kwargs.get('web_hook_url', None)
        self.email_recipient = kwargs.get('email_recipient', None)
        self.notification_locale = kwargs.get('notification_locale', None)
        self.description = kwargs.get('description', None)
        self.events = kwargs.get('events', None)


class NotificationSettings(Model):
    """Notification settings for a schedule.

    :param status: If notifications are enabled for this schedule (i.e.
     Enabled, Disabled). Possible values include: 'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param time_in_minutes: Time in minutes before event at which notification
     will be sent.
    :type time_in_minutes: int
    :param webhook_url: The webhook URL to which the notification will be
     sent.
    :type webhook_url: str
    :param email_recipient: The email recipient to send notifications to (can
     be a list of semi-colon separated email addresses).
    :type email_recipient: str
    :param notification_locale: The locale to use when sending a notification
     (fallback for unsupported languages is EN).
    :type notification_locale: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'time_in_minutes': {'key': 'timeInMinutes', 'type': 'int'},
        'webhook_url': {'key': 'webhookUrl', 'type': 'str'},
        'email_recipient': {'key': 'emailRecipient', 'type': 'str'},
        'notification_locale': {'key': 'notificationLocale', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NotificationSettings, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.time_in_minutes = kwargs.get('time_in_minutes', None)
        self.webhook_url = kwargs.get('webhook_url', None)
        self.email_recipient = kwargs.get('email_recipient', None)
        self.notification_locale = kwargs.get('notification_locale', None)


class NotificationSettingsFragment(Model):
    """Notification settings for a schedule.

    :param status: If notifications are enabled for this schedule (i.e.
     Enabled, Disabled). Possible values include: 'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param time_in_minutes: Time in minutes before event at which notification
     will be sent.
    :type time_in_minutes: int
    :param webhook_url: The webhook URL to which the notification will be
     sent.
    :type webhook_url: str
    :param email_recipient: The email recipient to send notifications to (can
     be a list of semi-colon separated email addresses).
    :type email_recipient: str
    :param notification_locale: The locale to use when sending a notification
     (fallback for unsupported languages is EN).
    :type notification_locale: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'time_in_minutes': {'key': 'timeInMinutes', 'type': 'int'},
        'webhook_url': {'key': 'webhookUrl', 'type': 'str'},
        'email_recipient': {'key': 'emailRecipient', 'type': 'str'},
        'notification_locale': {'key': 'notificationLocale', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NotificationSettingsFragment, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.time_in_minutes = kwargs.get('time_in_minutes', None)
        self.webhook_url = kwargs.get('webhook_url', None)
        self.email_recipient = kwargs.get('email_recipient', None)
        self.notification_locale = kwargs.get('notification_locale', None)


class NotifyParameters(Model):
    """Properties for generating a Notification.

    :param event_name: The type of event (i.e. AutoShutdown, Cost). Possible
     values include: 'AutoShutdown', 'Cost'
    :type event_name: str or
     ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
    :param json_payload: Properties for the notification in json format.
    :type json_payload: str
    """

    _attribute_map = {
        'event_name': {'key': 'eventName', 'type': 'str'},
        'json_payload': {'key': 'jsonPayload', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NotifyParameters, self).__init__(**kwargs)
        self.event_name = kwargs.get('event_name', None)
        self.json_payload = kwargs.get('json_payload', None)


class OperationError(Model):
    """Error details for the operation in case of a failure.

    :param code: The error code of the operation error.
    :type code: str
    :param message: The error message of the operation error.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class OperationMetadata(Model):
    """The REST API operation supported by DevTestLab ResourceProvider.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: The object that describes the operations
    :type display: ~azure.mgmt.devtestlabs.models.OperationMetadataDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationMetadataDisplay'},
    }

    def __init__(self, **kwargs):
        super(OperationMetadata, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationMetadataDisplay(Model):
    """The object that describes the operations.

    :param provider: Friendly name of the resource provider
    :type provider: str
    :param resource: Resource type on which the operation is performed.
    :type resource: str
    :param operation: Operation type: read, write, delete, listKeys/action,
     etc.
    :type operation: str
    :param description: Friendly name of the operation
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationMetadataDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationResult(Model):
    """An Operation Result.

    :param status: The operation status.
    :type status: str
    :param status_code: The status code for the operation. Possible values
     include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted',
     'NonAuthoritativeInformation', 'NoContent', 'ResetContent',
     'PartialContent', 'MultipleChoices', 'MovedPermanently', 'Redirect',
     'SeeOther', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect',
     'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound',
     'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired',
     'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired',
     'PreconditionFailed', 'RequestEntityTooLarge', 'RequestUriTooLong',
     'UnsupportedMediaType', 'RequestedRangeNotSatisfiable',
     'ExpectationFailed', 'UpgradeRequired', 'InternalServerError',
     'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout',
     'HttpVersionNotSupported'
    :type status_code: str or ~azure.mgmt.devtestlabs.models.HttpStatusCode
    :param error: Error details for the operation in case of a failure.
    :type error: ~azure.mgmt.devtestlabs.models.OperationError
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'error': {'key': 'error', 'type': 'OperationError'},
    }

    def __init__(self, **kwargs):
        super(OperationResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.status_code = kwargs.get('status_code', None)
        self.error = kwargs.get('error', None)


class ParameterInfo(Model):
    """Information about an artifact's parameter.

    :param name: The name of the artifact parameter.
    :type name: str
    :param value: The value of the artifact parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ParameterInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class ParametersValueFileInfo(Model):
    """A file containing a set of parameter values for an ARM template.

    :param file_name: File name.
    :type file_name: str
    :param parameters_value_info: Contents of the file.
    :type parameters_value_info: object
    """

    _attribute_map = {
        'file_name': {'key': 'fileName', 'type': 'str'},
        'parameters_value_info': {'key': 'parametersValueInfo', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(ParametersValueFileInfo, self).__init__(**kwargs)
        self.file_name = kwargs.get('file_name', None)
        self.parameters_value_info = kwargs.get('parameters_value_info', None)


class PercentageCostThresholdProperties(Model):
    """Properties of a percentage cost threshold.

    :param threshold_value: The cost threshold value.
    :type threshold_value: float
    """

    _attribute_map = {
        'threshold_value': {'key': 'thresholdValue', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(PercentageCostThresholdProperties, self).__init__(**kwargs)
        self.threshold_value = kwargs.get('threshold_value', None)


class Policy(Resource):
    """A Policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param description: The description of the policy.
    :type description: str
    :param status: The status of the policy. Possible values include:
     'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.PolicyStatus
    :param fact_name: The fact name of the policy (e.g. LabVmCount, LabVmSize,
     MaxVmsAllowedPerLab, etc. Possible values include: 'UserOwnedLabVmCount',
     'UserOwnedLabPremiumVmCount', 'LabVmCount', 'LabPremiumVmCount',
     'LabVmSize', 'GalleryImage', 'UserOwnedLabVmCountInSubnet',
     'LabTargetCost', 'EnvironmentTemplate', 'ScheduleEditPermission'
    :type fact_name: str or ~azure.mgmt.devtestlabs.models.PolicyFactName
    :param fact_data: The fact data of the policy.
    :type fact_data: str
    :param threshold: The threshold of the policy (i.e. a number for
     MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
    :type threshold: str
    :param evaluator_type: The evaluator type of the policy (i.e.
     AllowedValuesPolicy, MaxValuePolicy). Possible values include:
     'AllowedValuesPolicy', 'MaxValuePolicy'
    :type evaluator_type: str or
     ~azure.mgmt.devtestlabs.models.PolicyEvaluatorType
    :ivar created_date: The creation date of the policy.
    :vartype created_date: datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'fact_name': {'key': 'properties.factName', 'type': 'str'},
        'fact_data': {'key': 'properties.factData', 'type': 'str'},
        'threshold': {'key': 'properties.threshold', 'type': 'str'},
        'evaluator_type': {'key': 'properties.evaluatorType', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Policy, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.status = kwargs.get('status', None)
        self.fact_name = kwargs.get('fact_name', None)
        self.fact_data = kwargs.get('fact_data', None)
        self.threshold = kwargs.get('threshold', None)
        self.evaluator_type = kwargs.get('evaluator_type', None)
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class PolicyFragment(UpdateResource):
    """A Policy.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param description: The description of the policy.
    :type description: str
    :param status: The status of the policy. Possible values include:
     'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.PolicyStatus
    :param fact_name: The fact name of the policy (e.g. LabVmCount, LabVmSize,
     MaxVmsAllowedPerLab, etc. Possible values include: 'UserOwnedLabVmCount',
     'UserOwnedLabPremiumVmCount', 'LabVmCount', 'LabPremiumVmCount',
     'LabVmSize', 'GalleryImage', 'UserOwnedLabVmCountInSubnet',
     'LabTargetCost', 'EnvironmentTemplate', 'ScheduleEditPermission'
    :type fact_name: str or ~azure.mgmt.devtestlabs.models.PolicyFactName
    :param fact_data: The fact data of the policy.
    :type fact_data: str
    :param threshold: The threshold of the policy (i.e. a number for
     MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
    :type threshold: str
    :param evaluator_type: The evaluator type of the policy (i.e.
     AllowedValuesPolicy, MaxValuePolicy). Possible values include:
     'AllowedValuesPolicy', 'MaxValuePolicy'
    :type evaluator_type: str or
     ~azure.mgmt.devtestlabs.models.PolicyEvaluatorType
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'fact_name': {'key': 'properties.factName', 'type': 'str'},
        'fact_data': {'key': 'properties.factData', 'type': 'str'},
        'threshold': {'key': 'properties.threshold', 'type': 'str'},
        'evaluator_type': {'key': 'properties.evaluatorType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PolicyFragment, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.status = kwargs.get('status', None)
        self.fact_name = kwargs.get('fact_name', None)
        self.fact_data = kwargs.get('fact_data', None)
        self.threshold = kwargs.get('threshold', None)
        self.evaluator_type = kwargs.get('evaluator_type', None)


class PolicySetResult(Model):
    """Result of a policy set evaluation.

    :param has_error: A value indicating whether this policy set evaluation
     has discovered violations.
    :type has_error: bool
    :param policy_violations: The list of policy violations.
    :type policy_violations:
     list[~azure.mgmt.devtestlabs.models.PolicyViolation]
    """

    _attribute_map = {
        'has_error': {'key': 'hasError', 'type': 'bool'},
        'policy_violations': {'key': 'policyViolations', 'type': '[PolicyViolation]'},
    }

    def __init__(self, **kwargs):
        super(PolicySetResult, self).__init__(**kwargs)
        self.has_error = kwargs.get('has_error', None)
        self.policy_violations = kwargs.get('policy_violations', None)


class PolicyViolation(Model):
    """Policy violation.

    :param code: The code of the policy violation.
    :type code: str
    :param message: The message of the policy violation.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PolicyViolation, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Port(Model):
    """Properties of a network port.

    :param transport_protocol: Protocol type of the port. Possible values
     include: 'Tcp', 'Udp'
    :type transport_protocol: str or
     ~azure.mgmt.devtestlabs.models.TransportProtocol
    :param backend_port: Backend port of the target virtual machine.
    :type backend_port: int
    """

    _attribute_map = {
        'transport_protocol': {'key': 'transportProtocol', 'type': 'str'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Port, self).__init__(**kwargs)
        self.transport_protocol = kwargs.get('transport_protocol', None)
        self.backend_port = kwargs.get('backend_port', None)


class PortFragment(Model):
    """Properties of a network port.

    :param transport_protocol: Protocol type of the port. Possible values
     include: 'Tcp', 'Udp'
    :type transport_protocol: str or
     ~azure.mgmt.devtestlabs.models.TransportProtocol
    :param backend_port: Backend port of the target virtual machine.
    :type backend_port: int
    """

    _attribute_map = {
        'transport_protocol': {'key': 'transportProtocol', 'type': 'str'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(PortFragment, self).__init__(**kwargs)
        self.transport_protocol = kwargs.get('transport_protocol', None)
        self.backend_port = kwargs.get('backend_port', None)


class RdpConnection(Model):
    """Represents a .rdp file.

    :param contents: The contents of the .rdp file
    :type contents: str
    """

    _attribute_map = {
        'contents': {'key': 'contents', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RdpConnection, self).__init__(**kwargs)
        self.contents = kwargs.get('contents', None)


class ResizeLabVirtualMachineProperties(Model):
    """Request body for resizing a virtual machine.

    :param size: Specifies the size of the virtual machine.
    :type size: str
    """

    _attribute_map = {
        'size': {'key': 'size', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResizeLabVirtualMachineProperties, self).__init__(**kwargs)
        self.size = kwargs.get('size', None)


class RetargetScheduleProperties(Model):
    """Properties for retargeting a virtual machine schedule.

    :param current_resource_id: The resource Id of the virtual machine on
     which the schedule operates
    :type current_resource_id: str
    :param target_resource_id: The resource Id of the virtual machine that the
     schedule should be retargeted to
    :type target_resource_id: str
    """

    _attribute_map = {
        'current_resource_id': {'key': 'currentResourceId', 'type': 'str'},
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RetargetScheduleProperties, self).__init__(**kwargs)
        self.current_resource_id = kwargs.get('current_resource_id', None)
        self.target_resource_id = kwargs.get('target_resource_id', None)


class Schedule(Resource):
    """A schedule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the schedule (i.e. Enabled, Disabled).
     Possible values include: 'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param task_type: The task type of the schedule (e.g. LabVmsShutdownTask,
     LabVmAutoStart).
    :type task_type: str
    :param weekly_recurrence: If the schedule will occur only some days of the
     week, specify the weekly recurrence.
    :type weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetails
    :param daily_recurrence: If the schedule will occur once each day of the
     week, specify the daily recurrence.
    :type daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetails
    :param hourly_recurrence: If the schedule will occur multiple times a day,
     specify the hourly recurrence.
    :type hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetails
    :param time_zone_id: The time zone ID (e.g. Pacific Standard time).
    :type time_zone_id: str
    :param notification_settings: Notification settings.
    :type notification_settings:
     ~azure.mgmt.devtestlabs.models.NotificationSettings
    :ivar created_date: The creation date of the schedule.
    :vartype created_date: datetime
    :param target_resource_id: The resource ID to which the schedule belongs
    :type target_resource_id: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'task_type': {'key': 'properties.taskType', 'type': 'str'},
        'weekly_recurrence': {'key': 'properties.weeklyRecurrence', 'type': 'WeekDetails'},
        'daily_recurrence': {'key': 'properties.dailyRecurrence', 'type': 'DayDetails'},
        'hourly_recurrence': {'key': 'properties.hourlyRecurrence', 'type': 'HourDetails'},
        'time_zone_id': {'key': 'properties.timeZoneId', 'type': 'str'},
        'notification_settings': {'key': 'properties.notificationSettings', 'type': 'NotificationSettings'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Schedule, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.task_type = kwargs.get('task_type', None)
        self.weekly_recurrence = kwargs.get('weekly_recurrence', None)
        self.daily_recurrence = kwargs.get('daily_recurrence', None)
        self.hourly_recurrence = kwargs.get('hourly_recurrence', None)
        self.time_zone_id = kwargs.get('time_zone_id', None)
        self.notification_settings = kwargs.get('notification_settings', None)
        self.created_date = None
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.provisioning_state = None
        self.unique_identifier = None


class ScheduleCreationParameter(Model):
    """Properties for creating a schedule.

    :param status: The status of the schedule (i.e. Enabled, Disabled).
     Possible values include: 'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param task_type: The task type of the schedule (e.g. LabVmsShutdownTask,
     LabVmAutoStart).
    :type task_type: str
    :param weekly_recurrence: If the schedule will occur only some days of the
     week, specify the weekly recurrence.
    :type weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetails
    :param daily_recurrence: If the schedule will occur once each day of the
     week, specify the daily recurrence.
    :type daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetails
    :param hourly_recurrence: If the schedule will occur multiple times a day,
     specify the hourly recurrence.
    :type hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetails
    :param time_zone_id: The time zone ID (e.g. Pacific Standard time).
    :type time_zone_id: str
    :param notification_settings: Notification settings.
    :type notification_settings:
     ~azure.mgmt.devtestlabs.models.NotificationSettings
    :param target_resource_id: The resource ID to which the schedule belongs
    :type target_resource_id: str
    :param name: The name of the virtual machine or environment
    :type name: str
    :param location: The location of the new virtual machine or environment
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'status': {'key': 'properties.status', 'type': 'str'},
        'task_type': {'key': 'properties.taskType', 'type': 'str'},
        'weekly_recurrence': {'key': 'properties.weeklyRecurrence', 'type': 'WeekDetails'},
        'daily_recurrence': {'key': 'properties.dailyRecurrence', 'type': 'DayDetails'},
        'hourly_recurrence': {'key': 'properties.hourlyRecurrence', 'type': 'HourDetails'},
        'time_zone_id': {'key': 'properties.timeZoneId', 'type': 'str'},
        'notification_settings': {'key': 'properties.notificationSettings', 'type': 'NotificationSettings'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ScheduleCreationParameter, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.task_type = kwargs.get('task_type', None)
        self.weekly_recurrence = kwargs.get('weekly_recurrence', None)
        self.daily_recurrence = kwargs.get('daily_recurrence', None)
        self.hourly_recurrence = kwargs.get('hourly_recurrence', None)
        self.time_zone_id = kwargs.get('time_zone_id', None)
        self.notification_settings = kwargs.get('notification_settings', None)
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ScheduleCreationParameterFragment(Model):
    """Properties for creating a schedule.

    :param status: The status of the schedule (i.e. Enabled, Disabled).
     Possible values include: 'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param task_type: The task type of the schedule (e.g. LabVmsShutdownTask,
     LabVmAutoStart).
    :type task_type: str
    :param weekly_recurrence: If the schedule will occur only some days of the
     week, specify the weekly recurrence.
    :type weekly_recurrence:
     ~azure.mgmt.devtestlabs.models.WeekDetailsFragment
    :param daily_recurrence: If the schedule will occur once each day of the
     week, specify the daily recurrence.
    :type daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetailsFragment
    :param hourly_recurrence: If the schedule will occur multiple times a day,
     specify the hourly recurrence.
    :type hourly_recurrence:
     ~azure.mgmt.devtestlabs.models.HourDetailsFragment
    :param time_zone_id: The time zone ID (e.g. Pacific Standard time).
    :type time_zone_id: str
    :param notification_settings: Notification settings.
    :type notification_settings:
     ~azure.mgmt.devtestlabs.models.NotificationSettingsFragment
    :param target_resource_id: The resource ID to which the schedule belongs
    :type target_resource_id: str
    :param name: The name of the virtual machine or environment
    :type name: str
    :param location: The location of the new virtual machine or environment
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'status': {'key': 'properties.status', 'type': 'str'},
        'task_type': {'key': 'properties.taskType', 'type': 'str'},
        'weekly_recurrence': {'key': 'properties.weeklyRecurrence', 'type': 'WeekDetailsFragment'},
        'daily_recurrence': {'key': 'properties.dailyRecurrence', 'type': 'DayDetailsFragment'},
        'hourly_recurrence': {'key': 'properties.hourlyRecurrence', 'type': 'HourDetailsFragment'},
        'time_zone_id': {'key': 'properties.timeZoneId', 'type': 'str'},
        'notification_settings': {'key': 'properties.notificationSettings', 'type': 'NotificationSettingsFragment'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ScheduleCreationParameterFragment, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.task_type = kwargs.get('task_type', None)
        self.weekly_recurrence = kwargs.get('weekly_recurrence', None)
        self.daily_recurrence = kwargs.get('daily_recurrence', None)
        self.hourly_recurrence = kwargs.get('hourly_recurrence', None)
        self.time_zone_id = kwargs.get('time_zone_id', None)
        self.notification_settings = kwargs.get('notification_settings', None)
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ScheduleFragment(UpdateResource):
    """A schedule.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the schedule (i.e. Enabled, Disabled).
     Possible values include: 'Enabled', 'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param task_type: The task type of the schedule (e.g. LabVmsShutdownTask,
     LabVmAutoStart).
    :type task_type: str
    :param weekly_recurrence: If the schedule will occur only some days of the
     week, specify the weekly recurrence.
    :type weekly_recurrence:
     ~azure.mgmt.devtestlabs.models.WeekDetailsFragment
    :param daily_recurrence: If the schedule will occur once each day of the
     week, specify the daily recurrence.
    :type daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetailsFragment
    :param hourly_recurrence: If the schedule will occur multiple times a day,
     specify the hourly recurrence.
    :type hourly_recurrence:
     ~azure.mgmt.devtestlabs.models.HourDetailsFragment
    :param time_zone_id: The time zone ID (e.g. Pacific Standard time).
    :type time_zone_id: str
    :param notification_settings: Notification settings.
    :type notification_settings:
     ~azure.mgmt.devtestlabs.models.NotificationSettingsFragment
    :param target_resource_id: The resource ID to which the schedule belongs
    :type target_resource_id: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'task_type': {'key': 'properties.taskType', 'type': 'str'},
        'weekly_recurrence': {'key': 'properties.weeklyRecurrence', 'type': 'WeekDetailsFragment'},
        'daily_recurrence': {'key': 'properties.dailyRecurrence', 'type': 'DayDetailsFragment'},
        'hourly_recurrence': {'key': 'properties.hourlyRecurrence', 'type': 'HourDetailsFragment'},
        'time_zone_id': {'key': 'properties.timeZoneId', 'type': 'str'},
        'notification_settings': {'key': 'properties.notificationSettings', 'type': 'NotificationSettingsFragment'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ScheduleFragment, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.task_type = kwargs.get('task_type', None)
        self.weekly_recurrence = kwargs.get('weekly_recurrence', None)
        self.daily_recurrence = kwargs.get('daily_recurrence', None)
        self.hourly_recurrence = kwargs.get('hourly_recurrence', None)
        self.time_zone_id = kwargs.get('time_zone_id', None)
        self.notification_settings = kwargs.get('notification_settings', None)
        self.target_resource_id = kwargs.get('target_resource_id', None)


class Secret(Resource):
    """A secret.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param value: The value of the secret for secret creation.
    :type value: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Secret, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.provisioning_state = None
        self.unique_identifier = None


class SecretFragment(UpdateResource):
    """A secret.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param value: The value of the secret for secret creation.
    :type value: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'value': {'key': 'properties.value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecretFragment, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ServiceFabric(Resource):
    """A Service Fabric.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param external_service_fabric_id: The backing service fabric resource's
     id
    :type external_service_fabric_id: str
    :param environment_id: The resource id of the environment under which the
     service fabric resource is present
    :type environment_id: str
    :ivar applicable_schedule: The applicable schedule for the virtual
     machine.
    :vartype applicable_schedule:
     ~azure.mgmt.devtestlabs.models.ApplicableSchedule
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'applicable_schedule': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'external_service_fabric_id': {'key': 'properties.externalServiceFabricId', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'applicable_schedule': {'key': 'properties.applicableSchedule', 'type': 'ApplicableSchedule'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceFabric, self).__init__(**kwargs)
        self.external_service_fabric_id = kwargs.get('external_service_fabric_id', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.applicable_schedule = None
        self.provisioning_state = None
        self.unique_identifier = None


class ServiceFabricFragment(UpdateResource):
    """A Service Fabric.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param external_service_fabric_id: The backing service fabric resource's
     id
    :type external_service_fabric_id: str
    :param environment_id: The resource id of the environment under which the
     service fabric resource is present
    :type environment_id: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'external_service_fabric_id': {'key': 'properties.externalServiceFabricId', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceFabricFragment, self).__init__(**kwargs)
        self.external_service_fabric_id = kwargs.get('external_service_fabric_id', None)
        self.environment_id = kwargs.get('environment_id', None)


class ServiceRunner(Resource):
    """A container for a managed identity to execute DevTest lab services.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.devtestlabs.models.IdentityProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
    }

    def __init__(self, **kwargs):
        super(ServiceRunner, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)


class SharedPublicIpAddressConfiguration(Model):
    """Properties of a virtual machine that determine how it is connected to a
    load balancer.

    :param inbound_nat_rules: The incoming NAT rules
    :type inbound_nat_rules:
     list[~azure.mgmt.devtestlabs.models.InboundNatRule]
    """

    _attribute_map = {
        'inbound_nat_rules': {'key': 'inboundNatRules', 'type': '[InboundNatRule]'},
    }

    def __init__(self, **kwargs):
        super(SharedPublicIpAddressConfiguration, self).__init__(**kwargs)
        self.inbound_nat_rules = kwargs.get('inbound_nat_rules', None)


class SharedPublicIpAddressConfigurationFragment(Model):
    """Properties of a virtual machine that determine how it is connected to a
    load balancer.

    :param inbound_nat_rules: The incoming NAT rules
    :type inbound_nat_rules:
     list[~azure.mgmt.devtestlabs.models.InboundNatRuleFragment]
    """

    _attribute_map = {
        'inbound_nat_rules': {'key': 'inboundNatRules', 'type': '[InboundNatRuleFragment]'},
    }

    def __init__(self, **kwargs):
        super(SharedPublicIpAddressConfigurationFragment, self).__init__(**kwargs)
        self.inbound_nat_rules = kwargs.get('inbound_nat_rules', None)


class ShutdownNotificationContent(Model):
    """The contents of a shutdown notification. Webhooks can use this type to
    deserialize the request body when they get notified of an imminent
    shutdown.

    :param skip_url: The URL to skip auto-shutdown.
    :type skip_url: str
    :param delay_url60: The URL to delay shutdown by 60 minutes.
    :type delay_url60: str
    :param delay_url120: The URL to delay shutdown by 2 hours.
    :type delay_url120: str
    :param vm_name: The virtual machine to be shut down.
    :type vm_name: str
    :param guid: The GUID for the virtual machine to be shut down.
    :type guid: str
    :param owner: The owner of the virtual machine.
    :type owner: str
    :param vm_url: The URL of the virtual machine.
    :type vm_url: str
    :param minutes_until_shutdown: Minutes remaining until shutdown
    :type minutes_until_shutdown: str
    :param event_type: The event for which a notification will be sent.
    :type event_type: str
    :param text: The text for the notification.
    :type text: str
    :param subscription_id: The subscription ID for the schedule.
    :type subscription_id: str
    :param resource_group_name: The resource group name for the schedule.
    :type resource_group_name: str
    :param lab_name: The lab for the schedule.
    :type lab_name: str
    """

    _attribute_map = {
        'skip_url': {'key': 'skipUrl', 'type': 'str'},
        'delay_url60': {'key': 'delayUrl60', 'type': 'str'},
        'delay_url120': {'key': 'delayUrl120', 'type': 'str'},
        'vm_name': {'key': 'vmName', 'type': 'str'},
        'guid': {'key': 'guid', 'type': 'str'},
        'owner': {'key': 'owner', 'type': 'str'},
        'vm_url': {'key': 'vmUrl', 'type': 'str'},
        'minutes_until_shutdown': {'key': 'minutesUntilShutdown', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'lab_name': {'key': 'labName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ShutdownNotificationContent, self).__init__(**kwargs)
        self.skip_url = kwargs.get('skip_url', None)
        self.delay_url60 = kwargs.get('delay_url60', None)
        self.delay_url120 = kwargs.get('delay_url120', None)
        self.vm_name = kwargs.get('vm_name', None)
        self.guid = kwargs.get('guid', None)
        self.owner = kwargs.get('owner', None)
        self.vm_url = kwargs.get('vm_url', None)
        self.minutes_until_shutdown = kwargs.get('minutes_until_shutdown', None)
        self.event_type = kwargs.get('event_type', None)
        self.text = kwargs.get('text', None)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group_name = kwargs.get('resource_group_name', None)
        self.lab_name = kwargs.get('lab_name', None)


class Subnet(Model):
    """Subnet information.

    :param resource_id: The resource ID of the subnet.
    :type resource_id: str
    :param lab_subnet_name: The name of the subnet as seen in the lab.
    :type lab_subnet_name: str
    :param allow_public_ip: The permission policy of the subnet for allowing
     public IP addresses (i.e. Allow, Deny)). Possible values include:
     'Default', 'Deny', 'Allow'
    :type allow_public_ip: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'lab_subnet_name': {'key': 'labSubnetName', 'type': 'str'},
        'allow_public_ip': {'key': 'allowPublicIp', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Subnet, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.lab_subnet_name = kwargs.get('lab_subnet_name', None)
        self.allow_public_ip = kwargs.get('allow_public_ip', None)


class SubnetFragment(Model):
    """Subnet information.

    :param resource_id: The resource ID of the subnet.
    :type resource_id: str
    :param lab_subnet_name: The name of the subnet as seen in the lab.
    :type lab_subnet_name: str
    :param allow_public_ip: The permission policy of the subnet for allowing
     public IP addresses (i.e. Allow, Deny)). Possible values include:
     'Default', 'Deny', 'Allow'
    :type allow_public_ip: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'lab_subnet_name': {'key': 'labSubnetName', 'type': 'str'},
        'allow_public_ip': {'key': 'allowPublicIp', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubnetFragment, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.lab_subnet_name = kwargs.get('lab_subnet_name', None)
        self.allow_public_ip = kwargs.get('allow_public_ip', None)


class SubnetOverride(Model):
    """Property overrides on a subnet of a virtual network.

    :param resource_id: The resource ID of the subnet.
    :type resource_id: str
    :param lab_subnet_name: The name given to the subnet within the lab.
    :type lab_subnet_name: str
    :param use_in_vm_creation_permission: Indicates whether this subnet can be
     used during virtual machine creation (i.e. Allow, Deny). Possible values
     include: 'Default', 'Deny', 'Allow'
    :type use_in_vm_creation_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param use_public_ip_address_permission: Indicates whether public IP
     addresses can be assigned to virtual machines on this subnet (i.e. Allow,
     Deny). Possible values include: 'Default', 'Deny', 'Allow'
    :type use_public_ip_address_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param shared_public_ip_address_configuration: Properties that virtual
     machines on this subnet will share.
    :type shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SubnetSharedPublicIpAddressConfiguration
    :param virtual_network_pool_name: The virtual network pool associated with
     this subnet.
    :type virtual_network_pool_name: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'lab_subnet_name': {'key': 'labSubnetName', 'type': 'str'},
        'use_in_vm_creation_permission': {'key': 'useInVmCreationPermission', 'type': 'str'},
        'use_public_ip_address_permission': {'key': 'usePublicIpAddressPermission', 'type': 'str'},
        'shared_public_ip_address_configuration': {'key': 'sharedPublicIpAddressConfiguration', 'type': 'SubnetSharedPublicIpAddressConfiguration'},
        'virtual_network_pool_name': {'key': 'virtualNetworkPoolName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubnetOverride, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.lab_subnet_name = kwargs.get('lab_subnet_name', None)
        self.use_in_vm_creation_permission = kwargs.get('use_in_vm_creation_permission', None)
        self.use_public_ip_address_permission = kwargs.get('use_public_ip_address_permission', None)
        self.shared_public_ip_address_configuration = kwargs.get('shared_public_ip_address_configuration', None)
        self.virtual_network_pool_name = kwargs.get('virtual_network_pool_name', None)


class SubnetOverrideFragment(Model):
    """Property overrides on a subnet of a virtual network.

    :param resource_id: The resource ID of the subnet.
    :type resource_id: str
    :param lab_subnet_name: The name given to the subnet within the lab.
    :type lab_subnet_name: str
    :param use_in_vm_creation_permission: Indicates whether this subnet can be
     used during virtual machine creation (i.e. Allow, Deny). Possible values
     include: 'Default', 'Deny', 'Allow'
    :type use_in_vm_creation_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param use_public_ip_address_permission: Indicates whether public IP
     addresses can be assigned to virtual machines on this subnet (i.e. Allow,
     Deny). Possible values include: 'Default', 'Deny', 'Allow'
    :type use_public_ip_address_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param shared_public_ip_address_configuration: Properties that virtual
     machines on this subnet will share.
    :type shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SubnetSharedPublicIpAddressConfigurationFragment
    :param virtual_network_pool_name: The virtual network pool associated with
     this subnet.
    :type virtual_network_pool_name: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'lab_subnet_name': {'key': 'labSubnetName', 'type': 'str'},
        'use_in_vm_creation_permission': {'key': 'useInVmCreationPermission', 'type': 'str'},
        'use_public_ip_address_permission': {'key': 'usePublicIpAddressPermission', 'type': 'str'},
        'shared_public_ip_address_configuration': {'key': 'sharedPublicIpAddressConfiguration', 'type': 'SubnetSharedPublicIpAddressConfigurationFragment'},
        'virtual_network_pool_name': {'key': 'virtualNetworkPoolName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubnetOverrideFragment, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.lab_subnet_name = kwargs.get('lab_subnet_name', None)
        self.use_in_vm_creation_permission = kwargs.get('use_in_vm_creation_permission', None)
        self.use_public_ip_address_permission = kwargs.get('use_public_ip_address_permission', None)
        self.shared_public_ip_address_configuration = kwargs.get('shared_public_ip_address_configuration', None)
        self.virtual_network_pool_name = kwargs.get('virtual_network_pool_name', None)


class SubnetSharedPublicIpAddressConfiguration(Model):
    """Configuration for public IP address sharing.

    :param allowed_ports: Backend ports that virtual machines on this subnet
     are allowed to expose
    :type allowed_ports: list[~azure.mgmt.devtestlabs.models.Port]
    """

    _attribute_map = {
        'allowed_ports': {'key': 'allowedPorts', 'type': '[Port]'},
    }

    def __init__(self, **kwargs):
        super(SubnetSharedPublicIpAddressConfiguration, self).__init__(**kwargs)
        self.allowed_ports = kwargs.get('allowed_ports', None)


class SubnetSharedPublicIpAddressConfigurationFragment(Model):
    """Configuration for public IP address sharing.

    :param allowed_ports: Backend ports that virtual machines on this subnet
     are allowed to expose
    :type allowed_ports: list[~azure.mgmt.devtestlabs.models.PortFragment]
    """

    _attribute_map = {
        'allowed_ports': {'key': 'allowedPorts', 'type': '[PortFragment]'},
    }

    def __init__(self, **kwargs):
        super(SubnetSharedPublicIpAddressConfigurationFragment, self).__init__(**kwargs)
        self.allowed_ports = kwargs.get('allowed_ports', None)


class TargetCostProperties(Model):
    """Properties of a cost target.

    :param status: Target cost status. Possible values include: 'Enabled',
     'Disabled'
    :type status: str or ~azure.mgmt.devtestlabs.models.TargetCostStatus
    :param target: Lab target cost
    :type target: int
    :param cost_thresholds: Cost thresholds.
    :type cost_thresholds:
     list[~azure.mgmt.devtestlabs.models.CostThresholdProperties]
    :param cycle_start_date_time: Reporting cycle start date.
    :type cycle_start_date_time: datetime
    :param cycle_end_date_time: Reporting cycle end date.
    :type cycle_end_date_time: datetime
    :param cycle_type: Reporting cycle type. Possible values include:
     'CalendarMonth', 'Custom'
    :type cycle_type: str or ~azure.mgmt.devtestlabs.models.ReportingCycleType
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'target': {'key': 'target', 'type': 'int'},
        'cost_thresholds': {'key': 'costThresholds', 'type': '[CostThresholdProperties]'},
        'cycle_start_date_time': {'key': 'cycleStartDateTime', 'type': 'iso-8601'},
        'cycle_end_date_time': {'key': 'cycleEndDateTime', 'type': 'iso-8601'},
        'cycle_type': {'key': 'cycleType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TargetCostProperties, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.target = kwargs.get('target', None)
        self.cost_thresholds = kwargs.get('cost_thresholds', None)
        self.cycle_start_date_time = kwargs.get('cycle_start_date_time', None)
        self.cycle_end_date_time = kwargs.get('cycle_end_date_time', None)
        self.cycle_type = kwargs.get('cycle_type', None)


class User(Resource):
    """Profile of a lab user.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param identity: The identity of the user.
    :type identity: ~azure.mgmt.devtestlabs.models.UserIdentity
    :param secret_store: The secret store of the user.
    :type secret_store: ~azure.mgmt.devtestlabs.models.UserSecretStore
    :ivar created_date: The creation date of the user profile.
    :vartype created_date: datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'properties.identity', 'type': 'UserIdentity'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'UserSecretStore'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(User, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.secret_store = kwargs.get('secret_store', None)
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class UserFragment(UpdateResource):
    """Profile of a lab user.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param identity: The identity of the user.
    :type identity: ~azure.mgmt.devtestlabs.models.UserIdentityFragment
    :param secret_store: The secret store of the user.
    :type secret_store: ~azure.mgmt.devtestlabs.models.UserSecretStoreFragment
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'properties.identity', 'type': 'UserIdentityFragment'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'UserSecretStoreFragment'},
    }

    def __init__(self, **kwargs):
        super(UserFragment, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.secret_store = kwargs.get('secret_store', None)


class UserIdentity(Model):
    """Identity attributes of a lab user.

    :param principal_name: Set to the principal name / UPN of the client JWT
     making the request.
    :type principal_name: str
    :param principal_id: Set to the principal Id of the client JWT making the
     request. Service principal will not have the principal Id.
    :type principal_id: str
    :param tenant_id: Set to the tenant ID of the client JWT making the
     request.
    :type tenant_id: str
    :param object_id: Set to the object Id of the client JWT making the
     request. Not all users have object Id. For CSP (reseller) scenarios for
     example, object Id is not available.
    :type object_id: str
    :param app_id: Set to the app Id of the client JWT making the request.
    :type app_id: str
    """

    _attribute_map = {
        'principal_name': {'key': 'principalName', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'app_id': {'key': 'appId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserIdentity, self).__init__(**kwargs)
        self.principal_name = kwargs.get('principal_name', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.object_id = kwargs.get('object_id', None)
        self.app_id = kwargs.get('app_id', None)


class UserIdentityFragment(Model):
    """Identity attributes of a lab user.

    :param principal_name: Set to the principal name / UPN of the client JWT
     making the request.
    :type principal_name: str
    :param principal_id: Set to the principal Id of the client JWT making the
     request. Service principal will not have the principal Id.
    :type principal_id: str
    :param tenant_id: Set to the tenant ID of the client JWT making the
     request.
    :type tenant_id: str
    :param object_id: Set to the object Id of the client JWT making the
     request. Not all users have object Id. For CSP (reseller) scenarios for
     example, object Id is not available.
    :type object_id: str
    :param app_id: Set to the app Id of the client JWT making the request.
    :type app_id: str
    """

    _attribute_map = {
        'principal_name': {'key': 'principalName', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'app_id': {'key': 'appId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserIdentityFragment, self).__init__(**kwargs)
        self.principal_name = kwargs.get('principal_name', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.object_id = kwargs.get('object_id', None)
        self.app_id = kwargs.get('app_id', None)


class UserSecretStore(Model):
    """Properties of a user's secret store.

    :param key_vault_uri: The URI of the user's Key vault.
    :type key_vault_uri: str
    :param key_vault_id: The ID of the user's Key vault.
    :type key_vault_id: str
    """

    _attribute_map = {
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserSecretStore, self).__init__(**kwargs)
        self.key_vault_uri = kwargs.get('key_vault_uri', None)
        self.key_vault_id = kwargs.get('key_vault_id', None)


class UserSecretStoreFragment(Model):
    """Properties of a user's secret store.

    :param key_vault_uri: The URI of the user's Key vault.
    :type key_vault_uri: str
    :param key_vault_id: The ID of the user's Key vault.
    :type key_vault_id: str
    """

    _attribute_map = {
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserSecretStoreFragment, self).__init__(**kwargs)
        self.key_vault_uri = kwargs.get('key_vault_uri', None)
        self.key_vault_id = kwargs.get('key_vault_id', None)


class VirtualNetwork(Resource):
    """A virtual network.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param allowed_subnets: The allowed subnets of the virtual network.
    :type allowed_subnets: list[~azure.mgmt.devtestlabs.models.Subnet]
    :param description: The description of the virtual network.
    :type description: str
    :param external_provider_resource_id: The Microsoft.Network resource
     identifier of the virtual network.
    :type external_provider_resource_id: str
    :ivar external_subnets: The external subnet properties.
    :vartype external_subnets:
     list[~azure.mgmt.devtestlabs.models.ExternalSubnet]
    :param subnet_overrides: The subnet overrides of the virtual network.
    :type subnet_overrides:
     list[~azure.mgmt.devtestlabs.models.SubnetOverride]
    :ivar created_date: The creation date of the virtual network.
    :vartype created_date: datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'external_subnets': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'allowed_subnets': {'key': 'properties.allowedSubnets', 'type': '[Subnet]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_provider_resource_id': {'key': 'properties.externalProviderResourceId', 'type': 'str'},
        'external_subnets': {'key': 'properties.externalSubnets', 'type': '[ExternalSubnet]'},
        'subnet_overrides': {'key': 'properties.subnetOverrides', 'type': '[SubnetOverride]'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetwork, self).__init__(**kwargs)
        self.allowed_subnets = kwargs.get('allowed_subnets', None)
        self.description = kwargs.get('description', None)
        self.external_provider_resource_id = kwargs.get('external_provider_resource_id', None)
        self.external_subnets = None
        self.subnet_overrides = kwargs.get('subnet_overrides', None)
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class VirtualNetworkFragment(UpdateResource):
    """A virtual network.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param allowed_subnets: The allowed subnets of the virtual network.
    :type allowed_subnets: list[~azure.mgmt.devtestlabs.models.SubnetFragment]
    :param description: The description of the virtual network.
    :type description: str
    :param external_provider_resource_id: The Microsoft.Network resource
     identifier of the virtual network.
    :type external_provider_resource_id: str
    :param subnet_overrides: The subnet overrides of the virtual network.
    :type subnet_overrides:
     list[~azure.mgmt.devtestlabs.models.SubnetOverrideFragment]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'allowed_subnets': {'key': 'properties.allowedSubnets', 'type': '[SubnetFragment]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_provider_resource_id': {'key': 'properties.externalProviderResourceId', 'type': 'str'},
        'subnet_overrides': {'key': 'properties.subnetOverrides', 'type': '[SubnetOverrideFragment]'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkFragment, self).__init__(**kwargs)
        self.allowed_subnets = kwargs.get('allowed_subnets', None)
        self.description = kwargs.get('description', None)
        self.external_provider_resource_id = kwargs.get('external_provider_resource_id', None)
        self.subnet_overrides = kwargs.get('subnet_overrides', None)


class WeekDetails(Model):
    """Properties of a weekly schedule.

    :param weekdays: The days of the week for which the schedule is set (e.g.
     Sunday, Monday, Tuesday, etc.).
    :type weekdays: list[str]
    :param time: The time of the day the schedule will occur.
    :type time: str
    """

    _attribute_map = {
        'weekdays': {'key': 'weekdays', 'type': '[str]'},
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WeekDetails, self).__init__(**kwargs)
        self.weekdays = kwargs.get('weekdays', None)
        self.time = kwargs.get('time', None)


class WeekDetailsFragment(Model):
    """Properties of a weekly schedule.

    :param weekdays: The days of the week for which the schedule is set (e.g.
     Sunday, Monday, Tuesday, etc.).
    :type weekdays: list[str]
    :param time: The time of the day the schedule will occur.
    :type time: str
    """

    _attribute_map = {
        'weekdays': {'key': 'weekdays', 'type': '[str]'},
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WeekDetailsFragment, self).__init__(**kwargs)
        self.weekdays = kwargs.get('weekdays', None)
        self.time = kwargs.get('time', None)


class WindowsOsInfo(Model):
    """Information about a Windows OS.

    :param windows_os_state: The state of the Windows OS (i.e. NonSysprepped,
     SysprepRequested, SysprepApplied). Possible values include:
     'NonSysprepped', 'SysprepRequested', 'SysprepApplied'
    :type windows_os_state: str or
     ~azure.mgmt.devtestlabs.models.WindowsOsState
    """

    _attribute_map = {
        'windows_os_state': {'key': 'windowsOsState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WindowsOsInfo, self).__init__(**kwargs)
        self.windows_os_state = kwargs.get('windows_os_state', None)


class WindowsOsInfoFragment(Model):
    """Information about a Windows OS.

    :param windows_os_state: The state of the Windows OS (i.e. NonSysprepped,
     SysprepRequested, SysprepApplied). Possible values include:
     'NonSysprepped', 'SysprepRequested', 'SysprepApplied'
    :type windows_os_state: str or
     ~azure.mgmt.devtestlabs.models.WindowsOsState
    """

    _attribute_map = {
        'windows_os_state': {'key': 'windowsOsState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WindowsOsInfoFragment, self).__init__(**kwargs)
        self.windows_os_state = kwargs.get('windows_os_state', None)
