#!/usr/bin/python

"""Create power domains for one-meter systems."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import popen2
import discovery
import pwrkap_data
import sys

# Note: This code does not autodetect systems with multiple power domains!

def default_system_discover():
	"""Configure power domain on single-meter systems."""
	if len(discovery.PWRKAP_POWER_METERS) > 1 or \
	   len(discovery.PWRKAP_ENERGY_METERS) > 1 or \
	   (len(discovery.PWRKAP_POWER_METERS) == 0 and \
	    len(discovery.PWRKAP_ENERGY_METERS) == 0):
		return

	# Take the sensor
	pmeter = discovery.PWRKAP_POWER_METERS[0]
	emeter = discovery.PWRKAP_POWER_METERS[0]

	# No devices?
	if len(discovery.PWRKAP_DEVICES) == 0:
		return

	# Assume all CPUs have identical power curves
	idomain = []
	for device in discovery.PWRKAP_DEVICES:
		(name, data) = device.inventory()
		if not name.startswith("cpu"):
			continue
		idomain.append(device)

	if len(idomain) < 1:
		print "No power-manageable devices found."
		sys.exit(1)

	# Take all device domains for this power domain
	domains = discovery.PWRKAP_DEVICE_DOMAINS

	# Remove all devices, domains, and meters that we intend to use.
	discovery.PWRKAP_DEVICES = []
	discovery.PWRKAP_DEVICE_DOMAINS = []
	discovery.PWRKAP_POWER_METERS = []
	discovery.PWRKAP_ENERGY_METERS = []

	# Create power domain
	pd = pwrkap_data.power_domain(domains, [idomain], pmeter, emeter, 1000)
	discovery.PWRKAP_POWER_DOMAINS.append(pd)

def default_init():
	"""Set up default system discovery functions."""
	discovery.PWRKAP_POWER_DOMAIN_DISCOVERY.append(default_system_discover)
