/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Misc helperfunctions used throughout the program 
 *
 * Copyright (C) 2003-2006 Isak Savo
 */
#ifndef __HELPER_H__
#define __HELPER_H__
#include <glib.h>

gint arr_count (gchar **arr);
gboolean misc_str_is_only_whitespace (const gchar *s1);
gchar **create_array (gint *argc_out, ...);

gchar *misc_spawn_command (const gchar *cmdline);
gchar *misc_get_process_info (const gchar *pid, const gchar *file);

gchar *string_to_utf8 (const gchar *str);
gchar *string_to_vuser_locale (const char *str);
gchar *string_from_vuser_locale (const char *str);

gchar *filename_without_extension (const gchar *filename);
gboolean misc_str_isearch (const gchar *haystack, const gchar *needle);

gchar *pur_elipzise (const gchar *orig_s, guint len);

gboolean misc_stop_server (GError **err);
gboolean misc_start_server (GError **err);

gint misc_close_connection (guint pid);
gint misc_get_pureftpd_pid (void);

gchar *misc_find_file_in_dirs (const gchar *filename, const gchar *dirs);
gchar *misc_find_prog_in_dirs (const gchar *filename, const gchar *dirs);
gchar *misc_get_line_beginning_with (const gchar *filename, const gchar *needle);

gchar *misc_find_webbrowser (void);

gboolean misc_create_passwd_file (const gchar *filename);

gboolean misc_create_directory (const gchar *directory, gint uid, gint gid, GError **err);
gchar *misc_crypt_passwd (const gchar * const pwd);

#define MISC_VALID_STRING(s) ((s != NULL && *(s) != 0))

#define PUREADMIN_MAIN_ERROR g_quark_from_static_string ("PUREADMIN_MAIN")

typedef enum
{
	PA_MAIN_ERROR_COMMAND_NOT_FOUND,
	PA_MAIN_ERROR_PERMISSION_DENIED,
	PA_MAIN_ERROR_FAILED
} PureadminMainError;

#endif /* __HELPER_H__ */
