/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __PILENOMMACRO__
#define __PILENOMMACRO__

#include <src/global/global.h>

typedef struct pilenommacro CONTENEUR(PileNomMacro);

struct pilenommacro
{
	STOCKAGE_SCALAIRE(NomMacro) nommacro;
	//NomMacro  conserver au chaud.
	STOCKAGE_SCALAIRE(Entier) niveauimbrication;
	//Sert  indiquer le degr d'imbrication dans un autre
	//appel de macro.
	STOCKAGE(PileNomMacro) suivant;
	//Pointeur sur le suivant.
};
/* Pile de nom de macros utilises lors de l'analyse de l'entre de
 * planfacile, et grrrrmbl  bison et flex !
 */

Resultat pilenommacro_initialisation(TRAVAIL(PileNomMacro) pilenommacro);
/* Cre une pile de nom de macros.
 */

Resultat pilenommacro_ajout(TRAVAIL(PileNomMacro) pilenommacro , TRAVAIL_SCALAIRE(NomMacro) nommacro , TRAVAIL_SCALAIRE(Entier) niveauimbrication);
/* Ajoute un nom de macro au sommet de la pile.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat pilenommacro_retrait(TRAVAIL(PileNomMacro) pilenommacro , COREFERENCE_SCALAIRE(NomMacro) nommacro);
/* Retire le sommet de la pile, et renvoye le nom de macro.
 * Renvoie RESULTAT_ERREUR si la pile est vide.
 * Il faudra librer le nom de macro renvoy  la main.
 */

Resultat pilenommacro_definition_niveauimbrication(TRAVAIL(PileNomMacro) pilenommacro , TRAVAIL_SCALAIRE(Entier) niveauimbrication);
/* Dfinit un niveau d'imbrication d'appel de macro
 * Renvoie RESULTAT_ERREUR si pilenommacro vaut NULL
 */

Resultat pilenommacro_echange(TRAVAIL(PileNomMacro) pilenommacro);
/* Echange les 2 premiers lments de la pile.
 * Renvoie RESULTAT_ERREUR si la pile est vide.
 * Ne fait rien si la pile contient moins de 2 lments.
 */

Resultat pilenommacro_appels_successifs(TRAVAIL(PileNomMacro) pilenommacro , REFERENCE_SCALAIRE(Booleen) appels_successifs);
/* Renvoie VRAI dans appels_successifs si les 2 premiers noms
 * de macro correspondent  des appels successifs.
 * Renvoie FAUX si la pile contient moins de 2 lments.
 */

Resultat pilenommacro_lecture_nom(TRAVAIL(PileNomMacro) pilenommacro , REFERENCE_SCALAIRE(NomMacro) nommacro);
/* Lit le sommet et renvoye le nom de macro.
 * Renvoie RESULTAT_ERREUR si la pile est vide.
 */

Resultat pilenommacro_vide(TRAVAIL(PileNomMacro) pilenommacro , REFERENCE_SCALAIRE(Booleen) vide);
/* Renvoie VRAI dans vide si la pile est vide.
 */

Resultat pilenommacro_copie(TRAVAIL(PileNomMacro) pilenommacro , TRAVAIL(PileNomMacro) copie);
/* Ralise une copie de la pile.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 * La copie est dtruite si elle est non vide.
 */

Resultat pilenommacro_destruction(TRAVAIL(PileNomMacro) pilenommacro);
/* Dtruit une pile de nom de macros.
 */

#endif
