############## mysql-test\t\transaction_alloc_block_size_basic.test ###########
#                                                                             #
# Variable Name: transaction_alloc_block_size                                 #
# Scope: GLOBAL | SESSION                                                     #
# Access Type: Dynamic                                                        #
# Data Type: numeric                                                          #
# Default Value: 8192                                                         #
# Range: 1024-4294967295                                                      #
#                                                                             #
#                                                                             #
# Creation Date: 2008-02-14                                                   #
# Author:  Salman                                                             #
#                                                                             #
# Description: Test Cases of Dynamic System Variable                          #
#              transaction_alloc_block_size                                   #
#              that checks the behavior of this variable in the following ways#
#              * Default Value                                                #
#              * Valid & Invalid values                                       #
#              * Scope & Access method                                        #
#              * Data Integrity                                               #
#                                                                             #
# Reference: http://dev.mysql.com/doc/refman/5.1/en/                          #
#  server-system-variables.html                                               #
#                                                                             #
###############################################################################

--source include/load_sysvars.inc

########################################################################
#           START OF transaction_alloc_block_size TESTS                #
########################################################################


#############################################################
#                 Save initial value                        #
#############################################################

SET @start_global_value = @@global.transaction_alloc_block_size;
SELECT @start_global_value;
SET @start_session_value = @@session.transaction_alloc_block_size;
SELECT @start_session_value;


--echo '#--------------------FN_DYNVARS_005_01-------------------------#'
########################################################################
#     Display the DEFAULT value of transaction_alloc_block_size        #
########################################################################

SET @@global.transaction_alloc_block_size = 100;
SET @@global.transaction_alloc_block_size = DEFAULT;
SELECT @@global.transaction_alloc_block_size;


SET @@session.transaction_alloc_block_size = 200;
SET @@session.transaction_alloc_block_size = DEFAULT;
SELECT @@session.transaction_alloc_block_size;



--echo '#--------------------FN_DYNVARS_005_02-------------------------#'
########################################################################
#     Check the DEFAULT value of transaction_alloc_block_size          #
########################################################################

SET @@global.transaction_alloc_block_size = DEFAULT;
SELECT @@global.transaction_alloc_block_size = 8192;

SET @@session.transaction_alloc_block_size = DEFAULT;
SELECT @@session.transaction_alloc_block_size = 8192;


--echo '#--------------------FN_DYNVARS_005_03-------------------------#'
##################################################################
# Change the value of variable to a valid value for GLOBAL Scope #
##################################################################

SET @@global.transaction_alloc_block_size = 1024;
SELECT @@global.transaction_alloc_block_size;

SET @@global.transaction_alloc_block_size = 60020;
SELECT @@global.transaction_alloc_block_size;

SET @@global.transaction_alloc_block_size = 4294967295;
SELECT @@global.transaction_alloc_block_size;
--echo 'Bug# 34877: Invalid Values are coming in variable on assigning valid values';

--echo '#--------------------FN_DYNVARS_005_04-------------------------#'
###################################################################
# Change the value of variable to a valid value for SESSION Scope #
###################################################################
 
SET @@session.transaction_alloc_block_size = 1024;
SELECT @@session.transaction_alloc_block_size;

SET @@session.transaction_alloc_block_size =4294967295;
SELECT @@session.transaction_alloc_block_size;

SET @@session.transaction_alloc_block_size = 65535;
SELECT @@session.transaction_alloc_block_size;
--echo 'Bug# 34877: Invalid Values are coming in variable on assigning valid values';


--echo '#------------------FN_DYNVARS_005_05-----------------------#'
########################################################################
# Change the value of transaction_alloc_block_size to an invalid value #
########################################################################

SET @@global.transaction_alloc_block_size = 0;
SELECT @@global.transaction_alloc_block_size;

SET @@global.transaction_alloc_block_size = -1024;
SELECT @@global.transaction_alloc_block_size;


SET @@global.transaction_alloc_block_size = 123456789201;
SELECT @@global.transaction_alloc_block_size;

--echo 'Bug # 34837: Errors are not coming on assigning invalid values to variable';

-- Error ER_WRONG_TYPE_FOR_VAR
SET @@global.transaction_alloc_block_size = ON;

-- Error ER_WRONG_TYPE_FOR_VAR
SET @@global.transaction_alloc_block_size = OFF;


SET @@global.transaction_alloc_block_size = True;
SELECT @@global.transaction_alloc_block_size;

SET @@global.transaction_alloc_block_size = False;
SELECT @@global.transaction_alloc_block_size;


-- Error ER_WRONG_TYPE_FOR_VAR
SET @@global.transaction_alloc_block_size = 65530.34;

-- Error ER_WRONG_TYPE_FOR_VAR
SET @@global.transaction_alloc_block_size ="Test";

SET @@global.transaction_alloc_block_size = 1000;
SELECT @@global.transaction_alloc_block_size;

SET @@session.transaction_alloc_block_size = 12345678901;
SELECT @@session.transaction_alloc_block_size;

--echo 'Bug # 34837: Errors are not coming on assigning invalid values to variable';

-- Error ER_WRONG_TYPE_FOR_VAR
SET @@session.transaction_alloc_block_size = ON;

-- Error ER_WRONG_TYPE_FOR_VAR
SET @@session.transaction_alloc_block_size = OFF;

SET @@session.transaction_alloc_block_size = True;
SELECT @@session.transaction_alloc_block_size;

SET @@session.transaction_alloc_block_size = False;
SELECT @@session.transaction_alloc_block_size;


-- Error ER_WRONG_TYPE_FOR_VAR
SET @@session.transaction_alloc_block_size = "Test";


--Error ER_WRONG_TYPE_FOR_VAR
SET @@session.transaction_alloc_block_size = 'test';

--echo '#------------------FN_DYNVARS_005_06-----------------------#'
####################################################################
#   Check if the value in GLOBAL Table matches value in variable   #
####################################################################


SELECT @@global.transaction_alloc_block_size = VARIABLE_VALUE 
FROM INFORMATION_SCHEMA.GLOBAL_VARIABLES 
WHERE VARIABLE_NAME='transaction_alloc_block_size';

--echo '#------------------FN_DYNVARS_005_07-----------------------#'
####################################################################
#  Check if the value in SESSION Table matches value in variable   #
####################################################################

SELECT @@session.transaction_alloc_block_size = VARIABLE_VALUE 
FROM INFORMATION_SCHEMA.SESSION_VARIABLES 
WHERE VARIABLE_NAME='transaction_alloc_block_size';


--echo '#---------------------FN_DYNVARS_001_08----------------------#'
###########################################################################
#  Check if global and session variable are independent of each other     #
###########################################################################

SET @@transaction_alloc_block_size = 1024;
SET @@global.transaction_alloc_block_size = 4294967295;
SELECT @@transaction_alloc_block_size = @@global.transaction_alloc_block_size;
 

--echo '#---------------------FN_DYNVARS_001_09----------------------#'
########################################################################
#    Check if accessing variable with SESSION,LOCAL and without SCOPE  #
#    points to same session variable                                   #
########################################################################

SET @@transaction_alloc_block_size = 100;
SELECT @@transaction_alloc_block_size = @@local.transaction_alloc_block_size;
SELECT @@local.transaction_alloc_block_size = @@session.transaction_alloc_block_size;


--echo '#---------------------FN_DYNVARS_001_10----------------------#'
################################################################
#   Check if variable can be accessed with and without @@ sign #
################################################################

SET transaction_alloc_block_size = 1027;
SELECT @@transaction_alloc_block_size;

--Error ER_UNKNOWN_TABLE
SELECT local.transaction_alloc_block_size;

--Error ER_UNKNOWN_TABLE
SELECT session.transaction_alloc_block_size;

--Error ER_BAD_FIELD_ERROR
SELECT transaction_alloc_block_size = @@session.transaction_alloc_block_size;


####################################
#     Restore initial value        #
####################################

SET @@global.transaction_alloc_block_size = @start_global_value;
SELECT @@global.transaction_alloc_block_size;
SET @@session.tmp_table_size = @start_session_value;
SELECT @@session.transaction_alloc_block_size;


#############################################################
#             END OF transaction_alloc_block_size TESTS     #
#############################################################

