//=======================================================================
// filestab.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_FILES_TAB_H
#define GPACO_FILES_TAB_H

#include <gtkmm/label.h>
#include <gtkmm/progressbar.h>
#include <gtkmm/box.h>
#include <gtkmm/checkbutton.h>

namespace Gpaco
{

class Pkg;
class FilesTreeView;

class FilesTab : public Gtk::VBox
{
	public:

	FilesTab(Pkg&);
	~FilesTab();

	FilesTreeView* treeView()		{ return mpTreeView; }
	Gtk::ProgressBar& progressBar()	{ return mProgressBar; }

	void setLabelText(Glib::ustring const&);

	private:

	Pkg&				mPkg;
	Gtk::Label			mLabel;
	Gtk::ProgressBar	mProgressBar;
	FilesTreeView*		mpTreeView;
	Gtk::CheckButton	mButtonInst;
	Gtk::CheckButton	mButtonMiss;

	void onSwitchInstalled();
	void onSwitchMissing();
};

} // namespace Gpaco


#endif  // GPACO_FILES_TAB_H
