///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/viewport/input/ScalingMode.h>
#include <core/viewport/input/XFormManager.h>
#include <core/viewport/snapping/SnappingManager.h>
#include <core/data/DataSetManager.h>
#include <core/scene/animation/AnimManager.h>

namespace Core {

/******************************************************************************
* Is called when the xform operation begins.
******************************************************************************/
void ScalingMode::startXForm()
{
}

/******************************************************************************
* Is called during the operation.
******************************************************************************/
void ScalingMode::doXForm()
{
}

/******************************************************************************
* Applies the current transformation to the given nodes.
******************************************************************************/
void ScalingMode::applyXForm(const QVector<SceneNode*>& nodeSet, FloatType multiplier)
{
}

};
