###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for gtk+2.0 vulnerability USN-415-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840086);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.1");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "USN", value: "415-1");
  script_cve_id("CVE-2007-0010");
  script_name( "Ubuntu Update for gtk+2.0 vulnerability USN-415-1");
  desc = "

  Vulnerability Insight:

  A flaw was discovered in the error handling of GTK's image loading
  library.  Applications opening certain corrupted images could be made to
  crash, causing a denial of service.

  Affected Software/OS:
  gtk+2.0 vulnerability on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-February/000476.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gtk+2.0 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"gtk2-engines-pixbuf", ver:"2.8.20-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gtk2.0-examples", ver:"2.8.20-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-0-dbg", ver:"2.8.20-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-0", ver:"2.8.20-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-bin", ver:"2.8.20-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-dev", ver:"2.8.20-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-common", ver:"2.8.20-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-doc", ver:"2.8.20-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"gtk2-engines-pixbuf", ver:"2.10.6-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gtk2.0-examples", ver:"2.10.6-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-0-dbg", ver:"2.10.6-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-0", ver:"2.10.6-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-bin", ver:"2.10.6-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-dev", ver:"2.10.6-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-common", ver:"2.10.6-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-doc", ver:"2.10.6-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"gtk2-engines-pixbuf", ver:"2.8.6-0ubuntu2.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gtk2.0-examples", ver:"2.8.6-0ubuntu2.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-0-dbg", ver:"2.8.6-0ubuntu2.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-0", ver:"2.8.6-0ubuntu2.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-bin", ver:"2.8.6-0ubuntu2.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-dev", ver:"2.8.6-0ubuntu2.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-common", ver:"2.8.6-0ubuntu2.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgtk2.0-doc", ver:"2.8.6-0ubuntu2.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}