###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_flatchat_detect.nasl 2100 2009-05-09 15:15:24Z may $
#
# Flatchat Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800317);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Flatchat Version Detection");
  desc = "

  Overview : This script detects the installed version of Flatchat and
  sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of Flatchat in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

flatchatPort = get_http_port(default:80);
if(!get_port_state(flatchatPort)){
  exit(0);
}

foreach dir (make_list("/flatchat", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:flatchatPort);
  rcvRes = http_send_recv(port:flatchatPort, data:sndReq);

  if("Flat Chat" >< rcvRes && "Login" >< rcvRes)
  {
    fcVer = eregmatch(pattern:"Flat Chat (v )?([0-9.]+)", string:rcvRes);
    if(fcVer[2] != NULL)
    {
      set_kb_item(name:"www/" + flatchatPort + "/Flatchat", value:fcVer[2] +
                       " under " + dir);
      security_note(data:"Flat Chat version " + fcVer[2] + " running at location "
                         + dir +  " was detected on the host"); 
    }
  }
}
