###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gambas FEDORA-2010-1872
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861633);
  script_version("$Revision: 7426 $: 1.0");
  script_tag(name:"cvss_base", value:"6.9");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2010-1872");
  script_cve_id("CVE-2009-3736");
  script_name("Fedora Update for gambas FEDORA-2010-1872");
  desc = "

  Vulnerability Insight:
  Gambas is a free development environment based on a Basic interpreter
  with object extensions, like Visual Basic (but it is NOT a clone !).
  With Gambas, you can quickly design your program GUI, access MySQL or
  PostgreSQL databases, pilot KDE applications with DCOP, translate your
  program into many languages, create network applications easily, and so
  on...


  Affected Software/OS:
  gambas on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-February/035133.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gambas");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"gambas", rpm:"gambas~1.0.19~12.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}