# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5356 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64074);
 script_cve_id("CVE-2009-0065", "CVE-2008-5079", "CVE-2009-1242", "CVE-2009-1337", "CVE-2009-1439", "CVE-2009-1633");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 10 FEDORA-2009-5356 (kernel)";
 script_name(name);

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-5356.

Update Information:

Update to kernel 2.6.27.24:
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.22
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.23
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.24

Includes ext4 bug fixes from Fedora 11.
Updates the atl2 network driver to version 2.0.5

ChangeLog:

* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.68
- Enable Divas (formerly Eicon) ISDN drivers on x86_64. (#480837)
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.67
- Enable sfc driver for Solarflare SFC4000 network adapter (#499392)
(disabled on powerpc)
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.66
- Add workaround for Intel Atom erratum AAH41 (#499803)
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.65
- Allow building the F-10 2.6.27 kernel on F-11.
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.64
- ext4 fixes from Fedora 11:
linux-2.6-ext4-clear-unwritten-flag.patch
linux-2.6-ext4-fake-delalloc-bno.patch
linux-2.6-ext4-fix-i_cached_extent-race.patch
linux-2.6-ext4-prealloc-fixes.patch
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.63
- Merge official ext4 patches headed for -stable.
- Drop ext4 patches we already had:
linux-2.6.27-ext4-fix-header-check.patch
linux-2.6.27-ext4-print-warning-once.patch
linux-2.6.27-ext4-fix-bogus-bug-ons-in-mballoc.patch
linux-2.6.27-ext4-fix-bb-prealloc-list-corruption.patch
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.62
- Add patches from Fedora 9:
Update the atl2 network driver to version 2.0.5
KVM: don't allow access to the EFER from 32-bit x86 guests
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.61
- Linux 2.6.27.24
- Fix up execshield, utrace, r8169 and drm patches for .24

References:

[ 1 ] Bug #502109 - CVE-2009-1242 kernel: x86 guest OS can crash the system by writing to the EFER
https://bugzilla.redhat.com/show_bug.cgi?id=502109
[ 2 ] Bug #493771 - CVE-2009-1337 kernel: exit_notify: kill the wrong capable(CAP_KILL) check
https://bugzilla.redhat.com/show_bug.cgi?id=493771
[ 3 ] Bug #494275 - CVE-2009-1439 kernel: cifs: memory overwrite when saving nativeFileSystem field during mount
https://bugzilla.redhat.com/show_bug.cgi?id=494275
[ 4 ] Bug #496572 - CVE-2009-1633 kernel: cifs: fix potential buffer overruns when converting unicode strings sent by server
https://bugzilla.redhat.com/show_bug.cgi?id=496572


Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5356

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-5356 (kernel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.27.24~170.2.68.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
