# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 175-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53430);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 175-1 (syslog-ng)";
 script_name(name);

 desc = "The remote host is missing an update to syslog-ng
announced via advisory DSA 175-1.

Pter Hltzl discovered a problem in the way syslog-ng handles macro
expansion.  When a macro is expanded a static length buffer is used
accompanied by a counter.  However, when constant chharacters are
appended, the counter is not updated properly, leading to incorrect
boundary checking.  An attacker may be able to use specially crafted
log messages inserted via UDP which overflows the buffer.

This problem has been fixed in version 1.5.15-1.1 for the current
stable distribution (woody), in version 1.4.0rc3-3.2 for the old
stable distribution (potato) and version 1.5.21-1 for the unstable
distribution (sid).

We recommend that you upgrade your syslog-ng package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20175-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 175-1 (syslog-ng)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"syslog-ng", ver:"1.4.0rc3-3.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"syslog-ng", ver:"1.5.15-1.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
