// --------------------------------------------------------------------------
//                   OpenMS -- Open-Source Mass Spectrometry               
// --------------------------------------------------------------------------
// Copyright The OpenMS Team -- Eberhard Karls University Tuebingen,
// ETH Zurich, and Freie Universitaet Berlin 2002-2013.
// 
// This software is released under a three-clause BSD license:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of any author or any participating institution 
//    may be used to endorse or promote products derived from this software 
//    without specific prior written permission.
// For a full list of authors, refer to the file AUTHORS. 
// --------------------------------------------------------------------------
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL ANY OF THE AUTHORS OR THE CONTRIBUTING 
// INSTITUTIONS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 
// --------------------------------------------------------------------------
// $Maintainer: Sandro Andreotti$
// $Authors: Sandro Andreotti$
// --------------------------------------------------------------------------

#include <OpenMS/CONCEPT/ClassTest.h>
#include <OpenMS/CHEMISTRY/SvmTheoreticalSpectrumGeneratorTrainer.h>


using namespace OpenMS;
using namespace std;

START_TEST(SvmTheoreticalSpectrumGeneratorTrainer, "$Id: SvmTheoreticalSpectrumGeneratorTrainer_test.C 10915 2013-04-04 20:14:57Z aiche $")

/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

SvmTheoreticalSpectrumGeneratorTrainer* ptr = 0;
SvmTheoreticalSpectrumGeneratorTrainer* nullPointer = 0;
START_SECTION(SvmTheoreticalSpectrumGeneratorTrainer())
{
	ptr = new SvmTheoreticalSpectrumGeneratorTrainer();
	TEST_NOT_EQUAL(ptr, nullPointer)
}
END_SECTION

START_SECTION((SvmTheoreticalSpectrumGeneratorTrainer(const SvmTheoreticalSpectrumGeneratorTrainer &source)))
{
  SvmTheoreticalSpectrumGeneratorTrainer train_c(*ptr);
  TEST_EQUAL(train_c.getParameters(), ptr->getParameters())
}
END_SECTION

START_SECTION((SvmTheoreticalSpectrumGeneratorTrainer& operator=(const SvmTheoreticalSpectrumGeneratorTrainer &tsg)))
{

  SvmTheoreticalSpectrumGeneratorTrainer train_a;
  train_a = *ptr;
  TEST_EQUAL(train_a.getParameters(), ptr->getParameters())
}
END_SECTION

START_SECTION((virtual ~SvmTheoreticalSpectrumGeneratorTrainer()))
{
  delete ptr;
}
END_SECTION


START_SECTION((void trainModel(const PeakMap &spectra, const std::vector< AASequence > &annotations, String filename, Int precursor_charge)))
{
  NOT_TESTABLE
}
END_SECTION

START_SECTION((void normalizeIntensity(PeakSpectrum &S) const ))
{
  NOT_TESTABLE
}
END_SECTION


/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
END_TEST



