/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package grpFilt;

import help.Config;
import help.Convertions;
import help.Pair;
import help.myMouseListener;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;


import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.Map.Entry;

import javax.swing.Box;

import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.RowSorter;

import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultFormatter;

import xmlObjects.Group;
import xmlObjects.VtEnv;

import help.Text;


/****
 * 	Is a Panel that contains all Components and Gui elements for filtering.
 */
public class Filtering extends javax.swing.JPanel{

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	private SymbolGroupTable simbolTable = null;
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private ArrayList<SymbolGroupTable> sTables = new ArrayList<SymbolGroupTable>();
    private VtEnv env = null;
    private JPanel help = new JPanel();
    private ArrayList<JRadioButton> filtersOff = new ArrayList<JRadioButton>();
    private ArrayList<JRadioButton> filtersUnl = new ArrayList<JRadioButton>();
    private DefaultGroups defGroups = null;
    private Text mytext = null;
    
	/****
	 * initialize all components
	 * @param sTable SymbolGroupTable used by this Class and General and Grouping Class.
	 */
	public Filtering(SymbolGroupTable sTable,final VtEnv env,DefaultGroups defGroups,Text mytext)
	{
		this.mytext = mytext;
		simbolTable = sTable;
		this.env = env;
		this.defGroups = defGroups;
		
		JPanel topPanel = new JPanel();
		Box box1 = Box.createVerticalBox();
		Box box2 = Box.createHorizontalBox();
		BorderLayout layout = new BorderLayout();
		topPanel.setLayout(layout);
		
		final JFormattedTextField text = new JFormattedTextField("");
		text.setColumns(8);
		text.setAlignmentX(Component.RIGHT_ALIGNMENT);
		text.setAlignmentY(Component.CENTER_ALIGNMENT);
		
		help.add(text);

		JButton addFilter = new JButton(mytext.getText("Filtering_addProcFilter_btn"));
		addFilter.setAlignmentX(Component.RIGHT_ALIGNMENT);
		help.add(addFilter);
		
		box2.add(help);
		
		topPanel.add(box1,BorderLayout.WEST);
		topPanel.add(box2,BorderLayout.EAST);
		
		
		
		addFilter.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				String title = text.getText();
				while(title.contains(" "))
					title = title.replaceAll(" ", "");
				String title_test = title.replaceAll("[0-9 [: \\- \\, N]]", "");
				
				if(title_test.trim().equals("") &&
						!title.contains(",,") &&
						!title.contains("--") &&
						!title.contains("::") &&
						!title.contains("NN") &&
						!title.contains("-,") &&
						!title.contains(",-") &&
						!title.startsWith(",") &&
						!title.startsWith("-") &&
						!title.startsWith(":") &&
						!title.endsWith(",") &&
						!title.endsWith("-") &&
						!title.endsWith(":") &&
						!title.trim().equals("")
				  )
				{
					
					addTab(title);
				}
				else
				{
					JOptionPane.showMessageDialog(null, "Prozess filter has no valid pattern.");
				}
			}
			
		});
	
		text.addActionListener(addFilter.getActionListeners()[addFilter.getActionListeners().length-1]);
		this.setLayout(new BorderLayout());
		this.add(topPanel,BorderLayout.NORTH);
		
		
		this.add(tabbedPane,BorderLayout.CENTER);
		tabbedPane.removeAll();
		tabbedPane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
	//	final JScrollPane comp = new JScrollPane(makeGlobalPanel());
	//	comp.setPreferredSize(new Dimension(500, 250));
	//	comp.setVerticalScrollBarPolicy( JScrollPane.VERTICAL_SCROLLBAR_NEVER);
	//	comp.setHorizontalScrollBarPolicy( JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		
		final JPanel comp = new JPanel(new BorderLayout());
		comp.add(makeGlobalPanel(),BorderLayout.CENTER);
		tabbedPane.addTab("Global", comp);
		tabbedPane.setMnemonicAt(0, KeyEvent.VK_1);

		
		myMouseListener n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Filtering_addProcFilter_title"), mytext.getText("Filtering_addProcFilter")));
		addFilter.addMouseListener(n);
		text.addMouseListener(n);
		
	}
	
	
	/***
	 * add a new Tab to the tabbedComponent
	 * @param tabtitle new title of the tab
	 */
	private void addTab(String tabtitle)
	{
		int index = tabbedPane.getComponentCount()-3;
		/*
		final JScrollPane comp = new JScrollPane(makeProcPanel(tabtitle));
		comp.setHorizontalScrollBarPolicy( JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		comp.setVerticalScrollBarPolicy( JScrollPane.VERTICAL_SCROLLBAR_NEVER);
		*/
		JPanel comp = new JPanel(new BorderLayout());
		comp.add(makeProcPanel(tabtitle),BorderLayout.CENTER);
		
		tabbedPane.add("Process Group: "+tabtitle, comp);
        tabbedPane.setAutoscrolls(false);
        comp.setAutoscrolls(false);
        initTabComponent(index);

        switch(index)
        {
        	case 1:	tabbedPane.setMnemonicAt(index, KeyEvent.VK_2); break;
        	case 2:	tabbedPane.setMnemonicAt(index, KeyEvent.VK_3); break;
        	case 3:	tabbedPane.setMnemonicAt(index, KeyEvent.VK_4); break;
        	case 4:	tabbedPane.setMnemonicAt(index, KeyEvent.VK_5); break;
        	case 5:	tabbedPane.setMnemonicAt(index, KeyEvent.VK_6); break;
        	case 6:	tabbedPane.setMnemonicAt(index, KeyEvent.VK_7); break;
        	case 7:	tabbedPane.setMnemonicAt(index, KeyEvent.VK_8); break;
        	case 8:	tabbedPane.setMnemonicAt(index, KeyEvent.VK_9); break;
        	case 9:	tabbedPane.setMnemonicAt(index, KeyEvent.VK_0); break;
        	default: ;
        }
	}
	
	
	/***
	 * Create a ButtonTabedComponent 
	 * @param i index of the tab.
	 */
    private void initTabComponent(int i) {
    	tabbedPane.setTabComponentAt(i,
                 new ButtonTabedComponent(tabbedPane));
    } 
	
    
    /***
     * Set Gui elements for the main tab
     * @return Component with all elements of the main tab
     */
	private JComponent makeGlobalPanel() {
        JPanel panel = new JPanel();
        JPanel panel1 = new JPanel();
        
        panel.setLayout(new BorderLayout());
        panel1.setLayout(new BorderLayout());
    
        JPanel table = (JPanel) addTable(20);
        panel.add(table,BorderLayout.CENTER);
        panel1.add(panel,BorderLayout.NORTH);
        return panel1;
	}
	
	/***
	 * Set Gui elements for a process Tab
	 * @param title of this tab
	 * @return Component with all elements of the tab
	 */
	private JComponent makeProcPanel(String title) {
        final JPanel panel = new JPanel(false);
        
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints(); 
        panel.setLayout(layout);
        
        c.gridx=0;
        c.gridy=0;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.anchor=GridBagConstraints.LINE_START;
        c.insets = new Insets(10,20,10,20);
        JButton remove = new JButton("Remove Process Group");
        c.gridwidth = 1;
        c.weightx = 0;
        panel.add(remove,c);
        
        // *** move tab settings *** /
        JButton moveforward = new JButton("Move Filter Forward");
        JButton movebackward = new JButton("Move Filter Backward");
        moveforward.setEnabled(false);
        if(tabbedPane.getTabCount() == 1)
        	movebackward.setEnabled(false);
        if(tabbedPane.getTabCount() > 1)
        {
        	((JPanel)getTabContent(tabbedPane.getTabCount()-1).getComponent(1)).getComponent(1).setEnabled(true);
        }
        
     
        // *** end move tab settings *** /
        c.anchor = GridBagConstraints.LINE_END;
        JPanel helpPanel = new JPanel();
        helpPanel.add(movebackward);
        helpPanel.add(moveforward);
        c.gridx=2;
        
        panel.add(helpPanel,c);
        c.weightx = 1;
      //SET PROPERTYS
        JPanel properties = new JPanel(new GridBagLayout());
        
        properties.setBorder(BorderFactory.createTitledBorder("Properties:"));
        properties.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0,Color.GRAY), "Properties:", TitledBorder.DEFAULT_JUSTIFICATION,TitledBorder.DEFAULT_POSITION));
        GridBagConstraints d = new GridBagConstraints();
        d.anchor = GridBagConstraints.LINE_START;
        d.fill = GridBagConstraints.HORIZONTAL;
        d.insets = new Insets(5,5,5,10);
        d.gridx = d.gridy = 0;
        
      //SET Filtertype
        d.weightx = 0;
        properties.add(new JLabel("Filtertype:"),d);
        d.gridx=1;
        final JRadioButton useRules = new JRadioButton("Use rules");
        useRules.setSelected(true);
        useRules.setActionCommand("rules");
        properties.add(useRules,d);
        
        d.gridx=2;
        final JRadioButton filterAll = new JRadioButton("Filter all");
        filterAll.setActionCommand("rules");
        properties.add(filterAll,d);
        
        d.weightx = 1;
        d.gridx=3;        
        properties.add(new JLabel(""),d);
        d.weightx = 0; 
        
        ButtonGroup RuleGroup = new ButtonGroup();
        RuleGroup.add(useRules);
        RuleGroup.add(filterAll);

      //SET Processes
        d.gridx=0;
        d.gridy++;
        properties.add(new JLabel("Process range:"),d);
        d.gridx=1;
        d.gridwidth = 3;
        d.weightx=1;
        final JFormattedTextField text = new JFormattedTextField(title);
		properties.add(text,d);
		d.weightx=0;
		d.gridx=4;
		d.gridwidth = 1;
		final JButton renameTitle = new JButton("Change");
		properties.add(renameTitle,d);
        c.gridy=1;
        c.gridx=0;
		c.gridwidth = 3;
	//	properties.setPreferredSize(new Dimension(Config.subGroup_min_width-20,properties.getPreferredSize().height));
    //    d.gridx = 4;
  //      properties.add(new JLabel("                                             "),d);
		c.weightx = 1;
		panel.add(properties,c);
        
        c.gridx=0;
        c.gridy=2;
        BorderLayout layout2 = new BorderLayout();
        JPanel filter = new JPanel(layout2);
        //filter.setBorder(BorderFactory.createTitledBorder("Filter rules"));
        filter.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0,Color.GRAY), "Filter Rules", TitledBorder.DEFAULT_JUSTIFICATION,TitledBorder.DEFAULT_POSITION));
        
        filter.add(addTable(0),BorderLayout.NORTH);
 //       filter.setPreferredSize(new Dimension(Config.subGroup_min_width-20,filter.getPreferredSize().height));
        panel.add(filter,c);
       
        
 //       panel.setPreferredSize(new Dimension(Config.subGroup_min_width,panel.getPreferredSize().height));
    
        //ActionListener
        remove.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				int i = tabbedPane.getSelectedIndex();
				sTables.remove(i);
				tabbedPane.remove(tabbedPane.getSelectedIndex());
				//set button "move previous" disabled if the first element is deleated
				  try{
		        	   if(i == 1 && tabbedPane.getComponentCount()>i+3)
		        		   ((JPanel)getTabContent(i).getComponent(1)).getComponent(0).setEnabled(false);
		        	   
		           }catch(IndexOutOfBoundsException ex)
		           {
		        	   Config.errorHandler(ex);
		           }
		            	
		           	//show next tab
		           try{
		        	   if(tabbedPane.getComponentCount()>i+3)
		        		   tabbedPane.getComponentAt(i);
		        	   else
		        		   if(i != 1)
		        			   ((JPanel)getTabContent(i-1).getComponent(1)).getComponent(1).setEnabled(false);
		        	   
		           }catch(IndexOutOfBoundsException ex)
		           {
		            	
		            	Config.errorHandler(ex);
		           }
			}
        	
        });
        
        // move forward listener Event
        moveforward.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent e)
        	{
        		int src = tabbedPane.getSelectedIndex(); 
        		int dst = tabbedPane.getSelectedIndex()+1;// Get all the properties Component 
        		
        		Component comp = tabbedPane.getComponentAt(src); 
        		String label = tabbedPane.getTitleAt(src); 
        		Icon icon = tabbedPane.getIconAt(src); 
        		Icon iconDis = tabbedPane.getDisabledIconAt(src);
        		String tooltip = tabbedPane.getToolTipTextAt(src);
        		boolean enabled = tabbedPane.isEnabledAt(src);
        		int keycode = tabbedPane.getMnemonicAt(src);
        		int mnemonicLoc = tabbedPane.getDisplayedMnemonicIndexAt(src);
        		Color fg = tabbedPane.getForegroundAt(src); 
        		Color bg = tabbedPane.getBackgroundAt(src); 
        		
        		// Remove the tab 
        		tabbedPane.remove(src); 
        		
        		// Add a new tab 
        		tabbedPane.insertTab(label, icon, comp, tooltip, dst); 
        		
        		// Restore all properties 
        		tabbedPane.setDisabledIconAt(dst, iconDis); 
        		tabbedPane.setEnabledAt(dst, enabled); 
        		tabbedPane.setMnemonicAt(dst, keycode+1);
        		tabbedPane.setMnemonicAt(src, keycode);
        		tabbedPane.setDisplayedMnemonicIndexAt(dst, mnemonicLoc); 
        		tabbedPane.setForegroundAt(dst, fg); 
        		tabbedPane.setBackgroundAt(dst, bg); 
        		
        		tabbedPane.setSelectedIndex(dst);
        		initTabComponent(dst);
        		
        		
        		//enables or disables move buttons for src component
        		((JPanel)getTabContent(dst).getComponent(1)).getComponent(0).setEnabled(true);

        		
        		if(dst == tabbedPane.getTabCount()-1)
        			((JPanel)getTabContent(dst).getComponent(1)).getComponent(1).setEnabled(false);
        		else
        			((JPanel)getTabContent(dst).getComponent(1)).getComponent(1).setEnabled(true);
        		
        		//enables or disables move buttons for dst component
        		((JPanel)getTabContent(src).getComponent(1)).getComponent(1).setEnabled(true);
        		if(src == 1)
        			((JPanel)getTabContent(src).getComponent(1)).getComponent(0).setEnabled(false);
        		else
        			((JPanel)getTabContent(src).getComponent(1)).getComponent(0).setEnabled(true);
        	}
        });
        
     // move backward listener Event
        movebackward.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent e)
        	{
        		int src = tabbedPane.getSelectedIndex(); 
        		int dst = tabbedPane.getSelectedIndex()-1;// Get all the properties Component 
        		
        		Component comp = tabbedPane.getComponentAt(src); 
        		String label = tabbedPane.getTitleAt(src); 
        		Icon icon = tabbedPane.getIconAt(src); 
        		Icon iconDis = tabbedPane.getDisabledIconAt(src);
        		String tooltip = tabbedPane.getToolTipTextAt(src);
        		boolean enabled = tabbedPane.isEnabledAt(src);
        		int keycode = tabbedPane.getMnemonicAt(src);
        		int mnemonicLoc = tabbedPane.getDisplayedMnemonicIndexAt(src);
        		Color fg = tabbedPane.getForegroundAt(src); 
        		Color bg = tabbedPane.getBackgroundAt(src); 
        		
        		// Remove the tab 
        		tabbedPane.remove(src); 
        		
        		// Add a new tab 
        		tabbedPane.insertTab(label, icon, comp, tooltip, dst); 
        		
        		// Restore all properties 
        		tabbedPane.setDisabledIconAt(dst, iconDis); 
        		tabbedPane.setEnabledAt(dst, enabled); 
        		tabbedPane.setMnemonicAt(dst, keycode-1);
        		tabbedPane.setMnemonicAt(src, keycode);
        		tabbedPane.setDisplayedMnemonicIndexAt(dst, mnemonicLoc); 
        		tabbedPane.setForegroundAt(dst, fg); 
        		tabbedPane.setBackgroundAt(dst, bg); 
        		
        		tabbedPane.setSelectedIndex(dst);
        		initTabComponent(dst);
        		
        		
        		//enables or disables move buttons for src component
        		((JPanel)getTabContent(dst).getComponent(1)).getComponent(1).setEnabled(true);

        		
        		if(dst == 1)
        			((JPanel)getTabContent(dst).getComponent(1)).getComponent(0).setEnabled(false);
        		else
        			((JPanel)getTabContent(dst).getComponent(1)).getComponent(0).setEnabled(true);
        		
        		//enables or disables move buttons for dst component
        		((JPanel)getTabContent(src).getComponent(1)).getComponent(0).setEnabled(true);
        		if(src == tabbedPane.getTabCount()-1)
        			((JPanel)getTabContent(src).getComponent(1)).getComponent(1).setEnabled(false);
        		else
        			((JPanel)getTabContent(src).getComponent(1)).getComponent(1).setEnabled(true);
        	}
        });
        
        renameTitle.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent e)
        	{
        		String title = text.getText();
        		while(title.contains(" "))
        			title=title.replaceAll(" ","");
				String title_test = title.replaceAll("[0-9 [: \\- \\, N]]", "");
				if(title_test.trim().equals("") &&
					!title.contains(",,") &&
					!title.contains("--") &&
					!title.contains("::") &&
					!title.contains("NN") &&
					!title.contains("-,") &&
					!title.contains(",-") &&
					!title.startsWith(",") &&
					!title.startsWith("-") &&
					!title.startsWith(":") &&
					!title.endsWith(",") &&
					!title.endsWith("-") &&
					!title.endsWith(":") &&
					!title.trim().equals("")
				  )
				{
					
					tabbedPane.setTitleAt(tabbedPane.getSelectedIndex(), "Process Group: "+text.getText());
				}
				else
				{
					JOptionPane.showMessageDialog(null, "Prozess filter has no valid pattern.");
				}
        	}
        });
        filterAll.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent e)
        	{
        		if(filterAll.isSelected())
        		{

        		//	text.setEnabled(false);
        		//	renameTitle.setEnabled(false);
        			JPanel help = (JPanel) panel.getComponent(panel.getComponentCount()-2);
        			((JLabel) ((JPanel)help.getComponent(0)).getComponent(0)).setEnabled(false);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(1)).getComponent(0).setEnabled(false);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(1)).getComponent(1).setEnabled(false);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(1)).getComponent(2).setEnabled(false);
        			
        			((JScrollPane) ((JPanel)help.getComponent(0)).getComponent(2)).getViewport().getComponent(0).setEnabled(false);
        			((MySymbolTableRenderer)((SymbolGroupTable) ((JScrollPane) ((JPanel)help.getComponent(0)).getComponent(2)).getViewport().getComponent(0)).c).setDisabled();
        			
        			
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(0).setEnabled(false);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(1).setEnabled(false);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(2).setEnabled(false);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(3).setEnabled(false);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(4).setEnabled(false);
        			((JButton) ((JPanel)help.getComponent(0)).getComponent(4)).setEnabled(false);
        			
        			
        		}	
        		
        	}
        });

        useRules.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent e)
        	{
        		if(useRules.isSelected())
        		{
        			text.setEnabled(true);
        			renameTitle.setEnabled(true);
        			JPanel help = (JPanel) panel.getComponent(panel.getComponentCount()-2);
        			((JLabel) ((JPanel)help.getComponent(0)).getComponent(0)).setEnabled(true);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(1)).getComponent(0).setEnabled(true);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(1)).getComponent(1).setEnabled(true);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(1)).getComponent(2).setEnabled(true);
        			
        			((JScrollPane) ((JPanel)help.getComponent(0)).getComponent(2)).getViewport().getComponent(0).setEnabled(true);
        			((MySymbolTableRenderer)((SymbolGroupTable) ((JScrollPane) ((JPanel)help.getComponent(0)).getComponent(2)).getViewport().getComponent(0)).c).setEnabled();
        			
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(0).setEnabled(true);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(1).setEnabled(true);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(2).setEnabled(true);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(3).setEnabled(true);
        			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(4).setEnabled(true);
        			((JButton) ((JPanel)help.getComponent(0)).getComponent(4)).setEnabled(true);
        		}
        	}
        });
        
        myMouseListener n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Filtering_remProcFilter_title"), mytext.getText("Filtering_remProcFilter")));
		remove.addMouseListener(n);
		
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Filtering_moveForward_title"), mytext.getText("Filtering_moveForward")));
		moveforward.addMouseListener(n);
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Filtering_moveBackward_title"), mytext.getText("Filtering_moveBackward")));
		movebackward.addMouseListener(n);
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Filtering_filterType_title"), mytext.getText("Filtering_filterType")));
		useRules.addMouseListener(n);
		filterAll.addMouseListener(n);
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Filtering_procRange_title"), mytext.getText("Filtering_procRange")));
		text.addMouseListener(n);
		renameTitle.addMouseListener(n);
		
        sTables.get(sTables.size()-1).find(null);
        
        

        c.gridy=0;
        c.gridx=1;
        c.gridwidth = 1;
        c.weightx = 1;
        panel.add(new JLabel(""),c);
        c.weightx=0;
        
        JPanel help = new JPanel(new BorderLayout());
        help.add(panel,BorderLayout.NORTH);
        return help;
	}

	/***
	 * remove invalid entries in simbolTable  and add Groups as entries
	 * @param dest current symbolGroupTable
	 */
	private void getTableModelData(SymbolGroupTable dest)
	{

		DefaultTableModel src = null;
		if(sTables.isEmpty())
			src = (DefaultTableModel) simbolTable.getModel();
		else
			src = (DefaultTableModel) sTables.get(0).getModel();
		
		ArrayList<String> system = new ArrayList<String>();
		ArrayList<String> name = new ArrayList<String>();
		ArrayList<String> libtype = new ArrayList<String>();
		ArrayList<String> group = new ArrayList<String>();
		
		dest.clear();
		Object[] data;
		for(int i = 0; i<src.getRowCount();i++)
		{
			data = ((Vector<?>)src.getDataVector().elementAt(i)).toArray();
			if(data[1] != null && data[4] != null 
			   && data[0] != null && !data[0].toString().endsWith("system")		
			   && data[2] != null && !data[2].toString().trim().endsWith("8")
			   && data[3] != null && data[3].toString().trim().equals("")
			 )
			{
				
				system.add(data[0].toString());
				name.add(data[1].toString());
				libtype.add(data[2].toString());
				group.add(data[4].toString());
			}	
		}
		
		if(sTables.isEmpty())
		{
			ArrayList<String> groups = dest.getGroups();
			for(int i=0;i<groups.size();i++)
			{
				
					dest.addRow(groups.get(i), groups.get(i),"agrp");
			}
		}
		dest.find("");

		if(!name.isEmpty())
			dest.addRow(name, group, system, libtype);
		dest.reorder_filter();
	}
	
	/***
	 * initialize a symbolGroupTable with search  button scrollPane  
	 * @return component with symbolGroupTable 
	 */
	private Component addTable(int Hgap)
	{
		final JFormattedTextField text = new JFormattedTextField("");
		((DefaultFormatter)text.getFormatter()).setOverwriteMode(false);
		text.setColumns(8);
		final JButton find = new JButton("Find");
		simbolTable.find(null);

		final SymbolGroupTable newTable = new SymbolGroupTable(mytext);
		newTable.setDefGroups(defGroups);
		newTable.setView(SymbolGroupTable.FILTER_VIEW);
		getTableModelData(newTable);
	//	newTable.setPreferredScrollableViewportSize(new Dimension(100,250));
		sTables.add(newTable);
		
		
		
		final JScrollPane comp = new JScrollPane(newTable);
		comp.setPreferredSize(new Dimension(100, 250));
		comp.setVerticalScrollBarPolicy( JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		comp.setHorizontalScrollBarPolicy( JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		
		JPanel search = new JPanel(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		final JLabel SearchFor = new JLabel("Search for ");
		search.add(SearchFor);
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 0;
		c.anchor = GridBagConstraints.LINE_END;
		search.add(text);
		search.add(find);
		c.anchor = GridBagConstraints.LINE_START;
		JPanel output = new JPanel(new GridBagLayout());
		
		c.gridx=0;c.gridy=0;
		
		c.insets = new Insets(10,Hgap,0,Hgap);
		output.add(new JLabel("Call limit for group or symbol(s)"),c);
		c.gridx=2;
		c.anchor = GridBagConstraints.LINE_END;
		output.add(search,c);
		c.anchor = GridBagConstraints.LINE_START;
		c.gridy++;
		c.gridx=0;
		c.gridwidth=3;
		c.insets = new Insets(0,Hgap,0,Hgap);
		c.weightx = 1;
		
		output.add(comp,c);
		c.weightx = 0;
		c.insets = new Insets(10,Hgap,0,Hgap);
		c.gridwidth=1;
		
		//create Menu for selection
		JPanel selection = new JPanel(new GridBagLayout());
		
		JButton collapse = new JButton(mytext.getText("Filtering_collapse_title"));
		collapse.setAlignmentY(TOP_ALIGNMENT);
		
		c.gridy++;
		c.gridx = 0;
		output.add(selection,c);
		c.anchor = GridBagConstraints.FIRST_LINE_END;
		

		c.gridx = 2;
		c.weightx = 0;
		
		output.add(collapse,c);
		
		c.gridx=1;
		c.weightx=1;
		output.add(new JLabel(""),c);
		
		GridBagConstraints selc = new GridBagConstraints(); 
		
		selc.gridx = selc.gridy = 0;
		selc.anchor = GridBagConstraints.LINE_START;
        final JRadioButton filterOut = new JRadioButton(mytext.getText("Filtering_not_traced"));
        final JRadioButton filterAfter = new JRadioButton(mytext.getText("Filtering_after_calls"));
        final JFormattedTextField filterText = new JFormattedTextField("");
        final JRadioButton filterOff = new JRadioButton(mytext.getText("Filtering_filter_off"));
        final JRadioButton filterUnl = new JRadioButton(mytext.getText("Filtering_always_traced"));
        filterText.getFormatter().install(filterText);
		filterText.setColumns(5);
		 
		filtersOff.add(filterOff);
		filtersUnl.add(filterUnl);
		
		final ButtonGroup filterGroup = new ButtonGroup();
	    filterGroup.add(filterOut);
	    filterGroup.add(filterUnl);
	    filterGroup.add(filterOff);
	    filterGroup.add(filterAfter);

	        
		selection.add(filterOut,selc);
		selc.gridy++;
		selection.add(filterUnl,selc);
		selc.gridy++;
		selection.add(filterOff,selc);
		selc.gridy++;
		selection.add(filterAfter,selc);
		selc.gridx = 1;
		selection.add(filterText,selc);
		selc.gridx = 0;
		
		final SymbolGroupTable table = (SymbolGroupTable) comp.getViewport().getComponent(0);

		
		/*** ACTIONlistener ***/
		collapse.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				newTable.FiltCollapseExpand();
			}
		});
		find.setVisible(false);
		myMouseListener n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Filtering_search_title"), mytext.getText("Filtering_search")));
		text.addMouseListener(n);
	//	find.addMouseListener(n);
		
		n = new myMouseListener();
		n.setToolTip(env);

		n.setText(Config.setToolTipString(mytext.getText("Filtering_setFilter_title"), mytext.getText("Filtering_setFilter")));
		filterOut.addMouseListener(n);
		filterUnl.addMouseListener(n);
		filterAfter.addMouseListener(n);
		filterOff.addMouseListener(n);
		filterText.addMouseListener(n);
		
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Filtering_symbTable_title"), mytext.getText("Filtering_symbTable")));
		newTable.addMouseListener(n);
		
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Filtering_collapse_title"), mytext.getText("Filtering_collapse")));
		collapse.addMouseListener(n);
		
		final SearchFunction myFunc = new SearchFunction(newTable,text);
		final Thread searchThread = new Thread(myFunc);
		searchThread.start();		
		text.addKeyListener(new KeyListener(){


			public void keyPressed(KeyEvent e) {;}

			public void keyReleased(KeyEvent e) {
				if(myFunc.searchisRunning)
				{
					try {
						myFunc.currentDelay = 0;
					} catch (Exception err) {
						Config.errorHandler(err);
					}
				}else{	
					try {
						myFunc.searchisRunning = true;
						myFunc.currentDelay = 0;
					} catch (Exception err) {
						Config.errorHandler(err);
					}
				}
			}

			public void keyTyped(KeyEvent e) {;}
			
		});
		
		filterText.addKeyListener(new KeyListener(){
			public void keyPressed(KeyEvent e) {;}

			public void keyReleased(KeyEvent e) {
				int key = (int) e.getKeyChar();
				if(key >= 32 && key <= 126)
				{
					filterText.setText(Convertions.validateAsNumber(filterText.getText()));
				}
					filterAfter.getActionListeners()[0].actionPerformed(null);
					if(!filterAfter.isSelected())
						filterAfter.setSelected(true);
			}			
			public void keyTyped(KeyEvent e) {;}
			
		});

		// listens for selection changes and set radio buttons to current settings
		
		table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){		

			public void valueChanged(ListSelectionEvent e) {
				
				try
				{
					int[] rows = table.getSelectedRows();
					if(rows.length >= 1)
					{
						String content = table.getModel().getValueAt(table.getRowSorter().convertRowIndexToModel(rows[0]), 3).toString().trim();
						filterText.setText("");
						filterGroup.clearSelection();
	
						
						boolean setFilter = true;
						for(int i=1;i<rows.length;i++)
						{

							
							
							if(  ( table.getModel().getValueAt(table.getRowSorter().convertRowIndexToModel(rows[i]), 0).toString().trim().equals("agrp") &&
							       table.getModel().getValueAt(table.getRowSorter().convertRowIndexToModel(rows[i]), 3).toString().trim().equals("")
							      ) 
							          ||
							     (!content.equals(table.getModel().getValueAt(table.getRowSorter().convertRowIndexToModel(rows[i]), 3).toString().trim()))
							   )
							{
								setFilter = false;
								break;
							}
						}
						
						if(setFilter)
							setRadioButtons(content);
					}
				}catch(Exception ex)
				{
					Config.errorHandler(ex);
				}
				
			}
			
			//set radio buttons to current settings
			private void setRadioButtons(String content)
			{
				if(content.trim().equals(""))
					filterOff.setSelected(true);
				else if(content.trim().equals("0"))
					filterOut.setSelected(true);
				else if(content.trim().equals("-1"))
					filterUnl.setSelected(true);
				else{
					filterAfter.setSelected(true);
					filterText.setText(content.trim());
				}
			}
			
		});
		
		
		
		/*** RadioButton EventListener ***/
		//Action filter for regions dinied
		filterOut.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				SymbolGroupTable newTable = (SymbolGroupTable) comp.getViewport().getComponent(0);
				int[] rows = newTable.getSelectedRows();
				ArrayList<String> grps = new ArrayList<String>();
				ArrayList<String> chgrps = new ArrayList<String>();
				ArrayList<String> val = new ArrayList<String>();
				String value = "0";
				for(int i=0;i<rows.length;i++)
				{
					
					if(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 0).toString().trim().equals("agrp"))
						grps.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 4).toString().trim());
					newTable.setValueAt(value,rows[i], 1);
					chgrps.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 4).toString().trim());
					val.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 1).toString());
				}
				
				if(grps.size() > 0 || chgrps.size() > 0)
					setGrpFilter(newTable, grps,chgrps, value);
				
				removesymbolsfromprocFilter(val);
			}
		});
		//Action filter for unlimited
		filterUnl.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				SymbolGroupTable newTable = (SymbolGroupTable) comp.getViewport().getComponent(0);
				int[] rows = newTable.getSelectedRows();
				ArrayList<String> grps = new ArrayList<String>();
				ArrayList<String> chgrps = new ArrayList<String>();
				ArrayList<String> val = new ArrayList<String>();
				String value = "-1";
				for(int i=0;i<rows.length;i++)
				{
					
					if(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 0).toString().trim().equals("agrp"))
						grps.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 4).toString().trim());
					newTable.setValueAt(value,rows[i], 1);
					chgrps.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 4).toString().trim());
					
					val.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 1).toString());
				}
				
				if(grps.size() > 0 || chgrps.size() > 0)
					setGrpFilter(newTable, grps,chgrps, value);
				
				removesymbolsfromprocFilter(val);
			}
		});
		//Action filter for off
		filterOff.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				SymbolGroupTable newTable = (SymbolGroupTable) comp.getViewport().getComponent(0);	
				int[] rows = newTable.getSelectedRows();
				ArrayList<String> grps = new ArrayList<String>();
				ArrayList<String> chgrps = new ArrayList<String>();
				String value = "";
				
				ArrayList<String> val = new ArrayList<String>();
				
				for(int i=0;i<rows.length;i++)
				{
					//set filter
					if(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 0).toString().trim().equals("agrp"))
						grps.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 4).toString().trim());
					newTable.setValueAt(value,rows[i], 1);
					chgrps.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 4).toString().trim());
					
					val.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 1).toString());
				}
				
				if(grps.size() > 0 || chgrps.size() > 0)
					setGrpFilter(newTable, grps,chgrps, value);
				
				removesymbolsfromprocFilter(val);
			}
		});
		//Action filter for after some calls
		filterAfter.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				SymbolGroupTable newTable = (SymbolGroupTable) comp.getViewport().getComponent(0);
				int[] rows = newTable.getSelectedRows();
				ArrayList<String> grps = new ArrayList<String>();
				ArrayList<String> chgrps = new ArrayList<String>();
				
				ArrayList<String> val = new ArrayList<String>();
				
				String value = filterText.getText();
				
				for(int i=0;i<rows.length;i++)
				{
					if(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 0).toString().trim().equals("agrp"))
						grps.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 4).toString().trim());
					
					
					newTable.setValueAt(value,rows[i], 1);
					chgrps.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 4).toString().trim());
					
					val.add(newTable.getModel().getValueAt(newTable.getRowSorter().convertRowIndexToModel(rows[i]), 1).toString());
				}
				
				if(grps.size() > 0 || chgrps.size() > 0)
					setGrpFilter(newTable, grps,chgrps, value);
				
				removesymbolsfromprocFilter(val);
			}
		});
		
		return output;
	}
	
	/***
	 * set the filter for every symbol of a group and changes group filter if a symbol changes
	 * @param table table with symbol and group data
	 * @param GrpID list of groups that are changed
	 * @param changedGrpID list of groups were a symbol changed
	 * @param value value the symbols are changed to.
	 */
	private void setGrpFilter(SymbolGroupTable table, ArrayList<String> GrpID, ArrayList<String> changedGrpID, String value)
	{
		ArrayList<String> val = new ArrayList<String>();

		for(int i=0;i<GrpID.size();i++)
		{
			changedGrpID.remove(GrpID.get(i));
		}
		
		for(int i=0;i<table.getModel().getRowCount();i++)
		{
			//if symbol changes unset group
			if(table.getModel().getValueAt(i, 0).equals("agrp") &&
			   changedGrpID.contains(table.getModel().getValueAt(i, 4).toString().trim()))
				table.getModel().setValueAt("", i, 3);
			
			//if group was set, set symbol
			if(table.getModel().getValueAt(i, 4) == null)
				table.getModel().setValueAt(DefaultGroups.DEFAULTGROUP, i, 4);
			if(GrpID.contains(table.getModel().getValueAt(i, 4).toString().trim()))
			{
				val.add(table.getModel().getValueAt(i, 1).toString());
				table.getModel().setValueAt(value, i, 3);
			}
			
			
		}
		
		if(val.size() > 0)
			removesymbolsfromprocFilter(val);
	}
	
	/***
	 * changes view
	 * @return this panel in the special view.
	 */
	public JPanel getPanel(boolean visible)
	{
		for(int j=0;j<this.sTables.size();j++)
		{
			simbolTable = sTables.get(j);
			simbolTable.setView(simbolTable.FILTER_VIEW);
			if(visible){
				help.setVisible(true);
				if(!filtersUnl.get(0).isVisible())
				for(int i=0; i<filtersUnl.size();i++)
				{
					filtersUnl.get(i).setVisible(true);
					filtersOff.get(i).setText("No rule");
					
				}
				simbolTable.hideDefaultStandardGroups(false);
			}else{
				help.setVisible(false);
				if(filtersUnl.get(0).isVisible())
				for(int i=0; i<filtersUnl.size();i++)
				{
					filtersUnl.get(i).setVisible(false);
					filtersOff.get(i).setText("Always traced");
					
				}
				simbolTable.hideDefaultStandardGroups(true);
			}
			simbolTable.setFltFilter(null);
		}
		return this;
	}
	
	/*** 
	 * set {@link SymbolGroupTable simbolGroupTable} with search elements
	 * @param table Table of type SymbolGroupTable
	 */
	public void setSTable(SymbolGroupTable table)
	{
		this.simbolTable = table;	
		
		//update global table
		updateTables(sTables.get(0), table);
		sTables.get(0).find(null);
		//update process filter tables
		for(int i = 1; i <sTables.size();i++)
		{
			updateTables( sTables.get(i), sTables.get(i-1));
		}
	}
	
	/*****
	 * changes that are made in one {@link SymblolGroupTable SymbolGroupTable} are
	 * used to update another
	 * @param currentTable 
	 * @param updateTable
	 * @return true
	 */
	@SuppressWarnings("unchecked")
	private boolean updateTables(SymbolGroupTable currentTable, SymbolGroupTable updateTable)
	{
		
		HashMap<String,Pair<Integer,String>> changes = updateTable.changed;
		if(changes.isEmpty())
			return true;
		
		String reason = "";
		String symbol;
		int index = 0;
		
		//Lists for adding a set of entries 
		ArrayList<String> system = new ArrayList<String>();
		ArrayList<String> name = new ArrayList<String>();
		ArrayList<String> libtype = new ArrayList<String>();
		ArrayList<String> group = new ArrayList<String>();

		for (Map.Entry<String,Pair<Integer,String>> entry : changes.entrySet())
		{
			try{
				if(!(entry.getValue().getLeft() == null))
					index = entry.getValue().getLeft();
				
				symbol = entry.getKey();
				
				reason = entry.getValue().getRight();

				if(reason.equals("rm") && currentTable.entries.containsKey(symbol))
				{
						DefaultRowSorter sorter = (DefaultRowSorter) currentTable.getRowSorter();
						currentTable.setRowSorter(null);
						currentTable.changed.put(symbol, new Pair<Integer,String>(currentTable.entries.get(symbol),reason));
						((DefaultTableModel)currentTable.getModel()).removeRow(currentTable.entries.get(symbol));
						
						for (Map.Entry<String,Integer> entries : currentTable.entries.entrySet())
						{
							if(entries.getValue().intValue() > currentTable.entries.get(symbol).intValue())
								currentTable.entries.put(entries.getKey(), entries.getValue()-1);
						}
						
						currentTable.entries.remove(symbol);
						currentTable.entries.get(symbol);		
						
						currentTable.setRowSorter(sorter);
						sorter.sort();
						
						continue;
					
				}
				
				if(reason.equals("add") && !currentTable.entries.containsKey(symbol))
				{
				   	system.add(updateTable.getModel().getValueAt(index, 0).toString());
					name.add(updateTable.getModel().getValueAt(index, 1).toString());
					libtype.add(updateTable.getModel().getValueAt(index, 2).toString());
					group.add(updateTable.getModel().getValueAt(index, 4).toString());
					continue;
				}	
				
				if(reason.equals("groupDeleted") && currentTable.entries.containsKey(symbol))
				{
					
					
					DefaultRowSorter sorter = (DefaultRowSorter) currentTable.getRowSorter();
					currentTable.setRowSorter(null);
					currentTable.changed.put(symbol, new Pair<Integer,String>(currentTable.entries.get(symbol),reason));
					((DefaultTableModel)currentTable.getModel()).removeRow(currentTable.entries.get(symbol));
					
					
					for (Map.Entry<String,Integer> entries : currentTable.entries.entrySet())
					{
						if(entries.getValue() > currentTable.entries.get(symbol))
							currentTable.entries.put(entries.getKey(), entries.getValue()-1);
					}
					
					currentTable.entries.remove(symbol);
					currentTable.entries.get(symbol);		
			
					currentTable.setRowSorter(sorter);
					sorter.sort();
					
					continue;
				}
				
				if(reason.startsWith("grouprenamed:"))
				{
					//if it is not set, add the new group
					if(!currentTable.entries.containsKey(symbol))
					{
						currentTable.addRow(reason.substring(13, reason.length()), reason.substring(12, reason.length()), "agrp");
					}else{
					//else rename the current group
						currentTable.getModel().setValueAt(reason.substring(13, reason.length()), currentTable.entries.get(symbol), 1);
						currentTable.getModel().setValueAt(reason.substring(13, reason.length()), currentTable.entries.get(symbol), 4);
						currentTable.entries.put("g"+reason.substring(13, reason.length()), currentTable.entries.get(symbol));
						currentTable.entries.remove(symbol);
						currentTable.changed.put(symbol, new Pair<Integer,String>(currentTable.entries.get("g"+reason.substring(13, reason.length())),reason));
					}
					continue;
				}
				
				if(reason.startsWith("regrouped"))
				{
					//if it is not set, it will be added 
					if(!currentTable.entries.containsKey(symbol))
					{
					   	system.add(updateTable.getModel().getValueAt(index, 0).toString());
						name.add(updateTable.getModel().getValueAt(index, 1).toString());
						libtype.add(updateTable.getModel().getValueAt(index, 2).toString());
						group.add(updateTable.getModel().getValueAt(index, 4).toString());
					}
					else
					{
						//otherwise the group changes
						currentTable.getModel().setValueAt(
							updateTable.getModel().getValueAt(index, 4),
							currentTable.entries.get(symbol),
							4);
						currentTable.changed.put(symbol, new Pair<Integer,String>(currentTable.entries.get(symbol),reason));
					}
					continue;
				}
				
				if(reason.startsWith("addGroup") && !currentTable.entries.containsKey(symbol))
				{
					currentTable.addRow(symbol.substring(1), symbol.substring(1), "agrp");
					currentTable.changed.put(symbol, new Pair<Integer,String>(currentTable.entries.get(symbol),reason));
				 	continue;
				}
			}catch(Exception e)
			{
				Config.errorHandler(e);
			}
			
		}
		currentTable.find(null);
		//Add symbols and/or groups
		if(!name.isEmpty())
			currentTable.addRow(name, group, system, libtype);
		
		//remove change log 
		updateTable.changed.clear();
		
			
		return true;
	}

	/***
	 * Generates a Filter File and save it to the File set by FileName
	 * @param FileName path to the file were the filter file is generated
	 */
	public void generateFilterFile(String FileName)
	{
		
		BufferedWriter out = null;
		if(FileName == null || FileName.trim().equals(""))
		{
			System.out.println("no filter file was generated!");
		}
		else
		{
			try{
				out = new BufferedWriter(
		                new OutputStreamWriter(
		                        new FileOutputStream( FileName ) 
		                        ) 
		        );
				
				//out.newLine();
				out.write("# VampirTrace region filter specification\n");
				out.write("# generated with VTSetup\n");
				out.newLine();
				out.newLine();
				
				DefaultTableModel help = null;
				String ranks = "";
				String ausgabe = "";
				Hashtable<String,ArrayList<String>> filter = new Hashtable<String,ArrayList<String>>();
				ArrayList<String> helpList = null;
				ArrayList<String> usedSimbols = new ArrayList<String>();
				for(int i=0;i<sTables.size();i++)
				{
					
					// ***** Get filtered symbols
					help = (DefaultTableModel) sTables.get(i).getModel();
					if(i>0)
					{
						ranks=tabbedPane.getTitleAt(i)+"\n";
						ranks = "@"+ranks.substring(ranks.indexOf(":")+1);
					}
					else
						ranks = "";
					
					if(i>0 && ((JRadioButton)((JPanel)getTabContent(i).getComponent(2)).getComponent(2)).isSelected())
					{
						out.write(ranks);
						out.write("* -- 0");
						out.newLine();
						
						continue;
					}
					
					for(int j=0;j<help.getRowCount();j++)
					{
						if((help.getValueAt(j, 3) == null || help.getValueAt(j, 3).toString().trim().equals("")) ||
							(help.getValueAt(j, 0).toString().trim().equals("agrp")) || usedSimbols.contains(help.getValueAt(j, 1).toString())
						)
							continue;
						if(filter.containsKey(help.getValueAt(j, 3).toString()))
						{
							filter.get(help.getValueAt(j, 3).toString()).add(help.getValueAt(j, 1).toString());
							if(i==0)
								usedSimbols.add(help.getValueAt(j, 1).toString());
						}
						else
						{
							ArrayList<String> helpEntry = new ArrayList<String>();
							helpEntry.add(help.getValueAt(j, 1).toString());
							filter.put(help.getValueAt(j, 3).toString(), helpEntry);
							if(i==0)
								usedSimbols.add(help.getValueAt(j, 1).toString());
						}
					}
					
					// ***** Write symbols
					Iterator<String> keys = filter.keySet().iterator();
					String filterroul = "";
					while(keys.hasNext())
					{
						filterroul = keys.next().toString();
						helpList = filter.get(filterroul);
						ausgabe = "";
						for(int j=0;j<helpList.size()-1;j++)
						{
							ausgabe = ausgabe+helpList.get(j)+";";
						}
						ausgabe = ausgabe+helpList.get(helpList.size()-1)+" -- "+filterroul;
						out.write(ranks);
						out.write(ausgabe);
						out.newLine();
						
						
					}
					filter.clear();
				
				}
				
				if(out != null)
					out.close();
			}catch(Exception ex)
			{
				Config.errorHandler(ex);
			}
			
		}
	}

	/***
	 * set all settings of an saved session. 
	 * @param loadString saved settings
	 * @param table table with all symbol informations
	 */
	@SuppressWarnings("unchecked")
	public void loadSettings(String loadString, SymbolGroupTable table)
	{
		try{
			
			
			String[] array = loadString.split("\n");
			tabbedPane.removeAll();
			sTables.clear();
			ArrayList<ArrayList<Pair<String,String>>> filter = new ArrayList<ArrayList<Pair<String,String>>>();
			for(int i=0;i<array.length;i++)
			{
				//comments
				if(array[i].length() < 1 || array[i].startsWith("#"))
					continue;
				
				//set filter all to last added tab
				if(array[i].equals("===FILTERALL"))
				{

						JPanel help = (JPanel) getTabContent(tabbedPane.getComponentCount()-4).getComponent(2);
						((JRadioButton)help.getComponent(2)).setSelected(true);
						help = (JPanel) getTabContent(tabbedPane.getComponentCount()-4).getComponent(3);
            			((JLabel) ((JPanel)help.getComponent(0)).getComponent(0)).setEnabled(false);
            			((JPanel) ((JPanel)help.getComponent(0)).getComponent(1)).getComponent(0).setEnabled(false);
            			((JPanel) ((JPanel)help.getComponent(0)).getComponent(1)).getComponent(1).setEnabled(false);
            			((JPanel) ((JPanel)help.getComponent(0)).getComponent(1)).getComponent(2).setEnabled(false);
            			
            			((JScrollPane) ((JPanel)help.getComponent(0)).getComponent(2)).getViewport().getComponent(0).setEnabled(false);
            			((MySymbolTableRenderer)((SymbolGroupTable) ((JScrollPane) ((JPanel)help.getComponent(0)).getComponent(2)).getViewport().getComponent(0)).c).setDisabled();
            			
            			
            			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(0).setEnabled(false);
            			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(1).setEnabled(false);
            			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(2).setEnabled(false);
            			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(3).setEnabled(false);
            			((JPanel) ((JPanel)help.getComponent(0)).getComponent(3)).getComponent(4).setEnabled(false);
            			((JButton) ((JPanel)help.getComponent(0)).getComponent(4)).setEnabled(false);
            			
				}
				
				//add new tab
				if(array[i].startsWith("@"))
				{
					if(array[i].trim().length()==1)
						tabbedPane.addTab("Global", makeGlobalPanel());
					else
						addTab(array[i].substring(1));
					filter.add(new ArrayList<Pair<String,String>>());
				}
				
				//make notice of filterroul
				if(array[i].contains(";"))
				{
					String[] array2 = array[i].split(";");
					filter.get(filter.size()-1).add(new Pair<String,String>(array2[0],array2[1]));
				}
			}
			//fill SymbolTable with data
			setSTable(table);
			SymbolGroupTable helptable = null;
			ArrayList<Pair<String,String>> help = null;
			for(int i=0;i<filter.size();i++)
			{
				help =filter.get(i);
				helptable =  sTables.get(i);
				helptable.find(null);
				RowSorter row = helptable.getRowSorter();
				helptable.setRowSorter(null);
				for(int j=0;j<help.size();j++)
				{
					if(helptable.entries.containsKey("s"+help.get(j).getLeft().trim()))
						helptable.setValueAt(help.get(j).getRight(),helptable.entries.get("s"+help.get(j).getLeft().trim()),1);
					if(helptable.entries.containsKey("l"+help.get(j).getLeft().trim()))
						helptable.setValueAt(help.get(j).getRight(),helptable.entries.get("l"+help.get(j).getLeft().trim()),1);
					if(helptable.entries.containsKey("g"+help.get(j).getLeft().trim()))
						helptable.setValueAt(help.get(j).getRight(),helptable.entries.get("g"+help.get(j).getLeft().trim()),1);
				}
				helptable.setRowSorter(row);
			}
		}catch(Exception ex)
		{
			Config.errorHandler(ex);
		}
	}
	
	/***
	 * Generates a string that can be used to {@link #loadSettings(String, SymbolGroupTable) load settings}
	 * @return String with all informations to reset all settings
	 */
	public String generateSaveString()
	{
		DefaultTableModel model = null;
		String output = "#save filter settings\n\n";
		Object help = "";
		String ranks = "";
		for(int k=0;k<sTables.size();k++)
		{
			if(k>0){
				ranks=tabbedPane.getTitleAt(k);
				ranks = "@"+ranks.substring(ranks.indexOf(":")+1);
				if(((JRadioButton)((JPanel)getTabContent(k).getComponent(2)).getComponent(2)).isSelected())
				{
					ranks +="\n===FILTERALL";
				}
			}else
				ranks = "@";
			
			output += "\n\n"+ranks+"\n";
			model = (DefaultTableModel) sTables.get(k).getModel();
			
			for(int i=0;i<model.getRowCount();i++)
			{
				if(model.getValueAt(i, 3) == null || model.getValueAt(i, 3).toString().trim().equals("") || model.getValueAt(i, 0).toString().trim().equals("agrp"))
					continue;
					help = model.getValueAt(i, 1);
					if(help==null)
						help="";
					output += help.toString()+";";
					
					help = model.getValueAt(i, 3);
					if(help==null)
						help="";
					output += help.toString()+";";
				
				output += "\n";
				
			}
		}
		return output;
	}


	/***
	 * help method that returns the content of a tab 
	 * @param index index of the tab
	 * @return content of the tab with the given index
	 */
	private JPanel getTabContent(int index)
	{
		JPanel panel = null;
		panel = (JPanel)((JPanel)((JPanel)tabbedPane.getComponentAt(index)).getComponent(0)).getComponent(0);
		return panel;
	}
	
	 private void removesymbolsfromprocFilter(ArrayList<String> val)
	    {
	    	if(tabbedPane.getSelectedIndex() == 0 && sTables.size() > 1)
	    	{
	    		ArrayList<String> delname = new ArrayList<String>();
	    		ArrayList<String> name = new ArrayList<String>();
	    		ArrayList<String> group = new ArrayList<String>();
	    		ArrayList<String> lybtype = new ArrayList<String>();
	    		ArrayList<String> system = new ArrayList<String>();
	    		SymbolGroupTable help = sTables.get(0);
	    		int index = 0;
	    		String value = "";
	    		for(int i=0;i<val.size();i++)
	    		{
	    			value = "s"+val.get(i);
	    			if(!help.entries.containsKey(value))
	    				value = "g"+val.get(i);
	    			if(!help.entries.containsKey(value))
	    				continue;
	    			index = help.entries.get(value);
	    			if(help.getModel().getValueAt(index, 3).toString().trim().equals(""))
	    			{
	    				if(value.startsWith("s") && !val.contains(help.getModel().getValueAt(index, 4).toString()))
	    				{
	    					val.add(help.getModel().getValueAt(index, 4).toString());
	    				}
	    				name.add(help.getModel().getValueAt(index, 1).toString());
	    				group.add(help.getModel().getValueAt(index, 4).toString());
	    				system.add(help.getModel().getValueAt(index, 0).toString());
	    				lybtype.add(help.getModel().getValueAt(index, 2).toString());
	    				
	    			}
	    			else
	    			{
	    				delname.add(value);
	    			}
	    		}
	    		
	    		for(int i=1;i<sTables.size();i++)
	    		{
	    			help = sTables.get(i);

	    			if(delname.size() > 0)
	    			{
		    			SymbolGroupTable.MySorter s = (SymbolGroupTable.MySorter) help.getRowSorter();
						help.setRowSorter(null);
	    				for(int j=0;j<delname.size();j++)
	    				{
	    					if(help.entries.containsKey(delname.get(j).trim()))
	    					{
	    						
		    					index = help.entries.get(delname.get(j).trim());
		    					((DefaultTableModel)help.getModel()).removeRow(index);		    					
		    					help.entries.remove(delname.get(j).trim());
		    					Iterator<Entry<String, Integer>> keys = help.entries.entrySet().iterator();
		    					while(keys.hasNext())
		    					{
		    						Entry<String,Integer> entry = keys.next();
		    						if(entry.getValue()> index)
		    							entry.setValue(entry.getValue()-1);
		    					}
	    					}
	    				}
	    				
	    				help.setRowSorter(s);
	    				s.sort();
	    				
	    			}
	    			
	    			if(name.size() > 0)
	    				help.addRow(name, group, system, lybtype);
    			
	    		}
	    		
	    	}
	    }
	
	/**
	 * Component to be used as tabComponent;
	 * Contains a JLabel to show the text and 
	 * a JButton to close the tab it belongs to 
	 */ 
	public class ButtonTabedComponent extends JPanel {
	    /**
		 * serial VersionUID
		 */
		private static final long serialVersionUID = 1L;
		private final JTabbedPane pane;

		/***
		 * Initialization of this component
		 * @param pane tab component
		 */
	    public ButtonTabedComponent(final JTabbedPane pane) {
	        //unset default FlowLayout' gaps
	        super(new FlowLayout(FlowLayout.LEFT, 0, 0));
	        if (pane == null) {
	            throw new NullPointerException("TabbedPane is null");
	        }
	        this.pane = pane;
	        setOpaque(false);
	        
	        //make JLabel read titles from JTabbedPane
	        JLabel label = new JLabel() {
	            /**
				 *  serial VersionUID
				 */
				private static final long serialVersionUID = 1L;

				public String getText() {
	                int i = pane.indexOfTabComponent(ButtonTabedComponent.this);
	                if (i != -1) {
	                    return pane.getTitleAt(i);
	                }
	                return null;
	            }
	        };
	        
	        add(label);
	        //add more space between the label and the button
	        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
	        //tab button
	        JButton button = new TabButton();

	        add(button);
	        //add more space to the top of the component
	        setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
	    }

	    
	    private class TabButton extends JButton implements ActionListener {
	        /**
			 *  serial VersionUID
			 */
			private static final long serialVersionUID = 1L;

			public TabButton() {
	            int size = 17;
	            setPreferredSize(new Dimension(size, size));
	            setToolTipText("close this tab");
	            //Make the button looks the same for all Laf's
	            setUI(new BasicButtonUI());
	            //Make it transparent
	            setContentAreaFilled(false);
	            //No need to be focusable
	            setFocusable(false);
	            setBorder(BorderFactory.createEtchedBorder());
	            setBorderPainted(false);
	            //Making nice rollover effect
	            //we use the same listener for all buttons
	            addMouseListener(buttonMouseListener);
	            setRolloverEnabled(true);
	            //Close the proper tab by clicking the button
	            addActionListener(this);
	        }

	        public void actionPerformed(ActionEvent e) {
	            int i = pane.indexOfTabComponent(ButtonTabedComponent.this);
	            if (i != -1) {
	                pane.remove(i);
	                sTables.remove(i);

	           try{
	        	   if(i == 1 && tabbedPane.getComponentCount()>i+3)
	        		   ((JPanel)getTabContent(i).getComponent(1)).getComponent(0).setEnabled(false);
	           }catch(IndexOutOfBoundsException ex)
	           {
	        	   Config.errorHandler(ex);
	           }
	            		
	           try{
	        	   if(tabbedPane.getComponentCount()>i+3)
	        		   pane.getComponentAt(i);
	        	   else
	        		   if(i != 1)
	        			   ((JPanel)getTabContent(i-1).getComponent(1)).getComponent(1).setEnabled(false);  
	           }catch(IndexOutOfBoundsException ex)
	           {
	        	   
	        	   Config.errorHandler(ex);
	           }
	           
	                
	            }
	        }

	        //we don't want to update UI for this button
	        public void updateUI() {
	        }

	        //paint the cross
	        protected void paintComponent(Graphics g) {
	            super.paintComponent(g);
	            Graphics2D g2 = (Graphics2D) g.create();
	            //shift the image for pressed buttons
/*
	            if (getModel().isPressed()) {
	                g2.translate(1, 1);
	            }
	            g2.setStroke(new BasicStroke(2));
	            g2.setColor(Color.BLACK);
	            if (getModel().isRollover()) {
	                g2.setColor(Color.RED);
	            }
	            
	            int delta = 4;
	            g2.drawLine(delta, delta, getWidth() - delta - 1, getHeight() - delta - 1);
	            g2.drawLine(getWidth() - delta - 1, delta, delta, getHeight() - delta - 1);
	            g2.dispose();
	            */

				ImageIcon pic = null;
				 if (getModel().isRollover()) {
					pic =  new ImageIcon(Group.class.getClass().getResource(VtEnv.srcFolder+Config.Image_TABCLOSE_OVER));
				 }else{
					 pic = new ImageIcon(Group.class.getClass().getResource(VtEnv.srcFolder+Config.Image_TABCLOSE));
				 }
				 Image img = pic.getImage(); 
			//	BufferedImage bi = new BufferedImage(getWidth(), getHeight(), BufferedImage.TYPE_INT_ARGB);  
				g2.drawImage(img, 0, 0, getWidth(), getHeight(), null, null); 
	            g2.dispose();
	        }
	        
	    }

	    private final MouseListener buttonMouseListener = new MouseAdapter() {
	        public void mouseEntered(MouseEvent e) {
	            Component component = e.getComponent();
	            if (component instanceof AbstractButton) {
	                AbstractButton button = (AbstractButton) component;
	                button.setBorderPainted(true);
	            }
	        }

	        public void mouseExited(MouseEvent e) {
	            Component component = e.getComponent();
	            if (component instanceof AbstractButton) {
	                AbstractButton button = (AbstractButton) component;
	                button.setBorderPainted(false);
	            }
	        }
	    };
	}
	
}
