/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2007-2019 PCOpt/NTUA
    Copyright (C) 2013-2019 FOSS GP
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.


Class
    Foam::steepestDescent

Description
    Update design variables using steepest descent

SourceFiles
    steepestDescent.C

\*---------------------------------------------------------------------------*/

#ifndef steepestDescent_H
#define steepestDescent_H

#include "updateMethod.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                       Class steepestDescent Declaration
\*---------------------------------------------------------------------------*/

class steepestDescent
:
    public updateMethod
{
private:

    // Private Member Functions

        //- No copy construct
        steepestDescent(const steepestDescent&);

        //- No copy assignment
        void operator=(const steepestDescent&);

public:

    //- Runtime type information
    TypeName("steepestDescent");


    // Constructors

        //- Construct from components
        steepestDescent(const fvMesh& mesh, const dictionary& dict);


    //- Destructor
    virtual ~steepestDescent() = default;


    // Member Functions

       // compute design variables correction
       void computeCorrection();
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
