#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SoftwareUpdateConformsToProfile.mof
	cimmof -aE -n $4 $6/mof/OpenDRIM_SoftwareUpdateConformsToProfile.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SoftwareUpdateConformsToProfile provider module";
Name = "SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfileModule";
Location = "cmpiSoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfileProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SoftwareUpdateConformsToProfile provider";
Name = "SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfileProvider";
ProviderModuleName = "SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfileModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SoftwareUpdateConformsToProfile provider capabilities";
ProviderModuleName = "SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfileModule";
ProviderName = "SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfileProvider";
ClassName = "OpenDRIM_SoftwareUpdateConformsToProfile";
ProviderType = {2, 3};
Namespaces = {"$1", "$4"};
SupportedProperties = {"ConformantStandard", "ManagedElement"};
CapabilityID = "SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SoftwareUpdateConformsToProfile.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SoftwareUpdateConformsToProfile]   
   provider: SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfileProvider
   location: cmpiSoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfileProvider
   type: instance association
   namespace: $1 $4
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SoftwareUpdateConformsToProfile.mof
	sfcbstage -r $OUTFILE -n $4 $6/mof/OpenDRIM_SoftwareUpdateConformsToProfile.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SoftwareUpdateConformsToProfile-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SoftwareUpdateConformsToProfile.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	owmofc -u http://localhost/$4 $OUTFILE
	
	rm -f $OUTFILE
	
fi
