/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.IvyAuthenticator;
import org.apache.ivy.util.url.URLHandler$URLInfo;

public final class BasicURLHandler
extends AbstractURLHandler {
    public final URLHandler$URLInfo getURLInfo(URL uRL) {
        return this.getURLInfo$57a0216e(uRL);
    }

    /*
     * Unable to fully structure code
     */
    private URLHandler$URLInfo getURLInfo$57a0216e(URL var1_1) {
        block13: {
            block11: {
                block12: {
                    block10: {
                        if ("http".equals(var1_1.getProtocol()) || "https".equals(var1_1.getProtocol())) {
                            IvyAuthenticator.install();
                        }
                        var2_2 = null;
                        var1_1 = BasicURLHandler.normalizeToURL(var1_1);
                        var2_2 = var1_1.openConnection();
                        var2_2.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
                        if (!(var2_2 instanceof HttpURLConnection)) ** GOTO lbl19
                        var3_3 = (HttpURLConnection)var2_2;
                        if (BasicURLHandler.getRequestMethod() == 2) {
                            var3_3.setRequestMethod("HEAD");
                        }
                        if (!BasicURLHandler.checkStatusCode(var1_1, var3_3)) break block10;
                        var4_7 = new URLHandler$URLInfo(true, var3_3.getContentLength(), var2_2.getLastModified());
                        BasicURLHandler.disconnect(var2_2);
                        return var4_7;
                    }
                    break block11;
lbl19:
                    // 1 sources

                    var3_4 = var2_2.getContentLength();
                    if (var3_4 > 0) break block12;
                    var4_8 = BasicURLHandler.UNAVAILABLE;
                    BasicURLHandler.disconnect(var2_2);
                    return var4_8;
                }
                try {
                    var4_9 = new URLHandler$URLInfo(true, var3_4, var2_2.getLastModified());
                }
                catch (UnknownHostException var3_5) {
                    Message.warn("Host " + var3_5.getMessage() + " not found. url=" + var1_1);
                    Message.info("You probably access the destination server through a proxy server that is not well configured.");
                    BasicURLHandler.disconnect(var2_2);
                    break block13;
                }
                catch (IOException var3_6) {
                    Message.error("Server access Error: " + var3_6.getMessage() + " url=" + var1_1);
                    {
                        catch (Throwable var5_10) {
                            BasicURLHandler.disconnect(var2_2);
                            throw var5_10;
                        }
                    }
                    BasicURLHandler.disconnect(var2_2);
                }
                BasicURLHandler.disconnect(var2_2);
                return var4_9;
            }
            BasicURLHandler.disconnect(var2_2);
        }
        return BasicURLHandler.UNAVAILABLE;
    }

    private static boolean checkStatusCode(URL uRL, HttpURLConnection httpURLConnection) {
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            return true;
        }
        if ("HEAD".equals(httpURLConnection.getRequestMethod()) && n == 204) {
            return true;
        }
        Message.debug("HTTP response status: " + n + " url=" + uRL);
        if (n == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(n).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + httpURLConnection.getResponseMessage() + " url=" + uRL);
        } else if (String.valueOf(n).startsWith("5")) {
            Message.error("SERVER ERROR: " + httpURLConnection.getResponseMessage() + " url=" + uRL);
        }
        return false;
    }

    public final InputStream openStream(URL uRL) {
        ByteArrayInputStream byteArrayInputStream;
        if ("http".equals(uRL.getProtocol()) || "https".equals(uRL.getProtocol())) {
            IvyAuthenticator.install();
        }
        URLConnection uRLConnection = null;
        try {
            int n;
            Object object;
            uRL = BasicURLHandler.normalizeToURL(uRL);
            uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
            uRLConnection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            if (uRLConnection instanceof HttpURLConnection && !BasicURLHandler.checkStatusCode(uRL, (HttpURLConnection)(object = (HttpURLConnection)uRLConnection))) {
                throw new IOException("The HTTP response code for " + uRL + " did not indicate a success." + " See log for more detail.");
            }
            object = BasicURLHandler.getDecodingInputStream(uRLConnection.getContentEncoding(), uRLConnection.getInputStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65536];
            while ((n = ((InputStream)object).read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            BasicURLHandler.disconnect(uRLConnection);
            throw throwable;
        }
        BasicURLHandler.disconnect(uRLConnection);
        return byteArrayInputStream;
    }

    public final void download(URL uRL, File file2, CopyProgressListener copyProgressListener) {
        URLConnection uRLConnection;
        block5: {
            if ("http".equals(uRL.getProtocol()) || "https".equals(uRL.getProtocol())) {
                IvyAuthenticator.install();
            }
            uRLConnection = null;
            try {
                int n;
                HttpURLConnection httpURLConnection;
                uRL = BasicURLHandler.normalizeToURL(uRL);
                uRLConnection = uRL.openConnection();
                uRLConnection.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
                uRLConnection.setRequestProperty("Accept-Encoding", "gzip,deflate");
                if (uRLConnection instanceof HttpURLConnection && !BasicURLHandler.checkStatusCode(uRL, httpURLConnection = (HttpURLConnection)uRLConnection)) {
                    throw new IOException("The HTTP response code for " + uRL + " did not indicate a success." + " See log for more detail.");
                }
                FileUtil.copy(BasicURLHandler.getDecodingInputStream(uRLConnection.getContentEncoding(), uRLConnection.getInputStream()), file2, copyProgressListener);
                if (uRLConnection.getContentEncoding() == null && (n = uRLConnection.getContentLength()) != -1 && file2.length() != (long)n) {
                    file2.delete();
                    throw new IOException("Downloaded file size doesn't match expected Content Length for " + uRL + ". Please retry.");
                }
                long l = uRLConnection.getLastModified();
                if (l <= 0L) break block5;
                file2.setLastModified(l);
            }
            catch (Throwable throwable) {
                BasicURLHandler.disconnect(uRLConnection);
                throw throwable;
            }
        }
        BasicURLHandler.disconnect(uRLConnection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void disconnect(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            block27: {
                if (!"HEAD".equals(((HttpURLConnection)uRLConnection).getRequestMethod())) {
                    InputStream inputStream;
                    byte[] byArray;
                    HttpURLConnection httpURLConnection;
                    block26: {
                        httpURLConnection = (HttpURLConnection)uRLConnection;
                        byArray = new byte[65536];
                        InputStream inputStream2 = null;
                        try {
                            inputStream2 = httpURLConnection.getInputStream();
                            while (inputStream2.read(byArray) > 0) {
                            }
                            if (inputStream2 == null) break block26;
                        }
                        catch (IOException iOException) {
                            if (inputStream2 != null) {
                                try {
                                    inputStream2.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block26;
                        }
                        catch (Throwable throwable) {
                            if (inputStream2 == null) throw throwable;
                            try {
                                inputStream2.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if ((inputStream = httpURLConnection.getErrorStream()) != null) {
                        try {
                            while (inputStream.read(byArray) > 0) {
                            }
                        }
                        catch (IOException iOException) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException3) {}
                            break block27;
                        }
                        catch (Throwable throwable) {
                            try {
                                inputStream.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ((HttpURLConnection)uRLConnection).disconnect();
            return;
        }
        if (uRLConnection == null) return;
        try {
            uRLConnection.getInputStream().close();
            return;
        }
        catch (IOException iOException) {}
    }
}

