"""Small example Nyquist OSC client

This program sends 10 random values between 0.0 and 1.0 to /slider 1,
waiting for 1 second between each value.
"""
import argparse
import random
import time

from pythonosc import udp_client


if __name__ == "__main__":
  parser = argparse.ArgumentParser()
  parser.add_argument("--ip", default="127.0.0.1",
      help="The ip of the OSC server")
  parser.add_argument("--port", type=int, default=7770,
      help="The port the OSC server (Nyquist) is listening on")
  args = parser.parse_args()

  client = udp_client.SimpleUDPClient(args.ip, args.port)

  for x in range(10):
    client.send_message("/slider", [1, random.random()])
    time.sleep(1)
