---
id: fast-element.htmlview
title: HTMLView class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-element](./fast-element.md) &gt; [HTMLView](./fast-element.htmlview.md)

## HTMLView class

The standard View implementation, which also implements ElementView and SyntheticView.

<b>Signature:</b>

```typescript
export declare class HTMLView implements ElementView, SyntheticView 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(fragment, behaviors)](./fast-element.htmlview._constructor_.md) |  | Constructs an instance of HTMLView. |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [context](./fast-element.htmlview.context.md) |  | [ExecutionContext](./fast-element.executioncontext.md) \| null | The execution context the view is running within. |
|  [firstChild](./fast-element.htmlview.firstchild.md) |  | Node | The first DOM node in the range of nodes that make up the view. |
|  [lastChild](./fast-element.htmlview.lastchild.md) |  | Node | The last DOM node in the range of nodes that make up the view. |
|  [source](./fast-element.htmlview.source.md) |  | any \| null | The data that the view is bound to. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [appendTo(node)](./fast-element.htmlview.appendto.md) |  | Appends the view's DOM nodes to the referenced node. |
|  [bind(source, context)](./fast-element.htmlview.bind.md) |  | Binds a view's behaviors to its binding source. |
|  [dispose()](./fast-element.htmlview.dispose.md) |  | Removes the view and unbinds its behaviors, disposing of DOM nodes afterward. Once a view has been disposed, it cannot be inserted or bound again. |
|  [disposeContiguousBatch(views)](./fast-element.htmlview.disposecontiguousbatch.md) | <code>static</code> | Efficiently disposes of a contiguous range of synthetic view instances. |
|  [insertBefore(node)](./fast-element.htmlview.insertbefore.md) |  | Inserts the view's DOM nodes before the referenced node. |
|  [remove()](./fast-element.htmlview.remove.md) |  | Removes the view's DOM nodes. The nodes are not disposed and the view can later be re-inserted. |
|  [unbind()](./fast-element.htmlview.unbind.md) |  | Unbinds a view's behaviors from its binding source. |
