if (typeof T === 'undefined') require('../setup');

T('toOctal', function () {

  var t = function (expected, n, sd, rm) {
    Decimal.precision = sd;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).toOctal());
  }

  Decimal.config({
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', NaN, 20, 4);
  t('NaN', 'NaN', 20, 4);
  t('Infinity', Infinity, 20, 4);
  t('-Infinity', -Infinity, 20, 4);
  t('Infinity', 'Infinity', 20, 4);
  t('-Infinity', '-Infinity', 20, 4);

  // Integers

  t('0o0', '0', 1, 4);
  t('0o171634571716400543513334300705612071133717535572246575453160', '364584667335183828987221775272570428237696628507956848', 60, 4);
  t('0o17140110747560', '1043696177008', 14, 4);
  t('0o1656', '942', 4, 4);
  t('0o642677755550042022420042650122720673705371422153432', '9341223088519577080757976073309527669316572954', 51, 4);
  t('0o1651372117475740354637456547', '4427164671782016593583463', 28, 4);
  t('0o432', '282', 3, 4);
  t('0o1156036607174723020034543345673164620146641', '103357460209213083948351046056291650977', 43, 4);
  t('0o347175', '118397', 6, 4);
  t('0o250711224523642463565466455623', '408358568053857594342267795', 30, 4);
  t('0o31464741215652662410302172736', '61905218854453628692395486', 29, 4);
  t('0o1151171074647051031165674252760067', '764101851531641191689328779319', 34, 4);
  t('0o111627132417321114752432320745434507337525667340540534056666', '220880699124044497678574383774865426395965086166441398', 60, 4);
  t('0o66607051535464671602731746325356021372265', '9099202145653789818834446363266512053', 41, 4);
  t('0o472035076601272777773466260770745221025541771310455547267433', '940021031620376267748547570264155096359926520862306075', 60, 4);
  t('0o35100215607256233370100157131103657413347736114726441', '332554887108209374458014391052845453182019808545', 53, 4);
  t('0o722062570016143', '32030085618787', 15, 4);
  t('0o74663674130162363012065031725670307006351247702', '2650448086139415170144453379569169365028802', 47, 4);
  t('0o221016156567502', '9966232203074', 15, 4);
  t('0o761570133215525640271', '8966391655604633785', 21, 4);
  t('0o101530101442425775517477023774', '158785455373148008304355324', 30, 4);
  t('0o374160464102717737077444644401061474361141636', '21456498302081433312710883059235111093150', 45, 4);
  t('0o31342760667031767334646421766116726252335314714', '1108212082493888677367272229520408961194444', 47, 4);
  t('0o272343723733570133550665013', '880462300728651545799179', 27, 4);
  t('0o27330316426437424646561612652414263301414200342717', '522342837272716004737400194551917026620851663', 50, 4);
  t('0o33', '27', 2, 4);
  t('0o6410235531675374505654365627', '15755268886904815024728983', 28, 4);
  t('0o462207311743', '41106117603', 12, 4);
  t('0o35434021473746', '2030987278310', 14, 4);
  t('0o10766710063735420744724674434722341532775011206477', '200309946175742618027595387139557376886377791', 50, 4);
  t('0o264652754111247167745300734100146216146065', '30046186741840723600384513771105209397', 42, 4);
  t('0o1717051362601647', '67007056380839', 16, 4);
  t('0o420547635403', '36601543427', 12, 4);
  t('0o113650166605747526017701737745742053073656134564465203303', '443294363845688739540957905727674168806539626088131', 57, 4);
  t('0o1403535540244734200354', '13901404808061976812', 22, 4);
  t('0o74712131706533505237435313', '287567912644119793384139', 26, 4);
  t('0o5136777371700436', '182450142019870', 16, 4);
  t('0o2035677377165', '141448576629', 13, 4);
  t('0o271106223317652510470133141417013436324344447232', '8063865882119118770028661617297344888458906', 48, 4);
  t('0o1021722', '271314', 7, 4);
  t('0o7036036165443146', '248356246275686', 16, 4);
  t('0o6470565', '1732981', 7, 4);
  t('0o61216176216205012773031', '454507717401133184537', 23, 4);
  t('0o3002513066606060620347136440362562046653642', '255651532540391785253392875614499461026', 43, 4);
  t('0o456', '302', 3, 4);
  t('0o17065041017173527170644622577111123272557633404173157515', '88295987850015910722625103099562923405439709011789', 56, 4);
  t('0o16027026131232476667231251', '66325667775824613159593', 26, 4);
  t('0o16625630637244103026266171376764352575040', '2457838121719672737744590760418408992', 41, 4);
  t('0o1561736223610', '118371198856', 13, 4);
  t('0o15056662412721204036161014', '61822867030969079620108', 26, 4);
  t('0o3477263035715376447112210', '17112580757759444423816', 25, 4);
  t('0o161037100117541', '7769478438753', 15, 4);
  t('0o32556410147661251456104752223004', '33072622383942794561666491908', 32, 4);
  t('0o1211474324420476530235671057512302', '804188130270400499435404432578', 34, 4);
  t('0o36007574066667272553066076615170250031017703', '2553404178224213798051876650192088604611', 44, 4);
  t('0o1237051', '343593', 7, 4);
  t('0o366237621254212707310212730126632527636236606', '20953914213183846148388529652331213045126', 45, 4);
  t('0o676337572246445153657', '8042293848523986863', 21, 4);
  t('0o157423050242731427202356723', '526719833217016133180883', 27, 4);
  t('0o7732111706233511415326631451', '19164044677656856523125545', 28, 4);
  t('0o133574562456214335435', '1652705792533576477', 21, 4);
  t('0o12151', '5225', 5, 4);
  t('0o1372066706', '199781830', 10, 4);
  t('0o37324076026320245555326737570636206', '19911177604481197795113399696518', 35, 4);
  t('0o2436', '1310', 4, 4);
  t('0o15576357436114241002422756773501074050', '4461159021738482150619844582864936', 38, 4);
  t('0o25163361', '5564145', 8, 4);
  t('0o563305225055677232242325342', '1753817655195311740136162', 27, 4);
  t('0o1730611463642631260026156435013323236764317226', '83774860480485487711819613225974439714454', 46, 4);
  t('0o3124144616475210442326726176753', '3917395568817125518374141419', 31, 4);
  t('0o122551245377370372510600247650271544', '52420971115555265131642802500452', 36, 4);
  t('0o711265667352525777055750103304054072', '289883291844318827546712512419898', 36, 4);
  t('0o1424357303022501420341156201', '3723432687881212284689537', 28, 4);
  t('0o51147130442424172652616112', '194568628606971297864778', 26, 4);
  t('0o3427410030517411126776423004072314', '2247499600567123820908846806220', 34, 4);
  t('0o16602427320624026652410144225431222411', '4788262207154170686928960302163209', 38, 4);
  t('0o46144610334425521434631035561707752201423', '6346533567879985413095577825858618131', 41, 4);
  t('0o1130215551', '157358953', 10, 4);
  t('0o1214401', '334081', 7, 4);
  t('0o222116623333265530440631564017304', '180929743300409204225159995076', 33, 4);
  t('0o15567437201441347355454544146426241554605511544026607651', '80286234176563111847045853769570753921004267573161', 56, 4);
  t('0o2254120142306727111645063565', '5648689955684980442294133', 28, 4);
  t('0o203252000343611312345016732574324517652170570536340103164002', '393097177469022242668976094291182082270851391919286274', 60, 4);
  t('0o22410502071700760126344737773405044556536263663106274741', '108249648375668138579864767958324372334698552719841', 56, 4);
  t('0o702464247710160725611573536407615231642232', '74869132891027108059075932498363368602', 42, 4);
  t('0o71215302120100471557063', '528279067564974726707', 23, 4);
  t('0o3443452305237156410051107403', '8630515683508240645394179', 28, 4);
  t('0o1750617616706657707114034617432306132573321272245040042711', '5850571219466548068012306893496891664635414265742793', 58, 4);
  t('0o747373012741076272574334113131066623327', '158199639324663999178714767706236631', 39, 4);
  t('0o240646541755015151746375314736543447343444475552143', '3586530035933343022858608741776409267984061539', 51, 4);
  t('0o21345516652054242646357330536124', '21600249893595093431386029140', 32, 4);
  t('0o3052066107', '413690951', 10, 4);
  t('0o116', '78', 3, 4);
  t('0o3050340627050765676451357427033162550', '999186955807785473462332939887976', 37, 4);
  t('0o172013616177746634055145614015', '295033519224308286956705805', 30, 4);
  t('0o161654155547445343476406063530377171044513302703466', '2538635569062190223060841428161267358214358838', 51, 4);
  t('0o36173', '15483', 5, 4);
  t('0o36547444550627731264507057423205012330760602245415526634143', '91896719045463903069060584567797070657705215769917539', 59, 4);
  t('0o23020170177167056322724056253016211772161010110040067', '217303698775390775219268953665006962201726042167', 53, 4);
  t('0o360364043226375763434734203', '1135619094464764138731651', 27, 4);
  t('0o14233136655362371400640556051237407411322356356326214052664', '36825078122035846824139359498863387810994115321025972', 59, 4);
  t('0o1640200513276356713203217', '8561606752326371837583', 25, 4);
  t('0o6103526361624161311443517175371632412741737', '521666973443756820065064110478867547103', 43, 4);
  t('0o174406316667406655013647151755454742463', '40406618960600991640852771818947891', 39, 4);
  t('0o7641714202176443731750235267341521674705251706234', '174307282119711580494340594082900153247173788', 49, 4);
  t('0o740202262443263067454211712735764360631542423775344744', '5483538014645444559676878691527370323481540807140', 54, 4);
  t('0o352754440661731162345175142131150650044732105622163', '5239828571223832230977981455751540869256651891', 51, 4);
  t('0o373127070001223103537740007213', '607292123862578721351274123', 30, 4);
  t('0o37572601640375442622771540474365322704464564070', '1382461219874045756706531331920884785145912', 47, 4);
  t('0o1442414261073074545327716347556337315543405616452064022', '9163205510581199876674535919032970590548216277010', 55, 4);
  t('0o1637342435475173653242473', '8554147181574260344123', 25, 4);
  t('0o537377662473314366627013423', '1659910424702725658515219', 27, 4);
  t('0o3166512513354164277266524513220176106234611', '274925189339848199032955327991581849993', 43, 4);
  t('0o64246753172171466452551711206021704632', '16980787914168592911515222526101914', 38, 4);
  t('0o1325642', '371618', 7, 4);
  t('0o172347572204054163707174', '1129426023321529454204', 24, 4);
  t('0o1707337005035225145674', '17427769821173697468', 22, 4);
  t('0o3167272', '847546', 7, 4);
  t('0o2376477566636626564635', '23033650866571372957', 22, 4);
  t('0o35417144376113077', '1038983257167423', 17, 4);
  t('0o106327541747664237656046756411744551632275412233636062531656', '210781807562814008194311763577265460650228437440181166', 60, 4);
  t('0o3763572416255254335772542046235033', '2520123204503077543365320456731', 34, 4);
  t('0o75362616525327077427633563743155774', '38963888713731612415310433147900', 35, 4);
  t('0o1401406016234566024656', '13862291742387612078', 22, 4);
  t('0o242172304552', '21775354218', 12, 4);
  t('0o10325355', '2206445', 8, 4);
  t('0o5503607200750620360575714717560', '6972513910589491335440605040', 31, 4);
  t('0o264701463721526107175255711722057442604571730762750705256542', '541396336231392418293871062570279037186171679825812834', 60, 4);
  t('0o421625631535034357267563', '2525290811852796555123', 24, 4);
  t('0o3766050301207656231423150647646364447', '1291785946520991837632125610879271', 37, 4);
  t('0o1630720467054635751474753253627460422', '583694432446675939525765785084178', 37, 4);
  t('0o303124303051000610137231406655066133635770174121', '8500626221290107216014710817942733884291153', 48, 4);
  t('0o1113562110102132653505161654522056473771101354321312031', '6710609582342689120085581704302230873683253367833', 55, 4);
  t('0o1464600512311275', '56401597141693', 16, 4);
  t('0o35261605356', '3938913006', 11, 4);
  t('0o120354645453413557275444611571627313424176417756144520333753', '240836899455748097083887093250256470467559683019356139', 60, 4);
  t('0o6775333741557561774067363222030024220313353605226', '155993258459571709305776966445938258645813910', 49, 4);
  t('0o1676422201112714661607652471073', '2317596989962208644778586683', 31, 4);
  t('0o1453174752703234014531654704472633215271161761475347123730', '4742538088234854254854687216429269914428692374530008', 58, 4);
  t('0o53154012227153364107323333356132334', '27388210321734783241567604356316', 35, 4);
  t('0o35225503612770774201320011176174535217542332620333552', '334458377978261177426569028332297268603291547498', 53, 4);
  t('0o414365504624046053220263710402064311', '170169261032326095162398418168009', 36, 4);
  t('0o7456545364015236001000', '70016530198021276160', 22, 4);
  t('0o13013306320776254', '387810637118636', 17, 4);
  t('0o21', '17', 2, 4);
  t('0o5347712744236105712406353', '25750698989482171567339', 25, 4);
  t('0o4201033713624', '292199307156', 13, 4);
  t('0o6147402214224431303026413646714237211640331341', '270142041873110958246056630570783242040033', 46, 4);
  t('0o15240705643046435', '468452863921437', 17, 4);
  t('0o3530013143266263651', '66147388776605609', 19, 4);
  t('0o44672701365702351354627010564700332716441663244', '1605697031030267612185423502895189353522852', 47, 4);
  t('0o3', '3', 1, 4);
  t('0o6127516', '1617742', 7, 4);
  t('0o66726644', '14396836', 8, 4);
  t('0o5311555461504533675663441245372657173', '1750444240707415099769307901156987', 37, 4);
  t('0o4054706260215077404512214064677061152506', '679180789158344428977587279718831430', 40, 4);
  t('0o62246711201113702465222477417147602750116154310733', '1122306478377713902587095609358921499575161307', 50, 4);
  t('0o4215475722134', '293885944924', 13, 4);
  t('0o53746157770654301215760653406471005756045764305156', '980109855734296770512774083035337723940538990', 50, 4);
  t('0o74411760251306275052060', '558193600905071580208', 23, 4);
  t('0o577115015776462242165511716153070323513627023272', '16688555517189422187103917664151515791369914', 48, 4);
  t('0o67', '55', 2, 4);
  t('0o17465535030523', '1072356929875', 14, 4);
  t('0o13317', '5839', 5, 4);
  t('0o2734162636214', '201356688524', 13, 4);
  t('0o514235610013374235501066012045440247061144570241', '14474060683475264437751372654279118864707745', 48, 4);
  t('0o3534775621556047145137126527746324006765443367053164', '42036808204933511970427575795842368941701486196', 52, 4);
  t('0o1371035220605170410066165577113314501175100', '126452315889789497901223436832123189824', 43, 4);
  t('0o51450362621322470420', '749021597016944912', 20, 4);
  t('0o4', '4', 1, 4);
  t('0o41726045554731777722315562631262755462314641246551410413772', '101522180338987737728899908294640200607836241899165690', 59, 4);
  t('0o3726520073102165257153311', '18508139224259054327497', 25, 4);
  t('0o110233030106104754146604170637', '174817507453714537420747167', 30, 4);
  t('0o34321447613754733467632640535662447106103006103436', '633549261053883686239613232774717922594031390', 50, 4);
  t('0o33260652734712254347', '492610547748526311', 20, 4);
  t('0o3652056541643012540022255', '18097097047518748877997', 25, 4);
  t('0o2266675470606120531031640140307074715050044204', '102669173431008960637137393788268958468228', 46, 4);
  t('0o1767255257', '266164911', 10, 4);
  t('0o46121044606131213674', '687399603768989628', 20, 4);
  t('0o44615', '18829', 5, 4);
  t('0o1066551671032724130551075541344416006004545251', '48210079462363778492658888113295918811817', 46, 4);
  t('0o661746213440700265725363254604246460427455151704051', '9677402829255135526689200426680775741960325161', 51, 4);
  t('0o6175', '3197', 4, 4);
  t('0o401151407274000477346136437000', '621886148896195273543007744', 30, 4);
  t('0o3757440272647170475376331367246161235546703357147547454', '23196351263151106376071114036941254762538586787628', 55, 4);
  t('0o1135', '605', 4, 4);
  t('0o2175424561041415433353531757', '5428551387992052131083247', 28, 4);
  t('0o52520357630643422', '1500865557120786', 17, 4);
  t('0o453', '299', 3, 4);
  t('0o20246731230644474456707331224171', '20210639089554274678470944889', 32, 4);
  t('0o3000523151311', '206247350985', 13, 4);
  t('0o113134637066412045754477071261275213637470', '12491631272411798853591088807340359480', 42, 4);
  t('0o126052261312470627317166600322300777652073650715', '3749430734838772876224746985432540515357133', 48, 4);
  t('0o44316700137250607462031357163634027001772445', '3096914367914270992782060024671299433765', 44, 4);
  t('0o171215002356221063407', '2184703385532655367', 21, 4);
  t('0o23721121', '5218897', 8, 4);
  t('0o14734353322620206602545731', '61062963683852360010713', 26, 4);
  t('0o475312075530063365616', '5717675808740207502', 21, 4);
  t('0o77440275263665614314052136204775', '78687457933212079867651754493', 32, 4);
  t('0o5261257577514510167240362153507501754265746731563', '119228114395905189012428590020540134015611763', 49, 4);
  t('0o145203764627604366316134', '933938082134087015516', 24, 4);
  t('0o300440712774126174401451236156067007573370014604', '8387356043080138295526316927827140067465604', 48, 4);
  t('0o1332570322632', '98077615514', 13, 4);
  t('0o3716217572065650441626246', '18430886692014464117926', 25, 4);
  t('0o716521140', '121283168', 9, 4);
  t('0o61226277150121532713772501031623101', '31243593013026976686003389408833', 35, 4);
  t('0o727134513004332506', '16578205872928070', 18, 4);
  t('0o1015752175345655', '36143524858797', 16, 4);
  t('0o15366300702132404747410165', '63663188402072700457077', 26, 4);
  t('0o2607400245312045520037132356700', '3422470520825634689242488256', 31, 4);
  t('0o1', '1', 1, 4);
  t('0o14232370256353054042511271041451307447', '3992139171064784961434159759593255', 38, 4);
  t('0o2654', '1452', 4, 4);
  t('0o43200420031713445212602476237542777011721017120532156', '402495698817091827248733349983795241261310588014', 53, 4);
  t('0o1012373453302574', '35905333986684', 16, 4);
  t('0o102052273401065267741403121062144257736511671', '5621698349102047273384509211278621447097', 45, 4);
  t('0o2303355462020425243403060', '11247570692927310923312', 25, 4);
  t('0o236571440705332620722731730', '749616319651624136717272', 27, 4);
  t('0o1634023045115006652225404137572537300225444451056550315', '10550640276770088084077930237138652035960136192205', 55, 4);
  t('0o226062710577641', '10314752130977', 15, 4);
  t('0o104167430465731064510563526155446356705', '22143034232047918382504353520541125', 39, 4);
  t('0o360474703465644142142614426374633517336173745433164557017', '1406659725135506145446652465678360390928078042488335', 57, 4);
  t('0o1077226367', '150809847', 10, 4);
  t('0o533412700560147364151506123351553042070455067164', '15136684942816823221295501833940390148075124', 48, 4);
  t('0o47321211337', '5289349855', 11, 4);
  t('0o33', '27', 2, 4);
  t('0o3114060641760665307', '56720562441120455', 19, 4);
  t('0o321544500711356560655140', '1934109172007933532768', 24, 4);
  t('0o31553466646', '3450760614', 11, 4);
  t('0o25427707303456416047670142267372377104250171470', '938489360691345858919636520999045373686584', 47, 4);
  t('0o124405625444044364574470555231', '204335816074449425736587929', 30, 4);
  t('0o7417670326016217030', '135666019698548248', 19, 4);
  t('0o14624322306021144203510134', '60398430088699424182364', 26, 4);
  t('0o1674442410', '250758408', 10, 4);
  t('0o527635172', '90126970', 9, 4);
  t('0o7141002130726144240353615134174321', '4556862540217805685823766591697', 34, 4);
  t('0o7703554633327072657443651371706621271374', '1309663585734465506833205292089832188', 40, 4);
  t('0o22777415000440655526', '342256872923028310', 20, 4);
  t('0o3077216', '818830', 7, 4);
  t('0o34243442230362323775450370', '133734900702608268611832', 26, 4);
  t('0o770344133547754604246147776', '2382177288166020121939966', 27, 4);
  t('0o523215407441303043220321763763461205763333647', '28862443771771851434414707295001265420199', 45, 4);
  t('0o37102705430230406225007132550325075', '19731384956592254443851247364669', 35, 4);
  t('0o26654765110654444621720', '210641979748604126160', 23, 4);
  t('0o575257272', '99966650', 9, 4);
  t('0o7207565613527210030', '130876365269176344', 19, 4);
  t('0o60127615404142232301236257126373142705430101557417025270', '281610543490460264519467262765660796455848821664440', 56, 4);
  t('0o11777165574076763721455', '92219848663426376493', 23, 4);
  t('0o35576422324763736', '1046634462177246', 17, 4);
  t('0o366255123122311123125', '4437634644479092309', 21, 4);
  t('0o1231751346340466252606553475546101570554617315561125473', '7603872826618045742580005490971103946545668860731', 55, 4);
  t('0o535563217273266762141100234605765502234', '113492301891561204235365568461833372', 39, 4);
  t('0o1657330721157546300772313767037603015', '597965777884596169919754548479501', 37, 4);
  t('0o701711416205015540454465462370167111721657451163343320', '5136876924230800291846439025619119075547100858064', 54, 4);
  t('0o2', '2', 1, 4);
  t('0o23044346313736', '1310562293726', 14, 4);
  t('0o762722210536357403530500', '4601638793217664004416', 24, 4);
  t('0o2243232540752434710611323210536463', '1469808842581774120550500842803', 34, 4);
  t('0o6042532553115031666', '109306485388096438', 19, 4);
  t('0o54750443750225316571406736430512671452166747632', '1958033248391176678532214751521115754712986', 47, 4);
  t('0o42122277123352400676', '615387804455272894', 20, 4);
  t('0o141671751106136325535453330430775232437321543', '8325279825157794222097655945192898667363', 45, 4);
  t('0o7335121015337612327750625531460025777262', '1234844453153886969183275916721651378', 40, 4);
  t('0o30', '24', 2, 4);
  t('0o646633456716673131010714325300106141144242503123341513', '4827567010183340607788016828465978158946284585803', 54, 4);
  t('0o34647345400115736740552300416234100512013623645', '1255594995624059221065714883120130755078053', 47, 4);
  t('0o6460334362676710', '232026545028552', 16, 4);
  t('0o106142331346752221011206', '647409104513791169158', 24, 4);
  t('0o11262714046100646006', '168424020893715462', 20, 4);
  t('0o310576032000120564437670443150', '485374511652821184626706024', 30, 4);
  t('0o5', '5', 1, 4);

  // Floats

  t('0o726746425.7006244261075431515424461645053746213677', '123456789.87654321', 49, 4);
  t('-0o0.0000000204437054635763657165267673054542', '-0.000000123456789', 33, 4);
  t('0o1747.7773716662132071260101422335136152375747', '999.999', 44, 4);
  t('-0o3741060405.2002576175337036445364576675624305775126', '-528769285.2506705498654986754987694357629487612132293856', 50, 4);
  t('0o35076567745235671502.6773342626436061433365155137731076310010275236050103305437451411644055625324564421515511562', '524624822785241922.8738874407101262195488876445', 111, 4);
  t('0o5605470434246053632363152113440650264426323520.33525466364076204553563061761202201336001507', '250925107172835956608925073908081234650960.4323', 90, 4);
  t('0o2321136.6635426603020156550074200106655', '631390.850962999306313972719936135603917', 38, 4);
  t('0o243.4465610031', '163.575626396226555033529183865411120656777021626883', 13, 4);

  // Include binary exponent.

  t = function (expected, n, sd, rm) {
    T.assertEqual(expected, new Decimal(n).toOctal(sd, rm));
  }

  t('0o0p+0', '0', 40, 4);
  t('0o1p+53', '9007199254740992', 40, 4);
  t('0o1.4p+8', '384', 40, 4);
  t('0o1p+1', '2', 40, 4);
  t('0o1p+8', '256', 40, 4);
  t('0o1p-6', '0.015625', 40, 4);
  t('0o1.556p-1', '0.857421875', 40, 4);

  t('0o1.777p-4', '0o1.777p-4', 4, 1);
});
