/* Names and abbreviations of all the commands.

	Copyright (C) 1993-1998 Sebastiano Vigna 
	Copyright (C) 1999-2013 Todd M. Lewis and Sebastiano Vigna

	This file is part of ne, the nice editor.

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or (at your
	option) any later version.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
	or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
	for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, see <http://www.gnu.org/licenses/>.  */

#include "ne.h"

/* This file is generated by info2src.pl from data found in ne.texinfo.
   Changes made directly to this file will we lost when the documentation
   is updated. */

/* Here we have the name of all commands. They are extern'd in names.h. Note
that whenever you add or remove a command, you should immediately change also
the command_names array at the end of this file. */


const char ABOUT_NAME[]   = "About";
const char ABOUT_ABBREV[] = "About";

const char ADJUSTVIEW_NAME[]   = "AdjustView";
const char ADJUSTVIEW_ABBREV[] = "AV";

const char ALERT_NAME[]   = "Alert";
const char ALERT_ABBREV[] = "AL";

const char ATOMICUNDO_NAME[]   = "AtomicUndo";
const char ATOMICUNDO_ABBREV[] = "AU";

const char AUTOCOMPLETE_NAME[]   = "AutoComplete";
const char AUTOCOMPLETE_ABBREV[] = "AC";

const char AUTOINDENT_NAME[]   = "AutoIndent";
const char AUTOINDENT_ABBREV[] = "AI";

const char AUTOMATCHBRACKET_NAME[]   = "AutoMatchBracket";
const char AUTOMATCHBRACKET_ABBREV[] = "AMB";

const char AUTOPREFS_NAME[]   = "AutoPrefs";
const char AUTOPREFS_ABBREV[] = "AP";

const char BACKSPACE_NAME[]   = "Backspace";
const char BACKSPACE_ABBREV[] = "BS";

const char BEEP_NAME[]   = "Beep";
const char BEEP_ABBREV[] = "BE";

const char BINARY_NAME[]   = "Binary";
const char BINARY_ABBREV[] = "B";

const char CAPITALIZE_NAME[]   = "Capitalize";
const char CAPITALIZE_ABBREV[] = "CA";

const char CASESEARCH_NAME[]   = "CaseSearch";
const char CASESEARCH_ABBREV[] = "CS";

const char CENTER_NAME[]   = "Center";
const char CENTER_ABBREV[] = "CE";

const char CLEAR_NAME[]   = "Clear";
const char CLEAR_ABBREV[] = "CL";

const char CLIPNUMBER_NAME[]   = "ClipNumber";
const char CLIPNUMBER_ABBREV[] = "CN";

const char CLOSEDOC_NAME[]   = "CloseDoc";
const char CLOSEDOC_ABBREV[] = "CD";

const char COPY_NAME[]   = "Copy";
const char COPY_ABBREV[] = "C";

const char CRLF_NAME[]   = "CRLF";
const char CRLF_ABBREV[] = "CRLF";

const char CUT_NAME[]   = "Cut";
const char CUT_ABBREV[] = "CU";

const char DELETECHAR_NAME[]   = "DeleteChar";
const char DELETECHAR_ABBREV[] = "DC";

const char DELETEEOL_NAME[]   = "DeleteEOL";
const char DELETEEOL_ABBREV[] = "DE";

const char DELETELINE_NAME[]   = "DeleteLine";
const char DELETELINE_ABBREV[] = "DL";

const char DELETENEXTWORD_NAME[]   = "DeleteNextWord";
const char DELETENEXTWORD_ABBREV[] = "DNW";

const char DELETEPREVWORD_NAME[]   = "DeletePrevWord";
const char DELETEPREVWORD_ABBREV[] = "DPW";

const char DELTABS_NAME[]   = "DelTabs";
const char DELTABS_ABBREV[] = "DT";

const char DOUNDO_NAME[]   = "DoUndo";
const char DOUNDO_ABBREV[] = "DU";

const char ERASE_NAME[]   = "Erase";
const char ERASE_ABBREV[] = "E";

const char ESCAPE_NAME[]   = "Escape";
const char ESCAPE_ABBREV[] = "ESC";

const char ESCAPETIME_NAME[]   = "EscapeTime";
const char ESCAPETIME_ABBREV[] = "ET";

const char EXEC_NAME[]   = "Exec";
const char EXEC_ABBREV[] = "EX";

const char EXIT_NAME[]   = "Exit";
const char EXIT_ABBREV[] = "X";

const char FASTGUI_NAME[]   = "FastGUI";
const char FASTGUI_ABBREV[] = "FG";

const char FIND_NAME[]   = "Find";
const char FIND_ABBREV[] = "F";

const char FINDREGEXP_NAME[]   = "FindRegExp";
const char FINDREGEXP_ABBREV[] = "FX";

const char FLAGS_NAME[]   = "Flags";
const char FLAGS_ABBREV[] = "FLAG";

const char FLASH_NAME[]   = "Flash";
const char FLASH_ABBREV[] = "FL";

const char FREEFORM_NAME[]   = "FreeForm";
const char FREEFORM_ABBREV[] = "FF";

const char GOTOBOOKMARK_NAME[]   = "GotoBookmark";
const char GOTOBOOKMARK_ABBREV[] = "GBM";

const char GOTOCOLUMN_NAME[]   = "GotoColumn";
const char GOTOCOLUMN_ABBREV[] = "GC";

const char GOTOLINE_NAME[]   = "GotoLine";
const char GOTOLINE_ABBREV[] = "GL";

const char GOTOMARK_NAME[]   = "GotoMark";
const char GOTOMARK_ABBREV[] = "GM";

const char HELP_NAME[]   = "Help";
const char HELP_ABBREV[] = "H";

const char HEXCODE_NAME[]   = "HexCode";
const char HEXCODE_ABBREV[] = "HC";

const char INSERT_NAME[]   = "Insert";
const char INSERT_ABBREV[] = "I";

const char INSERTCHAR_NAME[]   = "InsertChar";
const char INSERTCHAR_ABBREV[] = "IC";

const char INSERTLINE_NAME[]   = "InsertLine";
const char INSERTLINE_ABBREV[] = "IL";

const char INSERTSTRING_NAME[]   = "InsertString";
const char INSERTSTRING_ABBREV[] = "IS";

const char INSERTTAB_NAME[]   = "InsertTab";
const char INSERTTAB_ABBREV[] = "IT";

const char KEYCODE_NAME[]   = "KeyCode";
const char KEYCODE_ABBREV[] = "KC";

const char LINEDOWN_NAME[]   = "LineDown";
const char LINEDOWN_ABBREV[] = "LD";

const char LINEUP_NAME[]   = "LineUp";
const char LINEUP_ABBREV[] = "LU";

const char LOADAUTOPREFS_NAME[]   = "LoadAutoPrefs";
const char LOADAUTOPREFS_ABBREV[] = "LAP";

const char LOADPREFS_NAME[]   = "LoadPrefs";
const char LOADPREFS_ABBREV[] = "LP";

const char MACRO_NAME[]   = "Macro";
const char MACRO_ABBREV[] = "MA";

const char MARK_NAME[]   = "Mark";
const char MARK_ABBREV[] = "M";

const char MARKVERT_NAME[]   = "MarkVert";
const char MARKVERT_ABBREV[] = "MV";

const char MATCHBRACKET_NAME[]   = "MatchBracket";
const char MATCHBRACKET_ABBREV[] = "MB";

const char MODIFIED_NAME[]   = "Modified";
const char MODIFIED_ABBREV[] = "MOD";

const char MOVEBOS_NAME[]   = "MoveBOS";
const char MOVEBOS_ABBREV[] = "BOS";

const char MOVEEOF_NAME[]   = "MoveEOF";
const char MOVEEOF_ABBREV[] = "EOF";

const char MOVEEOL_NAME[]   = "MoveEOL";
const char MOVEEOL_ABBREV[] = "EOL";

const char MOVEEOW_NAME[]   = "MoveEOW";
const char MOVEEOW_ABBREV[] = "EOW";

const char MOVEINCDOWN_NAME[]   = "MoveIncDown";
const char MOVEINCDOWN_ABBREV[] = "MID";

const char MOVEINCUP_NAME[]   = "MoveIncUp";
const char MOVEINCUP_ABBREV[] = "MIU";

const char MOVELEFT_NAME[]   = "MoveLeft";
const char MOVELEFT_ABBREV[] = "ML";

const char MOVERIGHT_NAME[]   = "MoveRight";
const char MOVERIGHT_ABBREV[] = "MR";

const char MOVESOF_NAME[]   = "MoveSOF";
const char MOVESOF_ABBREV[] = "SOF";

const char MOVESOL_NAME[]   = "MoveSOL";
const char MOVESOL_ABBREV[] = "SOL";

const char MOVETOS_NAME[]   = "MoveTOS";
const char MOVETOS_ABBREV[] = "TOS";

const char NEWDOC_NAME[]   = "NewDoc";
const char NEWDOC_ABBREV[] = "N";

const char NEXTDOC_NAME[]   = "NextDoc";
const char NEXTDOC_ABBREV[] = "ND";

const char NEXTPAGE_NAME[]   = "NextPage";
const char NEXTPAGE_ABBREV[] = "NP";

const char NEXTWORD_NAME[]   = "NextWord";
const char NEXTWORD_ABBREV[] = "NW";

const char NOFILEREQ_NAME[]   = "NoFileReq";
const char NOFILEREQ_ABBREV[] = "NFR";

const char NOP_NAME[]   = "NOP";
const char NOP_ABBREV[] = "NOP";

const char OPEN_NAME[]   = "Open";
const char OPEN_ABBREV[] = "O";

const char OPENCLIP_NAME[]   = "OpenClip";
const char OPENCLIP_ABBREV[] = "OC";

const char OPENMACRO_NAME[]   = "OpenMacro";
const char OPENMACRO_ABBREV[] = "OM";

const char OPENNEW_NAME[]   = "OpenNew";
const char OPENNEW_ABBREV[] = "ON";

const char PAGEDOWN_NAME[]   = "PageDown";
const char PAGEDOWN_ABBREV[] = "PDN";

const char PAGEUP_NAME[]   = "PageUp";
const char PAGEUP_ABBREV[] = "PUP";

const char PARAGRAPH_NAME[]   = "Paragraph";
const char PARAGRAPH_ABBREV[] = "PA";

const char PASTE_NAME[]   = "Paste";
const char PASTE_ABBREV[] = "P";

const char PASTEVERT_NAME[]   = "PasteVert";
const char PASTEVERT_ABBREV[] = "PV";

const char PLAY_NAME[]   = "Play";
const char PLAY_ABBREV[] = "PL";

const char POPPREFS_NAME[]   = "PopPrefs";
const char POPPREFS_ABBREV[] = "POPP";

const char PRESERVECR_NAME[]   = "PreserveCR";
const char PRESERVECR_ABBREV[] = "PCR";

const char PREVDOC_NAME[]   = "PrevDoc";
const char PREVDOC_ABBREV[] = "PD";

const char PREVPAGE_NAME[]   = "PrevPage";
const char PREVPAGE_ABBREV[] = "PP";

const char PREVWORD_NAME[]   = "PrevWord";
const char PREVWORD_ABBREV[] = "PW";

const char PUSHPREFS_NAME[]   = "PushPrefs";
const char PUSHPREFS_ABBREV[] = "PUSHP";

const char QUIT_NAME[]   = "Quit";
const char QUIT_ABBREV[] = "Q";

const char READONLY_NAME[]   = "ReadOnly";
const char READONLY_ABBREV[] = "RO";

const char RECORD_NAME[]   = "Record";
const char RECORD_ABBREV[] = "REC";

const char REDO_NAME[]   = "Redo";
const char REDO_ABBREV[] = "RE";

const char REFRESH_NAME[]   = "Refresh";
const char REFRESH_ABBREV[] = "REF";

const char REPEATLAST_NAME[]   = "RepeatLast";
const char REPEATLAST_ABBREV[] = "RL";

const char REPLACE_NAME[]   = "Replace";
const char REPLACE_ABBREV[] = "R";

const char REPLACEALL_NAME[]   = "ReplaceAll";
const char REPLACEALL_ABBREV[] = "RA";

const char REPLACEONCE_NAME[]   = "ReplaceOnce";
const char REPLACEONCE_ABBREV[] = "R1";

const char REQUESTORDER_NAME[]   = "RequestOrder";
const char REQUESTORDER_ABBREV[] = "RQO";

const char RIGHTMARGIN_NAME[]   = "RightMargin";
const char RIGHTMARGIN_ABBREV[] = "RM";

const char SAVE_NAME[]   = "Save";
const char SAVE_ABBREV[] = "S";

const char SAVEAS_NAME[]   = "SaveAs";
const char SAVEAS_ABBREV[] = "SA";

const char SAVEAUTOPREFS_NAME[]   = "SaveAutoPrefs";
const char SAVEAUTOPREFS_ABBREV[] = "SAP";

const char SAVECLIP_NAME[]   = "SaveClip";
const char SAVECLIP_ABBREV[] = "SC";

const char SAVEDEFPREFS_NAME[]   = "SaveDefPrefs";
const char SAVEDEFPREFS_ABBREV[] = "SDP";

const char SAVEMACRO_NAME[]   = "SaveMacro";
const char SAVEMACRO_ABBREV[] = "SM";

const char SAVEPREFS_NAME[]   = "SavePrefs";
const char SAVEPREFS_ABBREV[] = "SP";

const char SEARCHBACK_NAME[]   = "SearchBack";
const char SEARCHBACK_ABBREV[] = "SB";

const char SELECTDOC_NAME[]   = "SelectDoc";
const char SELECTDOC_ABBREV[] = "SD";

const char SETBOOKMARK_NAME[]   = "SetBookmark";
const char SETBOOKMARK_ABBREV[] = "SBM";

const char SHIFT_NAME[]   = "Shift";
const char SHIFT_ABBREV[] = "SH";

const char SHIFTTABS_NAME[]   = "ShiftTabs";
const char SHIFTTABS_ABBREV[] = "SHT";

const char STATUSBAR_NAME[]   = "StatusBar";
const char STATUSBAR_ABBREV[] = "ST";

const char SUSPEND_NAME[]   = "Suspend";
const char SUSPEND_ABBREV[] = "SU";

const char SYNTAX_NAME[]   = "Syntax";
const char SYNTAX_ABBREV[] = "SY";

const char SYSTEM_NAME[]   = "System";
const char SYSTEM_ABBREV[] = "SYS";

const char TABS_NAME[]   = "Tabs";
const char TABS_ABBREV[] = "TAB";

const char TABSIZE_NAME[]   = "TabSize";
const char TABSIZE_ABBREV[] = "TS";

const char THROUGH_NAME[]   = "Through";
const char THROUGH_ABBREV[] = "T";

const char TOGGLESEOF_NAME[]   = "ToggleSEOF";
const char TOGGLESEOF_ABBREV[] = "TSEOF";

const char TOGGLESEOL_NAME[]   = "ToggleSEOL";
const char TOGGLESEOL_ABBREV[] = "TSEOL";

const char TOLOWER_NAME[]   = "ToLower";
const char TOLOWER_ABBREV[] = "TL";

const char TOUPPER_NAME[]   = "ToUpper";
const char TOUPPER_ABBREV[] = "TU";

const char TURBO_NAME[]   = "Turbo";
const char TURBO_ABBREV[] = "TUR";

const char UNDELLINE_NAME[]   = "UndelLine";
const char UNDELLINE_ABBREV[] = "UL";

const char UNDO_NAME[]   = "Undo";
const char UNDO_ABBREV[] = "U";

const char UNLOADMACROS_NAME[]   = "UnloadMacros";
const char UNLOADMACROS_ABBREV[] = "UM";

const char UNSETBOOKMARK_NAME[]   = "UnsetBookmark";
const char UNSETBOOKMARK_ABBREV[] = "UBM";

const char UTF8_NAME[]   = "UTF8";
const char UTF8_ABBREV[] = "U8";

const char UTF8AUTO_NAME[]   = "UTF8Auto";
const char UTF8AUTO_ABBREV[] = "U8A";

const char UTF8IO_NAME[]   = "UTF8IO";
const char UTF8IO_ABBREV[] = "U8IO";

const char VERBOSEMACROS_NAME[]   = "VerboseMacros";
const char VERBOSEMACROS_ABBREV[] = "VM";

const char VISUALBELL_NAME[]   = "VisualBell";
const char VISUALBELL_ABBREV[] = "VB";

const char WORDWRAP_NAME[]   = "WordWrap";
const char WORDWRAP_ABBREV[] = "WW";

/* These are extras that are very useful in the default menus and key bindings. */

const char PLAYONCE_ABBREV[] = "PL 1";
const char MIDDLEVIEW_ABBREV[] = "AV M";
const char SHIFTLEFT_ABBREV[] = "SH <";

/* This is the NULL-terminated, ordered list of names, useful for help etc. */

const char * const command_names[ACTION_COUNT+1] = {
  ABOUT_NAME,  ADJUSTVIEW_NAME,  ALERT_NAME,  ATOMICUNDO_NAME,
  AUTOCOMPLETE_NAME,  AUTOINDENT_NAME,  AUTOMATCHBRACKET_NAME,  AUTOPREFS_NAME,
  BACKSPACE_NAME,  BEEP_NAME,  BINARY_NAME,  CAPITALIZE_NAME,
  CASESEARCH_NAME,  CENTER_NAME,  CLEAR_NAME,  CLIPNUMBER_NAME,
  CLOSEDOC_NAME,  COPY_NAME,  CRLF_NAME,  CUT_NAME,
  DELETECHAR_NAME,  DELETEEOL_NAME,  DELETELINE_NAME,  DELETENEXTWORD_NAME,
  DELETEPREVWORD_NAME,  DELTABS_NAME,  DOUNDO_NAME,  ERASE_NAME,
  ESCAPE_NAME,  ESCAPETIME_NAME,  EXEC_NAME,  EXIT_NAME,
  FASTGUI_NAME,  FIND_NAME,  FINDREGEXP_NAME,  FLAGS_NAME,
  FLASH_NAME,  FREEFORM_NAME,  GOTOBOOKMARK_NAME,  GOTOCOLUMN_NAME,
  GOTOLINE_NAME,  GOTOMARK_NAME,  HELP_NAME,  HEXCODE_NAME,
  INSERT_NAME,  INSERTCHAR_NAME,  INSERTLINE_NAME,  INSERTSTRING_NAME,
  INSERTTAB_NAME,  KEYCODE_NAME,  LINEDOWN_NAME,  LINEUP_NAME,
  LOADAUTOPREFS_NAME,  LOADPREFS_NAME,  MACRO_NAME,  MARK_NAME,
  MARKVERT_NAME,  MATCHBRACKET_NAME,  MODIFIED_NAME,  MOVEBOS_NAME,
  MOVEEOF_NAME,  MOVEEOL_NAME,  MOVEEOW_NAME,  MOVEINCDOWN_NAME,
  MOVEINCUP_NAME,  MOVELEFT_NAME,  MOVERIGHT_NAME,  MOVESOF_NAME,
  MOVESOL_NAME,  MOVETOS_NAME,  NEWDOC_NAME,  NEXTDOC_NAME,
  NEXTPAGE_NAME,  NEXTWORD_NAME,  NOFILEREQ_NAME,  NOP_NAME,
  OPEN_NAME,  OPENCLIP_NAME,  OPENMACRO_NAME,  OPENNEW_NAME,
  PAGEDOWN_NAME,  PAGEUP_NAME,  PARAGRAPH_NAME,  PASTE_NAME,
  PASTEVERT_NAME,  PLAY_NAME,  POPPREFS_NAME,  PRESERVECR_NAME,
  PREVDOC_NAME,  PREVPAGE_NAME,  PREVWORD_NAME,  PUSHPREFS_NAME,
  QUIT_NAME,  READONLY_NAME,  RECORD_NAME,  REDO_NAME,
  REFRESH_NAME,  REPEATLAST_NAME,  REPLACE_NAME,  REPLACEALL_NAME,
  REPLACEONCE_NAME,  REQUESTORDER_NAME,  RIGHTMARGIN_NAME,  SAVE_NAME,
  SAVEAS_NAME,  SAVEAUTOPREFS_NAME,  SAVECLIP_NAME,  SAVEDEFPREFS_NAME,
  SAVEMACRO_NAME,  SAVEPREFS_NAME,  SEARCHBACK_NAME,  SELECTDOC_NAME,
  SETBOOKMARK_NAME,  SHIFT_NAME,  SHIFTTABS_NAME,  STATUSBAR_NAME,
  SUSPEND_NAME,  SYNTAX_NAME,  SYSTEM_NAME,  TABS_NAME,
  TABSIZE_NAME,  THROUGH_NAME,  TOGGLESEOF_NAME,  TOGGLESEOL_NAME,
  TOLOWER_NAME,  TOUPPER_NAME,  TURBO_NAME,  UNDELLINE_NAME,
  UNDO_NAME,  UNLOADMACROS_NAME,  UNSETBOOKMARK_NAME,  UTF8_NAME,
  UTF8AUTO_NAME,  UTF8IO_NAME,  VERBOSEMACROS_NAME,  VISUALBELL_NAME,
  WORDWRAP_NAME,  NULL
};
