/*
 * Copyright (c) 2010 Diane Gagne at Hartman Technica drose.gagne@gmail.ru
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS `AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES
 */

#if defined MSP430_HAS_HWMUL
		
#define lowa1	R14
#define higha1	R15
#define lowa2	R12
#define higha2	R13
#define anslow	R10
#define anshigh	R11

#define lowresult	R14
#define highresult	R15
	
.global __fpmulparts
.type __fpmulparts,@function
__fpmulparts:
        push    R10
        push    R11		; save the state of all registers

	mov	lowa2, &__MPY	; multiply the lsb
	mov	lowa1, &__OP2

	mov	&__RESHI, anslow	; shift right 16 and store the low

	mov	higha1, &__MPY	; multiply the most significant bits
	mov	higha2, &__OP2

	mov	&__RESLO, anshigh ; shift left 16 and store high

	mov	lowa1, &__MPY	; multiply the inbetween parts
	mov	higha2, &__OP2

	add	&__RESLO, anslow	; add the result to the answer with no shift
	addc	&__RESHI, anshigh

	mov	higha1, &__MPY	; multiply the inbetween parts
	mov	lowa2, &__OP2

	add	&__RESLO, anslow	; add the result to the answer with no shift
	addc	&__RESHI, anshigh
	
	mov	anslow, lowresult	; save the output to be returned
	mov	anshigh, highresult
	
	pop	R11
        pop     R10
	ret

#endif
	
