/*****************************************************************************
 *
 * This MobilityDB code is provided under The PostgreSQL License.
 * Copyright (c) 2016-2025, Université libre de Bruxelles and MobilityDB
 * contributors
 *
 * MobilityDB includes portions of PostGIS version 3 source code released
 * under the GNU General Public License (GPLv2 or later).
 * Copyright (c) 2001-2025, PostGIS contributors
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without a written
 * agreement is hereby granted, provided that the above copyright notice and
 * this paragraph and the following two paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL UNIVERSITE LIBRE DE BRUXELLES BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING
 * LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF UNIVERSITE LIBRE DE BRUXELLES HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * UNIVERSITE LIBRE DE BRUXELLES SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON
 * AN "AS IS" BASIS, AND UNIVERSITE LIBRE DE BRUXELLES HAS NO OBLIGATIONS TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *****************************************************************************/

/**
 * @file
 * @brief Sections for the documentation of the MobilityDB API: Rigid geometries
 */

/*****************************************************************************
 * Definition of the modules of the MobilityDB API
 * These modules follow the sections of the MobilityDB documentation although
 * some subsections are merged into a single submodule
 *****************************************************************************/

/**
 * @defgroup mobilitydb_rgeo_inout Input and output functions
 * @ingroup mobilitydb_rgeo
 * @brief Input and output functions for temporal rigid geometries
 *
 * @defgroup mobilitydb_rgeo_constructor Constructor functions
 * @ingroup mobilitydb_rgeo
 * @brief Constructor functions for temporal rigid geometries
 *
 * @defgroup mobilitydb_rgeo_conversion Conversion functions
 * @ingroup mobilitydb_rgeo
 * @brief Conversion functions for temporal rigid geometries
 *
 * @defgroup mobilitydb_rgeo_accessor Accessor functions
 * @ingroup mobilitydb_rgeo
 * @brief Accessor functions for temporal rigid geometries
 *
 * @defgroup mobilitydb_rgeo_transf Transformation functions
 * @ingroup mobilitydb_rgeo
 * @brief Transformation functions for temporal rigid geometries
 *
 * @defgroup mobilitydb_rgeo_restrict Restriction functions
 * @ingroup mobilitydb_rgeo
 * @brief Restriction functions for temporal rigid geometries
 *
 * @ingroup mobilitydb_rgeo
 * @brief Distance functions for temporal rigid geometries
 *
 * @defgroup mobilitydb_rgeo_dist Distance functions
 * @ingroup mobilitydb_rgeo
 * @brief Distance functions for temporal rigid geometries
 *
 * @defgroup mobilitydb_rgeo_comp Comparison functions
 * @ingroup mobilitydb_rgeo
 * @brief Comparison functions for temporal rigid geometries
 *
 *   @defgroup mobilitydb_rgeo_comp_ever Ever and always comparison functions
 *   @ingroup mobilitydb_rgeo_comp
 *   @brief Ever and always comparison functions for temporal rigid geometries
 *
 *   @defgroup mobilitydb_rgeo_comp_temp Temporal comparison functions
 *   @ingroup mobilitydb_rgeo_comp
 *   @brief Comparison functions for temporal rigid geometries
 *
 * @defgroup mobilitydb_rgeo_rel Spatial relationship functions
 * @ingroup mobilitydb_rgeo
 * @brief Spatial relationship functions for temporal rigid geometries
 *
 *   @defgroup mobilitydb_rgeo_rel_ever Ever and always spatial relationship functions
 *   @ingroup mobilitydb_rgeo_rel
 *   @brief Ever and always spatial relationship functions for temporal rigid geometries
 *
 *   @defgroup mobilitydb_rgeo_rel_temp Spatiotemporal relationship functions
 *   @ingroup mobilitydb_rgeo_rel
 *   @brief Spatiotemporal relationship functions for temporal rigid geometries
 *
 * @defgroup mobilitydb_rgeo_agg Aggregate functions
 * @ingroup mobilitydb_rgeo
 * @brief Aggregate functions for temporal rigid geometries
 */

/*****************************************************************************/

