# Check supported compiler warnings and enable them

# =============================================================================
# Copyright (C) 2012 Canonical Ltd. - All Rights Reserved
# Contact: Jim Hodapp <jim.hodapp@canonical.com>
# =============================================================================

MACRO(ENABLE_COMPILER_WARNINGS)
  INCLUDE(TestCCAcceptsFlag)
  INCLUDE(TestCXXAcceptsFlag)

  # Error flags
  OPTION(ENABLE_WARNINGS "Enable compiler warnings" OFF)
  OPTION(FATAL_WARNINGS "Turn compiler warnings into errors" OFF)

  IF(ENABLE_WARNINGS)
    SET(WARNING_FLAGS
        -Wall -Wextra -w1 -Wno-long-long -Wno-variadic-macros
        -DGSEAL_ENABLE -DG_DISABLE_DEPRECATED -DGST_DISABLE_DEPRECATED)
  ELSE(ENABLE_WARNINGS)
    SET(WARNING_FLAGS -Wall -w1)
  ENDIF(ENABLE_WARNINGS)

  IF(FATAL_WARNINGS)
    SET(WARNING_FLAGS ${WARNING_FLAGS} -Werror)
  ENDIF(FATAL_WARNINGS)

  FOREACH(flag IN LISTS WARNING_FLAGS)
    IF(NOT DEFINED CC_ACCEPTS_FLAG_${flag})
      CHECK_CC_ACCEPTS_FLAG(${flag} accepted)

      SET(CC_ACCEPTS_FLAG_${flag} ${accepted}
          CACHE INTERNAL "Weither the C compiler supports ${flag}")

      UNSET(accepted CACHE)
    ENDIF(NOT DEFINED CC_ACCEPTS_FLAG_${flag})

    IF(CC_ACCEPTS_FLAG_${flag})
      SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${flag}")
    ENDIF(CC_ACCEPTS_FLAG_${flag})

    IF(NOT DEFINED CXX_ACCEPTS_FLAG_${flag})
      CHECK_CXX_ACCEPTS_FLAG(${flag} accepted)

      SET(CXX_ACCEPTS_FLAG_${flag} ${accepted}
          CACHE INTERNAL "Weither the C++ compiler supports ${flag}")

      UNSET(accepted CACHE)
    ENDIF(NOT DEFINED CXX_ACCEPTS_FLAG_${flag})

    IF(CXX_ACCEPTS_FLAG_${flag})
      SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${flag}")
    ENDIF(CXX_ACCEPTS_FLAG_${flag})
  ENDFOREACH(flag)

  MESSAGE(STATUS "Using this C compiler flags:${CMAKE_C_FLAGS}")
  MESSAGE(STATUS "Using this C++ compiler flags:${CMAKE_CXX_FLAGS}")
ENDMACRO(ENABLE_COMPILER_WARNINGS)
