# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class PlaneCutter(DataObjectAlgorithm):
    r"""
    PlaneCutter - cut any dataset with a plane and generate a
    polygonal cut surface
    
    Superclass: DataObjectAlgorithm
    
    PlaneCutter is a specialization of the Cutter algorithm to cut
    a dataset grid with a single plane. It is designed for performance
    and an exploratory, fast workflow. It produces output polygons that
    result from cutting the input dataset with the specified plane.
    
    This algorithm is fast because it is threaded, it may delegate to a
    high-performance cutting algorithm, and/or it may build (in a
    preprocessing step) a spatial search structure that accelerates the
    plane cuts. The search structure, which is typically a sphere tree,
    is used to quickly cull candidate cells.  As mentioned, certain types
    of input data are delegated to other, internal classes--for example
    image data is delegated to FlyingEdgesPlaneCutter, and convex
    PolyData is delegated to PolyDataPlaneCutter.
    
    Because this filter may build an initial data structure during a
    preprocessing step, the first execution of the filter may take longer
    than subsequent operations. Typically the first execution is still
    faster than Cutter (especially with threading enabled), but for
    certain types of data this may not be true. However if you are using
    the filter to cut a dataset multiple times (as in an exploratory or
    interactive workflow) this filter typically works well.
    
    @warning
    This filter chooses the output type based on the input type.
    1) if input is DataSet, output is PolyData.
    2) if input is PartitionedDataSet, output is
       PartitionedDataSet.
    3) if input is PartitionedDataSetCollection, output is
       PartitionedDataSetCollection.
    4) if input is UniformGridAMR, output is
       PartitionedDataSetCollection.
    5) if input is MultiBlockDataSet, output is MultiBlockDataSet.
    
    @warning
    This filter produces may produce non-merged, potentially coincident
    points for all input dataset types except 1) ImageData (which uses
    FlyingEdgesPlaneCutter under the hood - which does merge points);
    and
    2) PolyData if all input cells are convex polygons.
    
    @warning
    This filter delegates to FlyingEdgesPlaneCutter to process image
    data, but output and input have been standardized when possible.
    
    @warning
    This filter delegates to PolyDataPlaneCutter to process input
    PolyData if all the input cells are convex polygons.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    FlyingEdgesPlaneCutter ThreeDLinearGridPlaneCutter Cutter
    Plane PolyDataPlaneCutter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPlaneCutter, obj, update, **traits)
    
    build_hierarchy = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether to build tree hierarchy. Computing the tree
        hierarchy can take some time on the first computation but if the
        input does not change, the computation of all further slice will
        be faster. Default is on.
        """
    )

    def _build_hierarchy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBuildHierarchy,
                        self.build_hierarchy_)

    build_tree = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether to build the sphere tree. Computing the sphere
        will take some time on the first computation but if the input
        does not change, the computation of all further slice will be
        much faster. Default is on.
        """
    )

    def _build_tree_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBuildTree,
                        self.build_tree_)

    compute_normals = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get the computation of normals. The normal generated is
        simply the cut plane normal. The normal, if generated, is defined
        by cell data associated with the output polygons. By default
        computing of normals is disabled.
        """
    )

    def _compute_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeNormals,
                        self.compute_normals_)

    generate_polygons = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether to generate polygons instead of triangles when
        cutting structured and rectilinear grid. No effect with other
        kinds of inputs, enabled by default.
        """
    )

    def _generate_polygons_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGeneratePolygons,
                        self.generate_polygons_)

    interpolate_attributes = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether to interpolate attribute data. By default this
        is enabled. Note that both cell data and point data is
        interpolated and output, except for image data input where only
        point data are output.
        """
    )

    def _interpolate_attributes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolateAttributes,
                        self.interpolate_attributes_)

    def _get_plane(self):
        return wrap_vtk(self._vtk_obj.GetPlane())
    def _set_plane(self, arg):
        old_val = self._get_plane()
        self._wrap_call(self._vtk_obj.SetPlane,
                        deref_vtk(arg))
        self.trait_property_changed('plane', old_val, arg)
    plane = traits.Property(_get_plane, _set_plane, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('build_hierarchy', 'GetBuildHierarchy'), ('build_tree',
    'GetBuildTree'), ('compute_normals', 'GetComputeNormals'),
    ('generate_polygons', 'GetGeneratePolygons'),
    ('interpolate_attributes', 'GetInterpolateAttributes'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'build_hierarchy', 'build_tree', 'compute_normals',
    'debug', 'generate_polygons', 'global_warning_display',
    'interpolate_attributes', 'release_data_flag', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PlaneCutter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['build_hierarchy', 'build_tree', 'compute_normals',
            'generate_polygons', 'interpolate_attributes'], [], ['object_name']),
            title='Edit PlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

