#ifndef _SIGNATURE_EFFECT_H
#define _SIGNATURE_EFFECT_H

#include "osl/effect/moveSignature.h"
#include "osl/piece.h"
#include "osl/misc/carray.h"

namespace osl 
{
  namespace effect
  {
  /**
   *
   */
  class SignatureTable{
    CArray<MoveSignature,16*(9+4)> signatures;
  public:
    template<typename State>
    SignatureTable(State& state){
      std::fill(signatures.begin(),signatures.end(),signature_EDGE);
      for(int y=1;y<=9;y++)
	for(int x=1;x<=9;x++){
	  Square pos(x,y);
	  PtypeO ptypeO=getPtypeO(state.pieceAt(pos));
	  set(pos,Move_Signature_Table.getSignature(ptypeO));
	}
    }
    MoveSignature get(Square pos) const{
      return signatures[pos.index()];
    }
    void set(Square pos,MoveSignature signature){ 
      signatures[pos.index()]=signature;
    }
  };

  template <Player P,class State>
  struct ApplyDoUndoSimpleMove;
  template <Player P,class State>
  struct ApplyDoUndoCaptureMove;
  template <Player P,class State>
  struct ApplyDoUndoDropMove;

    /**
     * マスごとの利き(MoveSignature)も保持するState.
     * Stateの更新の際に少しコストは増えるが，高速化が期待できる
     * 特に1マス1byteで表現できるため複数のマスを一度に操作することが可能
     * 現在は使われていない
     */
  template<class State>
  class SignatureEffect: public State{
  public:
    SignatureTable signatureTable;
    /** 継承したクラスから effect を実装した先祖を取り出すために使用する */
    typedef SignatureEffect<State> effect_state_t;
  public:
    template<typename OrigState>
    explicit SignatureEffect(OrigState const& st) :State(st),signatureTable(st){}
    MoveSignature getSignature(Square pos) const{
      return signatureTable.get(pos);
    }
    void setSignature(Square pos,MoveSignature signature){ 
      signatureTable.set(pos,signature);
    }
  };

  template<Player P,typename BaseState>
  struct ApplyDoUndoSimpleMove<P,SignatureEffect<BaseState> >
  {
    typedef SignatureEffect<BaseState> state_t;
    template <typename F>
    static void doUndoSimpleMove(state_t& s, 
				 Square from, Square to, int promoteMask,F& func){
      /* signatureのset */
      Piece oldPiece=s.pieceAt(from);
      PtypeO ptypeO=oldPiece.promoteWithMask(promoteMask).ptypeO();
      MoveSignature oldSignature=s.getSignature(from);
      s.setSignature(from,signature_EMPTY);
      s.setSignature(to,Move_Signature_Table.getSignature(ptypeO));

      ApplyDoUndoSimpleMove<P,BaseState>::doUndoSimpleMove(s,from,to,promoteMask,func);

      /* signatureの書き戻し */
      s.setSignature(from,oldSignature);
      s.setSignature(to,signature_EMPTY);
    }
  };
  
  template<Player P,typename BaseState>
  struct ApplyDoUndoDropMove<P,SignatureEffect<BaseState> >
  {
    typedef SignatureEffect<BaseState> state_t;
    template <typename F>
    static void doUndoDropMove(state_t& s, 
			       Square to, Ptype ptype,F& func){
      /* signatureのset */
      PtypeO ptypeO=newPtypeO(P,ptype);
      s.setSignature(to,Move_Signature_Table.getSignature(ptypeO));

      ApplyDoUndoDropMove<P,BaseState>::doUndoDropMove(s,to,ptype,func);
      /* signatureのundo */
      s.setSignature(to,signature_EMPTY);

    }
  };

  template<Player P,typename BaseState>
  struct ApplyDoUndoCaptureMove<P,SignatureEffect<BaseState> >
  {
    typedef SignatureEffect<BaseState> state_t;
    template <typename F>
    static void doUndoCaptureMove(state_t& s,
				  Square from,Square to, Piece p1, int promoteMask,F& func){
      /* signatureのset */
      Piece oldPiece=s.pieceAt(from);
      PtypeO ptypeO=oldPiece.promoteWithMask(promoteMask).ptypeO();
      MoveSignature oldSignatureFrom=s.getSignature(from);
      s.setSignature(from,signature_EMPTY);
      MoveSignature oldSignatureTo=s.getSignature(to);
      s.setSignature(to,Move_Signature_Table.getSignature(ptypeO));
      /* base classの呼び出し */
      ApplyDoUndoCaptureMove<P,BaseState>::doUndoCaptureMove(s,from,to,p1,promoteMask,func);
      /* signatureの書き戻し */
      s.setSignature(from,oldSignatureFrom);
      s.setSignature(to,oldSignatureTo);
    }
  };
} // namespace effect
} // namespace osl
#endif // _SIGNATURE_EFFECT_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
