use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::Compile 2.026

use Test::More  tests => 17 + ($ENV{AUTHOR_TESTING} ? 1 : 0);



my @module_files = (
    'Metabase/Fact.pm',
    'Metabase/Fact/Hash.pm',
    'Metabase/Fact/String.pm',
    'Metabase/Report.pm',
    'Metabase/Resource.pm',
    'Metabase/Resource/cpan.pm',
    'Metabase/Resource/cpan/distfile.pm',
    'Metabase/Resource/metabase.pm',
    'Metabase/Resource/metabase/fact.pm',
    'Metabase/Resource/metabase/user.pm',
    'Metabase/Resource/perl.pm',
    'Metabase/Resource/perl/commit.pm',
    'Metabase/User/EmailAddress.pm',
    'Metabase/User/FullName.pm',
    'Metabase/User/Profile.pm',
    'Metabase/User/Secret.pm'
);

my @scripts = (
    'bin/metabase-profile'
);

# fake home for cpan-testers
use File::Temp;
local $ENV{HOME} = File::Temp::tempdir( CLEANUP => 1 );


use IPC::Open3;
use IO::Handle;

my @warnings;
for my $lib (@module_files)
{
    # see L<perlfaq8/How can I capture STDERR from an external command?>
    my $stdin = '';     # converted to a gensym by open3
    my $stderr = IO::Handle->new;
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';

    my $pid = open3($stdin, '>&STDERR', $stderr, qq{$^X -Mblib -e"require q[$lib]"});
    waitpid($pid, 0);
    is($? >> 8, 0, "$lib loaded ok");

    if (my @_warnings = <$stderr>)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
}

use File::Spec;
foreach my $file (@scripts)
{ SKIP: {
    open my $fh, '<', $file or warn("Unable to open $file: $!"), next;
    my $line = <$fh>;
    close $fh and skip("$file isn't perl", 1) unless $line =~ /^#!.*?\bperl\b\s*(.*)$/;

    my $flags = $1;

    my $stdin = '';     # converted to a gensym by open3
    my $stderr = IO::Handle->new;
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';

    my $pid = open3($stdin, '>&STDERR', $stderr, qq{$^X -Mblib $flags -c $file});
    waitpid($pid, 0);
    is($? >> 8, 0, "$file compiled ok");

   # in older perls, -c output is simply the file portion of the path being tested
    if (my @_warnings = grep { !/\bsyntax OK$/ }
        grep { chomp; $_ ne (File::Spec->splitpath($file))[2] } <$stderr>)
    {
        # temporary measure - win32 newline issues?
        warn map { _show_whitespace($_) } @_warnings;
        push @warnings, @_warnings;
    }
} }

sub _show_whitespace
{
    my $string = shift;
    $string =~ s/\012/[\\012]/g;
    $string =~ s/\015/[\\015]/g;
    $string =~ s/\t/[\\t]/g;
    $string =~ s/ /[\\s]/g;
    return $string;
}



is(scalar(@warnings), 0, 'no warnings found') if $ENV{AUTHOR_TESTING};


