package org.jboss.cache.buddyreplication;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.testng.annotations.Test;

import java.util.ArrayList;

/**
 * Test added to replicate a found issue. When fixing it consider moving test to some other class.
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.1
 */
@Test(groups = {"functional"})
public class RemoveRootBuddyTest extends BuddyReplicationTestsBase
{
   public void testRemoveRootNode() throws Exception
   {
      CacheSPI cache1 = createCache(false, 1, "myBuddyPoolReplicationGroup", false, true, true);
      CacheSPI cache2 = createCache(false, 1, "myBuddyPoolReplicationGroup", false, true, true);
      caches = new ArrayList<CacheSPI<Object, Object>>(2);
      caches.add(cache1);
      caches.add(cache2);
      int opCount = 10;
      for (int i = 0; i < opCount; i++)
      {
         String key = String.valueOf(opCount);
         String value = String.valueOf(opCount);
         Fqn f = Fqn.fromElements("test", key);
         cache1.put(f, key, value);
      }
      cache1.removeNode(Fqn.ROOT);
   }
}
