package org.jboss.cache.loader.tcp;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;

import java.net.UnknownHostException;

/**
 * StandardMBean interface for {@link TcpCacheServer}.
 * 
 * @author Bela Ban
 * @author Brian Stansberry
 * @version $Id: TcpCacheServerMBean.java 3889 2007-05-23 06:34:31Z bstansberry $
 */
public interface TcpCacheServerMBean
{
   void create() throws Exception;

   void start() throws Exception;

   void stop();

   void destroy();
   
   String getBindAddress();

   void setBindAddress(String bind_addr) throws UnknownHostException;

   int getPort();

   void setPort(int port);

   String getConfig();

   void setConfig(String config);

   Cache getCache();

   // BES 2007/5/22 Don't expose this setter via MBean interface, as
   // it's a different type from getter, which is invalid.  This
   // setter doesn't need to be exposed vai JMX; the CacheJmxWrapper
   // is sufficient, and the setter is still there in the impl.
   //void setCache(CacheSPI cache);
   
   /**
    * Allows {@link #setCache(CacheSPI) injection of the CacheSPI} via
    * a {@link CacheJmxWrapperMBean}.
    * 
    * @param wrapper
    */
   void setCacheJmxWrapper(CacheJmxWrapperMBean wrapper);

   String getConnections();
}
