/*
 * @(#)DirectoryClassChannelLogReaderUTest.java
 *
 * Copyright (C) 2003-2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.codecoverage.v2.CCCreatorUtil;
import net.sourceforge.groboutils.codecoverage.v2.IChannelLogRecord;
import net.sourceforge.groboutils.codecoverage.v2.IClassChannelLogReaderUTestI;
import net.sourceforge.groboutils.junit.v1.iftc.CxFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;


/**
 * Tests the DirectoryClassChannelLogReader class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/07/07 09:39:13 $
 * @since     January 22, 2003
 */
public class DirectoryClassChannelLogReaderUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = DirectoryClassChannelLogReaderUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public DirectoryClassChannelLogReaderUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testNextRecord1() throws Exception
    {
        String sig = "MySig-1";
        File log = new File( CCCreatorUtil.createNewDirectory(),
            "test.log" );
        FileWriter fw = new FileWriter( log );
        fw.write( "1 0\n2 2\n0002 0002\n3 1\n" );
        fw.close();
        DirectoryClassChannelLogReader dcclr =
            new DirectoryClassChannelLogReader( log, sig );
        IChannelLogRecord clr;
        assertChannelLogRecord(
            dcclr.nextRecord(),
            sig, 1, 0 );
        assertChannelLogRecord(
            dcclr.nextRecord(),
            sig, 2, 2 );
        assertChannelLogRecord(
            dcclr.nextRecord(),
            sig, 2, 2 );
        assertChannelLogRecord(
            dcclr.nextRecord(),
            sig, 3, 1 );
        assertNull(
            "Didn't return null clr.",
            dcclr.nextRecord() );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected void assertChannelLogRecord( IChannelLogRecord clr,
            String sig, int methodIndex, int markIndex )
    {
        assertNotNull(
            "Returned null record.",
            clr );
        assertEquals(
            "Didn't return correct signature.",
            sig,
            clr.getClassSignature() );
        assertEquals(
            "Didn't return correct method index.",
            methodIndex,
            clr.getMethodIndex() );
        assertEquals(
            "Didn't return correct mark index.",
            markIndex,
            clr.getMarkIndex() );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = IClassChannelLogReaderUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() throws IOException {
                File log = new File( CCCreatorUtil.createNewDirectory(),
                    "test.log" );
                FileWriter fw = new FileWriter( log );
                fw.write( "1 0\n2 2\n0002 0002\n3 1\n" );
                fw.close();
                return new DirectoryClassChannelLogReader( log, "MySig-1" );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();

       
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

