/* assembly to compute the key powers */

#include "crypto_asm_hidden.h"
// linker define poly1305_maa64_g24_keypowers
// linker use mask2
// linker use mask2c

#define mask2  CRYPTO_SHARED_NAMESPACE(mask2)
#define mask2c CRYPTO_SHARED_NAMESPACE(mask2c)

#include "poly1305_keypowers_asm.h"
		
	.p2align 5
	
ASM_HIDDEN _CRYPTO_SHARED_NAMESPACE(poly1305_maa64_g24_keypowers)
ASM_HIDDEN CRYPTO_SHARED_NAMESPACE(poly1305_maa64_g24_keypowers)
.global _CRYPTO_SHARED_NAMESPACE(poly1305_maa64_g24_keypowers)
.global CRYPTO_SHARED_NAMESPACE(poly1305_maa64_g24_keypowers)
_CRYPTO_SHARED_NAMESPACE(poly1305_maa64_g24_keypowers):
CRYPTO_SHARED_NAMESPACE(poly1305_maa64_g24_keypowers):
	
	movq 	%rsp,%r11
	andq    $-32,%rsp
	subq 	$96,%rsp

	movq 	%r11,0(%rsp)
	movq 	%r12,8(%rsp)
	movq 	%r13,16(%rsp)
	movq 	%r14,24(%rsp)
	movq 	%r15,32(%rsp)
	movq 	%rbx,40(%rsp)
	movq 	%rbp,48(%rsp)

	/* key = tau */
	movq    0(%rdi),%r14
	movq    8(%rdi),%r15

	/* tau^2 */	
	fe1305_tau_square()
	cmp	$3,%rsi
	je	.L	
	
	/* tau^3 */	
	fe1305_mul_tau_taun(1,2)
	cmp	$4,%rsi
	je	.L	
	
	/* tau^4 */
	movq    24(%rdi),%r8
	movq    32(%rdi),%r9
	movq    40(%rdi),%r10		
	fe1305_tau_squaren(3)	
	cmp	$5,%rsi
	je	.L	
	
	/* tau^5 */	
	fe1305_mul_tau_taun(3,4)
	cmp	$6,%rsi
	je	.L	
	
	/* tau^6 */	
	fe1305_mul_tau_taun(4,5)
	cmp	$7,%rsi
	je	.L	
	
	/* tau^7 */	
	fe1305_mul_tau_taun(5,6)
	cmp	$8,%rsi
	je	.L	
	
	/* tau^8 */
	movq    72(%rdi),%r8
	movq    80(%rdi),%r9
	movq    88(%rdi),%r10		
	fe1305_tau_squaren(7)	
	cmp	$9,%rsi
	je	.L	
	
	/* tau^9 */	
	fe1305_mul_tau_taun(7,8)
	cmp	$10,%rsi
	je	.L	
	
	/* tau^10 */	
	fe1305_mul_tau_taun(8,9)
	cmp	$11,%rsi
	je	.L	
	
	/* tau^11 */	
	fe1305_mul_tau_taun(9,10)
	cmp	$12,%rsi
	je	.L	
	
	/* tau^12 */	
	fe1305_mul_tau_taun(10,11)
	cmp	$13,%rsi
	je	.L	
	
	/* tau^13 */	
	fe1305_mul_tau_taun(11,12)
	cmp	$14,%rsi
	je	.L	
	
	/* tau^14 */	
	fe1305_mul_tau_taun(12,13)
	cmp	$15,%rsi
	je	.L	
	
	/* tau^15 */	
	fe1305_mul_tau_taun(13,14)
	cmp	$16,%rsi
	je	.L	
	
	/* tau^16 */
	movq    168(%rdi),%r8
	movq    176(%rdi),%r9
	movq    184(%rdi),%r10	
	fe1305_tau_squaren(15)	
	cmp	$17,%rsi
	je	.L	
	
	/* tau^17 */	
	fe1305_mul_tau_taun(15,16)
	cmp	$18,%rsi
	je	.L	
	
	/* tau^18 */	
	fe1305_mul_tau_taun(16,17)
	cmp	$19,%rsi
	je	.L	
	
	/* tau^19 */	
	fe1305_mul_tau_taun(17,18)
	cmp	$20,%rsi
	je	.L	
	
	/* tau^20 */	
	fe1305_mul_tau_taun(18,19)
	cmp	$21,%rsi
	je	.L	
	
	/* tau^21 */	
	fe1305_mul_tau_taun(19,20)
	cmp	$22,%rsi
	je	.L	
	
	/* tau^22 */	
	fe1305_mul_tau_taun(20,21)
	cmp	$23,%rsi
	je	.L	
	
	/* tau^23 */	
	fe1305_mul_tau_taun(21,22)
	cmp	$24,%rsi
	je	.L	
	
	/* tau^24 */	
	fe1305_mul_tau_taun(22,23)
	
.L:				

	movq 	0(%rsp),%r11
	movq 	8(%rsp),%r12
	movq 	16(%rsp),%r13
	movq 	24(%rsp),%r14
	movq 	32(%rsp),%r15
	movq 	40(%rsp),%rbx
	movq 	48(%rsp),%rbp

	movq 	%r11,%rsp

	ret
