## API Report File for "@lumino/widgets"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { CommandRegistry } from '@lumino/commands';
import { ConflatableMessage } from '@lumino/messaging';
import { ElementARIAAttrs } from '@lumino/virtualdom';
import { ElementBaseAttrs } from '@lumino/virtualdom';
import { ElementDataset } from '@lumino/virtualdom';
import { ElementInlineStyle } from '@lumino/virtualdom';
import { h } from '@lumino/virtualdom';
import { IDisposable } from '@lumino/disposable';
import { IMessageHandler } from '@lumino/messaging';
import { IObservableDisposable } from '@lumino/disposable';
import { ISignal } from '@lumino/signaling';
import { Message } from '@lumino/messaging';
import { ReadonlyJSONObject } from '@lumino/coreutils';
import { VirtualElement } from '@lumino/virtualdom';

// @public
export class AccordionLayout extends SplitLayout {
    constructor(options: AccordionLayout.IOptions);
    protected attachWidget(index: number, widget: Widget): void;
    protected detachWidget(index: number, widget: Widget): void;
    dispose(): void;
    insertWidget(index: number, widget: Widget): void;
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    readonly renderer: AccordionLayout.IRenderer;
    get titles(): ReadonlyArray<HTMLElement>;
    get titleSpace(): number;
    set titleSpace(value: number);
    protected updateItemPosition(i: number, isHorizontal: boolean, left: number, top: number, height: number, width: number, size: number): void;
    // (undocumented)
    updateTitle(index: number, widget: Widget): void;
}

// @public (undocumented)
export namespace AccordionLayout {
    export type Alignment = SplitLayout.Alignment;
    export interface IOptions extends SplitLayout.IOptions {
        renderer: IRenderer;
        titleSpace?: number;
    }
    export interface IRenderer extends SplitLayout.IRenderer {
        createSectionTitle(title: Title<Widget>): HTMLElement;
        readonly titleClassName: string;
    }
    export type Orientation = SplitLayout.Orientation;
}

// @public
export class AccordionPanel extends SplitPanel {
    constructor(options?: AccordionPanel.IOptions);
    addWidget(widget: Widget): void;
    collapse(index: number): void;
    expand(index: number): void;
    get expansionToggled(): ISignal<this, number>;
    handleEvent(event: Event): void;
    insertWidget(index: number, widget: Widget): void;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    get renderer(): AccordionPanel.IRenderer;
    get titles(): ReadonlyArray<HTMLElement>;
    get titleSpace(): number;
    set titleSpace(value: number);
}

// @public
export namespace AccordionPanel {
    export type Alignment = SplitLayout.Alignment;
    export interface IOptions extends Partial<AccordionLayout.IOptions> {
        layout?: AccordionLayout;
    }
    export type IRenderer = AccordionLayout.IRenderer;
    export type Orientation = SplitLayout.Orientation;
    export class Renderer extends SplitPanel.Renderer implements IRenderer {
        constructor();
        createCollapseIcon(data: Title<Widget>): HTMLElement;
        createSectionTitle(data: Title<Widget>): HTMLElement;
        createTitleKey(data: Title<Widget>): string;
        readonly titleClassName = "lm-AccordionPanel-title";
    }
    const defaultRenderer: Renderer;
}

// @public
export namespace BoxEngine {
    export function adjust(sizers: ArrayLike<BoxSizer>, index: number, delta: number): void;
    export function calc(sizers: ArrayLike<BoxSizer>, space: number): number;
}

// @public
export class BoxLayout extends PanelLayout {
    constructor(options?: BoxLayout.IOptions);
    get alignment(): BoxLayout.Alignment;
    set alignment(value: BoxLayout.Alignment);
    protected attachWidget(index: number, widget: Widget): void;
    protected detachWidget(index: number, widget: Widget): void;
    get direction(): BoxLayout.Direction;
    set direction(value: BoxLayout.Direction);
    dispose(): void;
    protected init(): void;
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    get spacing(): number;
    set spacing(value: number);
}

// @public
export namespace BoxLayout {
    export type Alignment = 'start' | 'center' | 'end' | 'justify';
    export type Direction = 'left-to-right' | 'right-to-left' | 'top-to-bottom' | 'bottom-to-top';
    export function getSizeBasis(widget: Widget): number;
    export function getStretch(widget: Widget): number;
    export interface IOptions {
        alignment?: Alignment;
        direction?: Direction;
        spacing?: number;
    }
    export function setSizeBasis(widget: Widget, value: number): void;
    export function setStretch(widget: Widget, value: number): void;
}

// @public
export class BoxPanel extends Panel {
    constructor(options?: BoxPanel.IOptions);
    get alignment(): BoxPanel.Alignment;
    set alignment(value: BoxPanel.Alignment);
    get direction(): BoxPanel.Direction;
    set direction(value: BoxPanel.Direction);
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    get spacing(): number;
    set spacing(value: number);
}

// @public
export namespace BoxPanel {
    export type Alignment = BoxLayout.Alignment;
    export type Direction = BoxLayout.Direction;
    export function getSizeBasis(widget: Widget): number;
    export function getStretch(widget: Widget): number;
    export interface IOptions {
        alignment?: Alignment;
        direction?: Direction;
        layout?: BoxLayout;
        spacing?: number;
    }
    export function setSizeBasis(widget: Widget, value: number): void;
    export function setStretch(widget: Widget, value: number): void;
}

// @public
export class BoxSizer {
    done: boolean;
    maxSize: number;
    minSize: number;
    size: number;
    sizeHint: number;
    stretch: number;
}

// @public
export class CommandPalette extends Widget {
    constructor(options: CommandPalette.IOptions);
    addItem(options: CommandPalette.IItemOptions): CommandPalette.IItem;
    addItems(items: CommandPalette.IItemOptions[]): CommandPalette.IItem[];
    clearItems(): void;
    readonly commands: CommandRegistry;
    get contentNode(): HTMLUListElement;
    dispose(): void;
    handleEvent(event: Event): void;
    get inputNode(): HTMLInputElement;
    get items(): ReadonlyArray<CommandPalette.IItem>;
    protected onActivateRequest(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onAfterShow(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onUpdateRequest(msg: Message): void;
    refresh(): void;
    removeItem(item: CommandPalette.IItem): void;
    removeItemAt(index: number): void;
    readonly renderer: CommandPalette.IRenderer;
    get searchNode(): HTMLDivElement;
}

// @public
export namespace CommandPalette {
    export interface IEmptyMessageRenderData {
        query: string;
    }
    export interface IHeaderRenderData {
        readonly category: string;
        readonly indices: ReadonlyArray<number> | null;
    }
    export interface IItem {
        readonly args: ReadonlyJSONObject;
        readonly caption: string;
        readonly category: string;
        readonly className: string;
        readonly command: string;
        readonly dataset: CommandRegistry.Dataset;
        readonly icon: VirtualElement.IRenderer | undefined;
        readonly iconClass: string;
        readonly iconLabel: string;
        readonly isEnabled: boolean;
        readonly isToggleable: boolean;
        readonly isToggled: boolean;
        readonly isVisible: boolean;
        readonly keyBinding: CommandRegistry.IKeyBinding | null;
        readonly label: string;
        readonly rank: number;
    }
    export interface IItemOptions {
        args?: ReadonlyJSONObject;
        category: string;
        command: string;
        rank?: number;
    }
    export interface IItemRenderData {
        readonly active: boolean;
        readonly indices: ReadonlyArray<number> | null;
        readonly item: IItem;
    }
    export interface IOptions {
        commands: CommandRegistry;
        renderer?: IRenderer;
    }
    export interface IRenderer {
        renderEmptyMessage(data: IEmptyMessageRenderData): VirtualElement;
        renderHeader(data: IHeaderRenderData): VirtualElement;
        renderItem(data: IItemRenderData): VirtualElement;
    }
    export class Renderer implements IRenderer {
        createIconClass(data: IItemRenderData): string;
        createItemClass(data: IItemRenderData): string;
        createItemDataset(data: IItemRenderData): ElementDataset;
        formatEmptyMessage(data: IEmptyMessageRenderData): h.Child;
        formatHeader(data: IHeaderRenderData): h.Child;
        formatItemCaption(data: IItemRenderData): h.Child;
        formatItemLabel(data: IItemRenderData): h.Child;
        formatItemShortcut(data: IItemRenderData): h.Child;
        renderEmptyMessage(data: IEmptyMessageRenderData): VirtualElement;
        renderHeader(data: IHeaderRenderData): VirtualElement;
        renderItem(data: IItemRenderData): VirtualElement;
        renderItemCaption(data: IItemRenderData): VirtualElement;
        renderItemContent(data: IItemRenderData): VirtualElement;
        renderItemIcon(data: IItemRenderData): VirtualElement;
        renderItemLabel(data: IItemRenderData): VirtualElement;
        renderItemShortcut(data: IItemRenderData): VirtualElement;
    }
    const defaultRenderer: Renderer;
}

// @public
export class ContextMenu {
    constructor(options: ContextMenu.IOptions);
    addItem(options: ContextMenu.IItemOptions): IDisposable;
    readonly menu: Menu;
    open(event: MouseEvent): boolean;
}

// @public
export namespace ContextMenu {
    export interface IItemOptions extends Menu.IItemOptions {
        rank?: number;
        selector: string;
    }
    export interface IOptions {
        commands: CommandRegistry;
        groupByTarget?: boolean;
        renderer?: Menu.IRenderer;
        sortBySelector?: boolean;
    }
}

// @public
export class DockLayout extends Layout {
    [Symbol.iterator](): IterableIterator<Widget>;
    constructor(options: DockLayout.IOptions);
    addWidget(widget: Widget, options?: DockLayout.IAddOptions): void;
    protected attachWidget(widget: Widget): void;
    protected detachWidget(widget: Widget): void;
    dispose(): void;
    handles(): IterableIterator<HTMLDivElement>;
    get hiddenMode(): Widget.HiddenMode;
    set hiddenMode(v: Widget.HiddenMode);
    hitTestTabAreas(clientX: number, clientY: number): DockLayout.ITabAreaGeometry | null;
    protected init(): void;
    get isEmpty(): boolean;
    moveHandle(handle: HTMLDivElement, offsetX: number, offsetY: number): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    removeWidget(widget: Widget): void;
    readonly renderer: DockLayout.IRenderer;
    restoreLayout(config: DockLayout.ILayoutConfig): void;
    saveLayout(): DockLayout.ILayoutConfig;
    selectedWidgets(): IterableIterator<Widget>;
    get spacing(): number;
    set spacing(value: number);
    tabBars(): IterableIterator<TabBar<Widget>>;
    widgets(): IterableIterator<Widget>;
}

// @public
export namespace DockLayout {
    export type AreaConfig = ITabAreaConfig | ISplitAreaConfig;
    export interface IAddOptions {
        mode?: InsertMode;
        ref?: Widget | null;
    }
    export interface ILayoutConfig {
        main: AreaConfig | null;
    }
    export type InsertMode = /**
    * The area to the top of the reference widget.
    *
    * The widget will be inserted just above the reference widget.
    *
    * If the reference widget is null or invalid, the widget will be
    * inserted at the top edge of the dock layout.
    */ 'split-top'
    /**
    * The area to the left of the reference widget.
    *
    * The widget will be inserted just left of the reference widget.
    *
    * If the reference widget is null or invalid, the widget will be
    * inserted at the left edge of the dock layout.
    */
    | 'split-left'
    /**
    * The area to the right of the reference widget.
    *
    * The widget will be inserted just right of the reference widget.
    *
    * If the reference widget is null or invalid, the widget will be
    * inserted  at the right edge of the dock layout.
    */
    | 'split-right'
    /**
    * The area to the bottom of the reference widget.
    *
    * The widget will be inserted just below the reference widget.
    *
    * If the reference widget is null or invalid, the widget will be
    * inserted at the bottom edge of the dock layout.
    */
    | 'split-bottom'
    /**
    * Like `split-top` but if a tab layout exists above the reference widget,
    * it behaves like `tab-after` with reference to that instead.
    */
    | 'merge-top'
    /**
    * Like `split-left` but if a tab layout exists left of the reference widget,
    * it behaves like `tab-after` with reference to that instead.
    */
    | 'merge-left'
    /**
    * Like `split-right` but if a tab layout exists right of the reference widget,
    * it behaves like `tab-after` with reference to that instead.
    */
    | 'merge-right'
    /**
    * Like `split-bottom` but if a tab layout exists below the reference widget,
    * it behaves like `tab-after` with reference to that instead.
    */
    | 'merge-bottom'
    /**
    * The tab position before the reference widget.
    *
    * The widget will be added as a tab before the reference widget.
    *
    * If the reference widget is null or invalid, a sensible default
    * will be used.
    */
    | 'tab-before'
    /**
    * The tab position after the reference widget.
    *
    * The widget will be added as a tab after the reference widget.
    *
    * If the reference widget is null or invalid, a sensible default
    * will be used.
    */
    | 'tab-after';
    export interface IOptions {
        document?: Document | ShadowRoot;
        hiddenMode?: Widget.HiddenMode;
        renderer: IRenderer;
        spacing?: number;
    }
    export interface IRenderer {
        createHandle(): HTMLDivElement;
        createTabBar(document?: Document | ShadowRoot): TabBar<Widget>;
    }
    export interface ISplitAreaConfig {
        children: AreaConfig[];
        orientation: 'horizontal' | 'vertical';
        sizes: number[];
        type: 'split-area';
    }
    export interface ITabAreaConfig {
        currentIndex: number;
        type: 'tab-area';
        widgets: Widget[];
    }
    export interface ITabAreaGeometry {
        bottom: number;
        height: number;
        left: number;
        right: number;
        tabBar: TabBar<Widget>;
        top: number;
        width: number;
        x: number;
        y: number;
    }
}

// @public
export class DockPanel extends Widget {
    constructor(options?: DockPanel.IOptions);
    activateWidget(widget: Widget): void;
    get addButtonEnabled(): boolean;
    set addButtonEnabled(value: boolean);
    get addRequested(): ISignal<this, TabBar<Widget>>;
    addWidget(widget: Widget, options?: DockPanel.IAddOptions): void;
    dispose(): void;
    handleEvent(event: Event): void;
    handles(): IterableIterator<HTMLDivElement>;
    get hiddenMode(): Widget.HiddenMode;
    set hiddenMode(v: Widget.HiddenMode);
    get isEmpty(): boolean;
    get layoutModified(): ISignal<this, void>;
    get mode(): DockPanel.Mode;
    set mode(value: DockPanel.Mode);
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    readonly overlay: DockPanel.IOverlay;
    processMessage(msg: Message): void;
    get renderer(): DockPanel.IRenderer;
    restoreLayout(config: DockPanel.ILayoutConfig): void;
    saveLayout(): DockPanel.ILayoutConfig;
    selectedWidgets(): IterableIterator<Widget>;
    selectWidget(widget: Widget): void;
    get spacing(): number;
    set spacing(value: number);
    tabBars(): IterableIterator<TabBar<Widget>>;
    get tabsConstrained(): boolean;
    set tabsConstrained(value: boolean);
    get tabsMovable(): boolean;
    set tabsMovable(value: boolean);
    widgets(): IterableIterator<Widget>;
}

// @public
export namespace DockPanel {
    export type IAddOptions = DockLayout.IAddOptions;
    export interface IEdges {
        bottom: number;
        left: number;
        right: number;
        top: number;
    }
    export type ILayoutConfig = DockLayout.ILayoutConfig;
    export type InsertMode = DockLayout.InsertMode;
    export interface IOptions {
        addButtonEnabled?: boolean;
        document?: Document | ShadowRoot;
        edges?: IEdges;
        hiddenMode?: Widget.HiddenMode;
        mode?: DockPanel.Mode;
        overlay?: IOverlay;
        renderer?: IRenderer;
        spacing?: number;
        tabsConstrained?: boolean;
        tabsMovable?: boolean;
    }
    export interface IOverlay {
        hide(delay: number): void;
        readonly node: HTMLDivElement;
        show(geo: IOverlayGeometry): void;
    }
    export interface IOverlayGeometry {
        bottom: number;
        left: number;
        right: number;
        top: number;
    }
    export type IRenderer = DockLayout.IRenderer;
    export type Mode = /**
    * The single document mode.
    *
    * In this mode, only a single widget is visible at a time, and that
    * widget fills the available layout space. No tab bars are visible.
    */ 'single-document'
    /**
    * The multiple document mode.
    *
    * In this mode, multiple documents are displayed in separate tab
    * areas, and those areas can be individually resized by the user.
    */
    | 'multiple-document';
    export class Overlay implements IOverlay {
        constructor();
        hide(delay: number): void;
        readonly node: HTMLDivElement;
        show(geo: IOverlayGeometry): void;
    }
    export class Renderer implements IRenderer {
        createHandle(): HTMLDivElement;
        createTabBar(document?: Document | ShadowRoot): TabBar<Widget>;
    }
    const defaultRenderer: Renderer;
}

// @public
export class FocusTracker<T extends Widget> implements IDisposable {
    get activeChanged(): ISignal<this, FocusTracker.IChangedArgs<T>>;
    get activeWidget(): T | null;
    add(widget: T): void;
    get currentChanged(): ISignal<this, FocusTracker.IChangedArgs<T>>;
    get currentWidget(): T | null;
    dispose(): void;
    focusNumber(widget: T): number;
    handleEvent(event: Event): void;
    has(widget: T): boolean;
    get isDisposed(): boolean;
    remove(widget: T): void;
    get widgets(): ReadonlyArray<T>;
}

// @public
export namespace FocusTracker {
    export interface IChangedArgs<T extends Widget> {
        newValue: T | null;
        oldValue: T | null;
    }
}

// @public
export class GridLayout extends Layout {
    [Symbol.iterator](): IterableIterator<Widget>;
    constructor(options?: GridLayout.IOptions);
    addWidget(widget: Widget): void;
    protected attachWidget(widget: Widget): void;
    get columnCount(): number;
    set columnCount(value: number);
    get columnSpacing(): number;
    set columnSpacing(value: number);
    columnStretch(index: number): number;
    protected detachWidget(widget: Widget): void;
    dispose(): void;
    protected init(): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    removeWidget(widget: Widget): void;
    get rowCount(): number;
    set rowCount(value: number);
    get rowSpacing(): number;
    set rowSpacing(value: number);
    rowStretch(index: number): number;
    setColumnStretch(index: number, value: number): void;
    setRowStretch(index: number, value: number): void;
}

// @public
export namespace GridLayout {
    export function getCellConfig(widget: Widget): ICellConfig;
    export interface ICellConfig {
        readonly column: number;
        readonly columnSpan: number;
        readonly row: number;
        readonly rowSpan: number;
    }
    export interface IOptions extends Layout.IOptions {
        columnCount?: number;
        columnSpacing?: number;
        rowCount?: number;
        rowSpacing?: number;
    }
    export function setCellConfig(widget: Widget, value: Partial<ICellConfig>): void;
}

// @public
export interface IOverflowMenuOptions {
    isVisible: boolean;
    title?: string;
}

// @public
export abstract class Layout implements Iterable<Widget>, IDisposable {
    abstract [Symbol.iterator](): IterableIterator<Widget>;
    constructor(options?: Layout.IOptions);
    dispose(): void;
    get fitPolicy(): Layout.FitPolicy;
    set fitPolicy(value: Layout.FitPolicy);
    protected init(): void;
    get isDisposed(): boolean;
    protected onAfterAttach(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onAfterHide(msg: Message): void;
    protected onAfterShow(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeDetach(msg: Message): void;
    protected onBeforeHide(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    get parent(): Widget | null;
    set parent(value: Widget | null);
    processParentMessage(msg: Message): void;
    abstract removeWidget(widget: Widget): void;
}

// @public
export namespace Layout {
    export type FitPolicy = /**
    * No size constraint will be applied to the parent widget.
    */ 'set-no-constraint'
    /**
    * The computed min size will be applied to the parent widget.
    */
    | 'set-min-size';
    export function getHorizontalAlignment(widget: Widget): HorizontalAlignment;
    export function getVerticalAlignment(widget: Widget): VerticalAlignment;
    export type HorizontalAlignment = 'left' | 'center' | 'right';
    export interface IOptions {
        fitPolicy?: FitPolicy;
    }
    export function setHorizontalAlignment(widget: Widget, value: HorizontalAlignment): void;
    export function setVerticalAlignment(widget: Widget, value: VerticalAlignment): void;
    export type VerticalAlignment = 'top' | 'center' | 'bottom';
}

// @public
export class LayoutItem implements IDisposable {
    constructor(widget: Widget);
    dispose(): void;
    fit(): void;
    get isAttached(): boolean;
    get isDisposed(): boolean;
    get isHidden(): boolean;
    get isVisible(): boolean;
    get maxHeight(): number;
    get maxWidth(): number;
    get minHeight(): number;
    get minWidth(): number;
    update(left: number, top: number, width: number, height: number): void;
    readonly widget: Widget;
}

// @public
export class Menu extends Widget {
    constructor(options: Menu.IOptions);
    get aboutToClose(): ISignal<this, void>;
    activateNextItem(): void;
    activatePreviousItem(): void;
    get activeIndex(): number;
    set activeIndex(value: number);
    get activeItem(): Menu.IItem | null;
    set activeItem(value: Menu.IItem | null);
    addItem(options: Menu.IItemOptions): Menu.IItem;
    get childMenu(): Menu | null;
    clearItems(): void;
    readonly commands: CommandRegistry;
    get contentNode(): HTMLUListElement;
    dispose(): void;
    handleEvent(event: Event): void;
    insertItem(index: number, options: Menu.IItemOptions): Menu.IItem;
    get items(): ReadonlyArray<Menu.IItem>;
    get leafMenu(): Menu;
    get menuRequested(): ISignal<this, 'next' | 'previous'>;
    protected onActivateRequest(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onCloseRequest(msg: Message): void;
    protected onUpdateRequest(msg: Message): void;
    open(x: number, y: number, options?: Menu.IOpenOptions): void;
    get parentMenu(): Menu | null;
    removeItem(item: Menu.IItem): void;
    removeItemAt(index: number): void;
    readonly renderer: Menu.IRenderer;
    get rootMenu(): Menu;
    static saveWindowData(): void;
    triggerActiveItem(): void;
}

// @public
export namespace Menu {
    export interface IItem {
        readonly args: ReadonlyJSONObject;
        readonly caption: string;
        readonly className: string;
        readonly command: string;
        readonly dataset: CommandRegistry.Dataset;
        readonly icon: VirtualElement.IRenderer | undefined;
        readonly iconClass: string;
        readonly iconLabel: string;
        readonly isEnabled: boolean;
        readonly isToggled: boolean;
        readonly isVisible: boolean;
        readonly keyBinding: CommandRegistry.IKeyBinding | null;
        readonly label: string;
        readonly mnemonic: number;
        readonly submenu: Menu | null;
        readonly type: ItemType;
    }
    export interface IItemOptions {
        args?: ReadonlyJSONObject;
        command?: string;
        submenu?: Menu | null;
        type?: ItemType;
    }
    export interface IOpenOptions {
        forceX?: boolean;
        forceY?: boolean;
    }
    export interface IOptions {
        commands: CommandRegistry;
        renderer?: IRenderer;
    }
    export interface IRenderData {
        readonly active: boolean;
        readonly collapsed: boolean;
        readonly item: IItem;
        readonly onfocus?: () => void;
    }
    export interface IRenderer {
        renderItem(data: IRenderData): VirtualElement;
    }
    export type ItemType = 'command' | 'submenu' | 'separator';
    export class Renderer implements IRenderer {
        createIconClass(data: IRenderData): string;
        createItemARIA(data: IRenderData): ElementARIAAttrs;
        createItemClass(data: IRenderData): string;
        createItemDataset(data: IRenderData): ElementDataset;
        formatLabel(data: IRenderData): h.Child;
        formatShortcut(data: IRenderData): h.Child;
        renderIcon(data: IRenderData): VirtualElement;
        renderItem(data: IRenderData): VirtualElement;
        renderLabel(data: IRenderData): VirtualElement;
        renderShortcut(data: IRenderData): VirtualElement;
        renderSubmenu(data: IRenderData): VirtualElement;
    }
    const defaultRenderer: Renderer;
}

// @public
export class MenuBar extends Widget {
    constructor(options?: MenuBar.IOptions);
    get activeIndex(): number;
    set activeIndex(value: number);
    get activeMenu(): Menu | null;
    set activeMenu(value: Menu | null);
    addMenu(menu: Menu, update?: boolean): void;
    get childMenu(): Menu | null;
    clearMenus(): void;
    get contentNode(): HTMLUListElement;
    dispose(): void;
    handleEvent(event: Event): void;
    insertMenu(index: number, menu: Menu, update?: boolean): void;
    get menus(): ReadonlyArray<Menu>;
    protected onActivateRequest(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    openActiveMenu(): void;
    get overflowIndex(): number;
    get overflowMenu(): Menu | null;
    removeMenu(menu: Menu, update?: boolean): void;
    removeMenuAt(index: number, update?: boolean): void;
    readonly renderer: MenuBar.IRenderer;
}

// @public
export namespace MenuBar {
    export interface IOptions {
        forceItemsPosition?: Menu.IOpenOptions;
        overflowMenuOptions?: IOverflowMenuOptions;
        renderer?: IRenderer;
    }
    export interface IRenderData {
        readonly active: boolean;
        // (undocumented)
        readonly onfocus?: (event: FocusEvent) => void;
        readonly tabbable: boolean;
        readonly title: Title<Widget>;
    }
    export interface IRenderer {
        renderItem(data: IRenderData): VirtualElement;
    }
    export class Renderer implements IRenderer {
        createIconClass(data: IRenderData): string;
        createItemARIA(data: IRenderData): ElementARIAAttrs;
        createItemClass(data: IRenderData): string;
        createItemDataset(data: IRenderData): ElementDataset;
        formatLabel(data: IRenderData): h.Child;
        renderIcon(data: IRenderData): VirtualElement;
        renderItem(data: IRenderData): VirtualElement;
        renderLabel(data: IRenderData): VirtualElement;
    }
    const defaultRenderer: Renderer;
}

// @public
export class Panel extends Widget {
    constructor(options?: Panel.IOptions);
    addWidget(widget: Widget): void;
    insertWidget(index: number, widget: Widget): void;
    get widgets(): ReadonlyArray<Widget>;
}

// @public
export namespace Panel {
    export interface IOptions {
        layout?: PanelLayout;
    }
}

// @public
export class PanelLayout extends Layout {
    [Symbol.iterator](): IterableIterator<Widget>;
    addWidget(widget: Widget): void;
    protected attachWidget(index: number, widget: Widget): void;
    protected detachWidget(index: number, widget: Widget): void;
    dispose(): void;
    protected init(): void;
    insertWidget(index: number, widget: Widget): void;
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    removeWidget(widget: Widget): void;
    removeWidgetAt(index: number): void;
    get widgets(): ReadonlyArray<Widget>;
}

// @public
export class ScrollBar extends Widget {
    constructor(options?: ScrollBar.IOptions);
    get decrementNode(): HTMLDivElement;
    handleEvent(event: Event): void;
    get incrementNode(): HTMLDivElement;
    get maximum(): number;
    set maximum(value: number);
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onUpdateRequest(msg: Message): void;
    get orientation(): ScrollBar.Orientation;
    set orientation(value: ScrollBar.Orientation);
    get page(): number;
    set page(value: number);
    get pageRequested(): ISignal<this, 'decrement' | 'increment'>;
    get stepRequested(): ISignal<this, 'decrement' | 'increment'>;
    get thumbMoved(): ISignal<this, number>;
    get thumbNode(): HTMLDivElement;
    get trackNode(): HTMLDivElement;
    get value(): number;
    set value(value: number);
}

// @public
export namespace ScrollBar {
    export interface IOptions {
        maximum?: number;
        orientation?: Orientation;
        page?: number;
        value?: number;
    }
    export type Orientation = 'horizontal' | 'vertical';
}

// @public
export class SingletonLayout extends Layout {
    [Symbol.iterator](): IterableIterator<Widget>;
    protected attachWidget(widget: Widget): void;
    protected detachWidget(widget: Widget): void;
    dispose(): void;
    protected init(): void;
    removeWidget(widget: Widget): void;
    get widget(): Widget | null;
    set widget(widget: Widget | null);
}

// @public
export class SplitLayout extends PanelLayout {
    constructor(options: SplitLayout.IOptions);
    absoluteSizes(): number[];
    get alignment(): SplitLayout.Alignment;
    set alignment(value: SplitLayout.Alignment);
    protected attachWidget(index: number, widget: Widget): void;
    protected detachWidget(index: number, widget: Widget): void;
    dispose(): void;
    get handles(): ReadonlyArray<HTMLDivElement>;
    protected init(): void;
    moveHandle(index: number, position: number): void;
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    get orientation(): SplitLayout.Orientation;
    set orientation(value: SplitLayout.Orientation);
    relativeSizes(): number[];
    readonly renderer: SplitLayout.IRenderer;
    setRelativeSizes(sizes: number[], update?: boolean): void;
    get spacing(): number;
    set spacing(value: number);
    protected updateItemPosition(i: number, isHorizontal: boolean, left: number, top: number, height: number, width: number, size: number): void;
    // (undocumented)
    protected widgetOffset: number;
}

// @public
export namespace SplitLayout {
    export type Alignment = 'start' | 'center' | 'end' | 'justify';
    export function getStretch(widget: Widget): number;
    export interface IOptions {
        alignment?: Alignment;
        orientation?: Orientation;
        renderer: IRenderer;
        spacing?: number;
    }
    export interface IRenderer {
        createHandle(): HTMLDivElement;
    }
    export type Orientation = 'horizontal' | 'vertical';
    export function setStretch(widget: Widget, value: number): void;
}

// @public
export class SplitPanel extends Panel {
    constructor(options?: SplitPanel.IOptions);
    get alignment(): SplitPanel.Alignment;
    set alignment(value: SplitPanel.Alignment);
    dispose(): void;
    handleEvent(event: Event): void;
    get handleMoved(): ISignal<this, void>;
    get handles(): ReadonlyArray<HTMLDivElement>;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    get orientation(): SplitPanel.Orientation;
    set orientation(value: SplitPanel.Orientation);
    relativeSizes(): number[];
    get renderer(): SplitPanel.IRenderer;
    setRelativeSizes(sizes: number[], update?: boolean): void;
    get spacing(): number;
    set spacing(value: number);
}

// @public
export namespace SplitPanel {
    export type Alignment = SplitLayout.Alignment;
    export function getStretch(widget: Widget): number;
    export interface IOptions {
        alignment?: Alignment;
        layout?: SplitLayout;
        orientation?: Orientation;
        renderer?: IRenderer;
        spacing?: number;
    }
    export type IRenderer = SplitLayout.IRenderer;
    export type Orientation = SplitLayout.Orientation;
    const defaultRenderer: Renderer;
    export class Renderer implements IRenderer {
        createHandle(): HTMLDivElement;
    }
    export function setStretch(widget: Widget, value: number): void;
}

// @public
export class StackedLayout extends PanelLayout {
    constructor(options?: StackedLayout.IOptions);
    protected attachWidget(index: number, widget: Widget): void;
    protected detachWidget(index: number, widget: Widget): void;
    dispose(): void;
    get hiddenMode(): Widget.HiddenMode;
    set hiddenMode(v: Widget.HiddenMode);
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
}

// @public
export namespace StackedLayout {
    export interface IOptions extends Layout.IOptions {
        hiddenMode?: Widget.HiddenMode;
    }
}

// @public
export class StackedPanel extends Panel {
    constructor(options?: StackedPanel.IOptions);
    get hiddenMode(): Widget.HiddenMode;
    set hiddenMode(v: Widget.HiddenMode);
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    get widgetRemoved(): ISignal<this, Widget>;
}

// @public
export namespace StackedPanel {
    export interface IOptions {
        layout?: StackedLayout;
    }
}

// @public
export class TabBar<T> extends Widget {
    constructor(options?: TabBar.IOptions<T>);
    get addButtonEnabled(): boolean;
    set addButtonEnabled(value: boolean);
    get addButtonNode(): HTMLDivElement;
    get addRequested(): ISignal<this, void>;
    addTab(value: Title<T> | Title.IOptions<T>): Title<T>;
    allowDeselect: boolean;
    clearTabs(): void;
    get contentNode(): HTMLUListElement;
    get currentChanged(): ISignal<this, TabBar.ICurrentChangedArgs<T>>;
    get currentIndex(): number;
    set currentIndex(value: number);
    get currentTitle(): Title<T> | null;
    set currentTitle(value: Title<T> | null);
    dispose(): void;
    get document(): Document | ShadowRoot;
    handleEvent(event: Event): void;
    insertBehavior: TabBar.InsertBehavior;
    insertTab(index: number, value: Title<T> | Title.IOptions<T>): Title<T>;
    get name(): string;
    set name(value: string);
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onUpdateRequest(msg: Message): void;
    get orientation(): TabBar.Orientation;
    set orientation(value: TabBar.Orientation);
    releaseMouse(): void;
    removeBehavior: TabBar.RemoveBehavior;
    removeTab(title: Title<T>): void;
    removeTabAt(index: number): void;
    readonly renderer: TabBar.IRenderer<T>;
    get tabActivateRequested(): ISignal<this, TabBar.ITabActivateRequestedArgs<T>>;
    get tabCloseRequested(): ISignal<this, TabBar.ITabCloseRequestedArgs<T>>;
    get tabDetachRequested(): ISignal<this, TabBar.ITabDetachRequestedArgs<T>>;
    get tabMoved(): ISignal<this, TabBar.ITabMovedArgs<T>>;
    tabsMovable: boolean;
    get titles(): ReadonlyArray<Title<T>>;
    get titlesEditable(): boolean;
    set titlesEditable(value: boolean);
}

// @public
export namespace TabBar {
    export interface ICurrentChangedArgs<T> {
        readonly currentIndex: number;
        readonly currentTitle: Title<T> | null;
        readonly previousIndex: number;
        readonly previousTitle: Title<T> | null;
    }
    export type InsertBehavior = /**
    * The selected tab will not be changed.
    */ 'none'
    /**
    * The inserted tab will be selected.
    */
    | 'select-tab'
    /**
    * The inserted tab will be selected if the current tab is null.
    */
    | 'select-tab-if-needed';
    export interface IOptions<T> {
        addButtonEnabled?: boolean;
        allowDeselect?: boolean;
        document?: Document | ShadowRoot;
        insertBehavior?: TabBar.InsertBehavior;
        name?: string;
        orientation?: TabBar.Orientation;
        removeBehavior?: TabBar.RemoveBehavior;
        renderer?: IRenderer<T>;
        tabsMovable?: boolean;
        titlesEditable?: boolean;
    }
    export interface IRenderData<T> {
        readonly current: boolean;
        readonly tabIndex?: number;
        readonly title: Title<T>;
        readonly zIndex: number;
    }
    export interface IRenderer<T> {
        readonly closeIconSelector: string;
        renderTab(data: IRenderData<T>): VirtualElement;
    }
    export interface ITabActivateRequestedArgs<T> {
        readonly index: number;
        readonly title: Title<T>;
    }
    export interface ITabCloseRequestedArgs<T> {
        readonly index: number;
        readonly title: Title<T>;
    }
    export interface ITabDetachRequestedArgs<T> {
        readonly clientX: number;
        readonly clientY: number;
        readonly index: number;
        readonly offset?: {
            x: number;
            y: number;
        };
        readonly tab: HTMLElement;
        readonly title: Title<T>;
    }
    export interface ITabMovedArgs<T> {
        readonly fromIndex: number;
        readonly title: Title<T>;
        readonly toIndex: number;
    }
    export type Orientation = /**
    * The tabs are arranged in a single row, left-to-right.
    *
    * The tab text orientation is horizontal.
    */ 'horizontal'
    /**
    * The tabs are arranged in a single column, top-to-bottom.
    *
    * The tab text orientation is horizontal.
    */
    | 'vertical';
    export type RemoveBehavior = /**
    * No tab will be selected.
    */ 'none'
    /**
    * The tab after the removed tab will be selected if possible.
    */
    | 'select-tab-after'
    /**
    * The tab before the removed tab will be selected if possible.
    */
    | 'select-tab-before'
    /**
    * The previously selected tab will be selected if possible.
    */
    | 'select-previous-tab';
    export class Renderer implements IRenderer<any> {
        constructor();
        readonly closeIconSelector = ".lm-TabBar-tabCloseIcon";
        createIconClass(data: IRenderData<any>): string;
        createTabARIA(data: IRenderData<any>): ElementARIAAttrs | ElementBaseAttrs;
        createTabClass(data: IRenderData<any>): string;
        createTabDataset(data: IRenderData<any>): ElementDataset;
        createTabKey(data: IRenderData<any>): string;
        createTabStyle(data: IRenderData<any>): ElementInlineStyle;
        renderCloseIcon(data: IRenderData<any>): VirtualElement;
        renderIcon(data: IRenderData<any>): VirtualElement;
        renderLabel(data: IRenderData<any>): VirtualElement;
        renderTab(data: IRenderData<any>): VirtualElement;
    }
    const defaultRenderer: Renderer;
    const addButtonSelector = ".lm-TabBar-addButton";
}

// @public
export class TabPanel extends Widget {
    constructor(options?: TabPanel.IOptions);
    get addButtonEnabled(): boolean;
    set addButtonEnabled(value: boolean);
    get addRequested(): ISignal<this, TabBar<Widget>>;
    addWidget(widget: Widget): void;
    get currentChanged(): ISignal<this, TabPanel.ICurrentChangedArgs>;
    get currentIndex(): number;
    set currentIndex(value: number);
    get currentWidget(): Widget | null;
    set currentWidget(value: Widget | null);
    insertWidget(index: number, widget: Widget): void;
    readonly stackedPanel: StackedPanel;
    readonly tabBar: TabBar<Widget>;
    get tabPlacement(): TabPanel.TabPlacement;
    set tabPlacement(value: TabPanel.TabPlacement);
    get tabsMovable(): boolean;
    set tabsMovable(value: boolean);
    get widgets(): ReadonlyArray<Widget>;
}

// @public
export namespace TabPanel {
    export interface ICurrentChangedArgs {
        currentIndex: number;
        currentWidget: Widget | null;
        previousIndex: number;
        previousWidget: Widget | null;
    }
    export interface IOptions {
        addButtonEnabled?: boolean;
        document?: Document | ShadowRoot;
        renderer?: TabBar.IRenderer<Widget>;
        tabPlacement?: TabPlacement;
        tabsMovable?: boolean;
    }
    export type TabPlacement = /**
    * The tabs are placed as a row above the content.
    */ 'top'
    /**
    * The tabs are placed as a column to the left of the content.
    */
    | 'left'
    /**
    * The tabs are placed as a column to the right of the content.
    */
    | 'right'
    /**
    * The tabs are placed as a row below the content.
    */
    | 'bottom';
}

// @public
export class Title<T> implements IDisposable {
    constructor(options: Title.IOptions<T>);
    get caption(): string;
    set caption(value: string);
    get changed(): ISignal<this, void>;
    get className(): string;
    set className(value: string);
    get closable(): boolean;
    set closable(value: boolean);
    get dataset(): Title.Dataset;
    set dataset(value: Title.Dataset);
    dispose(): void;
    get icon(): VirtualElement.IRenderer | undefined;
    set icon(value: VirtualElement.IRenderer | undefined);
    get iconClass(): string;
    set iconClass(value: string);
    get iconLabel(): string;
    set iconLabel(value: string);
    get isDisposed(): boolean;
    get label(): string;
    set label(value: string);
    get mnemonic(): number;
    set mnemonic(value: number);
    readonly owner: T;
}

// @public
export namespace Title {
    export type Dataset = {
        readonly [key: string]: string;
    };
    export interface IOptions<T> {
        caption?: string;
        className?: string;
        closable?: boolean;
        dataset?: Dataset;
        icon?: VirtualElement.IRenderer;
        iconClass?: string;
        iconLabel?: string;
        label?: string;
        mnemonic?: number;
        owner: T;
    }
}

// @public
export class Widget implements IMessageHandler, IObservableDisposable {
    constructor(options?: Widget.IOptions);
    activate(): void;
    addClass(name: string): void;
    children(): IterableIterator<Widget>;
    clearFlag(flag: Widget.Flag): void;
    close(): void;
    contains(widget: Widget): boolean;
    get dataset(): DOMStringMap;
    dispose(): void;
    get disposed(): ISignal<this, void>;
    fit(): void;
    hasClass(name: string): boolean;
    get hiddenMode(): Widget.HiddenMode;
    set hiddenMode(value: Widget.HiddenMode);
    hide(): void;
    get id(): string;
    set id(value: string);
    get isAttached(): boolean;
    get isDisposed(): boolean;
    get isHidden(): boolean;
    get isVisible(): boolean;
    get layout(): Layout | null;
    set layout(value: Layout | null);
    readonly node: HTMLElement;
    protected notifyLayout(msg: Message): void;
    protected onActivateRequest(msg: Message): void;
    protected onAfterAttach(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onAfterHide(msg: Message): void;
    protected onAfterShow(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeDetach(msg: Message): void;
    protected onBeforeHide(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    protected onCloseRequest(msg: Message): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    get parent(): Widget | null;
    set parent(value: Widget | null);
    processMessage(msg: Message): void;
    removeClass(name: string): void;
    setFlag(flag: Widget.Flag): void;
    setHidden(hidden: boolean): void;
    show(): void;
    testFlag(flag: Widget.Flag): boolean;
    get title(): Title<Widget>;
    toggleClass(name: string, force?: boolean): boolean;
    update(): void;
}

// @public
export namespace Widget {
    export function attach(widget: Widget, host: HTMLElement, ref?: HTMLElement | null): void;
    export class ChildMessage extends Message {
        constructor(type: string, child: Widget);
        readonly child: Widget;
    }
    export function detach(widget: Widget): void;
    export enum Flag {
        DisallowLayout = 16,
        IsAttached = 2,
        IsDisposed = 1,
        IsHidden = 4,
        IsVisible = 8
    }
    export enum HiddenMode {
        ContentVisibility = 2,
        Display = 0,
        Scale = 1
    }
    export interface IOptions {
        node?: HTMLElement;
        tag?: keyof HTMLElementTagNameMap;
    }
    export namespace Msg {
        const BeforeShow: Message;
        const AfterShow: Message;
        const BeforeHide: Message;
        const AfterHide: Message;
        const BeforeAttach: Message;
        const AfterAttach: Message;
        const BeforeDetach: Message;
        const AfterDetach: Message;
        const ParentChanged: Message;
        const UpdateRequest: ConflatableMessage;
        const FitRequest: ConflatableMessage;
        const ActivateRequest: ConflatableMessage;
        const CloseRequest: ConflatableMessage;
    }
    export class ResizeMessage extends Message {
        constructor(width: number, height: number);
        readonly height: number;
        readonly width: number;
    }
    export namespace ResizeMessage {
        const UnknownSize: ResizeMessage;
    }
}

```
