FIND_PATH(JPEGLIB_INCLUDE_DIR jpeglib.h
  /usr/local/include
  /usr/include
  /opt/local/include
)

SET(JPEGLIB_NAMES ${JPEGLIB_NAMES} jpeg)
FIND_LIBRARY(JPEGLIB_LIBRARY NAMES ${JPEGLIB_NAMES} )

# handle the QUIETLY and REQUIRED arguments and set JPEGLIB_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(JPEGLIB  DEFAULT_MSG  JPEGLIB_LIBRARY  JPEGLIB_INCLUDE_DIR)

IF(JPEGLIB_FOUND)
  SET( JPEGLIB_LIBRARIES ${JPEGLIB_LIBRARY} )
  IF(NOT JPEGLIB_FIND_QUIETLY)
    MESSAGE(STATUS "Found jpeglib (JPEGLIB_LIBRARIES = ${JPEGLIB_LIBRARIES})")
    MESSAGE(STATUS "Found jpeglib (JPEGLIB_INCLUDE_DIR = ${JPEGLIB_INCLUDE_DIR})")
  ENDIF(NOT JPEGLIB_FIND_QUIETLY)
ELSE(JPEGLIB_FOUND)
  IF(JPEGLIB_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find jpeglib")
  ENDIF(JPEGLIB_FIND_REQUIRED)
ENDIF(JPEGLIB_FOUND)



MARK_AS_ADVANCED(JPEGLIB_INCLUDE_DIR JPEGLIB_LIBRARY)

