<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'Node.php';
	require_once 'Attribute.php';

	/**
	* Info Module object
	*
	* Gives information on current node
	* This module can be use as a sample module
	*
	* Author: Nicolas Dufresne
	*/

	class InfoViewer{
		var $node;
		var $parent;
		var $childrens;
		var $status;
		var $newStatus;
		var $attributes;

		function InfoViewer() {
			$this->node = new Node(trim($_GET['node_id']));
			$this->status = $this->node->getStatus();
			//$this->attributes = $this->node->getAttributes();
			$this->lts = $this->node->getLTS();
			return;
			If (!$this->status){
				$this->status['ip'] = "192.168.2.109";
				$this->status['bootservip'] = "192.168.2.5";
			}
			$newStatus = $this->status;
			$newStatus['code'] = 1;
			if ($this->node->setStatus($newStatus)) {
				$newStatus = $this->node->getStatus();
			}
			else return;
			$newStatus['code'] = 2;
			$newStatus['appservip'] = "192.168.2.71";
			$newStatus['display'] = 1;
			if ($this->node->setStatus($newStatus)) {
				$newStatus = $this->node->getStatus();
			}
			else return;
			$newStatus['code'] = 3;
			$newStatus['username'] = "Nicolas";
			if ($this->node->setStatus($newStatus)) {
				$newStatus = $this->node->getStatus();
			}
			else return;
			$newStatus['code'] = 4;
			if ($this->node->setStatus($newStatus)) {
				$this->newStatus = $this->node->getStatus();
			}

		}

		function print_info() {
			if (!$this->node_error($this->node))	$this->print_node($this->node);
			if ($this->status) $this->print_status($this->status);
			/*foreach ($this->attributes as $attribute) {
				$this->print_attribute($attribute);
			}*/
			if (is_array($this->lts)) $this->print_lts($this->lts);
			return;
			$this->print_status($this->newStatus);


		}

		function print_status($status){
			if (!is_array($status)) {
				print "<p>".$this->node->lastError()."</p>\n";
				return;
			}
			foreach ($status as $name => $value) {
				print "<p>".$name."=".$value."</p>\n";
			}
			print '<HR SIZE="1" noshade width=50% align="left">';
		}

		function print_lts($lts){
			foreach ($this->lts as $name => $value) {
				print "<p>".$name." = ".$value."</p>\n";
			}
			print '<HR SIZE="1" noshade width=50% align="left">';
		}


		function print_attribute($attribute){
			print "<p>name = ".$attribute->getName()."</p>\n";
			print "<p>value = ".$attribute->getValue()."</p>\n";
			print "<p>id = ".$attribute->getID()."</p>\n";
			print "<p>node_id = ".$attribute->getNodeID()."</p>\n";
			print "<p>attributeDef_id = ".$attribute->getAttributeDefID()."</p>\n";
			print "<p>type = ".$attribute->getType()."</p>\n";
			print "<p>mask = ".$attribute->getMask()."</p>\n";
			if ($attribute->getType() == 0) {
				print "<p>MaskInfo = ".ereg($attribute->getMask(),$attribute->getValue())."</p>\n";
			}
			$selection = $attribute->getSelection();
			if (is_array($selection)) {
				print "<p> selection = { <br>\n";
				foreach ($selection as $key => $value) {
					print "\t".$key." = ".$value."<br>\n";
				}
				print "</p>\n>";
			}
			print "<p>isError = ".$attribute->isError()."</p>\n";
			print "<p>lastError = ".$attribute->lastError()."</p>\n";
			print '<HR SIZE="1" noshade width=50% align="left">';
		}

		function print_node($node) {
			print "<h2>".getMEssage($_GET['module'])."</h2>";
			print "<p>id = ".$node->getID()."</p>\n";
			print "<p>father = ".$node->getParentID()."</p>\n";
			print "<p>mac = ".$node->getMac()."</p>\n";
			print "<p>name = ".$node->getName()."</p>\n";
			if ($node->isNode())
				print "<p>isNode = true</p>\n";
			else print "<p>isNode = false</p>\n";
			if ($node->isError())
				print "<p>isError = true</p>\n";
			else print "<p>isError = false</p>\n";
			print "<p>lastError = ".$node->lastError()."</p>\n";
			print '<HR SIZE="1" noshade width=50% align="left">';
		}

		function node_error($node) {
			if ($node->isError()) {
				print "<p>".$node->lastError()."</p>\n";
				return true;
			}
			return false;
		}
	}
?>