/*
 *  Copyright 1994-2016 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <arpa/inet.h>
#include "context.h"
#include "erlang.h"

/*
 * Protocol v1:
 * [ width ] "W"          2 bytes
 * [ height ] "H"         2 bytes
 * [ image data ] (RGB)   W*H*3 bytes
 *
 */
void
v1(const Context_t *ctx)
{
  uint16_t width = WIDTH, width2;
  uint16_t height = HEIGHT, height2;
  uint32_t proto = 1, proto2;
  uint32_t total, total2;
  Pixel_t *src;

  /* send packet size */
  total = sizeof(uint32_t)+2*sizeof(uint16_t)+RGB_BUFFSIZE*sizeof(u_char);
  total2 = htonl(total);
  write_uint32(&total2);
  
  /* protocol version */
  proto2 = htonl(proto);
  write_uint32(&proto2);
  
  /* send width, height */
  width2 = htons(width);
  height2 = htons(height);
  write_uint16(&width2);
  write_uint16(&height2);
  
  /* send picture */
  src = export_RGB_active_buffer(ctx, 0);
  write_binary(src, RGB_BUFFSIZE);
  xfree(src);
}


