/***************************************************************************
                          contactaddeduserdialog.h  -  description
                             -------------------
    begin                : Sun Apr 14 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTADDEDUSERDIALOG_H
#define CONTACTADDEDUSERDIALOG_H

#include <KDialog>

class QTabWidget;



/**
 * The dialog for when someone has added the user to his or her contact list.
 *
 * @author Mike K. Bennett, Timo Tambet
 * @ingroup Dialogs
 */
class ContactAddedUserDialog : public KDialog
{
  Q_OBJECT

  public:
    // The constructor
                 ContactAddedUserDialog( const QString& contactHandle, const QString& contactFriendlyName, QWidget *parent = 0 );
    // The destructor
    virtual      ~ContactAddedUserDialog();
    void         addTab( const QString& contactHandle, const QString& contactFriendlyName );

   private slots:
    void         slotCloseTab( int index );
    void         slotTabDeleted();

  signals:
    void         userChoice( const QString &handle, const QStringList &groupIds, const int code );

  private:
    QTabWidget   *tabWidget_;
};



#endif
