
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QWidget>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QWidget::staticMetaObject);
}


// bool QWidget::acceptDrops()


static void _init_f_acceptDrops_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptDrops_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->acceptDrops ());
}


// QString QWidget::accessibleDescription()


static void _init_f_accessibleDescription_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_accessibleDescription_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->accessibleDescription ());
}


// QString QWidget::accessibleName()


static void _init_f_accessibleName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_accessibleName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->accessibleName ());
}


// QList<QAction*> QWidget::actions()


static void _init_f_actions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAction*> > ();
}

static void _call_f_actions_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAction*> > ((QList<QAction*>)((QWidget *)cls)->actions ());
}


// void QWidget::activateWindow()


static void _init_f_activateWindow_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_activateWindow_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->activateWindow ();
}


// void QWidget::addAction(QAction *action)


static void _init_f_addAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addAction_1309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAction *arg1 = gsi::arg_reader<QAction * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->addAction (arg1);
}


// void QWidget::addActions(const QList<QAction*> &actions)


static void _init_f_addActions_2657 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("actions");
  decl->add_arg<const QList<QAction*> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addActions_2657 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QAction*> &arg1 = gsi::arg_reader<const QList<QAction*> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->addActions (arg1);
}


// void QWidget::adjustSize()


static void _init_f_adjustSize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_adjustSize_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->adjustSize ();
}


// bool QWidget::autoFillBackground()


static void _init_f_autoFillBackground_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoFillBackground_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->autoFillBackground ());
}


// QPalette::ColorRole QWidget::backgroundRole()


static void _init_f_backgroundRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPalette::ColorRole>::target_type > ();
}

static void _call_f_backgroundRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPalette::ColorRole>::target_type > ((qt_gsi::Converter<QPalette::ColorRole>::target_type)qt_gsi::CppToQtAdaptor<QPalette::ColorRole>(((QWidget *)cls)->backgroundRole ()));
}


// QBackingStore *QWidget::backingStore()


static void _init_f_backingStore_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBackingStore * > ();
}

static void _call_f_backingStore_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBackingStore * > ((QBackingStore *)((QWidget *)cls)->backingStore ());
}


// QSize QWidget::baseSize()


static void _init_f_baseSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_baseSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget *)cls)->baseSize ());
}


// QWidget *QWidget::childAt(int x, int y)


static void _init_f_childAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_childAt_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->childAt (arg1, arg2));
}


// QWidget *QWidget::childAt(const QPoint &p)


static void _init_f_childAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_childAt_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->childAt (arg1));
}


// QRect QWidget::childrenRect()


static void _init_f_childrenRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_childrenRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QWidget *)cls)->childrenRect ());
}


// QRegion QWidget::childrenRegion()


static void _init_f_childrenRegion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_childrenRegion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRegion > ((QRegion)((QWidget *)cls)->childrenRegion ());
}


// void QWidget::clearFocus()


static void _init_f_clearFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->clearFocus ();
}


// void QWidget::clearMask()


static void _init_f_clearMask_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearMask_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->clearMask ();
}


// bool QWidget::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->close ());
}


// QMargins QWidget::contentsMargins()


static void _init_f_contentsMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_f_contentsMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QWidget *)cls)->contentsMargins ());
}


// QRect QWidget::contentsRect()


static void _init_f_contentsRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_contentsRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QWidget *)cls)->contentsRect ());
}


// Qt::ContextMenuPolicy QWidget::contextMenuPolicy()


static void _init_f_contextMenuPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type > ();
}

static void _call_f_contextMenuPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type > ((qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type)qt_gsi::CppToQtAdaptor<Qt::ContextMenuPolicy>(((QWidget *)cls)->contextMenuPolicy ()));
}


// void QWidget::createWinId()


static void _init_f_createWinId_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_createWinId_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->createWinId ();
}


// QCursor QWidget::cursor()


static void _init_f_cursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCursor > ();
}

static void _call_f_cursor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCursor > ((QCursor)((QWidget *)cls)->cursor ());
}


// WId QWidget::effectiveWinId()


static void _init_f_effectiveWinId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<WId>::target_type > ();
}

static void _call_f_effectiveWinId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<WId>::target_type > ((qt_gsi::Converter<WId>::target_type)qt_gsi::CppToQtAdaptor<WId>(((QWidget *)cls)->effectiveWinId ()));
}


// void QWidget::ensurePolished()


static void _init_f_ensurePolished_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ensurePolished_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->ensurePolished ();
}


// Qt::FocusPolicy QWidget::focusPolicy()


static void _init_f_focusPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::FocusPolicy>::target_type > ();
}

static void _call_f_focusPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::FocusPolicy>::target_type > ((qt_gsi::Converter<Qt::FocusPolicy>::target_type)qt_gsi::CppToQtAdaptor<Qt::FocusPolicy>(((QWidget *)cls)->focusPolicy ()));
}


// QWidget *QWidget::focusProxy()


static void _init_f_focusProxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_focusProxy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->focusProxy ());
}


// QWidget *QWidget::focusWidget()


static void _init_f_focusWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_focusWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->focusWidget ());
}


// const QFont &QWidget::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QFont & > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QFont & > ((const QFont &)((QWidget *)cls)->font ());
}


// QFontInfo QWidget::fontInfo()


static void _init_f_fontInfo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFontInfo > ();
}

static void _call_f_fontInfo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFontInfo > ((QFontInfo)((QWidget *)cls)->fontInfo ());
}


// QFontMetrics QWidget::fontMetrics()


static void _init_f_fontMetrics_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFontMetrics > ();
}

static void _call_f_fontMetrics_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFontMetrics > ((QFontMetrics)((QWidget *)cls)->fontMetrics ());
}


// QPalette::ColorRole QWidget::foregroundRole()


static void _init_f_foregroundRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPalette::ColorRole>::target_type > ();
}

static void _call_f_foregroundRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPalette::ColorRole>::target_type > ((qt_gsi::Converter<QPalette::ColorRole>::target_type)qt_gsi::CppToQtAdaptor<QPalette::ColorRole>(((QWidget *)cls)->foregroundRole ()));
}


// QRect QWidget::frameGeometry()


static void _init_f_frameGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_frameGeometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QWidget *)cls)->frameGeometry ());
}


// QSize QWidget::frameSize()


static void _init_f_frameSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_frameSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget *)cls)->frameSize ());
}


// const QRect &QWidget::geometry()


static void _init_f_geometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QRect & > ();
}

static void _call_f_geometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QRect & > ((const QRect &)((QWidget *)cls)->geometry ());
}


// QPixmap QWidget::grab(const QRect &rectangle)


static void _init_f_grab_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rectangle", true, "QRect(QPoint(0, 0), QSize(-1, -1))");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QPixmap > ();
}

static void _call_f_grab_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args ? gsi::arg_reader<const QRect & >() (args, heap) : gsi::arg_maker<const QRect & >() (QRect(QPoint(0, 0), QSize(-1, -1)), heap);
  ret.write<QPixmap > ((QPixmap)((QWidget *)cls)->grab (arg1));
}


// void QWidget::grabGesture(Qt::GestureType type, QFlags<Qt::GestureFlag> flags)


static void _init_f_grabGesture_4352 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<Qt::GestureType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::GestureFlags()");
  decl->add_arg<QFlags<Qt::GestureFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_grabGesture_4352 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::GestureType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::GestureType>::target_type & >() (args, heap);
  QFlags<Qt::GestureFlag> arg2 = args ? gsi::arg_reader<QFlags<Qt::GestureFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::GestureFlag> >() (Qt::GestureFlags(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->grabGesture (qt_gsi::QtToCppAdaptor<Qt::GestureType>(arg1).cref(), arg2);
}


// void QWidget::grabKeyboard()


static void _init_f_grabKeyboard_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_grabKeyboard_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->grabKeyboard ();
}


// void QWidget::grabMouse()


static void _init_f_grabMouse_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_grabMouse_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->grabMouse ();
}


// void QWidget::grabMouse(const QCursor &)


static void _init_f_grabMouse_2032 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_grabMouse_2032 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCursor &arg1 = gsi::arg_reader<const QCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->grabMouse (arg1);
}


// int QWidget::grabShortcut(const QKeySequence &key, Qt::ShortcutContext context)


static void _init_f_grabShortcut_4758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QKeySequence & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("context", true, "Qt::WindowShortcut");
  decl->add_arg<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_grabShortcut_4758 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QKeySequence &arg1 = gsi::arg_reader<const QKeySequence & >() (args, heap);
  const qt_gsi::Converter<Qt::ShortcutContext>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ShortcutContext>(heap, Qt::WindowShortcut), heap);
  ret.write<int > ((int)((QWidget *)cls)->grabShortcut (arg1, qt_gsi::QtToCppAdaptor<Qt::ShortcutContext>(arg2).cref()));
}


// QGraphicsEffect *QWidget::graphicsEffect()


static void _init_f_graphicsEffect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsEffect * > ();
}

static void _call_f_graphicsEffect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsEffect * > ((QGraphicsEffect *)((QWidget *)cls)->graphicsEffect ());
}


// QGraphicsProxyWidget *QWidget::graphicsProxyWidget()


static void _init_f_graphicsProxyWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsProxyWidget * > ();
}

static void _call_f_graphicsProxyWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsProxyWidget * > ((QGraphicsProxyWidget *)((QWidget *)cls)->graphicsProxyWidget ());
}


// bool QWidget::hasFocus()


static void _init_f_hasFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFocus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->hasFocus ());
}


// bool QWidget::hasHeightForWidth()


static void _init_f_hasHeightForWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasHeightForWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->hasHeightForWidth ());
}


// bool QWidget::hasMouseTracking()


static void _init_f_hasMouseTracking_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasMouseTracking_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->hasMouseTracking ());
}


// bool QWidget::hasTabletTracking()


static void _init_f_hasTabletTracking_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasTabletTracking_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->hasTabletTracking ());
}


// int QWidget::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget *)cls)->height ());
}


// int QWidget::heightForWidth(int)


static void _init_f_heightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_heightForWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QWidget *)cls)->heightForWidth (arg1));
}


// void QWidget::hide()


static void _init_f_hide_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hide_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->hide ();
}


// QFlags<Qt::InputMethodHint> QWidget::inputMethodHints()


static void _init_f_inputMethodHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::InputMethodHint> > ();
}

static void _call_f_inputMethodHints_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::InputMethodHint> > ((QFlags<Qt::InputMethodHint>)((QWidget *)cls)->inputMethodHints ());
}


// QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QWidget *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}


// void QWidget::insertAction(QAction *before, QAction *action)


static void _init_f_insertAction_2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<QAction * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertAction_2510 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAction *arg1 = gsi::arg_reader<QAction * >() (args, heap);
  QAction *arg2 = gsi::arg_reader<QAction * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->insertAction (arg1, arg2);
}


// void QWidget::insertActions(QAction *before, const QList<QAction*> &actions)


static void _init_f_insertActions_3858 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("actions");
  decl->add_arg<const QList<QAction*> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertActions_3858 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAction *arg1 = gsi::arg_reader<QAction * >() (args, heap);
  const QList<QAction*> &arg2 = gsi::arg_reader<const QList<QAction*> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->insertActions (arg1, arg2);
}


// WId QWidget::internalWinId()


static void _init_f_internalWinId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<WId>::target_type > ();
}

static void _call_f_internalWinId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<WId>::target_type > ((qt_gsi::Converter<WId>::target_type)qt_gsi::CppToQtAdaptor<WId>(((QWidget *)cls)->internalWinId ()));
}


// bool QWidget::isActiveWindow()


static void _init_f_isActiveWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActiveWindow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isActiveWindow ());
}


// bool QWidget::isAncestorOf(const QWidget *child)


static void _init_f_isAncestorOf_c2010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isAncestorOf_c2010 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  ret.write<bool > ((bool)((QWidget *)cls)->isAncestorOf (arg1));
}


// bool QWidget::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isEnabled ());
}


// bool QWidget::isEnabledTo(const QWidget *)


static void _init_f_isEnabledTo_c2010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isEnabledTo_c2010 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  ret.write<bool > ((bool)((QWidget *)cls)->isEnabledTo (arg1));
}


// bool QWidget::isFullScreen()


static void _init_f_isFullScreen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFullScreen_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isFullScreen ());
}


// bool QWidget::isHidden()


static void _init_f_isHidden_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isHidden_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isHidden ());
}


// bool QWidget::isLeftToRight()


static void _init_f_isLeftToRight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLeftToRight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isLeftToRight ());
}


// bool QWidget::isMaximized()


static void _init_f_isMaximized_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMaximized_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isMaximized ());
}


// bool QWidget::isMinimized()


static void _init_f_isMinimized_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMinimized_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isMinimized ());
}


// bool QWidget::isModal()


static void _init_f_isModal_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isModal_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isModal ());
}


// bool QWidget::isRightToLeft()


static void _init_f_isRightToLeft_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRightToLeft_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isRightToLeft ());
}


// bool QWidget::isTopLevel()


static void _init_f_isTopLevel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTopLevel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isTopLevel ());
}


// bool QWidget::isVisible()


static void _init_f_isVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isVisible ());
}


// bool QWidget::isVisibleTo(const QWidget *)


static void _init_f_isVisibleTo_c2010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isVisibleTo_c2010 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  ret.write<bool > ((bool)((QWidget *)cls)->isVisibleTo (arg1));
}


// bool QWidget::isWindow()


static void _init_f_isWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWindow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isWindow ());
}


// bool QWidget::isWindowModified()


static void _init_f_isWindowModified_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWindowModified_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->isWindowModified ());
}


// QLayout *QWidget::layout()


static void _init_f_layout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_f_layout_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLayout * > ((QLayout *)((QWidget *)cls)->layout ());
}


// Qt::LayoutDirection QWidget::layoutDirection()


static void _init_f_layoutDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(((QWidget *)cls)->layoutDirection ()));
}


// QLocale QWidget::locale()


static void _init_f_locale_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_locale_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocale > ((QLocale)((QWidget *)cls)->locale ());
}


// void QWidget::lower()


static void _init_f_lower_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_lower_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->lower ();
}


// QPointF QWidget::mapFrom(const QWidget *, const QPointF &)


static void _init_f_mapFrom_c3888 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFrom_c3888 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  const QPointF &arg2 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QWidget *)cls)->mapFrom (arg1, arg2));
}


// QPoint QWidget::mapFrom(const QWidget *, const QPoint &)


static void _init_f_mapFrom_c3818 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFrom_c3818 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  const QPoint &arg2 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapFrom (arg1, arg2));
}


// QPointF QWidget::mapFromGlobal(const QPointF &)


static void _init_f_mapFromGlobal_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromGlobal_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QWidget *)cls)->mapFromGlobal (arg1));
}


// QPoint QWidget::mapFromGlobal(const QPoint &)


static void _init_f_mapFromGlobal_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFromGlobal_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapFromGlobal (arg1));
}


// QPointF QWidget::mapFromParent(const QPointF &)


static void _init_f_mapFromParent_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromParent_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QWidget *)cls)->mapFromParent (arg1));
}


// QPoint QWidget::mapFromParent(const QPoint &)


static void _init_f_mapFromParent_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFromParent_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapFromParent (arg1));
}


// QPointF QWidget::mapTo(const QWidget *, const QPointF &)


static void _init_f_mapTo_c3888 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapTo_c3888 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  const QPointF &arg2 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QWidget *)cls)->mapTo (arg1, arg2));
}


// QPoint QWidget::mapTo(const QWidget *, const QPoint &)


static void _init_f_mapTo_c3818 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return<QPoint > ();
}

static void _call_f_mapTo_c3818 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  const QPoint &arg2 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapTo (arg1, arg2));
}


// QPointF QWidget::mapToGlobal(const QPointF &)


static void _init_f_mapToGlobal_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToGlobal_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QWidget *)cls)->mapToGlobal (arg1));
}


// QPoint QWidget::mapToGlobal(const QPoint &)


static void _init_f_mapToGlobal_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapToGlobal_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapToGlobal (arg1));
}


// QPointF QWidget::mapToParent(const QPointF &)


static void _init_f_mapToParent_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToParent_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QWidget *)cls)->mapToParent (arg1));
}


// QPoint QWidget::mapToParent(const QPoint &)


static void _init_f_mapToParent_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapToParent_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapToParent (arg1));
}


// QRegion QWidget::mask()


static void _init_f_mask_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_mask_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRegion > ((QRegion)((QWidget *)cls)->mask ());
}


// int QWidget::maximumHeight()


static void _init_f_maximumHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumHeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget *)cls)->maximumHeight ());
}


// QSize QWidget::maximumSize()


static void _init_f_maximumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_maximumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget *)cls)->maximumSize ());
}


// int QWidget::maximumWidth()


static void _init_f_maximumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget *)cls)->maximumWidth ());
}


// int QWidget::minimumHeight()


static void _init_f_minimumHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumHeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget *)cls)->minimumHeight ());
}


// QSize QWidget::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget *)cls)->minimumSize ());
}


// QSize QWidget::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget *)cls)->minimumSizeHint ());
}


// int QWidget::minimumWidth()


static void _init_f_minimumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget *)cls)->minimumWidth ());
}


// void QWidget::move(int x, int y)


static void _init_f_move_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_move_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->move (arg1, arg2);
}


// void QWidget::move(const QPoint &)


static void _init_f_move_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_move_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->move (arg1);
}


// QWidget *QWidget::nativeParentWidget()


static void _init_f_nativeParentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_nativeParentWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->nativeParentWidget ());
}


// QWidget *QWidget::nextInFocusChain()


static void _init_f_nextInFocusChain_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_nextInFocusChain_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->nextInFocusChain ());
}


// QRect QWidget::normalGeometry()


static void _init_f_normalGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_normalGeometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QWidget *)cls)->normalGeometry ());
}


// void QWidget::overrideWindowFlags(QFlags<Qt::WindowType> type)


static void _init_f_overrideWindowFlags_2495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_overrideWindowFlags_2495 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::WindowType> arg1 = gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->overrideWindowFlags (arg1);
}


// void QWidget::overrideWindowState(QFlags<Qt::WindowState> state)


static void _init_f_overrideWindowState_2590 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<QFlags<Qt::WindowState> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_overrideWindowState_2590 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::WindowState> arg1 = gsi::arg_reader<QFlags<Qt::WindowState> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->overrideWindowState (arg1);
}


// QPaintEngine *QWidget::paintEngine()


static void _init_f_paintEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_f_paintEngine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QWidget *)cls)->paintEngine ());
}


// const QPalette &QWidget::palette()


static void _init_f_palette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPalette & > ();
}

static void _call_f_palette_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QPalette & > ((const QPalette &)((QWidget *)cls)->palette ());
}


// QWidget *QWidget::parentWidget()


static void _init_f_parentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_parentWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->parentWidget ());
}


// QPoint QWidget::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->pos ());
}


// QWidget *QWidget::previousInFocusChain()


static void _init_f_previousInFocusChain_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_previousInFocusChain_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->previousInFocusChain ());
}


// void QWidget::raise()


static void _init_f_raise_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_raise_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->raise ();
}


// QRect QWidget::rect()


static void _init_f_rect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_rect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QWidget *)cls)->rect ());
}


// void QWidget::releaseKeyboard()


static void _init_f_releaseKeyboard_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_releaseKeyboard_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->releaseKeyboard ();
}


// void QWidget::releaseMouse()


static void _init_f_releaseMouse_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_releaseMouse_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->releaseMouse ();
}


// void QWidget::releaseShortcut(int id)


static void _init_f_releaseShortcut_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_releaseShortcut_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->releaseShortcut (arg1);
}


// void QWidget::removeAction(QAction *action)


static void _init_f_removeAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAction_1309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAction *arg1 = gsi::arg_reader<QAction * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->removeAction (arg1);
}


// void QWidget::render(QPaintDevice *target, const QPoint &targetOffset, const QRegion &sourceRegion, QFlags<QWidget::RenderFlag> renderFlags)


static void _init_f_render_8328 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QPaintDevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("targetOffset", true, "QPoint()");
  decl->add_arg<const QPoint & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRegion", true, "QRegion()");
  decl->add_arg<const QRegion & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("renderFlags", true, "QWidget::RenderFlags(QWidget::DrawWindowBackground | QWidget::DrawChildren)");
  decl->add_arg<QFlags<QWidget::RenderFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_render_8328 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintDevice *arg1 = gsi::arg_reader<QPaintDevice * >() (args, heap);
  const QPoint &arg2 = args ? gsi::arg_reader<const QPoint & >() (args, heap) : gsi::arg_maker<const QPoint & >() (QPoint(), heap);
  const QRegion &arg3 = args ? gsi::arg_reader<const QRegion & >() (args, heap) : gsi::arg_maker<const QRegion & >() (QRegion(), heap);
  QFlags<QWidget::RenderFlag> arg4 = args ? gsi::arg_reader<QFlags<QWidget::RenderFlag> >() (args, heap) : gsi::arg_maker<QFlags<QWidget::RenderFlag> >() (QWidget::RenderFlags(QWidget::DrawWindowBackground | QWidget::DrawChildren), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->render (arg1, arg2, arg3, arg4);
}


// void QWidget::render(QPainter *painter, const QPoint &targetOffset, const QRegion &sourceRegion, QFlags<QWidget::RenderFlag> renderFlags)


static void _init_f_render_7951 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("targetOffset", true, "QPoint()");
  decl->add_arg<const QPoint & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRegion", true, "QRegion()");
  decl->add_arg<const QRegion & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("renderFlags", true, "QWidget::RenderFlags(QWidget::DrawWindowBackground | QWidget::DrawChildren)");
  decl->add_arg<QFlags<QWidget::RenderFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_render_7951 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QPoint &arg2 = args ? gsi::arg_reader<const QPoint & >() (args, heap) : gsi::arg_maker<const QPoint & >() (QPoint(), heap);
  const QRegion &arg3 = args ? gsi::arg_reader<const QRegion & >() (args, heap) : gsi::arg_maker<const QRegion & >() (QRegion(), heap);
  QFlags<QWidget::RenderFlag> arg4 = args ? gsi::arg_reader<QFlags<QWidget::RenderFlag> >() (args, heap) : gsi::arg_maker<QFlags<QWidget::RenderFlag> >() (QWidget::RenderFlags(QWidget::DrawWindowBackground | QWidget::DrawChildren), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->render (arg1, arg2, arg3, arg4);
}


// void QWidget::repaint()


static void _init_f_repaint_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_repaint_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->repaint ();
}


// void QWidget::repaint(int x, int y, int w, int h)


static void _init_f_repaint_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_repaint_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->repaint (arg1, arg2, arg3, arg4);
}


// void QWidget::repaint(const QRect &)


static void _init_f_repaint_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_repaint_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->repaint (arg1);
}


// void QWidget::repaint(const QRegion &)


static void _init_f_repaint_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_repaint_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->repaint (arg1);
}


// void QWidget::resize(int w, int h)


static void _init_f_resize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_resize_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->resize (arg1, arg2);
}


// void QWidget::resize(const QSize &)


static void _init_f_resize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->resize (arg1);
}


// bool QWidget::restoreGeometry(const QByteArray &geometry)


static void _init_f_restoreGeometry_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("geometry");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_restoreGeometry_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<bool > ((bool)((QWidget *)cls)->restoreGeometry (arg1));
}


// QByteArray QWidget::saveGeometry()


static void _init_f_saveGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_saveGeometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QWidget *)cls)->saveGeometry ());
}


// QScreen *QWidget::screen()


static void _init_f_screen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QScreen * > ();
}

static void _call_f_screen_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QScreen * > ((QScreen *)((QWidget *)cls)->screen ());
}


// void QWidget::scroll(int dx, int dy)


static void _init_f_scroll_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scroll_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->scroll (arg1, arg2);
}


// void QWidget::scroll(int dx, int dy, const QRect &)


static void _init_f_scroll_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arg3");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_scroll_3110 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QRect &arg3 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->scroll (arg1, arg2, arg3);
}


// void QWidget::setAcceptDrops(bool on)


static void _init_f_setAcceptDrops_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("on");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptDrops_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setAcceptDrops (arg1);
}


// void QWidget::setAccessibleDescription(const QString &description)


static void _init_f_setAccessibleDescription_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("description");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAccessibleDescription_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setAccessibleDescription (arg1);
}


// void QWidget::setAccessibleName(const QString &name)


static void _init_f_setAccessibleName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAccessibleName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setAccessibleName (arg1);
}


// void QWidget::setAttribute(Qt::WidgetAttribute, bool on)


static void _init_f_setAttribute_3065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAttribute_3065 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setAttribute (qt_gsi::QtToCppAdaptor<Qt::WidgetAttribute>(arg1).cref(), arg2);
}


// void QWidget::setAutoFillBackground(bool enabled)


static void _init_f_setAutoFillBackground_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoFillBackground_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setAutoFillBackground (arg1);
}


// void QWidget::setBackgroundRole(QPalette::ColorRole)


static void _init_f_setBackgroundRole_2265 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundRole_2265 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setBackgroundRole (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref());
}


// void QWidget::setBaseSize(const QSize &)


static void _init_f_setBaseSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBaseSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setBaseSize (arg1);
}


// void QWidget::setBaseSize(int basew, int baseh)


static void _init_f_setBaseSize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("basew");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("baseh");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setBaseSize_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setBaseSize (arg1, arg2);
}


// void QWidget::setContentsMargins(int left, int top, int right, int bottom)


static void _init_f_setContentsMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setContentsMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setContentsMargins (arg1, arg2, arg3, arg4);
}


// void QWidget::setContentsMargins(const QMargins &margins)


static void _init_f_setContentsMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContentsMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setContentsMargins (arg1);
}


// void QWidget::setContextMenuPolicy(Qt::ContextMenuPolicy policy)


static void _init_f_setContextMenuPolicy_2519 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContextMenuPolicy_2519 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setContextMenuPolicy (qt_gsi::QtToCppAdaptor<Qt::ContextMenuPolicy>(arg1).cref());
}


// void QWidget::setCursor(const QCursor &)


static void _init_f_setCursor_2032 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursor_2032 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCursor &arg1 = gsi::arg_reader<const QCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setCursor (arg1);
}


// void QWidget::setDisabled(bool)


static void _init_f_setDisabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDisabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setDisabled (arg1);
}


// void QWidget::setEnabled(bool)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setEnabled (arg1);
}


// void QWidget::setFixedHeight(int h)


static void _init_f_setFixedHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFixedHeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setFixedHeight (arg1);
}


// void QWidget::setFixedSize(const QSize &)


static void _init_f_setFixedSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFixedSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setFixedSize (arg1);
}


// void QWidget::setFixedSize(int w, int h)


static void _init_f_setFixedSize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFixedSize_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setFixedSize (arg1, arg2);
}


// void QWidget::setFixedWidth(int w)


static void _init_f_setFixedWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFixedWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setFixedWidth (arg1);
}


// void QWidget::setFocus()


static void _init_f_setFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setFocus ();
}


// void QWidget::setFocus(Qt::FocusReason reason)


static void _init_f_setFocus_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("reason");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusReason>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocus_1877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FocusReason>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::FocusReason>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setFocus (qt_gsi::QtToCppAdaptor<Qt::FocusReason>(arg1).cref());
}


// void QWidget::setFocusPolicy(Qt::FocusPolicy policy)


static void _init_f_setFocusPolicy_1885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusPolicy_1885 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FocusPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::FocusPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setFocusPolicy (qt_gsi::QtToCppAdaptor<Qt::FocusPolicy>(arg1).cref());
}


// void QWidget::setFocusProxy(QWidget *)


static void _init_f_setFocusProxy_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusProxy_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setFocusProxy (arg1);
}


// void QWidget::setFont(const QFont &)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setFont (arg1);
}


// void QWidget::setForegroundRole(QPalette::ColorRole)


static void _init_f_setForegroundRole_2265 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForegroundRole_2265 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setForegroundRole (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref());
}


// void QWidget::setGeometry(int x, int y, int w, int h)


static void _init_f_setGeometry_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setGeometry (arg1, arg2, arg3, arg4);
}


// void QWidget::setGeometry(const QRect &)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setGeometry (arg1);
}


// void QWidget::setGraphicsEffect(QGraphicsEffect *effect)


static void _init_f_setGraphicsEffect_2109 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("effect");
  decl->add_arg<QGraphicsEffect * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGraphicsEffect_2109 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsEffect *arg1 = gsi::arg_reader<QGraphicsEffect * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setGraphicsEffect (arg1);
}


// void QWidget::setHidden(bool hidden)


static void _init_f_setHidden_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hidden");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHidden_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setHidden (arg1);
}


// void QWidget::setInputMethodHints(QFlags<Qt::InputMethodHint> hints)


static void _init_f_setInputMethodHints_2985 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<QFlags<Qt::InputMethodHint> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputMethodHints_2985 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::InputMethodHint> arg1 = gsi::arg_reader<QFlags<Qt::InputMethodHint> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setInputMethodHints (arg1);
}


// void QWidget::setLayout(QLayout *)


static void _init_f_setLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayout_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setLayout (arg1);
}


// void QWidget::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}


// void QWidget::setLocale(const QLocale &locale)


static void _init_f_setLocale_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLocale_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setLocale (arg1);
}


// void QWidget::setMask(const QBitmap &)


static void _init_f_setMask_1999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QBitmap & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMask_1999 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBitmap &arg1 = gsi::arg_reader<const QBitmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMask (arg1);
}


// void QWidget::setMask(const QRegion &)


static void _init_f_setMask_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMask_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMask (arg1);
}


// void QWidget::setMaximumHeight(int maxh)


static void _init_f_setMaximumHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxh");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumHeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMaximumHeight (arg1);
}


// void QWidget::setMaximumSize(const QSize &)


static void _init_f_setMaximumSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMaximumSize (arg1);
}


// void QWidget::setMaximumSize(int maxw, int maxh)


static void _init_f_setMaximumSize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxw");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("maxh");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMaximumSize_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMaximumSize (arg1, arg2);
}


// void QWidget::setMaximumWidth(int maxw)


static void _init_f_setMaximumWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxw");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMaximumWidth (arg1);
}


// void QWidget::setMinimumHeight(int minh)


static void _init_f_setMinimumHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minh");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumHeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMinimumHeight (arg1);
}


// void QWidget::setMinimumSize(const QSize &)


static void _init_f_setMinimumSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMinimumSize (arg1);
}


// void QWidget::setMinimumSize(int minw, int minh)


static void _init_f_setMinimumSize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minw");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("minh");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMinimumSize_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMinimumSize (arg1, arg2);
}


// void QWidget::setMinimumWidth(int minw)


static void _init_f_setMinimumWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minw");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMinimumWidth (arg1);
}


// void QWidget::setMouseTracking(bool enable)


static void _init_f_setMouseTracking_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMouseTracking_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setMouseTracking (arg1);
}


// void QWidget::setPalette(const QPalette &)


static void _init_f_setPalette_2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPalette_2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setPalette (arg1);
}


// void QWidget::setParent(QWidget *parent)


static void _init_f_setParent_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setParent_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  if (arg1) {
    qt_gsi::qt_keep ((QWidget *)cls);
  } else {
    qt_gsi::qt_release ((QWidget *)cls);
  }
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setParent (arg1);
}


// void QWidget::setParent(QWidget *parent, QFlags<Qt::WindowType> f)


static void _init_f_setParent_3702 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setParent_3702 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QFlags<Qt::WindowType> arg2 = gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap);
  if (arg1) {
    qt_gsi::qt_keep ((QWidget *)cls);
  } else {
    qt_gsi::qt_release ((QWidget *)cls);
  }
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setParent (arg1, arg2);
}


// void QWidget::setScreen(QScreen *)


static void _init_f_setScreen_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScreen_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = gsi::arg_reader<QScreen * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setScreen (arg1);
}


// void QWidget::setShortcutAutoRepeat(int id, bool enable)


static void _init_f_setShortcutAutoRepeat_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enable", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setShortcutAutoRepeat_1523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setShortcutAutoRepeat (arg1, arg2);
}


// void QWidget::setShortcutEnabled(int id, bool enable)


static void _init_f_setShortcutEnabled_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enable", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setShortcutEnabled_1523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setShortcutEnabled (arg1, arg2);
}


// void QWidget::setSizeIncrement(const QSize &)


static void _init_f_setSizeIncrement_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizeIncrement_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setSizeIncrement (arg1);
}


// void QWidget::setSizeIncrement(int w, int h)


static void _init_f_setSizeIncrement_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSizeIncrement_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setSizeIncrement (arg1, arg2);
}


// void QWidget::setSizePolicy(QSizePolicy)


static void _init_f_setSizePolicy_1552 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QSizePolicy > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizePolicy_1552 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSizePolicy arg1 = gsi::arg_reader<QSizePolicy >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setSizePolicy (arg1);
}


// void QWidget::setSizePolicy(QSizePolicy::Policy horizontal, QSizePolicy::Policy vertical)


static void _init_f_setSizePolicy_4476 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("horizontal");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vertical");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSizePolicy_4476 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSizePolicy::Policy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & >() (args, heap);
  const qt_gsi::Converter<QSizePolicy::Policy>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setSizePolicy (qt_gsi::QtToCppAdaptor<QSizePolicy::Policy>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::Policy>(arg2).cref());
}


// void QWidget::setStatusTip(const QString &)


static void _init_f_setStatusTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatusTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setStatusTip (arg1);
}


// void QWidget::setStyle(QStyle *)


static void _init_f_setStyle_1232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle *arg1 = gsi::arg_reader<QStyle * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setStyle (arg1);
}


// void QWidget::setStyleSheet(const QString &styleSheet)


static void _init_f_setStyleSheet_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("styleSheet");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyleSheet_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setStyleSheet (arg1);
}


// void QWidget::setTabletTracking(bool enable)


static void _init_f_setTabletTracking_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabletTracking_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setTabletTracking (arg1);
}


// void QWidget::setToolTip(const QString &)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setToolTip (arg1);
}


// void QWidget::setToolTipDuration(int msec)


static void _init_f_setToolTipDuration_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTipDuration_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setToolTipDuration (arg1);
}


// void QWidget::setUpdatesEnabled(bool enable)


static void _init_f_setUpdatesEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUpdatesEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setUpdatesEnabled (arg1);
}


// void QWidget::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setVisible (arg1);
}


// void QWidget::setWhatsThis(const QString &)


static void _init_f_setWhatsThis_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWhatsThis_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWhatsThis (arg1);
}


// void QWidget::setWindowFilePath(const QString &filePath)


static void _init_f_setWindowFilePath_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filePath");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowFilePath_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowFilePath (arg1);
}


// void QWidget::setWindowFlag(Qt::WindowType, bool on)


static void _init_f_setWindowFlag_2555 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setWindowFlag_2555 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowType>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowFlag (qt_gsi::QtToCppAdaptor<Qt::WindowType>(arg1).cref(), arg2);
}


// void QWidget::setWindowFlags(QFlags<Qt::WindowType> type)


static void _init_f_setWindowFlags_2495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowFlags_2495 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::WindowType> arg1 = gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowFlags (arg1);
}


// void QWidget::setWindowIcon(const QIcon &icon)


static void _init_f_setWindowIcon_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowIcon_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowIcon (arg1);
}


// void QWidget::setWindowIconText(const QString &)


static void _init_f_setWindowIconText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowIconText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowIconText (arg1);
}


// void QWidget::setWindowModality(Qt::WindowModality windowModality)


static void _init_f_setWindowModality_2216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowModality");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowModality_2216 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowModality>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowModality>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowModality (qt_gsi::QtToCppAdaptor<Qt::WindowModality>(arg1).cref());
}


// void QWidget::setWindowModified(bool)


static void _init_f_setWindowModified_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowModified_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowModified (arg1);
}


// void QWidget::setWindowOpacity(double level)


static void _init_f_setWindowOpacity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("level");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowOpacity_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowOpacity (arg1);
}


// void QWidget::setWindowRole(const QString &)


static void _init_f_setWindowRole_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowRole_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowRole (arg1);
}


// void QWidget::setWindowState(QFlags<Qt::WindowState> state)


static void _init_f_setWindowState_2590 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<QFlags<Qt::WindowState> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowState_2590 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::WindowState> arg1 = gsi::arg_reader<QFlags<Qt::WindowState> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowState (arg1);
}


// void QWidget::setWindowTitle(const QString &)


static void _init_f_setWindowTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowTitle_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->setWindowTitle (arg1);
}


// void QWidget::show()


static void _init_f_show_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_show_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->show ();
}


// void QWidget::showFullScreen()


static void _init_f_showFullScreen_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showFullScreen_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->showFullScreen ();
}


// void QWidget::showMaximized()


static void _init_f_showMaximized_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showMaximized_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->showMaximized ();
}


// void QWidget::showMinimized()


static void _init_f_showMinimized_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showMinimized_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->showMinimized ();
}


// void QWidget::showNormal()


static void _init_f_showNormal_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showNormal_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->showNormal ();
}


// QSize QWidget::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget *)cls)->size ());
}


// QSize QWidget::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget *)cls)->sizeHint ());
}


// QSize QWidget::sizeIncrement()


static void _init_f_sizeIncrement_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeIncrement_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget *)cls)->sizeIncrement ());
}


// QSizePolicy QWidget::sizePolicy()


static void _init_f_sizePolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizePolicy > ();
}

static void _call_f_sizePolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizePolicy > ((QSizePolicy)((QWidget *)cls)->sizePolicy ());
}


// void QWidget::stackUnder(QWidget *)


static void _init_f_stackUnder_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stackUnder_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->stackUnder (arg1);
}


// QString QWidget::statusTip()


static void _init_f_statusTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_statusTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->statusTip ());
}


// QStyle *QWidget::style()


static void _init_f_style_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyle * > ();
}

static void _call_f_style_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStyle * > ((QStyle *)((QWidget *)cls)->style ());
}


// QString QWidget::styleSheet()


static void _init_f_styleSheet_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_styleSheet_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->styleSheet ());
}


// bool QWidget::testAttribute(Qt::WidgetAttribute)


static void _init_f_testAttribute_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testAttribute_c2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QWidget *)cls)->testAttribute (qt_gsi::QtToCppAdaptor<Qt::WidgetAttribute>(arg1).cref()));
}


// QString QWidget::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->toolTip ());
}


// int QWidget::toolTipDuration()


static void _init_f_toolTipDuration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_toolTipDuration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget *)cls)->toolTipDuration ());
}


// QWidget *QWidget::topLevelWidget()


static void _init_f_topLevelWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_topLevelWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->topLevelWidget ());
}


// bool QWidget::underMouse()


static void _init_f_underMouse_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_underMouse_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->underMouse ());
}


// void QWidget::ungrabGesture(Qt::GestureType type)


static void _init_f_ungrabGesture_1902 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<Qt::GestureType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ungrabGesture_1902 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::GestureType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::GestureType>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->ungrabGesture (qt_gsi::QtToCppAdaptor<Qt::GestureType>(arg1).cref());
}


// void QWidget::unsetCursor()


static void _init_f_unsetCursor_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetCursor_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->unsetCursor ();
}


// void QWidget::unsetLayoutDirection()


static void _init_f_unsetLayoutDirection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetLayoutDirection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->unsetLayoutDirection ();
}


// void QWidget::unsetLocale()


static void _init_f_unsetLocale_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetLocale_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->unsetLocale ();
}


// void QWidget::update()


static void _init_f_update_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_update_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->update ();
}


// void QWidget::update(int x, int y, int w, int h)


static void _init_f_update_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_update_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->update (arg1, arg2, arg3, arg4);
}


// void QWidget::update(const QRect &)


static void _init_f_update_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->update (arg1);
}


// void QWidget::update(const QRegion &)


static void _init_f_update_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->update (arg1);
}


// void QWidget::updateGeometry()


static void _init_f_updateGeometry_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_updateGeometry_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget *)cls)->updateGeometry ();
}


// bool QWidget::updatesEnabled()


static void _init_f_updatesEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_updatesEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget *)cls)->updatesEnabled ());
}


// QRegion QWidget::visibleRegion()


static void _init_f_visibleRegion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_visibleRegion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRegion > ((QRegion)((QWidget *)cls)->visibleRegion ());
}


// QString QWidget::whatsThis()


static void _init_f_whatsThis_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_whatsThis_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->whatsThis ());
}


// int QWidget::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget *)cls)->width ());
}


// WId QWidget::winId()


static void _init_f_winId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<WId>::target_type > ();
}

static void _call_f_winId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<WId>::target_type > ((qt_gsi::Converter<WId>::target_type)qt_gsi::CppToQtAdaptor<WId>(((QWidget *)cls)->winId ()));
}


// QWidget *QWidget::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->window ());
}


// QString QWidget::windowFilePath()


static void _init_f_windowFilePath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowFilePath_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->windowFilePath ());
}


// QFlags<Qt::WindowType> QWidget::windowFlags()


static void _init_f_windowFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::WindowType> > ();
}

static void _call_f_windowFlags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::WindowType> > ((QFlags<Qt::WindowType>)((QWidget *)cls)->windowFlags ());
}


// QWindow *QWidget::windowHandle()


static void _init_f_windowHandle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWindow * > ();
}

static void _call_f_windowHandle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWindow * > ((QWindow *)((QWidget *)cls)->windowHandle ());
}


// QIcon QWidget::windowIcon()


static void _init_f_windowIcon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_windowIcon_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIcon > ((QIcon)((QWidget *)cls)->windowIcon ());
}


// QString QWidget::windowIconText()


static void _init_f_windowIconText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowIconText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->windowIconText ());
}


// Qt::WindowModality QWidget::windowModality()


static void _init_f_windowModality_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::WindowModality>::target_type > ();
}

static void _call_f_windowModality_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::WindowModality>::target_type > ((qt_gsi::Converter<Qt::WindowModality>::target_type)qt_gsi::CppToQtAdaptor<Qt::WindowModality>(((QWidget *)cls)->windowModality ()));
}


// double QWidget::windowOpacity()


static void _init_f_windowOpacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_windowOpacity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QWidget *)cls)->windowOpacity ());
}


// QString QWidget::windowRole()


static void _init_f_windowRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->windowRole ());
}


// QFlags<Qt::WindowState> QWidget::windowState()


static void _init_f_windowState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::WindowState> > ();
}

static void _call_f_windowState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::WindowState> > ((QFlags<Qt::WindowState>)((QWidget *)cls)->windowState ());
}


// QString QWidget::windowTitle()


static void _init_f_windowTitle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowTitle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWidget *)cls)->windowTitle ());
}


// Qt::WindowType QWidget::windowType()


static void _init_f_windowType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::WindowType>::target_type > ();
}

static void _call_f_windowType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::WindowType>::target_type > ((qt_gsi::Converter<Qt::WindowType>::target_type)qt_gsi::CppToQtAdaptor<Qt::WindowType>(((QWidget *)cls)->windowType ()));
}


// int QWidget::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget *)cls)->x ());
}


// int QWidget::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget *)cls)->y ());
}


// static QWidget *QWidget::createWindowContainer(QWindow *window, QWidget *parent, QFlags<Qt::WindowType> flags)


static void _init_f_createWindowContainer_4929 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("window");
  decl->add_arg<QWindow * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::WindowFlags()");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_f_createWindowContainer_4929 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWindow *arg1 = gsi::arg_reader<QWindow * >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  QFlags<Qt::WindowType> arg3 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (Qt::WindowFlags(), heap);
  ret.write<QWidget * > ((QWidget *)QWidget::createWindowContainer (arg1, arg2, arg3));
}


// static QWidget *QWidget::find(WId)


static void _init_f_find_696 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_find_696 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap);
  ret.write<QWidget * > ((QWidget *)QWidget::find (qt_gsi::QtToCppAdaptor<WId>(arg1).cref()));
}


// static QWidget *QWidget::keyboardGrabber()


static void _init_f_keyboardGrabber_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_keyboardGrabber_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QWidget::keyboardGrabber ());
}


// static QWidget *QWidget::mouseGrabber()


static void _init_f_mouseGrabber_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_mouseGrabber_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QWidget::mouseGrabber ());
}


// static void QWidget::setTabOrder(QWidget *, QWidget *)


static void _init_f_setTabOrder_2522 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabOrder_2522 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QWidget::setTabOrder (arg1, arg2);
}


// static QString QWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QWidget::tr (arg1, arg2, arg3));
}


//  base class cast for QObject

static void _init_f_QWidget_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QWidget_as_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QWidget *)cls);
}

static void _init_f_QWidget_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QWidget_as_const_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QWidget *)cls);
}

//  base class cast for QPaintDevice

static void _init_f_QWidget_as_QPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice *> ();
}

static void _call_f_QWidget_as_QPaintDevice (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QPaintDevice *> ((QPaintDevice *)(QWidget *)cls);
}

static void _init_f_QWidget_as_const_QPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPaintDevice *> ();
}

static void _call_f_QWidget_as_const_QPaintDevice (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QPaintDevice *> ((const QPaintDevice *)(const QWidget *)cls);
}


namespace gsi
{

static gsi::Methods methods_QWidget () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":acceptDrops", "@brief Method bool QWidget::acceptDrops()\n", true, &_init_f_acceptDrops_c0, &_call_f_acceptDrops_c0);
  methods += new qt_gsi::GenericMethod (":accessibleDescription", "@brief Method QString QWidget::accessibleDescription()\n", true, &_init_f_accessibleDescription_c0, &_call_f_accessibleDescription_c0);
  methods += new qt_gsi::GenericMethod (":accessibleName", "@brief Method QString QWidget::accessibleName()\n", true, &_init_f_accessibleName_c0, &_call_f_accessibleName_c0);
  methods += new qt_gsi::GenericMethod ("actions", "@brief Method QList<QAction*> QWidget::actions()\n", true, &_init_f_actions_c0, &_call_f_actions_c0);
  methods += new qt_gsi::GenericMethod ("activateWindow", "@brief Method void QWidget::activateWindow()\n", false, &_init_f_activateWindow_0, &_call_f_activateWindow_0);
  methods += new qt_gsi::GenericMethod ("addAction", "@brief Method void QWidget::addAction(QAction *action)\n", false, &_init_f_addAction_1309, &_call_f_addAction_1309);
  methods += new qt_gsi::GenericMethod ("addActions", "@brief Method void QWidget::addActions(const QList<QAction*> &actions)\n", false, &_init_f_addActions_2657, &_call_f_addActions_2657);
  methods += new qt_gsi::GenericMethod ("adjustSize", "@brief Method void QWidget::adjustSize()\n", false, &_init_f_adjustSize_0, &_call_f_adjustSize_0);
  methods += new qt_gsi::GenericMethod (":autoFillBackground", "@brief Method bool QWidget::autoFillBackground()\n", true, &_init_f_autoFillBackground_c0, &_call_f_autoFillBackground_c0);
  methods += new qt_gsi::GenericMethod (":backgroundRole", "@brief Method QPalette::ColorRole QWidget::backgroundRole()\n", true, &_init_f_backgroundRole_c0, &_call_f_backgroundRole_c0);
  methods += new qt_gsi::GenericMethod ("backingStore", "@brief Method QBackingStore *QWidget::backingStore()\n", true, &_init_f_backingStore_c0, &_call_f_backingStore_c0);
  methods += new qt_gsi::GenericMethod (":baseSize", "@brief Method QSize QWidget::baseSize()\n", true, &_init_f_baseSize_c0, &_call_f_baseSize_c0);
  methods += new qt_gsi::GenericMethod ("childAt", "@brief Method QWidget *QWidget::childAt(int x, int y)\n", true, &_init_f_childAt_c1426, &_call_f_childAt_c1426);
  methods += new qt_gsi::GenericMethod ("childAt", "@brief Method QWidget *QWidget::childAt(const QPoint &p)\n", true, &_init_f_childAt_c1916, &_call_f_childAt_c1916);
  methods += new qt_gsi::GenericMethod (":childrenRect", "@brief Method QRect QWidget::childrenRect()\n", true, &_init_f_childrenRect_c0, &_call_f_childrenRect_c0);
  methods += new qt_gsi::GenericMethod (":childrenRegion", "@brief Method QRegion QWidget::childrenRegion()\n", true, &_init_f_childrenRegion_c0, &_call_f_childrenRegion_c0);
  methods += new qt_gsi::GenericMethod ("clearFocus", "@brief Method void QWidget::clearFocus()\n", false, &_init_f_clearFocus_0, &_call_f_clearFocus_0);
  methods += new qt_gsi::GenericMethod ("clearMask", "@brief Method void QWidget::clearMask()\n", false, &_init_f_clearMask_0, &_call_f_clearMask_0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method bool QWidget::close()\n", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod (":contentsMargins", "@brief Method QMargins QWidget::contentsMargins()\n", true, &_init_f_contentsMargins_c0, &_call_f_contentsMargins_c0);
  methods += new qt_gsi::GenericMethod ("contentsRect", "@brief Method QRect QWidget::contentsRect()\n", true, &_init_f_contentsRect_c0, &_call_f_contentsRect_c0);
  methods += new qt_gsi::GenericMethod (":contextMenuPolicy", "@brief Method Qt::ContextMenuPolicy QWidget::contextMenuPolicy()\n", true, &_init_f_contextMenuPolicy_c0, &_call_f_contextMenuPolicy_c0);
  methods += new qt_gsi::GenericMethod ("createWinId", "@brief Method void QWidget::createWinId()\n", false, &_init_f_createWinId_0, &_call_f_createWinId_0);
  methods += new qt_gsi::GenericMethod (":cursor", "@brief Method QCursor QWidget::cursor()\n", true, &_init_f_cursor_c0, &_call_f_cursor_c0);
  methods += new qt_gsi::GenericMethod ("effectiveWinId", "@brief Method WId QWidget::effectiveWinId()\n", true, &_init_f_effectiveWinId_c0, &_call_f_effectiveWinId_c0);
  methods += new qt_gsi::GenericMethod ("ensurePolished", "@brief Method void QWidget::ensurePolished()\n", true, &_init_f_ensurePolished_c0, &_call_f_ensurePolished_c0);
  methods += new qt_gsi::GenericMethod (":focusPolicy", "@brief Method Qt::FocusPolicy QWidget::focusPolicy()\n", true, &_init_f_focusPolicy_c0, &_call_f_focusPolicy_c0);
  methods += new qt_gsi::GenericMethod (":focusProxy", "@brief Method QWidget *QWidget::focusProxy()\n", true, &_init_f_focusProxy_c0, &_call_f_focusProxy_c0);
  methods += new qt_gsi::GenericMethod ("focusWidget", "@brief Method QWidget *QWidget::focusWidget()\n", true, &_init_f_focusWidget_c0, &_call_f_focusWidget_c0);
  methods += new qt_gsi::GenericMethod (":font", "@brief Method const QFont &QWidget::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod ("fontInfo", "@brief Method QFontInfo QWidget::fontInfo()\n", true, &_init_f_fontInfo_c0, &_call_f_fontInfo_c0);
  methods += new qt_gsi::GenericMethod ("fontMetrics", "@brief Method QFontMetrics QWidget::fontMetrics()\n", true, &_init_f_fontMetrics_c0, &_call_f_fontMetrics_c0);
  methods += new qt_gsi::GenericMethod (":foregroundRole", "@brief Method QPalette::ColorRole QWidget::foregroundRole()\n", true, &_init_f_foregroundRole_c0, &_call_f_foregroundRole_c0);
  methods += new qt_gsi::GenericMethod (":frameGeometry", "@brief Method QRect QWidget::frameGeometry()\n", true, &_init_f_frameGeometry_c0, &_call_f_frameGeometry_c0);
  methods += new qt_gsi::GenericMethod (":frameSize", "@brief Method QSize QWidget::frameSize()\n", true, &_init_f_frameSize_c0, &_call_f_frameSize_c0);
  methods += new qt_gsi::GenericMethod (":geometry", "@brief Method const QRect &QWidget::geometry()\n", true, &_init_f_geometry_c0, &_call_f_geometry_c0);
  methods += new qt_gsi::GenericMethod ("grab", "@brief Method QPixmap QWidget::grab(const QRect &rectangle)\n", false, &_init_f_grab_1792, &_call_f_grab_1792);
  methods += new qt_gsi::GenericMethod ("grabGesture", "@brief Method void QWidget::grabGesture(Qt::GestureType type, QFlags<Qt::GestureFlag> flags)\n", false, &_init_f_grabGesture_4352, &_call_f_grabGesture_4352);
  methods += new qt_gsi::GenericMethod ("grabKeyboard", "@brief Method void QWidget::grabKeyboard()\n", false, &_init_f_grabKeyboard_0, &_call_f_grabKeyboard_0);
  methods += new qt_gsi::GenericMethod ("grabMouse", "@brief Method void QWidget::grabMouse()\n", false, &_init_f_grabMouse_0, &_call_f_grabMouse_0);
  methods += new qt_gsi::GenericMethod ("grabMouse", "@brief Method void QWidget::grabMouse(const QCursor &)\n", false, &_init_f_grabMouse_2032, &_call_f_grabMouse_2032);
  methods += new qt_gsi::GenericMethod ("grabShortcut", "@brief Method int QWidget::grabShortcut(const QKeySequence &key, Qt::ShortcutContext context)\n", false, &_init_f_grabShortcut_4758, &_call_f_grabShortcut_4758);
  methods += new qt_gsi::GenericMethod (":graphicsEffect", "@brief Method QGraphicsEffect *QWidget::graphicsEffect()\n", true, &_init_f_graphicsEffect_c0, &_call_f_graphicsEffect_c0);
  methods += new qt_gsi::GenericMethod ("graphicsProxyWidget", "@brief Method QGraphicsProxyWidget *QWidget::graphicsProxyWidget()\n", true, &_init_f_graphicsProxyWidget_c0, &_call_f_graphicsProxyWidget_c0);
  methods += new qt_gsi::GenericMethod ("hasFocus|:focus", "@brief Method bool QWidget::hasFocus()\n", true, &_init_f_hasFocus_c0, &_call_f_hasFocus_c0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Method bool QWidget::hasHeightForWidth()\n", true, &_init_f_hasHeightForWidth_c0, &_call_f_hasHeightForWidth_c0);
  methods += new qt_gsi::GenericMethod ("hasMouseTracking|:mouseTracking", "@brief Method bool QWidget::hasMouseTracking()\n", true, &_init_f_hasMouseTracking_c0, &_call_f_hasMouseTracking_c0);
  methods += new qt_gsi::GenericMethod ("hasTabletTracking|:tabletTracking", "@brief Method bool QWidget::hasTabletTracking()\n", true, &_init_f_hasTabletTracking_c0, &_call_f_hasTabletTracking_c0);
  methods += new qt_gsi::GenericMethod (":height", "@brief Method int QWidget::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Method int QWidget::heightForWidth(int)\n", true, &_init_f_heightForWidth_c767, &_call_f_heightForWidth_c767);
  methods += new qt_gsi::GenericMethod ("hide", "@brief Method void QWidget::hide()\n", false, &_init_f_hide_0, &_call_f_hide_0);
  methods += new qt_gsi::GenericMethod (":inputMethodHints", "@brief Method QFlags<Qt::InputMethodHint> QWidget::inputMethodHints()\n", true, &_init_f_inputMethodHints_c0, &_call_f_inputMethodHints_c0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)\n", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
  methods += new qt_gsi::GenericMethod ("insertAction", "@brief Method void QWidget::insertAction(QAction *before, QAction *action)\n", false, &_init_f_insertAction_2510, &_call_f_insertAction_2510);
  methods += new qt_gsi::GenericMethod ("insertActions", "@brief Method void QWidget::insertActions(QAction *before, const QList<QAction*> &actions)\n", false, &_init_f_insertActions_3858, &_call_f_insertActions_3858);
  methods += new qt_gsi::GenericMethod ("internalWinId", "@brief Method WId QWidget::internalWinId()\n", true, &_init_f_internalWinId_c0, &_call_f_internalWinId_c0);
  methods += new qt_gsi::GenericMethod ("isActiveWindow?|:isActiveWindow", "@brief Method bool QWidget::isActiveWindow()\n", true, &_init_f_isActiveWindow_c0, &_call_f_isActiveWindow_c0);
  methods += new qt_gsi::GenericMethod ("isAncestorOf?", "@brief Method bool QWidget::isAncestorOf(const QWidget *child)\n", true, &_init_f_isAncestorOf_c2010, &_call_f_isAncestorOf_c2010);
  methods += new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QWidget::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isEnabledTo?", "@brief Method bool QWidget::isEnabledTo(const QWidget *)\n", true, &_init_f_isEnabledTo_c2010, &_call_f_isEnabledTo_c2010);
  methods += new qt_gsi::GenericMethod ("isFullScreen?|:fullScreen", "@brief Method bool QWidget::isFullScreen()\n", true, &_init_f_isFullScreen_c0, &_call_f_isFullScreen_c0);
  methods += new qt_gsi::GenericMethod ("isHidden?|:hidden", "@brief Method bool QWidget::isHidden()\n", true, &_init_f_isHidden_c0, &_call_f_isHidden_c0);
  methods += new qt_gsi::GenericMethod ("isLeftToRight?", "@brief Method bool QWidget::isLeftToRight()\n", true, &_init_f_isLeftToRight_c0, &_call_f_isLeftToRight_c0);
  methods += new qt_gsi::GenericMethod ("isMaximized?|:maximized", "@brief Method bool QWidget::isMaximized()\n", true, &_init_f_isMaximized_c0, &_call_f_isMaximized_c0);
  methods += new qt_gsi::GenericMethod ("isMinimized?|:minimized", "@brief Method bool QWidget::isMinimized()\n", true, &_init_f_isMinimized_c0, &_call_f_isMinimized_c0);
  methods += new qt_gsi::GenericMethod ("isModal?|:modal", "@brief Method bool QWidget::isModal()\n", true, &_init_f_isModal_c0, &_call_f_isModal_c0);
  methods += new qt_gsi::GenericMethod ("isRightToLeft?", "@brief Method bool QWidget::isRightToLeft()\n", true, &_init_f_isRightToLeft_c0, &_call_f_isRightToLeft_c0);
  methods += new qt_gsi::GenericMethod ("isTopLevel?", "@brief Method bool QWidget::isTopLevel()\n", true, &_init_f_isTopLevel_c0, &_call_f_isTopLevel_c0);
  methods += new qt_gsi::GenericMethod ("isVisible?|:visible", "@brief Method bool QWidget::isVisible()\n", true, &_init_f_isVisible_c0, &_call_f_isVisible_c0);
  methods += new qt_gsi::GenericMethod ("isVisibleTo?", "@brief Method bool QWidget::isVisibleTo(const QWidget *)\n", true, &_init_f_isVisibleTo_c2010, &_call_f_isVisibleTo_c2010);
  methods += new qt_gsi::GenericMethod ("isWindow?", "@brief Method bool QWidget::isWindow()\n", true, &_init_f_isWindow_c0, &_call_f_isWindow_c0);
  methods += new qt_gsi::GenericMethod ("isWindowModified?|:windowModified", "@brief Method bool QWidget::isWindowModified()\n", true, &_init_f_isWindowModified_c0, &_call_f_isWindowModified_c0);
  methods += new qt_gsi::GenericMethod (":layout", "@brief Method QLayout *QWidget::layout()\n", true, &_init_f_layout_c0, &_call_f_layout_c0);
  methods += new qt_gsi::GenericMethod (":layoutDirection", "@brief Method Qt::LayoutDirection QWidget::layoutDirection()\n", true, &_init_f_layoutDirection_c0, &_call_f_layoutDirection_c0);
  methods += new qt_gsi::GenericMethod (":locale", "@brief Method QLocale QWidget::locale()\n", true, &_init_f_locale_c0, &_call_f_locale_c0);
  methods += new qt_gsi::GenericMethod ("lower", "@brief Method void QWidget::lower()\n", false, &_init_f_lower_0, &_call_f_lower_0);
  methods += new qt_gsi::GenericMethod ("mapFrom", "@brief Method QPointF QWidget::mapFrom(const QWidget *, const QPointF &)\n", true, &_init_f_mapFrom_c3888, &_call_f_mapFrom_c3888);
  methods += new qt_gsi::GenericMethod ("mapFrom", "@brief Method QPoint QWidget::mapFrom(const QWidget *, const QPoint &)\n", true, &_init_f_mapFrom_c3818, &_call_f_mapFrom_c3818);
  methods += new qt_gsi::GenericMethod ("mapFromGlobal", "@brief Method QPointF QWidget::mapFromGlobal(const QPointF &)\n", true, &_init_f_mapFromGlobal_c1986, &_call_f_mapFromGlobal_c1986);
  methods += new qt_gsi::GenericMethod ("mapFromGlobal", "@brief Method QPoint QWidget::mapFromGlobal(const QPoint &)\n", true, &_init_f_mapFromGlobal_c1916, &_call_f_mapFromGlobal_c1916);
  methods += new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPointF QWidget::mapFromParent(const QPointF &)\n", true, &_init_f_mapFromParent_c1986, &_call_f_mapFromParent_c1986);
  methods += new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPoint QWidget::mapFromParent(const QPoint &)\n", true, &_init_f_mapFromParent_c1916, &_call_f_mapFromParent_c1916);
  methods += new qt_gsi::GenericMethod ("mapTo", "@brief Method QPointF QWidget::mapTo(const QWidget *, const QPointF &)\n", true, &_init_f_mapTo_c3888, &_call_f_mapTo_c3888);
  methods += new qt_gsi::GenericMethod ("mapTo", "@brief Method QPoint QWidget::mapTo(const QWidget *, const QPoint &)\n", true, &_init_f_mapTo_c3818, &_call_f_mapTo_c3818);
  methods += new qt_gsi::GenericMethod ("mapToGlobal", "@brief Method QPointF QWidget::mapToGlobal(const QPointF &)\n", true, &_init_f_mapToGlobal_c1986, &_call_f_mapToGlobal_c1986);
  methods += new qt_gsi::GenericMethod ("mapToGlobal", "@brief Method QPoint QWidget::mapToGlobal(const QPoint &)\n", true, &_init_f_mapToGlobal_c1916, &_call_f_mapToGlobal_c1916);
  methods += new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPointF QWidget::mapToParent(const QPointF &)\n", true, &_init_f_mapToParent_c1986, &_call_f_mapToParent_c1986);
  methods += new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPoint QWidget::mapToParent(const QPoint &)\n", true, &_init_f_mapToParent_c1916, &_call_f_mapToParent_c1916);
  methods += new qt_gsi::GenericMethod ("mask", "@brief Method QRegion QWidget::mask()\n", true, &_init_f_mask_c0, &_call_f_mask_c0);
  methods += new qt_gsi::GenericMethod (":maximumHeight", "@brief Method int QWidget::maximumHeight()\n", true, &_init_f_maximumHeight_c0, &_call_f_maximumHeight_c0);
  methods += new qt_gsi::GenericMethod (":maximumSize", "@brief Method QSize QWidget::maximumSize()\n", true, &_init_f_maximumSize_c0, &_call_f_maximumSize_c0);
  methods += new qt_gsi::GenericMethod (":maximumWidth", "@brief Method int QWidget::maximumWidth()\n", true, &_init_f_maximumWidth_c0, &_call_f_maximumWidth_c0);
  methods += new qt_gsi::GenericMethod (":minimumHeight", "@brief Method int QWidget::minimumHeight()\n", true, &_init_f_minimumHeight_c0, &_call_f_minimumHeight_c0);
  methods += new qt_gsi::GenericMethod (":minimumSize", "@brief Method QSize QWidget::minimumSize()\n", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
  methods += new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QWidget::minimumSizeHint()\n", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
  methods += new qt_gsi::GenericMethod (":minimumWidth", "@brief Method int QWidget::minimumWidth()\n", true, &_init_f_minimumWidth_c0, &_call_f_minimumWidth_c0);
  methods += new qt_gsi::GenericMethod ("move", "@brief Method void QWidget::move(int x, int y)\n", false, &_init_f_move_1426, &_call_f_move_1426);
  methods += new qt_gsi::GenericMethod ("move", "@brief Method void QWidget::move(const QPoint &)\n", false, &_init_f_move_1916, &_call_f_move_1916);
  methods += new qt_gsi::GenericMethod ("nativeParentWidget", "@brief Method QWidget *QWidget::nativeParentWidget()\n", true, &_init_f_nativeParentWidget_c0, &_call_f_nativeParentWidget_c0);
  methods += new qt_gsi::GenericMethod ("nextInFocusChain", "@brief Method QWidget *QWidget::nextInFocusChain()\n", true, &_init_f_nextInFocusChain_c0, &_call_f_nextInFocusChain_c0);
  methods += new qt_gsi::GenericMethod (":normalGeometry", "@brief Method QRect QWidget::normalGeometry()\n", true, &_init_f_normalGeometry_c0, &_call_f_normalGeometry_c0);
  methods += new qt_gsi::GenericMethod ("overrideWindowFlags", "@brief Method void QWidget::overrideWindowFlags(QFlags<Qt::WindowType> type)\n", false, &_init_f_overrideWindowFlags_2495, &_call_f_overrideWindowFlags_2495);
  methods += new qt_gsi::GenericMethod ("overrideWindowState", "@brief Method void QWidget::overrideWindowState(QFlags<Qt::WindowState> state)\n", false, &_init_f_overrideWindowState_2590, &_call_f_overrideWindowState_2590);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Method QPaintEngine *QWidget::paintEngine()\nThis is a reimplementation of QPaintDevice::paintEngine", true, &_init_f_paintEngine_c0, &_call_f_paintEngine_c0);
  methods += new qt_gsi::GenericMethod (":palette", "@brief Method const QPalette &QWidget::palette()\n", true, &_init_f_palette_c0, &_call_f_palette_c0);
  methods += new qt_gsi::GenericMethod ("parentWidget", "@brief Method QWidget *QWidget::parentWidget()\n", true, &_init_f_parentWidget_c0, &_call_f_parentWidget_c0);
  methods += new qt_gsi::GenericMethod (":pos", "@brief Method QPoint QWidget::pos()\n", true, &_init_f_pos_c0, &_call_f_pos_c0);
  methods += new qt_gsi::GenericMethod ("previousInFocusChain", "@brief Method QWidget *QWidget::previousInFocusChain()\n", true, &_init_f_previousInFocusChain_c0, &_call_f_previousInFocusChain_c0);
  methods += new qt_gsi::GenericMethod ("raise|qt_raise", "@brief Method void QWidget::raise()\n", false, &_init_f_raise_0, &_call_f_raise_0);
  methods += new qt_gsi::GenericMethod (":rect", "@brief Method QRect QWidget::rect()\n", true, &_init_f_rect_c0, &_call_f_rect_c0);
  methods += new qt_gsi::GenericMethod ("releaseKeyboard", "@brief Method void QWidget::releaseKeyboard()\n", false, &_init_f_releaseKeyboard_0, &_call_f_releaseKeyboard_0);
  methods += new qt_gsi::GenericMethod ("releaseMouse", "@brief Method void QWidget::releaseMouse()\n", false, &_init_f_releaseMouse_0, &_call_f_releaseMouse_0);
  methods += new qt_gsi::GenericMethod ("releaseShortcut", "@brief Method void QWidget::releaseShortcut(int id)\n", false, &_init_f_releaseShortcut_767, &_call_f_releaseShortcut_767);
  methods += new qt_gsi::GenericMethod ("removeAction", "@brief Method void QWidget::removeAction(QAction *action)\n", false, &_init_f_removeAction_1309, &_call_f_removeAction_1309);
  methods += new qt_gsi::GenericMethod ("render", "@brief Method void QWidget::render(QPaintDevice *target, const QPoint &targetOffset, const QRegion &sourceRegion, QFlags<QWidget::RenderFlag> renderFlags)\n", false, &_init_f_render_8328, &_call_f_render_8328);
  methods += new qt_gsi::GenericMethod ("render", "@brief Method void QWidget::render(QPainter *painter, const QPoint &targetOffset, const QRegion &sourceRegion, QFlags<QWidget::RenderFlag> renderFlags)\n", false, &_init_f_render_7951, &_call_f_render_7951);
  methods += new qt_gsi::GenericMethod ("repaint", "@brief Method void QWidget::repaint()\n", false, &_init_f_repaint_0, &_call_f_repaint_0);
  methods += new qt_gsi::GenericMethod ("repaint", "@brief Method void QWidget::repaint(int x, int y, int w, int h)\n", false, &_init_f_repaint_2744, &_call_f_repaint_2744);
  methods += new qt_gsi::GenericMethod ("repaint", "@brief Method void QWidget::repaint(const QRect &)\n", false, &_init_f_repaint_1792, &_call_f_repaint_1792);
  methods += new qt_gsi::GenericMethod ("repaint", "@brief Method void QWidget::repaint(const QRegion &)\n", false, &_init_f_repaint_2006, &_call_f_repaint_2006);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Method void QWidget::resize(int w, int h)\n", false, &_init_f_resize_1426, &_call_f_resize_1426);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Method void QWidget::resize(const QSize &)\n", false, &_init_f_resize_1805, &_call_f_resize_1805);
  methods += new qt_gsi::GenericMethod ("restoreGeometry", "@brief Method bool QWidget::restoreGeometry(const QByteArray &geometry)\n", false, &_init_f_restoreGeometry_2309, &_call_f_restoreGeometry_2309);
  methods += new qt_gsi::GenericMethod ("saveGeometry", "@brief Method QByteArray QWidget::saveGeometry()\n", true, &_init_f_saveGeometry_c0, &_call_f_saveGeometry_c0);
  methods += new qt_gsi::GenericMethod (":screen", "@brief Method QScreen *QWidget::screen()\n", true, &_init_f_screen_c0, &_call_f_screen_c0);
  methods += new qt_gsi::GenericMethod ("scroll", "@brief Method void QWidget::scroll(int dx, int dy)\n", false, &_init_f_scroll_1426, &_call_f_scroll_1426);
  methods += new qt_gsi::GenericMethod ("scroll", "@brief Method void QWidget::scroll(int dx, int dy, const QRect &)\n", false, &_init_f_scroll_3110, &_call_f_scroll_3110);
  methods += new qt_gsi::GenericMethod ("setAcceptDrops|acceptDrops=", "@brief Method void QWidget::setAcceptDrops(bool on)\n", false, &_init_f_setAcceptDrops_864, &_call_f_setAcceptDrops_864);
  methods += new qt_gsi::GenericMethod ("setAccessibleDescription|accessibleDescription=", "@brief Method void QWidget::setAccessibleDescription(const QString &description)\n", false, &_init_f_setAccessibleDescription_2025, &_call_f_setAccessibleDescription_2025);
  methods += new qt_gsi::GenericMethod ("setAccessibleName|accessibleName=", "@brief Method void QWidget::setAccessibleName(const QString &name)\n", false, &_init_f_setAccessibleName_2025, &_call_f_setAccessibleName_2025);
  methods += new qt_gsi::GenericMethod ("setAttribute", "@brief Method void QWidget::setAttribute(Qt::WidgetAttribute, bool on)\n", false, &_init_f_setAttribute_3065, &_call_f_setAttribute_3065);
  methods += new qt_gsi::GenericMethod ("setAutoFillBackground|autoFillBackground=", "@brief Method void QWidget::setAutoFillBackground(bool enabled)\n", false, &_init_f_setAutoFillBackground_864, &_call_f_setAutoFillBackground_864);
  methods += new qt_gsi::GenericMethod ("setBackgroundRole|backgroundRole=", "@brief Method void QWidget::setBackgroundRole(QPalette::ColorRole)\n", false, &_init_f_setBackgroundRole_2265, &_call_f_setBackgroundRole_2265);
  methods += new qt_gsi::GenericMethod ("setBaseSize|baseSize=", "@brief Method void QWidget::setBaseSize(const QSize &)\n", false, &_init_f_setBaseSize_1805, &_call_f_setBaseSize_1805);
  methods += new qt_gsi::GenericMethod ("setBaseSize", "@brief Method void QWidget::setBaseSize(int basew, int baseh)\n", false, &_init_f_setBaseSize_1426, &_call_f_setBaseSize_1426);
  methods += new qt_gsi::GenericMethod ("setContentsMargins", "@brief Method void QWidget::setContentsMargins(int left, int top, int right, int bottom)\n", false, &_init_f_setContentsMargins_2744, &_call_f_setContentsMargins_2744);
  methods += new qt_gsi::GenericMethod ("setContentsMargins|contentsMargins=", "@brief Method void QWidget::setContentsMargins(const QMargins &margins)\n", false, &_init_f_setContentsMargins_2115, &_call_f_setContentsMargins_2115);
  methods += new qt_gsi::GenericMethod ("setContextMenuPolicy|contextMenuPolicy=", "@brief Method void QWidget::setContextMenuPolicy(Qt::ContextMenuPolicy policy)\n", false, &_init_f_setContextMenuPolicy_2519, &_call_f_setContextMenuPolicy_2519);
  methods += new qt_gsi::GenericMethod ("setCursor|cursor=", "@brief Method void QWidget::setCursor(const QCursor &)\n", false, &_init_f_setCursor_2032, &_call_f_setCursor_2032);
  methods += new qt_gsi::GenericMethod ("setDisabled", "@brief Method void QWidget::setDisabled(bool)\n", false, &_init_f_setDisabled_864, &_call_f_setDisabled_864);
  methods += new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QWidget::setEnabled(bool)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
  methods += new qt_gsi::GenericMethod ("setFixedHeight", "@brief Method void QWidget::setFixedHeight(int h)\n", false, &_init_f_setFixedHeight_767, &_call_f_setFixedHeight_767);
  methods += new qt_gsi::GenericMethod ("setFixedSize", "@brief Method void QWidget::setFixedSize(const QSize &)\n", false, &_init_f_setFixedSize_1805, &_call_f_setFixedSize_1805);
  methods += new qt_gsi::GenericMethod ("setFixedSize", "@brief Method void QWidget::setFixedSize(int w, int h)\n", false, &_init_f_setFixedSize_1426, &_call_f_setFixedSize_1426);
  methods += new qt_gsi::GenericMethod ("setFixedWidth", "@brief Method void QWidget::setFixedWidth(int w)\n", false, &_init_f_setFixedWidth_767, &_call_f_setFixedWidth_767);
  methods += new qt_gsi::GenericMethod ("setFocus", "@brief Method void QWidget::setFocus()\n", false, &_init_f_setFocus_0, &_call_f_setFocus_0);
  methods += new qt_gsi::GenericMethod ("setFocus", "@brief Method void QWidget::setFocus(Qt::FocusReason reason)\n", false, &_init_f_setFocus_1877, &_call_f_setFocus_1877);
  methods += new qt_gsi::GenericMethod ("setFocusPolicy|focusPolicy=", "@brief Method void QWidget::setFocusPolicy(Qt::FocusPolicy policy)\n", false, &_init_f_setFocusPolicy_1885, &_call_f_setFocusPolicy_1885);
  methods += new qt_gsi::GenericMethod ("setFocusProxy|focusProxy=", "@brief Method void QWidget::setFocusProxy(QWidget *)\n", false, &_init_f_setFocusProxy_1315, &_call_f_setFocusProxy_1315);
  methods += new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QWidget::setFont(const QFont &)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericMethod ("setForegroundRole|foregroundRole=", "@brief Method void QWidget::setForegroundRole(QPalette::ColorRole)\n", false, &_init_f_setForegroundRole_2265, &_call_f_setForegroundRole_2265);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Method void QWidget::setGeometry(int x, int y, int w, int h)\n", false, &_init_f_setGeometry_2744, &_call_f_setGeometry_2744);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QWidget::setGeometry(const QRect &)\n", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
  methods += new qt_gsi::GenericMethod ("setGraphicsEffect|graphicsEffect=", "@brief Method void QWidget::setGraphicsEffect(QGraphicsEffect *effect)\n", false, &_init_f_setGraphicsEffect_2109, &_call_f_setGraphicsEffect_2109);
  methods += new qt_gsi::GenericMethod ("setHidden|hidden=", "@brief Method void QWidget::setHidden(bool hidden)\n", false, &_init_f_setHidden_864, &_call_f_setHidden_864);
  methods += new qt_gsi::GenericMethod ("setInputMethodHints|inputMethodHints=", "@brief Method void QWidget::setInputMethodHints(QFlags<Qt::InputMethodHint> hints)\n", false, &_init_f_setInputMethodHints_2985, &_call_f_setInputMethodHints_2985);
  methods += new qt_gsi::GenericMethod ("setLayout|layout=", "@brief Method void QWidget::setLayout(QLayout *)\n", false, &_init_f_setLayout_1341, &_call_f_setLayout_1341);
  methods += new qt_gsi::GenericMethod ("setLayoutDirection|layoutDirection=", "@brief Method void QWidget::setLayoutDirection(Qt::LayoutDirection direction)\n", false, &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
  methods += new qt_gsi::GenericMethod ("setLocale|locale=", "@brief Method void QWidget::setLocale(const QLocale &locale)\n", false, &_init_f_setLocale_1986, &_call_f_setLocale_1986);
  methods += new qt_gsi::GenericMethod ("setMask", "@brief Method void QWidget::setMask(const QBitmap &)\n", false, &_init_f_setMask_1999, &_call_f_setMask_1999);
  methods += new qt_gsi::GenericMethod ("setMask", "@brief Method void QWidget::setMask(const QRegion &)\n", false, &_init_f_setMask_2006, &_call_f_setMask_2006);
  methods += new qt_gsi::GenericMethod ("setMaximumHeight|maximumHeight=", "@brief Method void QWidget::setMaximumHeight(int maxh)\n", false, &_init_f_setMaximumHeight_767, &_call_f_setMaximumHeight_767);
  methods += new qt_gsi::GenericMethod ("setMaximumSize|maximumSize=", "@brief Method void QWidget::setMaximumSize(const QSize &)\n", false, &_init_f_setMaximumSize_1805, &_call_f_setMaximumSize_1805);
  methods += new qt_gsi::GenericMethod ("setMaximumSize", "@brief Method void QWidget::setMaximumSize(int maxw, int maxh)\n", false, &_init_f_setMaximumSize_1426, &_call_f_setMaximumSize_1426);
  methods += new qt_gsi::GenericMethod ("setMaximumWidth|maximumWidth=", "@brief Method void QWidget::setMaximumWidth(int maxw)\n", false, &_init_f_setMaximumWidth_767, &_call_f_setMaximumWidth_767);
  methods += new qt_gsi::GenericMethod ("setMinimumHeight|minimumHeight=", "@brief Method void QWidget::setMinimumHeight(int minh)\n", false, &_init_f_setMinimumHeight_767, &_call_f_setMinimumHeight_767);
  methods += new qt_gsi::GenericMethod ("setMinimumSize|minimumSize=", "@brief Method void QWidget::setMinimumSize(const QSize &)\n", false, &_init_f_setMinimumSize_1805, &_call_f_setMinimumSize_1805);
  methods += new qt_gsi::GenericMethod ("setMinimumSize", "@brief Method void QWidget::setMinimumSize(int minw, int minh)\n", false, &_init_f_setMinimumSize_1426, &_call_f_setMinimumSize_1426);
  methods += new qt_gsi::GenericMethod ("setMinimumWidth|minimumWidth=", "@brief Method void QWidget::setMinimumWidth(int minw)\n", false, &_init_f_setMinimumWidth_767, &_call_f_setMinimumWidth_767);
  methods += new qt_gsi::GenericMethod ("setMouseTracking|mouseTracking=", "@brief Method void QWidget::setMouseTracking(bool enable)\n", false, &_init_f_setMouseTracking_864, &_call_f_setMouseTracking_864);
  methods += new qt_gsi::GenericMethod ("setPalette|palette=", "@brief Method void QWidget::setPalette(const QPalette &)\n", false, &_init_f_setPalette_2113, &_call_f_setPalette_2113);
  methods += new qt_gsi::GenericMethod ("setParent", "@brief Method void QWidget::setParent(QWidget *parent)\n", false, &_init_f_setParent_1315, &_call_f_setParent_1315);
  methods += new qt_gsi::GenericMethod ("setParent", "@brief Method void QWidget::setParent(QWidget *parent, QFlags<Qt::WindowType> f)\n", false, &_init_f_setParent_3702, &_call_f_setParent_3702);
  methods += new qt_gsi::GenericMethod ("setScreen|screen=", "@brief Method void QWidget::setScreen(QScreen *)\n", false, &_init_f_setScreen_1311, &_call_f_setScreen_1311);
  methods += new qt_gsi::GenericMethod ("setShortcutAutoRepeat", "@brief Method void QWidget::setShortcutAutoRepeat(int id, bool enable)\n", false, &_init_f_setShortcutAutoRepeat_1523, &_call_f_setShortcutAutoRepeat_1523);
  methods += new qt_gsi::GenericMethod ("setShortcutEnabled", "@brief Method void QWidget::setShortcutEnabled(int id, bool enable)\n", false, &_init_f_setShortcutEnabled_1523, &_call_f_setShortcutEnabled_1523);
  methods += new qt_gsi::GenericMethod ("setSizeIncrement|sizeIncrement=", "@brief Method void QWidget::setSizeIncrement(const QSize &)\n", false, &_init_f_setSizeIncrement_1805, &_call_f_setSizeIncrement_1805);
  methods += new qt_gsi::GenericMethod ("setSizeIncrement", "@brief Method void QWidget::setSizeIncrement(int w, int h)\n", false, &_init_f_setSizeIncrement_1426, &_call_f_setSizeIncrement_1426);
  methods += new qt_gsi::GenericMethod ("setSizePolicy|sizePolicy=", "@brief Method void QWidget::setSizePolicy(QSizePolicy)\n", false, &_init_f_setSizePolicy_1552, &_call_f_setSizePolicy_1552);
  methods += new qt_gsi::GenericMethod ("setSizePolicy", "@brief Method void QWidget::setSizePolicy(QSizePolicy::Policy horizontal, QSizePolicy::Policy vertical)\n", false, &_init_f_setSizePolicy_4476, &_call_f_setSizePolicy_4476);
  methods += new qt_gsi::GenericMethod ("setStatusTip|statusTip=", "@brief Method void QWidget::setStatusTip(const QString &)\n", false, &_init_f_setStatusTip_2025, &_call_f_setStatusTip_2025);
  methods += new qt_gsi::GenericMethod ("setStyle|style=", "@brief Method void QWidget::setStyle(QStyle *)\n", false, &_init_f_setStyle_1232, &_call_f_setStyle_1232);
  methods += new qt_gsi::GenericMethod ("setStyleSheet|styleSheet=", "@brief Method void QWidget::setStyleSheet(const QString &styleSheet)\n", false, &_init_f_setStyleSheet_2025, &_call_f_setStyleSheet_2025);
  methods += new qt_gsi::GenericMethod ("setTabletTracking|tabletTracking=", "@brief Method void QWidget::setTabletTracking(bool enable)\n", false, &_init_f_setTabletTracking_864, &_call_f_setTabletTracking_864);
  methods += new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QWidget::setToolTip(const QString &)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
  methods += new qt_gsi::GenericMethod ("setToolTipDuration|toolTipDuration=", "@brief Method void QWidget::setToolTipDuration(int msec)\n", false, &_init_f_setToolTipDuration_767, &_call_f_setToolTipDuration_767);
  methods += new qt_gsi::GenericMethod ("setUpdatesEnabled|updatesEnabled=", "@brief Method void QWidget::setUpdatesEnabled(bool enable)\n", false, &_init_f_setUpdatesEnabled_864, &_call_f_setUpdatesEnabled_864);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QWidget::setVisible(bool visible)\n", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += new qt_gsi::GenericMethod ("setWhatsThis|whatsThis=", "@brief Method void QWidget::setWhatsThis(const QString &)\n", false, &_init_f_setWhatsThis_2025, &_call_f_setWhatsThis_2025);
  methods += new qt_gsi::GenericMethod ("setWindowFilePath|windowFilePath=", "@brief Method void QWidget::setWindowFilePath(const QString &filePath)\n", false, &_init_f_setWindowFilePath_2025, &_call_f_setWindowFilePath_2025);
  methods += new qt_gsi::GenericMethod ("setWindowFlag", "@brief Method void QWidget::setWindowFlag(Qt::WindowType, bool on)\n", false, &_init_f_setWindowFlag_2555, &_call_f_setWindowFlag_2555);
  methods += new qt_gsi::GenericMethod ("setWindowFlags|windowFlags=", "@brief Method void QWidget::setWindowFlags(QFlags<Qt::WindowType> type)\n", false, &_init_f_setWindowFlags_2495, &_call_f_setWindowFlags_2495);
  methods += new qt_gsi::GenericMethod ("setWindowIcon|windowIcon=", "@brief Method void QWidget::setWindowIcon(const QIcon &icon)\n", false, &_init_f_setWindowIcon_1787, &_call_f_setWindowIcon_1787);
  methods += new qt_gsi::GenericMethod ("setWindowIconText|windowIconText=", "@brief Method void QWidget::setWindowIconText(const QString &)\n", false, &_init_f_setWindowIconText_2025, &_call_f_setWindowIconText_2025);
  methods += new qt_gsi::GenericMethod ("setWindowModality|windowModality=", "@brief Method void QWidget::setWindowModality(Qt::WindowModality windowModality)\n", false, &_init_f_setWindowModality_2216, &_call_f_setWindowModality_2216);
  methods += new qt_gsi::GenericMethod ("setWindowModified|windowModified=", "@brief Method void QWidget::setWindowModified(bool)\n", false, &_init_f_setWindowModified_864, &_call_f_setWindowModified_864);
  methods += new qt_gsi::GenericMethod ("setWindowOpacity|windowOpacity=", "@brief Method void QWidget::setWindowOpacity(double level)\n", false, &_init_f_setWindowOpacity_1071, &_call_f_setWindowOpacity_1071);
  methods += new qt_gsi::GenericMethod ("setWindowRole|windowRole=", "@brief Method void QWidget::setWindowRole(const QString &)\n", false, &_init_f_setWindowRole_2025, &_call_f_setWindowRole_2025);
  methods += new qt_gsi::GenericMethod ("setWindowState|windowState=", "@brief Method void QWidget::setWindowState(QFlags<Qt::WindowState> state)\n", false, &_init_f_setWindowState_2590, &_call_f_setWindowState_2590);
  methods += new qt_gsi::GenericMethod ("setWindowTitle|windowTitle=", "@brief Method void QWidget::setWindowTitle(const QString &)\n", false, &_init_f_setWindowTitle_2025, &_call_f_setWindowTitle_2025);
  methods += new qt_gsi::GenericMethod ("show", "@brief Method void QWidget::show()\n", false, &_init_f_show_0, &_call_f_show_0);
  methods += new qt_gsi::GenericMethod ("showFullScreen", "@brief Method void QWidget::showFullScreen()\n", false, &_init_f_showFullScreen_0, &_call_f_showFullScreen_0);
  methods += new qt_gsi::GenericMethod ("showMaximized", "@brief Method void QWidget::showMaximized()\n", false, &_init_f_showMaximized_0, &_call_f_showMaximized_0);
  methods += new qt_gsi::GenericMethod ("showMinimized", "@brief Method void QWidget::showMinimized()\n", false, &_init_f_showMinimized_0, &_call_f_showMinimized_0);
  methods += new qt_gsi::GenericMethod ("showNormal", "@brief Method void QWidget::showNormal()\n", false, &_init_f_showNormal_0, &_call_f_showNormal_0);
  methods += new qt_gsi::GenericMethod (":size", "@brief Method QSize QWidget::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QWidget::sizeHint()\n", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":sizeIncrement", "@brief Method QSize QWidget::sizeIncrement()\n", true, &_init_f_sizeIncrement_c0, &_call_f_sizeIncrement_c0);
  methods += new qt_gsi::GenericMethod (":sizePolicy", "@brief Method QSizePolicy QWidget::sizePolicy()\n", true, &_init_f_sizePolicy_c0, &_call_f_sizePolicy_c0);
  methods += new qt_gsi::GenericMethod ("stackUnder", "@brief Method void QWidget::stackUnder(QWidget *)\n", false, &_init_f_stackUnder_1315, &_call_f_stackUnder_1315);
  methods += new qt_gsi::GenericMethod (":statusTip", "@brief Method QString QWidget::statusTip()\n", true, &_init_f_statusTip_c0, &_call_f_statusTip_c0);
  methods += new qt_gsi::GenericMethod (":style", "@brief Method QStyle *QWidget::style()\n", true, &_init_f_style_c0, &_call_f_style_c0);
  methods += new qt_gsi::GenericMethod (":styleSheet", "@brief Method QString QWidget::styleSheet()\n", true, &_init_f_styleSheet_c0, &_call_f_styleSheet_c0);
  methods += new qt_gsi::GenericMethod ("testAttribute", "@brief Method bool QWidget::testAttribute(Qt::WidgetAttribute)\n", true, &_init_f_testAttribute_c2309, &_call_f_testAttribute_c2309);
  methods += new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QWidget::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
  methods += new qt_gsi::GenericMethod (":toolTipDuration", "@brief Method int QWidget::toolTipDuration()\n", true, &_init_f_toolTipDuration_c0, &_call_f_toolTipDuration_c0);
  methods += new qt_gsi::GenericMethod ("topLevelWidget", "@brief Method QWidget *QWidget::topLevelWidget()\n", true, &_init_f_topLevelWidget_c0, &_call_f_topLevelWidget_c0);
  methods += new qt_gsi::GenericMethod ("underMouse", "@brief Method bool QWidget::underMouse()\n", true, &_init_f_underMouse_c0, &_call_f_underMouse_c0);
  methods += new qt_gsi::GenericMethod ("ungrabGesture", "@brief Method void QWidget::ungrabGesture(Qt::GestureType type)\n", false, &_init_f_ungrabGesture_1902, &_call_f_ungrabGesture_1902);
  methods += new qt_gsi::GenericMethod ("unsetCursor", "@brief Method void QWidget::unsetCursor()\n", false, &_init_f_unsetCursor_0, &_call_f_unsetCursor_0);
  methods += new qt_gsi::GenericMethod ("unsetLayoutDirection", "@brief Method void QWidget::unsetLayoutDirection()\n", false, &_init_f_unsetLayoutDirection_0, &_call_f_unsetLayoutDirection_0);
  methods += new qt_gsi::GenericMethod ("unsetLocale", "@brief Method void QWidget::unsetLocale()\n", false, &_init_f_unsetLocale_0, &_call_f_unsetLocale_0);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QWidget::update()\n", false, &_init_f_update_0, &_call_f_update_0);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QWidget::update(int x, int y, int w, int h)\n", false, &_init_f_update_2744, &_call_f_update_2744);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QWidget::update(const QRect &)\n", false, &_init_f_update_1792, &_call_f_update_1792);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QWidget::update(const QRegion &)\n", false, &_init_f_update_2006, &_call_f_update_2006);
  methods += new qt_gsi::GenericMethod ("updateGeometry", "@brief Method void QWidget::updateGeometry()\n", false, &_init_f_updateGeometry_0, &_call_f_updateGeometry_0);
  methods += new qt_gsi::GenericMethod (":updatesEnabled", "@brief Method bool QWidget::updatesEnabled()\n", true, &_init_f_updatesEnabled_c0, &_call_f_updatesEnabled_c0);
  methods += new qt_gsi::GenericMethod ("visibleRegion", "@brief Method QRegion QWidget::visibleRegion()\n", true, &_init_f_visibleRegion_c0, &_call_f_visibleRegion_c0);
  methods += new qt_gsi::GenericMethod (":whatsThis", "@brief Method QString QWidget::whatsThis()\n", true, &_init_f_whatsThis_c0, &_call_f_whatsThis_c0);
  methods += new qt_gsi::GenericMethod (":width", "@brief Method int QWidget::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
  methods += new qt_gsi::GenericMethod ("winId", "@brief Method WId QWidget::winId()\n", true, &_init_f_winId_c0, &_call_f_winId_c0);
  methods += new qt_gsi::GenericMethod ("window", "@brief Method QWidget *QWidget::window()\n", true, &_init_f_window_c0, &_call_f_window_c0);
  methods += new qt_gsi::GenericMethod (":windowFilePath", "@brief Method QString QWidget::windowFilePath()\n", true, &_init_f_windowFilePath_c0, &_call_f_windowFilePath_c0);
  methods += new qt_gsi::GenericMethod (":windowFlags", "@brief Method QFlags<Qt::WindowType> QWidget::windowFlags()\n", true, &_init_f_windowFlags_c0, &_call_f_windowFlags_c0);
  methods += new qt_gsi::GenericMethod ("windowHandle", "@brief Method QWindow *QWidget::windowHandle()\n", true, &_init_f_windowHandle_c0, &_call_f_windowHandle_c0);
  methods += new qt_gsi::GenericMethod (":windowIcon", "@brief Method QIcon QWidget::windowIcon()\n", true, &_init_f_windowIcon_c0, &_call_f_windowIcon_c0);
  methods += new qt_gsi::GenericMethod (":windowIconText", "@brief Method QString QWidget::windowIconText()\n", true, &_init_f_windowIconText_c0, &_call_f_windowIconText_c0);
  methods += new qt_gsi::GenericMethod (":windowModality", "@brief Method Qt::WindowModality QWidget::windowModality()\n", true, &_init_f_windowModality_c0, &_call_f_windowModality_c0);
  methods += new qt_gsi::GenericMethod (":windowOpacity", "@brief Method double QWidget::windowOpacity()\n", true, &_init_f_windowOpacity_c0, &_call_f_windowOpacity_c0);
  methods += new qt_gsi::GenericMethod (":windowRole", "@brief Method QString QWidget::windowRole()\n", true, &_init_f_windowRole_c0, &_call_f_windowRole_c0);
  methods += new qt_gsi::GenericMethod (":windowState", "@brief Method QFlags<Qt::WindowState> QWidget::windowState()\n", true, &_init_f_windowState_c0, &_call_f_windowState_c0);
  methods += new qt_gsi::GenericMethod (":windowTitle", "@brief Method QString QWidget::windowTitle()\n", true, &_init_f_windowTitle_c0, &_call_f_windowTitle_c0);
  methods += new qt_gsi::GenericMethod ("windowType", "@brief Method Qt::WindowType QWidget::windowType()\n", true, &_init_f_windowType_c0, &_call_f_windowType_c0);
  methods += new qt_gsi::GenericMethod (":x", "@brief Method int QWidget::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
  methods += new qt_gsi::GenericMethod (":y", "@brief Method int QWidget::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QWidget::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QWidget::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QWidget::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QWidget::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("createWindowContainer", "@brief Static method QWidget *QWidget::createWindowContainer(QWindow *window, QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_createWindowContainer_4929, &_call_f_createWindowContainer_4929);
  methods += new qt_gsi::GenericStaticMethod ("find", "@brief Static method QWidget *QWidget::find(WId)\nThis method is static and can be called without an instance.", &_init_f_find_696, &_call_f_find_696);
  methods += new qt_gsi::GenericStaticMethod ("keyboardGrabber", "@brief Static method QWidget *QWidget::keyboardGrabber()\nThis method is static and can be called without an instance.", &_init_f_keyboardGrabber_0, &_call_f_keyboardGrabber_0);
  methods += new qt_gsi::GenericStaticMethod ("mouseGrabber", "@brief Static method QWidget *QWidget::mouseGrabber()\nThis method is static and can be called without an instance.", &_init_f_mouseGrabber_0, &_call_f_mouseGrabber_0);
  methods += new qt_gsi::GenericStaticMethod ("setTabOrder", "@brief Static method void QWidget::setTabOrder(QWidget *, QWidget *)\nThis method is static and can be called without an instance.", &_init_f_setTabOrder_2522, &_call_f_setTabOrder_2522);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QWidget\nClass QWidget is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QWidget_as_QObject, &_call_f_QWidget_as_QObject);
  methods += new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QWidget\nClass QWidget is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QWidget_as_const_QObject, &_call_f_QWidget_as_const_QObject);
  methods += new qt_gsi::GenericMethod ("asQPaintDevice", "@brief Delivers the base class interface QPaintDevice of QWidget\nClass QWidget is derived from multiple base classes. This method delivers the QPaintDevice base class aspect.", false, &_init_f_QWidget_as_QPaintDevice, &_call_f_QWidget_as_QPaintDevice);
  methods += new qt_gsi::GenericMethod ("asConstQPaintDevice", "@brief Delivers the base class interface QPaintDevice of QWidget\nClass QWidget is derived from multiple base classes. This method delivers the QPaintDevice base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QWidget_as_const_QPaintDevice, &_call_f_QWidget_as_const_QPaintDevice);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QWidget> decl_QWidget (qtdecl_QObject (), "QtWidgets", "QWidget_Native",
  methods_QWidget (),
  "@hide\n@alias QWidget");

//  Additional base classes

gsi::Class<QPaintDevice> &qtdecl_QPaintDevice ();

gsi::ClassExt<QWidget> base_class_QPaintDevice_in_QWidget (qtdecl_QPaintDevice ());

GSI_QTWIDGETS_PUBLIC gsi::Class<QWidget> &qtdecl_QWidget () { return decl_QWidget; }

}


class QWidget_Adaptor : public QWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QWidget_Adaptor();

  //  [adaptor ctor] QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f)
  QWidget_Adaptor() : QWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f)
  QWidget_Adaptor(QWidget *parent) : QWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f)
  QWidget_Adaptor(QWidget *parent, QFlags<Qt::WindowType> f) : QWidget(parent, f)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QWidget::focusNextChild()
  bool fp_QWidget_focusNextChild_0 () {
    return QWidget::focusNextChild();
  }

  //  [expose] bool QWidget::focusPreviousChild()
  bool fp_QWidget_focusPreviousChild_0 () {
    return QWidget::focusPreviousChild();
  }

  //  [expose] bool QWidget::isSignalConnected(const QMetaMethod &signal)
  bool fp_QWidget_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QWidget::isSignalConnected(signal);
  }

  //  [expose] int QWidget::receivers(const char *signal)
  int fp_QWidget_receivers_c1731 (const char *signal) const {
    return QWidget::receivers(signal);
  }

  //  [expose] QObject *QWidget::sender()
  QObject * fp_QWidget_sender_c0 () const {
    return QWidget::sender();
  }

  //  [expose] int QWidget::senderSignalIndex()
  int fp_QWidget_senderSignalIndex_c0 () const {
    return QWidget::senderSignalIndex();
  }

  //  [expose] void QWidget::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QWidget_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QWidget::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [emitter impl] void QWidget::customContextMenuRequested(const QPoint &pos)
  void emitter_QWidget_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QWidget::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QWidget::destroyed(QObject *)
  void emitter_QWidget_destroyed_1302(QObject *arg1)
  {
    emit QWidget::destroyed(arg1);
  }

  //  [adaptor impl] bool QWidget::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QWidget::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QWidget_Adaptor, bool, QObject *, QEvent *>(&QWidget_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QWidget::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QWidget::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QWidget::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QWidget_Adaptor, bool>(&QWidget_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QWidget::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QWidget::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QWidget::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QWidget_Adaptor, int, int>(&QWidget_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QWidget::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QWidget::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QWidget_Adaptor, QSize>(&QWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QWidget::minimumSizeHint();
    }
  }

  //  [emitter impl] void QWidget::objectNameChanged(const QString &objectName)
  void emitter_QWidget_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QWidget::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QWidget_Adaptor, QPaintEngine *>(&QWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QWidget::paintEngine();
    }
  }

  //  [adaptor impl] void QWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QWidget_Adaptor, bool>(&QWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QWidget_Adaptor, QSize>(&QWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QWidget::sizeHint();
    }
  }

  //  [emitter impl] void QWidget::windowIconChanged(const QIcon &icon)
  void emitter_QWidget_windowIconChanged_1787(const QIcon &icon)
  {
    emit QWidget::windowIconChanged(icon);
  }

  //  [emitter impl] void QWidget::windowIconTextChanged(const QString &iconText)
  void emitter_QWidget_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QWidget::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QWidget::windowTitleChanged(const QString &title)
  void emitter_QWidget_windowTitleChanged_2025(const QString &title)
  {
    emit QWidget::windowTitleChanged(title);
  }

  //  [adaptor impl] void QWidget::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QWidget::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QWidget_Adaptor, QActionEvent *>(&QWidget_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QWidget::actionEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QWidget_Adaptor, QEvent *>(&QWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QWidget::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QWidget_Adaptor, QChildEvent *>(&QWidget_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QWidget::childEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QWidget::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QWidget_Adaptor, QCloseEvent *>(&QWidget_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QWidget::closeEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QWidget::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QWidget_Adaptor, QContextMenuEvent *>(&QWidget_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QWidget::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QWidget::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QWidget_Adaptor, QEvent *>(&QWidget_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QWidget::customEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QWidget_Adaptor, const QMetaMethod &>(&QWidget_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QWidget::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QWidget::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QWidget_Adaptor, QDragEnterEvent *>(&QWidget_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QWidget::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QWidget::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QWidget_Adaptor, QDragLeaveEvent *>(&QWidget_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QWidget::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QWidget::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QWidget_Adaptor, QDragMoveEvent *>(&QWidget_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QWidget::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QWidget::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QWidget_Adaptor, QDropEvent *>(&QWidget_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QWidget::dropEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QWidget::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QWidget_Adaptor, QEnterEvent *>(&QWidget_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QWidget::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QWidget::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QWidget::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QWidget_Adaptor, bool, QEvent *>(&QWidget_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QWidget::event(_event);
    }
  }

  //  [adaptor impl] void QWidget::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QWidget::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QWidget_Adaptor, QFocusEvent *>(&QWidget_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QWidget::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QWidget_Adaptor, bool, bool>(&QWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QWidget::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QWidget::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QWidget_Adaptor, QFocusEvent *>(&QWidget_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QWidget::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QWidget::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QWidget_Adaptor, QHideEvent *>(&QWidget_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QWidget::hideEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QWidget::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QWidget_Adaptor, QPainter *>(&QWidget_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QWidget::initPainter(painter);
    }
  }

  //  [adaptor impl] void QWidget::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QWidget::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QWidget_Adaptor, QInputMethodEvent *>(&QWidget_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QWidget::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QWidget::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QWidget_Adaptor, QKeyEvent *>(&QWidget_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QWidget::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QWidget::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QWidget_Adaptor, QKeyEvent *>(&QWidget_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QWidget::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QWidget::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QWidget_Adaptor, QEvent *>(&QWidget_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QWidget::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QWidget::metric(arg1);
    }
  }

  //  [adaptor impl] void QWidget::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QWidget::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QWidget_Adaptor, QMouseEvent *>(&QWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QWidget::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QWidget::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QWidget_Adaptor, QMouseEvent *>(&QWidget_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QWidget::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QWidget_Adaptor, QMouseEvent *>(&QWidget_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QWidget::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QWidget_Adaptor, QMouseEvent *>(&QWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QWidget::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QWidget::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QWidget_Adaptor, QMoveEvent *>(&QWidget_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QWidget::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QWidget::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QWidget::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QWidget_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QWidget_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QWidget::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QWidget::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QWidget::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QWidget_Adaptor, QPaintEvent *>(&QWidget_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QWidget::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QWidget::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QWidget::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QWidget_Adaptor, QPaintDevice *, QPoint *>(&QWidget_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QWidget::redirected(offset);
    }
  }

  //  [adaptor impl] void QWidget::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QWidget::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QWidget_Adaptor, QResizeEvent *>(&QWidget_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QWidget::resizeEvent(event);
    }
  }

  //  [adaptor impl] QPainter *QWidget::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QWidget::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QWidget_Adaptor, QPainter *>(&QWidget_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QWidget::sharedPainter();
    }
  }

  //  [adaptor impl] void QWidget::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QWidget::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QWidget_Adaptor, QShowEvent *>(&QWidget_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QWidget::showEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QWidget::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QWidget_Adaptor, QTabletEvent *>(&QWidget_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QWidget::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QWidget::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QWidget_Adaptor, QTimerEvent *>(&QWidget_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QWidget::timerEvent(event);
    }
  }

  //  [adaptor impl] void QWidget::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QWidget::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QWidget_Adaptor, QWheelEvent *>(&QWidget_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QWidget::wheelEvent(event);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QWidget_Adaptor::~QWidget_Adaptor() { }

//  Constructor QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f) (adaptor class)

static void _init_ctor_QWidget_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "Qt::WindowFlags()");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QWidget_Adaptor> ();
}

static void _call_ctor_QWidget_Adaptor_3702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (Qt::WindowFlags(), heap);
  ret.write<QWidget_Adaptor *> (new QWidget_Adaptor (arg1, arg2));
}


// void QWidget::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QWidget::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QWidget::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QWidget::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->fp_QWidget_create_2208 (arg1, arg2, arg3);
}


// emitter void QWidget::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QWidget_Adaptor *)cls)->emitter_QWidget_customContextMenuRequested_1916 (arg1);
}


// void QWidget::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->fp_QWidget_destroy_1620 (arg1, arg2);
}


// emitter void QWidget::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QWidget_Adaptor *)cls)->emitter_QWidget_destroyed_1302 (arg1);
}


// void QWidget::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QWidget::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QWidget::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QWidget::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QWidget::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QWidget::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QWidget::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QWidget::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QWidget::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->fp_QWidget_focusNextChild_0 ());
}


// bool QWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QWidget::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->fp_QWidget_focusPreviousChild_0 ());
}


// bool QWidget::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QWidget::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QWidget::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QWidget::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QWidget::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QWidget::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->fp_QWidget_isSignalConnected_c2394 (arg1));
}


// void QWidget::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QWidget::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QWidget::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QWidget::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QWidget::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QWidget::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QWidget::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QWidget::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QWidget::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QWidget::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QWidget_Adaptor *)cls)->emitter_QWidget_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QWidget::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QWidget_Adaptor *)cls)->fp_QWidget_receivers_c1731 (arg1));
}


// QPaintDevice *QWidget::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QWidget_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QWidget::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QWidget_Adaptor *)cls)->fp_QWidget_sender_c0 ());
}


// exposed int QWidget::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWidget_Adaptor *)cls)->fp_QWidget_senderSignalIndex_c0 ());
}


// void QWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QWidget::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QWidget_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QWidget::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QWidget::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QWidget::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QWidget::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->fp_QWidget_updateMicroFocus_2420 (arg1);
}


// void QWidget::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QWidget::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QWidget_Adaptor *)cls)->emitter_QWidget_windowIconChanged_1787 (arg1);
}


// emitter void QWidget::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QWidget_Adaptor *)cls)->emitter_QWidget_windowIconTextChanged_2025 (arg1);
}


// emitter void QWidget::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QWidget_Adaptor *)cls)->emitter_QWidget_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QWidget> &qtdecl_QWidget ();

static gsi::Methods methods_QWidget_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f)\nThis method creates an object of class QWidget.", &_init_ctor_QWidget_Adaptor_3702, &_call_ctor_QWidget_Adaptor_3702);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QWidget::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QWidget::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QWidget::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QWidget::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QWidget::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QWidget::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QWidget::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QWidget::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QWidget::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QWidget::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QWidget::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QWidget::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QWidget::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QWidget::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QWidget::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QWidget::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QWidget::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QWidget::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QWidget::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QWidget::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QWidget::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QWidget::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QWidget::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QWidget::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QWidget::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QWidget::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QWidget::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QWidget::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QWidget::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QWidget::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QWidget::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QWidget::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QWidget::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QWidget::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QWidget::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QWidget::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QWidget::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QWidget::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QWidget::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QWidget::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QWidget::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QWidget::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QWidget::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QWidget::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QWidget::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QWidget::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QWidget_Adaptor> decl_QWidget_Adaptor (qtdecl_QWidget (), "QtWidgets", "QWidget",
  methods_QWidget_Adaptor (),
  "@qt\n@brief Binding of QWidget");

}


//  Implementation of the enum wrapper class for QWidget::RenderFlag
namespace qt_gsi
{

static gsi::Enum<QWidget::RenderFlag> decl_QWidget_RenderFlag_Enum ("QtWidgets", "QWidget_RenderFlag",
    gsi::enum_const ("DrawWindowBackground", QWidget::DrawWindowBackground, "@brief Enum constant QWidget::DrawWindowBackground") +
    gsi::enum_const ("DrawChildren", QWidget::DrawChildren, "@brief Enum constant QWidget::DrawChildren") +
    gsi::enum_const ("IgnoreMask", QWidget::IgnoreMask, "@brief Enum constant QWidget::IgnoreMask"),
  "@qt\n@brief This class represents the QWidget::RenderFlag enum");

static gsi::QFlagsClass<QWidget::RenderFlag > decl_QWidget_RenderFlag_Enums ("QtWidgets", "QWidget_QFlags_RenderFlag",
  "@qt\n@brief This class represents the QFlags<QWidget::RenderFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QWidget> inject_QWidget_RenderFlag_Enum_in_parent (decl_QWidget_RenderFlag_Enum.defs ());
static gsi::ClassExt<QWidget> decl_QWidget_RenderFlag_Enum_as_child (decl_QWidget_RenderFlag_Enum, "RenderFlag");
static gsi::ClassExt<QWidget> decl_QWidget_RenderFlag_Enums_as_child (decl_QWidget_RenderFlag_Enums, "QFlags_RenderFlag");

}

