/*
 * Decompiled with CFR 0.152.
 */
package net.sf.akismet;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Akismet {
    private Log logger = LogFactory.getLog((Class)(class$net$sf$akismet$Akismet == null ? (class$net$sf$akismet$Akismet = Akismet.class$("net.sf.akismet.Akismet")) : class$net$sf$akismet$Akismet));
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String USER_AGENT_VALUE = "Akismet Java API/1.02";
    private static final String API_PARAMETER_KEY = "key";
    private static final String API_PARAMETER_BLOG = "blog";
    private static final String API_PARAMETER_USER_IP = "user_ip";
    private static final String API_PARAMETER_USER_AGENT = "user_agent";
    private static final String API_PARAMETER_REFERRER = "referrer";
    private static final String API_PARAMETER_PERMALINK = "permalink";
    private static final String API_PARAMETER_COMMENT_TYPE = "comment_type";
    private static final String API_PARAMETER_COMMENT_AUTHOR = "comment_author";
    private static final String API_PARAMETER_COMMENT_AUTHOR_EMAIL = "comment_author_email";
    private static final String API_PARAMETER_COMMENT_AUTHOR_URL = "comment_author_url";
    private static final String API_PARAMETER_COMMENT_CONTENT = "comment_content";
    private static final String VALID_RESPONSE = "valid";
    private static final String FALSE_RESPONSE = "false";
    public static final String COMMENT_TYPE_BLANK = "";
    public static final String COMMENT_TYPE_COMMENT = "comment";
    public static final String COMMENT_TYPE_TRACKBACK = "trackback";
    public static final String COMMENT_TYPE_PINGBACK = "pingback";
    private HttpClient httpClient;
    private String apiKey;
    private String blog;
    private boolean verifiedKey = false;
    private int httpResult;
    static /* synthetic */ Class class$net$sf$akismet$Akismet;

    public Akismet(String apiKey, String blog) {
        this.apiKey = apiKey;
        this.blog = blog;
        if (apiKey == null) {
            throw new IllegalArgumentException("API key cannot be null");
        }
        if (blog == null) {
            throw new IllegalArgumentException("Blog cannot be null");
        }
        this.httpClient = new HttpClient();
        HttpClientParams httpClientParams = new HttpClientParams();
        DefaultHttpMethodRetryHandler defaultHttpMethodRetryHandler = new DefaultHttpMethodRetryHandler(0, false);
        httpClientParams.setParameter(USER_AGENT_HEADER, (Object)USER_AGENT_VALUE);
        httpClientParams.setParameter("http.method.retry-handler", (Object)defaultHttpMethodRetryHandler);
        this.httpClient.setParams(httpClientParams);
    }

    public int getHttpResult() {
        return this.httpResult;
    }

    public boolean isVerifiedKey() {
        return this.verifiedKey;
    }

    public void setProxyConfiguration(String proxyHost, int proxyPort) {
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setProxy(proxyHost, proxyPort);
        this.httpClient.setHostConfiguration(hostConfiguration);
    }

    private boolean checkNullOrBlank(String input) {
        return input == null || COMMENT_TYPE_BLANK.equals(input);
    }

    public void setProxyAuthenticationConfiguration(String proxyUsername, String proxyPassword) {
        this.httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
    }

    public boolean verifyAPIKey() {
        boolean callResult = true;
        PostMethod post = new PostMethod("http://rest.akismet.com/1.1/verify-key");
        post.addParameter(API_PARAMETER_KEY, this.apiKey);
        post.addParameter(API_PARAMETER_BLOG, this.blog);
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)post);
            String result = post.getResponseBodyAsString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Akismet response: " + result));
            }
            if (!this.checkNullOrBlank(result) && !VALID_RESPONSE.equals(result)) {
                callResult = false;
            }
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)e);
            }
            callResult = false;
        }
        this.verifiedKey = callResult;
        return callResult;
    }

    protected boolean akismetCall(String function, String ipAddress, String userAgent, String referrer, String permalink, String commentType, String author, String authorEmail, String authorURL, String commentContent, Map other) {
        boolean callResult = false;
        String akismetURL = "http://" + this.apiKey + ".rest.akismet.com/1.1/" + function;
        PostMethod post = new PostMethod(akismetURL);
        post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        post.addParameter(new NameValuePair(API_PARAMETER_BLOG, this.blog));
        if (ipAddress != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_USER_IP, ipAddress));
        } else {
            post.addParameter(new NameValuePair(API_PARAMETER_USER_IP, COMMENT_TYPE_BLANK));
        }
        if (userAgent != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_USER_AGENT, userAgent));
        }
        if (referrer != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_REFERRER, referrer));
        }
        if (permalink != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_PERMALINK, permalink));
        }
        if (commentType != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_TYPE, commentType));
        }
        if (author != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_AUTHOR, author));
        }
        if (authorEmail != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_AUTHOR_EMAIL, authorEmail));
        }
        if (authorURL != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_AUTHOR_URL, authorURL));
        }
        if (commentContent != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_CONTENT, commentContent));
        }
        if (other != null && other.size() > 0) {
            Iterator keyIterator = other.keySet().iterator();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                if (key == null || other.get(key) == null) continue;
                post.addParameter(new NameValuePair(key, other.get(key).toString()));
            }
        }
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)post);
            String result = post.getResponseBodyAsString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Akismet response: " + result));
            }
            if (!this.checkNullOrBlank(result) && !FALSE_RESPONSE.equals(result = result.trim())) {
                callResult = true;
            }
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)e);
            }
            callResult = true;
        }
        return callResult;
    }

    public boolean commentCheck(String ipAddress, String userAgent, String referrer, String permalink, String commentType, String author, String authorEmail, String authorURL, String commentContent, Map other) {
        return this.akismetCall("comment-check", ipAddress, userAgent, referrer, permalink, commentType, author, authorEmail, authorURL, commentContent, other);
    }

    public void submitSpam(String ipAddress, String userAgent, String referrer, String permalink, String commentType, String author, String authorEmail, String authorURL, String commentContent, Map other) {
        this.akismetCall("submit-spam", ipAddress, userAgent, referrer, permalink, commentType, author, authorEmail, authorURL, commentContent, other);
    }

    public void submitHam(String ipAddress, String userAgent, String referrer, String permalink, String commentType, String author, String authorEmail, String authorURL, String commentContent, Map other) {
        this.akismetCall("submit-ham", ipAddress, userAgent, referrer, permalink, commentType, author, authorEmail, authorURL, commentContent, other);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

