/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util.bean;

import java.lang.reflect.Array;
import net.sourceforge.stripes.util.bean.EvaluationException;
import net.sourceforge.stripes.util.bean.NodeEvaluation;
import net.sourceforge.stripes.util.bean.PropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayPropertyAccessor
implements PropertyAccessor<Object> {
    @Override
    public Object getValue(NodeEvaluation evaluation, Object target) {
        int index = this.getKey(evaluation);
        return Array.get(target, index);
    }

    @Override
    public void setValue(NodeEvaluation evaluation, Object target, Object value) {
        int index = this.getKey(evaluation);
        Array.set(target, index, value);
    }

    private int getKey(NodeEvaluation eval) {
        Object key = eval.getNode().getTypedValue();
        if (key.getClass() != Integer.class) {
            throw new EvaluationException("Attempting to index into an array using a non-integer index: " + key);
        }
        return (Integer)key;
    }
}

