# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
ALMALINUX_RELEASES += 9

.PHONY: all
all:: almalinux-cloud-9.$(GARDEN_ARCH).qcow2 almalinux-cloud-9.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/almalinux/AlmaLinux-9-GenericCloud-latest.$(GARDEN_ARCH).qcow2

$(GARDEN_DL_DIR)/almalinux/AlmaLinux-9-GenericCloud-latest.x86_64.qcow2 $(GARDEN_DL_DIR)/almalinux/AlmaLinux-9-GenericCloud-latest.aarch64.qcow2: $(GARDEN_DL_DIR)/almalinux/AlmaLinux-9-GenericCloud-latest.%.qcow2: | $(GARDEN_DL_DIR)/almalinux
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://repo.almalinux.org/almalinux/9/cloud/$*/images/AlmaLinux-9-GenericCloud-latest.$*.qcow2)

$(GARDEN_DL_DIR)/almalinux/almalinux-cloud-9.x86_64.qcow2: | $(GARDEN_DL_DIR)/almalinux/ $(GARDEN_DL_DIR)/almalinux/AlmaLinux-9-GenericCloud-latest.x86_64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/almalinux/almalinux-cloud-9.aarch64.qcow2: | $(GARDEN_DL_DIR)/almalinux/ $(GARDEN_DL_DIR)/almalinux/AlmaLinux-9-GenericCloud-latest.aarch64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/almalinux/almalinux-cloud-9.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/almalinux/AlmaLinux-9-GenericCloud-latest.*.qcow2
