/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.CompoundButtonCompatApi23;
import android.support.v4.widget.CompoundButtonCompatDonut;
import android.support.v4.widget.CompoundButtonCompatLollipop;
import android.widget.CompoundButton;

public final class CompoundButtonCompat {
    private static final CompoundButtonCompatImpl IMPL;

    private CompoundButtonCompat() {
    }

    public static void setButtonTintList(@NonNull CompoundButton button, @Nullable ColorStateList tint) {
        IMPL.setButtonTintList(button, tint);
    }

    @Nullable
    public static ColorStateList getButtonTintList(@NonNull CompoundButton button) {
        return IMPL.getButtonTintList(button);
    }

    public static void setButtonTintMode(@NonNull CompoundButton button, @Nullable PorterDuff.Mode tintMode) {
        IMPL.setButtonTintMode(button, tintMode);
    }

    @Nullable
    public static PorterDuff.Mode getButtonTintMode(@NonNull CompoundButton button) {
        return IMPL.getButtonTintMode(button);
    }

    @Nullable
    public static Drawable getButtonDrawable(@NonNull CompoundButton button) {
        return IMPL.getButtonDrawable(button);
    }

    static {
        int sdk = Build.VERSION.SDK_INT;
        IMPL = sdk >= 23 ? new Api23CompoundButtonImpl() : (sdk >= 21 ? new LollipopCompoundButtonImpl() : new BaseCompoundButtonCompat());
    }

    static class Api23CompoundButtonImpl
    extends LollipopCompoundButtonImpl {
        Api23CompoundButtonImpl() {
        }

        @Override
        public Drawable getButtonDrawable(CompoundButton button) {
            return CompoundButtonCompatApi23.getButtonDrawable(button);
        }
    }

    static class LollipopCompoundButtonImpl
    extends BaseCompoundButtonCompat {
        LollipopCompoundButtonImpl() {
        }

        @Override
        public void setButtonTintList(CompoundButton button, ColorStateList tint) {
            CompoundButtonCompatLollipop.setButtonTintList(button, tint);
        }

        @Override
        public ColorStateList getButtonTintList(CompoundButton button) {
            return CompoundButtonCompatLollipop.getButtonTintList(button);
        }

        @Override
        public void setButtonTintMode(CompoundButton button, PorterDuff.Mode tintMode) {
            CompoundButtonCompatLollipop.setButtonTintMode(button, tintMode);
        }

        @Override
        public PorterDuff.Mode getButtonTintMode(CompoundButton button) {
            return CompoundButtonCompatLollipop.getButtonTintMode(button);
        }
    }

    static class BaseCompoundButtonCompat
    implements CompoundButtonCompatImpl {
        BaseCompoundButtonCompat() {
        }

        @Override
        public void setButtonTintList(CompoundButton button, ColorStateList tint) {
            CompoundButtonCompatDonut.setButtonTintList(button, tint);
        }

        @Override
        public ColorStateList getButtonTintList(CompoundButton button) {
            return CompoundButtonCompatDonut.getButtonTintList(button);
        }

        @Override
        public void setButtonTintMode(CompoundButton button, PorterDuff.Mode tintMode) {
            CompoundButtonCompatDonut.setButtonTintMode(button, tintMode);
        }

        @Override
        public PorterDuff.Mode getButtonTintMode(CompoundButton button) {
            return CompoundButtonCompatDonut.getButtonTintMode(button);
        }

        @Override
        public Drawable getButtonDrawable(CompoundButton button) {
            return CompoundButtonCompatDonut.getButtonDrawable(button);
        }
    }

    static interface CompoundButtonCompatImpl {
        public void setButtonTintList(CompoundButton var1, ColorStateList var2);

        public ColorStateList getButtonTintList(CompoundButton var1);

        public void setButtonTintMode(CompoundButton var1, PorterDuff.Mode var2);

        public PorterDuff.Mode getButtonTintMode(CompoundButton var1);

        public Drawable getButtonDrawable(CompoundButton var1);
    }
}

