{- This module was generated from data in the Kate syntax
   highlighting file r.xml, version 2.07, by  -}

module Text.Highlighting.Kate.Syntax.R
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "R Script"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.R;*.r;*.S;*.s;*.q"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("R Script","level0")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("R Script","level0") -> return ()
      ("R Script","ctx0") -> return ()
      ("R Script","parenthesis") -> return ()
      ("R Script","string") -> return ()
      ("R Script","string2") -> return ()
      ("R Script","backquotedsymbol") -> return ()
      ("R Script","operator_rhs") -> return ()
      ("R Script","Headline") -> (popContext) >> pEndLine
      ("R Script","Comment") -> (popContext) >> pEndLine
      ("R Script","CommonRules") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_controls = Set.fromList $ words $ "for in next break while repeat if else switch function"
list_words = Set.fromList $ words $ "TRUE FALSE NULL NA NA_integer_ NA_real_ NA_complex_ NA_character_ Inf NaN"

regex_'5ba'2dzA'2dZ'5f'5c'2e'5d'5b0'2d9a'2dzA'2dZ'5f'5c'2e'5d'2a'5b'5cs'5d'2a'3d'28'3f'3d'28'5b'5e'3d'5d'7c'24'29'29 = compileRegex True "[a-zA-Z_\\.][0-9a-zA-Z_\\.]*[\\s]*=(?=([^=]|$))"
regex_'28'5c'2a'7c'2f'7c'3c'7c'3e'7c'5c'21'3d'7c'3d'7c'5c'7c'7c'26'7c'3a'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29 = compileRegex True "(\\*|/|<|>|\\!=|=|\\||&|:|\\^|@|\\$|~)"
regex_'5ba'2dzA'2dZ'5f'5d'2b'5ba'2dzA'2dZ'5f'5c'2e0'2d9'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 = compileRegex True "[a-zA-Z_]+[a-zA-Z_\\.0-9]*(?=[\\s]*[(])"
regex_'5c'2e'5ba'2dzA'2dZ'5f'5c'2e'5d'2b'5ba'2dzA'2dZ'5f'5c'2e0'2d9'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 = compileRegex True "\\.[a-zA-Z_\\.]+[a-zA-Z_\\.0-9]*(?=[\\s]*[(])"
regex_'5c'28 = compileRegex True "\\("
regex_'5b'3c'5d'7b1'2c2'7d'5c'2d = compileRegex True "[<]{1,2}\\-"
regex_'5c'2d'5b'3e'5d'7b1'2c2'7d = compileRegex True "\\-[>]{1,2}"
regex_'3d'28'3f'21'3d'29 = compileRegex True "=(?!=)"
regex_'28'5c'2b'7c'5c'2d'7c'5c'2a'7b1'2c2'7d'7c'2f'7c'3c'3d'3f'7c'3e'3d'3f'7c'3d'7b1'2c2'7d'7c'5c'21'3d'3f'7c'5c'7c'7b1'2c2'7d'7c'26'7b1'2c2'7d'7c'3a'7b1'2c3'7d'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29 = compileRegex True "(\\+|\\-|\\*{1,2}|/|<=?|>=?|={1,2}|\\!=?|\\|{1,2}|&{1,2}|:{1,3}|\\^|@|\\$|~)"
regex_'25'5b'5e'25'5d'2a'25 = compileRegex True "%[^%]*%"

parseRules ("R Script","level0") =
  (((parseRules ("R Script","CommonRules")))
   <|>
   ((pDetectChar False '}' >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("R Script","level0")) >> pDefault >>= withAttribute NormalTok))

parseRules ("R Script","ctx0") =
  (((parseRules ("R Script","CommonRules")))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False ')' >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("R Script","ctx0")) >> pDefault >>= withAttribute NormalTok))

parseRules ("R Script","parenthesis") =
  (((pLineContinue >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5f'5c'2e'5d'5b0'2d9a'2dzA'2dZ'5f'5c'2e'5d'2a'5b'5cs'5d'2a'3d'28'3f'3d'28'5b'5e'3d'5d'7c'24'29'29 >>= withAttribute DataTypeTok))
   <|>
   ((parseRules ("R Script","CommonRules")))
   <|>
   ((pDetectChar False '}' >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("R Script","parenthesis")) >> pDefault >>= withAttribute NormalTok))

parseRules ("R Script","string") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   (currentContext >>= \x -> guard (x == ("R Script","string")) >> pDefault >>= withAttribute StringTok))

parseRules ("R Script","string2") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   (currentContext >>= \x -> guard (x == ("R Script","string2")) >> pDefault >>= withAttribute StringTok))

parseRules ("R Script","backquotedsymbol") =
  (((pDetectChar False '`' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   (currentContext >>= \x -> guard (x == ("R Script","backquotedsymbol")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("R Script","operator_rhs") =
  (((pString False "##" >>= withAttribute NormalTok) >>~ pushContext ("R Script","Headline"))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("R Script","Comment"))
   <|>
   ((pDetectChar False ' ' >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'28'5c'2a'7c'2f'7c'3c'7c'3e'7c'5c'21'3d'7c'3d'7c'5c'7c'7c'26'7c'3a'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29 >>= withAttribute ErrorTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("R Script","Headline") =
  (currentContext >>= \x -> guard (x == ("R Script","Headline")) >> pDefault >>= withAttribute NormalTok)

parseRules ("R Script","Comment") =
  (currentContext >>= \x -> guard (x == ("R Script","Comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("R Script","CommonRules") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("R Script","string"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("R Script","string2"))
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ pushContext ("R Script","backquotedsymbol"))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\$" list_controls >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\$" list_words >>= withAttribute OtherTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5f'5d'2b'5ba'2dzA'2dZ'5f'5c'2e0'2d9'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'2e'5ba'2dzA'2dZ'5f'5c'2e'5d'2b'5ba'2dzA'2dZ'5f'5c'2e0'2d9'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'28 >>= withAttribute NormalTok) >>~ pushContext ("R Script","parenthesis"))
   <|>
   ((pString False "##" >>= withAttribute NormalTok) >>~ pushContext ("R Script","Headline"))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("R Script","Comment"))
   <|>
   ((pRegExpr regex_'5b'3c'5d'7b1'2c2'7d'5c'2d >>= withAttribute NormalTok) >>~ pushContext ("R Script","operator_rhs"))
   <|>
   ((pRegExpr regex_'5c'2d'5b'3e'5d'7b1'2c2'7d >>= withAttribute NormalTok) >>~ pushContext ("R Script","operator_rhs"))
   <|>
   ((pRegExpr regex_'3d'28'3f'21'3d'29 >>= withAttribute NormalTok) >>~ pushContext ("R Script","operator_rhs"))
   <|>
   ((pRegExpr regex_'28'5c'2b'7c'5c'2d'7c'5c'2a'7b1'2c2'7d'7c'2f'7c'3c'3d'3f'7c'3e'3d'3f'7c'3d'7b1'2c2'7d'7c'5c'21'3d'3f'7c'5c'7c'7b1'2c2'7d'7c'26'7b1'2c2'7d'7c'3a'7b1'2c3'7d'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29 >>= withAttribute NormalTok) >>~ pushContext ("R Script","operator_rhs"))
   <|>
   ((pRegExpr regex_'25'5b'5e'25'5d'2a'25 >>= withAttribute NormalTok) >>~ pushContext ("R Script","operator_rhs"))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("R Script","ctx0"))
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("R Script","CommonRules")) >> pDefault >>= withAttribute NormalTok))


parseRules x = parseRules ("R Script","level0") <|> fail ("Unknown context" ++ show x)
